# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GlobalConnectionArgs', 'GlobalConnection']

@pulumi.input_type
class GlobalConnectionArgs:
    def __init__(__self__, *,
                 apache_spark: Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']] = None,
                 athena: Optional[pulumi.Input['GlobalConnectionAthenaArgs']] = None,
                 bigquery: Optional[pulumi.Input['GlobalConnectionBigqueryArgs']] = None,
                 databricks: Optional[pulumi.Input['GlobalConnectionDatabricksArgs']] = None,
                 fabric: Optional[pulumi.Input['GlobalConnectionFabricArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_configuration_id: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres: Optional[pulumi.Input['GlobalConnectionPostgresArgs']] = None,
                 private_link_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redshift: Optional[pulumi.Input['GlobalConnectionRedshiftArgs']] = None,
                 snowflake: Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']] = None,
                 starburst: Optional[pulumi.Input['GlobalConnectionStarburstArgs']] = None,
                 synapse: Optional[pulumi.Input['GlobalConnectionSynapseArgs']] = None,
                 teradata: Optional[pulumi.Input['GlobalConnectionTeradataArgs']] = None):
        """
        The set of arguments for constructing a GlobalConnection resource.
        :param pulumi.Input['GlobalConnectionApacheSparkArgs'] apache_spark: Apache Spark connection configuration.
        :param pulumi.Input['GlobalConnectionAthenaArgs'] athena: Athena connection configuration.
        :param pulumi.Input['GlobalConnectionDatabricksArgs'] databricks: Databricks connection configuration
        :param pulumi.Input['GlobalConnectionFabricArgs'] fabric: Microsoft Fabric connection configuration.
        :param pulumi.Input[_builtins.str] name: Connection name
        :param pulumi.Input[_builtins.int] oauth_configuration_id: External OAuth configuration ID (only Snowflake for now)
        :param pulumi.Input['GlobalConnectionPostgresArgs'] postgres: PostgreSQL connection configuration.
        :param pulumi.Input[_builtins.str] private_link_endpoint_id: Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        :param pulumi.Input['GlobalConnectionRedshiftArgs'] redshift: Redshift connection configuration
        :param pulumi.Input['GlobalConnectionSnowflakeArgs'] snowflake: Snowflake connection configuration
        :param pulumi.Input['GlobalConnectionStarburstArgs'] starburst: Starburst/Trino connection configuration.
        :param pulumi.Input['GlobalConnectionSynapseArgs'] synapse: Azure Synapse Analytics connection configuration.
        :param pulumi.Input['GlobalConnectionTeradataArgs'] teradata: Teradata connection configuration.
        """
        if apache_spark is not None:
            pulumi.set(__self__, "apache_spark", apache_spark)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if bigquery is not None:
            pulumi.set(__self__, "bigquery", bigquery)
        if databricks is not None:
            pulumi.set(__self__, "databricks", databricks)
        if fabric is not None:
            pulumi.set(__self__, "fabric", fabric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configuration_id is not None:
            pulumi.set(__self__, "oauth_configuration_id", oauth_configuration_id)
        if postgres is not None:
            pulumi.set(__self__, "postgres", postgres)
        if private_link_endpoint_id is not None:
            pulumi.set(__self__, "private_link_endpoint_id", private_link_endpoint_id)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if starburst is not None:
            pulumi.set(__self__, "starburst", starburst)
        if synapse is not None:
            pulumi.set(__self__, "synapse", synapse)
        if teradata is not None:
            pulumi.set(__self__, "teradata", teradata)

    @_builtins.property
    @pulumi.getter(name="apacheSpark")
    def apache_spark(self) -> Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']]:
        """
        Apache Spark connection configuration.
        """
        return pulumi.get(self, "apache_spark")

    @apache_spark.setter
    def apache_spark(self, value: Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']]):
        pulumi.set(self, "apache_spark", value)

    @_builtins.property
    @pulumi.getter
    def athena(self) -> Optional[pulumi.Input['GlobalConnectionAthenaArgs']]:
        """
        Athena connection configuration.
        """
        return pulumi.get(self, "athena")

    @athena.setter
    def athena(self, value: Optional[pulumi.Input['GlobalConnectionAthenaArgs']]):
        pulumi.set(self, "athena", value)

    @_builtins.property
    @pulumi.getter
    def bigquery(self) -> Optional[pulumi.Input['GlobalConnectionBigqueryArgs']]:
        return pulumi.get(self, "bigquery")

    @bigquery.setter
    def bigquery(self, value: Optional[pulumi.Input['GlobalConnectionBigqueryArgs']]):
        pulumi.set(self, "bigquery", value)

    @_builtins.property
    @pulumi.getter
    def databricks(self) -> Optional[pulumi.Input['GlobalConnectionDatabricksArgs']]:
        """
        Databricks connection configuration
        """
        return pulumi.get(self, "databricks")

    @databricks.setter
    def databricks(self, value: Optional[pulumi.Input['GlobalConnectionDatabricksArgs']]):
        pulumi.set(self, "databricks", value)

    @_builtins.property
    @pulumi.getter
    def fabric(self) -> Optional[pulumi.Input['GlobalConnectionFabricArgs']]:
        """
        Microsoft Fabric connection configuration.
        """
        return pulumi.get(self, "fabric")

    @fabric.setter
    def fabric(self, value: Optional[pulumi.Input['GlobalConnectionFabricArgs']]):
        pulumi.set(self, "fabric", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        External OAuth configuration ID (only Snowflake for now)
        """
        return pulumi.get(self, "oauth_configuration_id")

    @oauth_configuration_id.setter
    def oauth_configuration_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "oauth_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def postgres(self) -> Optional[pulumi.Input['GlobalConnectionPostgresArgs']]:
        """
        PostgreSQL connection configuration.
        """
        return pulumi.get(self, "postgres")

    @postgres.setter
    def postgres(self, value: Optional[pulumi.Input['GlobalConnectionPostgresArgs']]):
        pulumi.set(self, "postgres", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @private_link_endpoint_id.setter
    def private_link_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def redshift(self) -> Optional[pulumi.Input['GlobalConnectionRedshiftArgs']]:
        """
        Redshift connection configuration
        """
        return pulumi.get(self, "redshift")

    @redshift.setter
    def redshift(self, value: Optional[pulumi.Input['GlobalConnectionRedshiftArgs']]):
        pulumi.set(self, "redshift", value)

    @_builtins.property
    @pulumi.getter
    def snowflake(self) -> Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']]:
        """
        Snowflake connection configuration
        """
        return pulumi.get(self, "snowflake")

    @snowflake.setter
    def snowflake(self, value: Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']]):
        pulumi.set(self, "snowflake", value)

    @_builtins.property
    @pulumi.getter
    def starburst(self) -> Optional[pulumi.Input['GlobalConnectionStarburstArgs']]:
        """
        Starburst/Trino connection configuration.
        """
        return pulumi.get(self, "starburst")

    @starburst.setter
    def starburst(self, value: Optional[pulumi.Input['GlobalConnectionStarburstArgs']]):
        pulumi.set(self, "starburst", value)

    @_builtins.property
    @pulumi.getter
    def synapse(self) -> Optional[pulumi.Input['GlobalConnectionSynapseArgs']]:
        """
        Azure Synapse Analytics connection configuration.
        """
        return pulumi.get(self, "synapse")

    @synapse.setter
    def synapse(self, value: Optional[pulumi.Input['GlobalConnectionSynapseArgs']]):
        pulumi.set(self, "synapse", value)

    @_builtins.property
    @pulumi.getter
    def teradata(self) -> Optional[pulumi.Input['GlobalConnectionTeradataArgs']]:
        """
        Teradata connection configuration.
        """
        return pulumi.get(self, "teradata")

    @teradata.setter
    def teradata(self, value: Optional[pulumi.Input['GlobalConnectionTeradataArgs']]):
        pulumi.set(self, "teradata", value)


@pulumi.input_type
class _GlobalConnectionState:
    def __init__(__self__, *,
                 adapter_version: Optional[pulumi.Input[_builtins.str]] = None,
                 apache_spark: Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']] = None,
                 athena: Optional[pulumi.Input['GlobalConnectionAthenaArgs']] = None,
                 bigquery: Optional[pulumi.Input['GlobalConnectionBigqueryArgs']] = None,
                 databricks: Optional[pulumi.Input['GlobalConnectionDatabricksArgs']] = None,
                 fabric: Optional[pulumi.Input['GlobalConnectionFabricArgs']] = None,
                 is_ssh_tunnel_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_configuration_id: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres: Optional[pulumi.Input['GlobalConnectionPostgresArgs']] = None,
                 private_link_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redshift: Optional[pulumi.Input['GlobalConnectionRedshiftArgs']] = None,
                 snowflake: Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']] = None,
                 starburst: Optional[pulumi.Input['GlobalConnectionStarburstArgs']] = None,
                 synapse: Optional[pulumi.Input['GlobalConnectionSynapseArgs']] = None,
                 teradata: Optional[pulumi.Input['GlobalConnectionTeradataArgs']] = None):
        """
        Input properties used for looking up and filtering GlobalConnection resources.
        :param pulumi.Input[_builtins.str] adapter_version: Version of the adapter
        :param pulumi.Input['GlobalConnectionApacheSparkArgs'] apache_spark: Apache Spark connection configuration.
        :param pulumi.Input['GlobalConnectionAthenaArgs'] athena: Athena connection configuration.
        :param pulumi.Input['GlobalConnectionDatabricksArgs'] databricks: Databricks connection configuration
        :param pulumi.Input['GlobalConnectionFabricArgs'] fabric: Microsoft Fabric connection configuration.
        :param pulumi.Input[_builtins.bool] is_ssh_tunnel_enabled: Whether the connection can use an SSH tunnel
        :param pulumi.Input[_builtins.str] name: Connection name
        :param pulumi.Input[_builtins.int] oauth_configuration_id: External OAuth configuration ID (only Snowflake for now)
        :param pulumi.Input['GlobalConnectionPostgresArgs'] postgres: PostgreSQL connection configuration.
        :param pulumi.Input[_builtins.str] private_link_endpoint_id: Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        :param pulumi.Input['GlobalConnectionRedshiftArgs'] redshift: Redshift connection configuration
        :param pulumi.Input['GlobalConnectionSnowflakeArgs'] snowflake: Snowflake connection configuration
        :param pulumi.Input['GlobalConnectionStarburstArgs'] starburst: Starburst/Trino connection configuration.
        :param pulumi.Input['GlobalConnectionSynapseArgs'] synapse: Azure Synapse Analytics connection configuration.
        :param pulumi.Input['GlobalConnectionTeradataArgs'] teradata: Teradata connection configuration.
        """
        if adapter_version is not None:
            pulumi.set(__self__, "adapter_version", adapter_version)
        if apache_spark is not None:
            pulumi.set(__self__, "apache_spark", apache_spark)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if bigquery is not None:
            pulumi.set(__self__, "bigquery", bigquery)
        if databricks is not None:
            pulumi.set(__self__, "databricks", databricks)
        if fabric is not None:
            pulumi.set(__self__, "fabric", fabric)
        if is_ssh_tunnel_enabled is not None:
            pulumi.set(__self__, "is_ssh_tunnel_enabled", is_ssh_tunnel_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configuration_id is not None:
            pulumi.set(__self__, "oauth_configuration_id", oauth_configuration_id)
        if postgres is not None:
            pulumi.set(__self__, "postgres", postgres)
        if private_link_endpoint_id is not None:
            pulumi.set(__self__, "private_link_endpoint_id", private_link_endpoint_id)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if snowflake is not None:
            pulumi.set(__self__, "snowflake", snowflake)
        if starburst is not None:
            pulumi.set(__self__, "starburst", starburst)
        if synapse is not None:
            pulumi.set(__self__, "synapse", synapse)
        if teradata is not None:
            pulumi.set(__self__, "teradata", teradata)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the adapter
        """
        return pulumi.get(self, "adapter_version")

    @adapter_version.setter
    def adapter_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adapter_version", value)

    @_builtins.property
    @pulumi.getter(name="apacheSpark")
    def apache_spark(self) -> Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']]:
        """
        Apache Spark connection configuration.
        """
        return pulumi.get(self, "apache_spark")

    @apache_spark.setter
    def apache_spark(self, value: Optional[pulumi.Input['GlobalConnectionApacheSparkArgs']]):
        pulumi.set(self, "apache_spark", value)

    @_builtins.property
    @pulumi.getter
    def athena(self) -> Optional[pulumi.Input['GlobalConnectionAthenaArgs']]:
        """
        Athena connection configuration.
        """
        return pulumi.get(self, "athena")

    @athena.setter
    def athena(self, value: Optional[pulumi.Input['GlobalConnectionAthenaArgs']]):
        pulumi.set(self, "athena", value)

    @_builtins.property
    @pulumi.getter
    def bigquery(self) -> Optional[pulumi.Input['GlobalConnectionBigqueryArgs']]:
        return pulumi.get(self, "bigquery")

    @bigquery.setter
    def bigquery(self, value: Optional[pulumi.Input['GlobalConnectionBigqueryArgs']]):
        pulumi.set(self, "bigquery", value)

    @_builtins.property
    @pulumi.getter
    def databricks(self) -> Optional[pulumi.Input['GlobalConnectionDatabricksArgs']]:
        """
        Databricks connection configuration
        """
        return pulumi.get(self, "databricks")

    @databricks.setter
    def databricks(self, value: Optional[pulumi.Input['GlobalConnectionDatabricksArgs']]):
        pulumi.set(self, "databricks", value)

    @_builtins.property
    @pulumi.getter
    def fabric(self) -> Optional[pulumi.Input['GlobalConnectionFabricArgs']]:
        """
        Microsoft Fabric connection configuration.
        """
        return pulumi.get(self, "fabric")

    @fabric.setter
    def fabric(self, value: Optional[pulumi.Input['GlobalConnectionFabricArgs']]):
        pulumi.set(self, "fabric", value)

    @_builtins.property
    @pulumi.getter(name="isSshTunnelEnabled")
    def is_ssh_tunnel_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the connection can use an SSH tunnel
        """
        return pulumi.get(self, "is_ssh_tunnel_enabled")

    @is_ssh_tunnel_enabled.setter
    def is_ssh_tunnel_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ssh_tunnel_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        External OAuth configuration ID (only Snowflake for now)
        """
        return pulumi.get(self, "oauth_configuration_id")

    @oauth_configuration_id.setter
    def oauth_configuration_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "oauth_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def postgres(self) -> Optional[pulumi.Input['GlobalConnectionPostgresArgs']]:
        """
        PostgreSQL connection configuration.
        """
        return pulumi.get(self, "postgres")

    @postgres.setter
    def postgres(self, value: Optional[pulumi.Input['GlobalConnectionPostgresArgs']]):
        pulumi.set(self, "postgres", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @private_link_endpoint_id.setter
    def private_link_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def redshift(self) -> Optional[pulumi.Input['GlobalConnectionRedshiftArgs']]:
        """
        Redshift connection configuration
        """
        return pulumi.get(self, "redshift")

    @redshift.setter
    def redshift(self, value: Optional[pulumi.Input['GlobalConnectionRedshiftArgs']]):
        pulumi.set(self, "redshift", value)

    @_builtins.property
    @pulumi.getter
    def snowflake(self) -> Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']]:
        """
        Snowflake connection configuration
        """
        return pulumi.get(self, "snowflake")

    @snowflake.setter
    def snowflake(self, value: Optional[pulumi.Input['GlobalConnectionSnowflakeArgs']]):
        pulumi.set(self, "snowflake", value)

    @_builtins.property
    @pulumi.getter
    def starburst(self) -> Optional[pulumi.Input['GlobalConnectionStarburstArgs']]:
        """
        Starburst/Trino connection configuration.
        """
        return pulumi.get(self, "starburst")

    @starburst.setter
    def starburst(self, value: Optional[pulumi.Input['GlobalConnectionStarburstArgs']]):
        pulumi.set(self, "starburst", value)

    @_builtins.property
    @pulumi.getter
    def synapse(self) -> Optional[pulumi.Input['GlobalConnectionSynapseArgs']]:
        """
        Azure Synapse Analytics connection configuration.
        """
        return pulumi.get(self, "synapse")

    @synapse.setter
    def synapse(self, value: Optional[pulumi.Input['GlobalConnectionSynapseArgs']]):
        pulumi.set(self, "synapse", value)

    @_builtins.property
    @pulumi.getter
    def teradata(self) -> Optional[pulumi.Input['GlobalConnectionTeradataArgs']]:
        """
        Teradata connection configuration.
        """
        return pulumi.get(self, "teradata")

    @teradata.setter
    def teradata(self, value: Optional[pulumi.Input['GlobalConnectionTeradataArgs']]):
        pulumi.set(self, "teradata", value)


@pulumi.type_token("dbtcloud:index/globalConnection:GlobalConnection")
class GlobalConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apache_spark: Optional[pulumi.Input[Union['GlobalConnectionApacheSparkArgs', 'GlobalConnectionApacheSparkArgsDict']]] = None,
                 athena: Optional[pulumi.Input[Union['GlobalConnectionAthenaArgs', 'GlobalConnectionAthenaArgsDict']]] = None,
                 bigquery: Optional[pulumi.Input[Union['GlobalConnectionBigqueryArgs', 'GlobalConnectionBigqueryArgsDict']]] = None,
                 databricks: Optional[pulumi.Input[Union['GlobalConnectionDatabricksArgs', 'GlobalConnectionDatabricksArgsDict']]] = None,
                 fabric: Optional[pulumi.Input[Union['GlobalConnectionFabricArgs', 'GlobalConnectionFabricArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_configuration_id: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres: Optional[pulumi.Input[Union['GlobalConnectionPostgresArgs', 'GlobalConnectionPostgresArgsDict']]] = None,
                 private_link_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redshift: Optional[pulumi.Input[Union['GlobalConnectionRedshiftArgs', 'GlobalConnectionRedshiftArgsDict']]] = None,
                 snowflake: Optional[pulumi.Input[Union['GlobalConnectionSnowflakeArgs', 'GlobalConnectionSnowflakeArgsDict']]] = None,
                 starburst: Optional[pulumi.Input[Union['GlobalConnectionStarburstArgs', 'GlobalConnectionStarburstArgsDict']]] = None,
                 synapse: Optional[pulumi.Input[Union['GlobalConnectionSynapseArgs', 'GlobalConnectionSynapseArgsDict']]] = None,
                 teradata: Optional[pulumi.Input[Union['GlobalConnectionTeradataArgs', 'GlobalConnectionTeradataArgsDict']]] = None,
                 __props__=None):
        """
        This resource can be used to create global connections as introduced in dbt Cloud in August 2024.

        Those connections are not linked to a specific project and can be linked to environments from different projects by using the `connection_id` field in the `Environment` resource.

        ## Import

        A project-scoped connection can be imported as a global connection by specifying the connection ID

        Migrating from project-scoped connections to global connections could be done by:

        1. Adding the config for the global connection and importing it (see below)

        2. Removing the project-scoped connection from the config AND from the state
           
           - CAREFUL: If the connection is removed from the config but not the state, it will be destroyed on the next apply

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_global_connection.my_connection

          id = "connection_id"

        }

        import {

          to = dbtcloud_global_connection.my_connection

          id = "1234"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/globalConnection:GlobalConnection my_connection "connection_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/globalConnection:GlobalConnection my_connection 1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GlobalConnectionApacheSparkArgs', 'GlobalConnectionApacheSparkArgsDict']] apache_spark: Apache Spark connection configuration.
        :param pulumi.Input[Union['GlobalConnectionAthenaArgs', 'GlobalConnectionAthenaArgsDict']] athena: Athena connection configuration.
        :param pulumi.Input[Union['GlobalConnectionDatabricksArgs', 'GlobalConnectionDatabricksArgsDict']] databricks: Databricks connection configuration
        :param pulumi.Input[Union['GlobalConnectionFabricArgs', 'GlobalConnectionFabricArgsDict']] fabric: Microsoft Fabric connection configuration.
        :param pulumi.Input[_builtins.str] name: Connection name
        :param pulumi.Input[_builtins.int] oauth_configuration_id: External OAuth configuration ID (only Snowflake for now)
        :param pulumi.Input[Union['GlobalConnectionPostgresArgs', 'GlobalConnectionPostgresArgsDict']] postgres: PostgreSQL connection configuration.
        :param pulumi.Input[_builtins.str] private_link_endpoint_id: Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        :param pulumi.Input[Union['GlobalConnectionRedshiftArgs', 'GlobalConnectionRedshiftArgsDict']] redshift: Redshift connection configuration
        :param pulumi.Input[Union['GlobalConnectionSnowflakeArgs', 'GlobalConnectionSnowflakeArgsDict']] snowflake: Snowflake connection configuration
        :param pulumi.Input[Union['GlobalConnectionStarburstArgs', 'GlobalConnectionStarburstArgsDict']] starburst: Starburst/Trino connection configuration.
        :param pulumi.Input[Union['GlobalConnectionSynapseArgs', 'GlobalConnectionSynapseArgsDict']] synapse: Azure Synapse Analytics connection configuration.
        :param pulumi.Input[Union['GlobalConnectionTeradataArgs', 'GlobalConnectionTeradataArgsDict']] teradata: Teradata connection configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalConnectionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can be used to create global connections as introduced in dbt Cloud in August 2024.

        Those connections are not linked to a specific project and can be linked to environments from different projects by using the `connection_id` field in the `Environment` resource.

        ## Import

        A project-scoped connection can be imported as a global connection by specifying the connection ID

        Migrating from project-scoped connections to global connections could be done by:

        1. Adding the config for the global connection and importing it (see below)

        2. Removing the project-scoped connection from the config AND from the state
           
           - CAREFUL: If the connection is removed from the config but not the state, it will be destroyed on the next apply

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_global_connection.my_connection

          id = "connection_id"

        }

        import {

          to = dbtcloud_global_connection.my_connection

          id = "1234"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/globalConnection:GlobalConnection my_connection "connection_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/globalConnection:GlobalConnection my_connection 1234
        ```

        :param str resource_name: The name of the resource.
        :param GlobalConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apache_spark: Optional[pulumi.Input[Union['GlobalConnectionApacheSparkArgs', 'GlobalConnectionApacheSparkArgsDict']]] = None,
                 athena: Optional[pulumi.Input[Union['GlobalConnectionAthenaArgs', 'GlobalConnectionAthenaArgsDict']]] = None,
                 bigquery: Optional[pulumi.Input[Union['GlobalConnectionBigqueryArgs', 'GlobalConnectionBigqueryArgsDict']]] = None,
                 databricks: Optional[pulumi.Input[Union['GlobalConnectionDatabricksArgs', 'GlobalConnectionDatabricksArgsDict']]] = None,
                 fabric: Optional[pulumi.Input[Union['GlobalConnectionFabricArgs', 'GlobalConnectionFabricArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_configuration_id: Optional[pulumi.Input[_builtins.int]] = None,
                 postgres: Optional[pulumi.Input[Union['GlobalConnectionPostgresArgs', 'GlobalConnectionPostgresArgsDict']]] = None,
                 private_link_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redshift: Optional[pulumi.Input[Union['GlobalConnectionRedshiftArgs', 'GlobalConnectionRedshiftArgsDict']]] = None,
                 snowflake: Optional[pulumi.Input[Union['GlobalConnectionSnowflakeArgs', 'GlobalConnectionSnowflakeArgsDict']]] = None,
                 starburst: Optional[pulumi.Input[Union['GlobalConnectionStarburstArgs', 'GlobalConnectionStarburstArgsDict']]] = None,
                 synapse: Optional[pulumi.Input[Union['GlobalConnectionSynapseArgs', 'GlobalConnectionSynapseArgsDict']]] = None,
                 teradata: Optional[pulumi.Input[Union['GlobalConnectionTeradataArgs', 'GlobalConnectionTeradataArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalConnectionArgs.__new__(GlobalConnectionArgs)

            __props__.__dict__["apache_spark"] = apache_spark
            __props__.__dict__["athena"] = athena
            __props__.__dict__["bigquery"] = bigquery
            __props__.__dict__["databricks"] = databricks
            __props__.__dict__["fabric"] = fabric
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_configuration_id"] = oauth_configuration_id
            __props__.__dict__["postgres"] = postgres
            __props__.__dict__["private_link_endpoint_id"] = private_link_endpoint_id
            __props__.__dict__["redshift"] = redshift
            __props__.__dict__["snowflake"] = snowflake
            __props__.__dict__["starburst"] = starburst
            __props__.__dict__["synapse"] = synapse
            __props__.__dict__["teradata"] = teradata
            __props__.__dict__["adapter_version"] = None
            __props__.__dict__["is_ssh_tunnel_enabled"] = None
        super(GlobalConnection, __self__).__init__(
            'dbtcloud:index/globalConnection:GlobalConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adapter_version: Optional[pulumi.Input[_builtins.str]] = None,
            apache_spark: Optional[pulumi.Input[Union['GlobalConnectionApacheSparkArgs', 'GlobalConnectionApacheSparkArgsDict']]] = None,
            athena: Optional[pulumi.Input[Union['GlobalConnectionAthenaArgs', 'GlobalConnectionAthenaArgsDict']]] = None,
            bigquery: Optional[pulumi.Input[Union['GlobalConnectionBigqueryArgs', 'GlobalConnectionBigqueryArgsDict']]] = None,
            databricks: Optional[pulumi.Input[Union['GlobalConnectionDatabricksArgs', 'GlobalConnectionDatabricksArgsDict']]] = None,
            fabric: Optional[pulumi.Input[Union['GlobalConnectionFabricArgs', 'GlobalConnectionFabricArgsDict']]] = None,
            is_ssh_tunnel_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oauth_configuration_id: Optional[pulumi.Input[_builtins.int]] = None,
            postgres: Optional[pulumi.Input[Union['GlobalConnectionPostgresArgs', 'GlobalConnectionPostgresArgsDict']]] = None,
            private_link_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            redshift: Optional[pulumi.Input[Union['GlobalConnectionRedshiftArgs', 'GlobalConnectionRedshiftArgsDict']]] = None,
            snowflake: Optional[pulumi.Input[Union['GlobalConnectionSnowflakeArgs', 'GlobalConnectionSnowflakeArgsDict']]] = None,
            starburst: Optional[pulumi.Input[Union['GlobalConnectionStarburstArgs', 'GlobalConnectionStarburstArgsDict']]] = None,
            synapse: Optional[pulumi.Input[Union['GlobalConnectionSynapseArgs', 'GlobalConnectionSynapseArgsDict']]] = None,
            teradata: Optional[pulumi.Input[Union['GlobalConnectionTeradataArgs', 'GlobalConnectionTeradataArgsDict']]] = None) -> 'GlobalConnection':
        """
        Get an existing GlobalConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] adapter_version: Version of the adapter
        :param pulumi.Input[Union['GlobalConnectionApacheSparkArgs', 'GlobalConnectionApacheSparkArgsDict']] apache_spark: Apache Spark connection configuration.
        :param pulumi.Input[Union['GlobalConnectionAthenaArgs', 'GlobalConnectionAthenaArgsDict']] athena: Athena connection configuration.
        :param pulumi.Input[Union['GlobalConnectionDatabricksArgs', 'GlobalConnectionDatabricksArgsDict']] databricks: Databricks connection configuration
        :param pulumi.Input[Union['GlobalConnectionFabricArgs', 'GlobalConnectionFabricArgsDict']] fabric: Microsoft Fabric connection configuration.
        :param pulumi.Input[_builtins.bool] is_ssh_tunnel_enabled: Whether the connection can use an SSH tunnel
        :param pulumi.Input[_builtins.str] name: Connection name
        :param pulumi.Input[_builtins.int] oauth_configuration_id: External OAuth configuration ID (only Snowflake for now)
        :param pulumi.Input[Union['GlobalConnectionPostgresArgs', 'GlobalConnectionPostgresArgsDict']] postgres: PostgreSQL connection configuration.
        :param pulumi.Input[_builtins.str] private_link_endpoint_id: Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        :param pulumi.Input[Union['GlobalConnectionRedshiftArgs', 'GlobalConnectionRedshiftArgsDict']] redshift: Redshift connection configuration
        :param pulumi.Input[Union['GlobalConnectionSnowflakeArgs', 'GlobalConnectionSnowflakeArgsDict']] snowflake: Snowflake connection configuration
        :param pulumi.Input[Union['GlobalConnectionStarburstArgs', 'GlobalConnectionStarburstArgsDict']] starburst: Starburst/Trino connection configuration.
        :param pulumi.Input[Union['GlobalConnectionSynapseArgs', 'GlobalConnectionSynapseArgsDict']] synapse: Azure Synapse Analytics connection configuration.
        :param pulumi.Input[Union['GlobalConnectionTeradataArgs', 'GlobalConnectionTeradataArgsDict']] teradata: Teradata connection configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalConnectionState.__new__(_GlobalConnectionState)

        __props__.__dict__["adapter_version"] = adapter_version
        __props__.__dict__["apache_spark"] = apache_spark
        __props__.__dict__["athena"] = athena
        __props__.__dict__["bigquery"] = bigquery
        __props__.__dict__["databricks"] = databricks
        __props__.__dict__["fabric"] = fabric
        __props__.__dict__["is_ssh_tunnel_enabled"] = is_ssh_tunnel_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_configuration_id"] = oauth_configuration_id
        __props__.__dict__["postgres"] = postgres
        __props__.__dict__["private_link_endpoint_id"] = private_link_endpoint_id
        __props__.__dict__["redshift"] = redshift
        __props__.__dict__["snowflake"] = snowflake
        __props__.__dict__["starburst"] = starburst
        __props__.__dict__["synapse"] = synapse
        __props__.__dict__["teradata"] = teradata
        return GlobalConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adapterVersion")
    def adapter_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the adapter
        """
        return pulumi.get(self, "adapter_version")

    @_builtins.property
    @pulumi.getter(name="apacheSpark")
    def apache_spark(self) -> pulumi.Output[Optional['outputs.GlobalConnectionApacheSpark']]:
        """
        Apache Spark connection configuration.
        """
        return pulumi.get(self, "apache_spark")

    @_builtins.property
    @pulumi.getter
    def athena(self) -> pulumi.Output[Optional['outputs.GlobalConnectionAthena']]:
        """
        Athena connection configuration.
        """
        return pulumi.get(self, "athena")

    @_builtins.property
    @pulumi.getter
    def bigquery(self) -> pulumi.Output[Optional['outputs.GlobalConnectionBigquery']]:
        return pulumi.get(self, "bigquery")

    @_builtins.property
    @pulumi.getter
    def databricks(self) -> pulumi.Output[Optional['outputs.GlobalConnectionDatabricks']]:
        """
        Databricks connection configuration
        """
        return pulumi.get(self, "databricks")

    @_builtins.property
    @pulumi.getter
    def fabric(self) -> pulumi.Output[Optional['outputs.GlobalConnectionFabric']]:
        """
        Microsoft Fabric connection configuration.
        """
        return pulumi.get(self, "fabric")

    @_builtins.property
    @pulumi.getter(name="isSshTunnelEnabled")
    def is_ssh_tunnel_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the connection can use an SSH tunnel
        """
        return pulumi.get(self, "is_ssh_tunnel_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Connection name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        External OAuth configuration ID (only Snowflake for now)
        """
        return pulumi.get(self, "oauth_configuration_id")

    @_builtins.property
    @pulumi.getter
    def postgres(self) -> pulumi.Output[Optional['outputs.GlobalConnectionPostgres']]:
        """
        PostgreSQL connection configuration.
        """
        return pulumi.get(self, "postgres")

    @_builtins.property
    @pulumi.getter(name="privateLinkEndpointId")
    def private_link_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private Link Endpoint ID. This ID can be found using the `privatelink_endpoint` data source
        """
        return pulumi.get(self, "private_link_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def redshift(self) -> pulumi.Output[Optional['outputs.GlobalConnectionRedshift']]:
        """
        Redshift connection configuration
        """
        return pulumi.get(self, "redshift")

    @_builtins.property
    @pulumi.getter
    def snowflake(self) -> pulumi.Output[Optional['outputs.GlobalConnectionSnowflake']]:
        """
        Snowflake connection configuration
        """
        return pulumi.get(self, "snowflake")

    @_builtins.property
    @pulumi.getter
    def starburst(self) -> pulumi.Output[Optional['outputs.GlobalConnectionStarburst']]:
        """
        Starburst/Trino connection configuration.
        """
        return pulumi.get(self, "starburst")

    @_builtins.property
    @pulumi.getter
    def synapse(self) -> pulumi.Output[Optional['outputs.GlobalConnectionSynapse']]:
        """
        Azure Synapse Analytics connection configuration.
        """
        return pulumi.get(self, "synapse")

    @_builtins.property
    @pulumi.getter
    def teradata(self) -> pulumi.Output[Optional['outputs.GlobalConnectionTeradata']]:
        """
        Teradata connection configuration.
        """
        return pulumi.get(self, "teradata")

