# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[_builtins.int],
                 execute_steps: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project_id: pulumi.Input[_builtins.int],
                 triggers: pulumi.Input['JobTriggersArgs'],
                 compare_changes_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deferring_environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 deferring_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 errors_on_lint_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate_docs: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_completion_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 run_compare_changes: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_generate_sources: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_lint: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_hours: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 self_deferring: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 triggers_on_draft_pr: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.int] environment_id: Environment ID to create the job in
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] execute_steps: List of commands to execute for the job
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the job in
        :param pulumi.Input['JobTriggersArgs'] triggers: Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        :param pulumi.Input[_builtins.str] compare_changes_flags: The model selector for checking changes in the compare changes Advanced CI feature
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        :param pulumi.Input[_builtins.int] deferring_environment_id: Environment identifier that this job defers to (new deferring approach)
        :param pulumi.Input[_builtins.int] deferring_job_id: Job identifier that this job defers to (legacy deferring approach)
        :param pulumi.Input[_builtins.str] description: Description for the job
        :param pulumi.Input[_builtins.bool] errors_on_lint_failure: Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] generate_docs: Flag for whether the job should generate documentation
        :param pulumi.Input[_builtins.bool] is_active: Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        :param pulumi.Input[_builtins.str] job_type: Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        :param pulumi.Input[_builtins.str] name: Job name
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use in the job
        :param pulumi.Input[_builtins.bool] run_compare_changes: Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        :param pulumi.Input[_builtins.bool] run_generate_sources: Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        :param pulumi.Input[_builtins.bool] run_lint: Whether the CI job should lint SQL changes. Defaults to `false`.
        :param pulumi.Input[_builtins.str] schedule_cron: Custom cron expression for schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_days: List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_hours: List of hours to execute the job at if running on a schedule
        :param pulumi.Input[_builtins.int] schedule_interval: Number of hours between job executions if running on a schedule
        :param pulumi.Input[_builtins.str] schedule_type: Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        :param pulumi.Input[_builtins.bool] self_deferring: Whether this job defers on a previous run of itself
        :param pulumi.Input[_builtins.str] target_name: Target name for the dbt profile
        :param pulumi.Input[_builtins.int] timeout_seconds: [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        :param pulumi.Input[_builtins.bool] triggers_on_draft_pr: Whether the CI job should be automatically triggered on draft PRs
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "execute_steps", execute_steps)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "triggers", triggers)
        if compare_changes_flags is not None:
            pulumi.set(__self__, "compare_changes_flags", compare_changes_flags)
        if dbt_version is not None:
            pulumi.set(__self__, "dbt_version", dbt_version)
        if deferring_environment_id is not None:
            pulumi.set(__self__, "deferring_environment_id", deferring_environment_id)
        if deferring_job_id is not None:
            pulumi.set(__self__, "deferring_job_id", deferring_job_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if errors_on_lint_failure is not None:
            pulumi.set(__self__, "errors_on_lint_failure", errors_on_lint_failure)
        if generate_docs is not None:
            pulumi.set(__self__, "generate_docs", generate_docs)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if job_completion_trigger_conditions is not None:
            pulumi.set(__self__, "job_completion_trigger_conditions", job_completion_trigger_conditions)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if run_compare_changes is not None:
            pulumi.set(__self__, "run_compare_changes", run_compare_changes)
        if run_generate_sources is not None:
            pulumi.set(__self__, "run_generate_sources", run_generate_sources)
        if run_lint is not None:
            pulumi.set(__self__, "run_lint", run_lint)
        if schedule_cron is not None:
            pulumi.set(__self__, "schedule_cron", schedule_cron)
        if schedule_days is not None:
            pulumi.set(__self__, "schedule_days", schedule_days)
        if schedule_hours is not None:
            pulumi.set(__self__, "schedule_hours", schedule_hours)
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if self_deferring is not None:
            pulumi.set(__self__, "self_deferring", self_deferring)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if timeout_seconds is not None:
            warnings.warn("""Moved to execution.timeout_seconds""", DeprecationWarning)
            pulumi.log.warn("""timeout_seconds is deprecated: Moved to execution.timeout_seconds""")
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if triggers_on_draft_pr is not None:
            pulumi.set(__self__, "triggers_on_draft_pr", triggers_on_draft_pr)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.int]:
        """
        Environment ID to create the job in
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="executeSteps")
    def execute_steps(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of commands to execute for the job
        """
        return pulumi.get(self, "execute_steps")

    @execute_steps.setter
    def execute_steps(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "execute_steps", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the job in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Input['JobTriggersArgs']:
        """
        Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input['JobTriggersArgs']):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter(name="compareChangesFlags")
    def compare_changes_flags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model selector for checking changes in the compare changes Advanced CI feature
        """
        return pulumi.get(self, "compare_changes_flags")

    @compare_changes_flags.setter
    def compare_changes_flags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compare_changes_flags", value)

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        """
        return pulumi.get(self, "dbt_version")

    @dbt_version.setter
    def dbt_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_version", value)

    @_builtins.property
    @pulumi.getter(name="deferringEnvironmentId")
    def deferring_environment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Environment identifier that this job defers to (new deferring approach)
        """
        return pulumi.get(self, "deferring_environment_id")

    @deferring_environment_id.setter
    def deferring_environment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deferring_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="deferringJobId")
    def deferring_job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Job identifier that this job defers to (legacy deferring approach)
        """
        return pulumi.get(self, "deferring_job_id")

    @deferring_job_id.setter
    def deferring_job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deferring_job_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the job
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="errorsOnLintFailure")
    def errors_on_lint_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        """
        return pulumi.get(self, "errors_on_lint_failure")

    @errors_on_lint_failure.setter
    def errors_on_lint_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "errors_on_lint_failure", value)

    @_builtins.property
    @pulumi.getter(name="generateDocs")
    def generate_docs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag for whether the job should generate documentation
        """
        return pulumi.get(self, "generate_docs")

    @generate_docs.setter
    def generate_docs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_docs", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="jobCompletionTriggerConditions")
    def job_completion_trigger_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]]:
        """
        Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        """
        return pulumi.get(self, "job_completion_trigger_conditions")

    @job_completion_trigger_conditions.setter
    def job_completion_trigger_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]]):
        pulumi.set(self, "job_completion_trigger_conditions", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use in the job
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter(name="runCompareChanges")
    def run_compare_changes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        """
        return pulumi.get(self, "run_compare_changes")

    @run_compare_changes.setter
    def run_compare_changes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_compare_changes", value)

    @_builtins.property
    @pulumi.getter(name="runGenerateSources")
    def run_generate_sources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        """
        return pulumi.get(self, "run_generate_sources")

    @run_generate_sources.setter
    def run_generate_sources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_generate_sources", value)

    @_builtins.property
    @pulumi.getter(name="runLint")
    def run_lint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should lint SQL changes. Defaults to `false`.
        """
        return pulumi.get(self, "run_lint")

    @run_lint.setter
    def run_lint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_lint", value)

    @_builtins.property
    @pulumi.getter(name="scheduleCron")
    def schedule_cron(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom cron expression for schedule
        """
        return pulumi.get(self, "schedule_cron")

    @schedule_cron.setter
    def schedule_cron(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_cron", value)

    @_builtins.property
    @pulumi.getter(name="scheduleDays")
    def schedule_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_days")

    @schedule_days.setter
    def schedule_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "schedule_days", value)

    @_builtins.property
    @pulumi.getter(name="scheduleHours")
    def schedule_hours(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of hours to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_hours")

    @schedule_hours.setter
    def schedule_hours(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "schedule_hours", value)

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hours between job executions if running on a schedule
        """
        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "schedule_interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_type", value)

    @_builtins.property
    @pulumi.getter(name="selfDeferring")
    def self_deferring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this job defers on a previous run of itself
        """
        return pulumi.get(self, "self_deferring")

    @self_deferring.setter
    def self_deferring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "self_deferring", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target name for the dbt profile
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    @_utilities.deprecated("""Moved to execution.timeout_seconds""")
    def timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)

    @_builtins.property
    @pulumi.getter(name="triggersOnDraftPr")
    def triggers_on_draft_pr(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should be automatically triggered on draft PRs
        """
        return pulumi.get(self, "triggers_on_draft_pr")

    @triggers_on_draft_pr.setter
    def triggers_on_draft_pr(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "triggers_on_draft_pr", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 compare_changes_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deferring_environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 deferring_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 errors_on_lint_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_steps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_docs: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_completion_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]] = None,
                 job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 run_compare_changes: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_generate_sources: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_lint: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_hours: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 self_deferring: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 triggers: Optional[pulumi.Input['JobTriggersArgs']] = None,
                 triggers_on_draft_pr: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.str] compare_changes_flags: The model selector for checking changes in the compare changes Advanced CI feature
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        :param pulumi.Input[_builtins.int] deferring_environment_id: Environment identifier that this job defers to (new deferring approach)
        :param pulumi.Input[_builtins.int] deferring_job_id: Job identifier that this job defers to (legacy deferring approach)
        :param pulumi.Input[_builtins.str] description: Description for the job
        :param pulumi.Input[_builtins.int] environment_id: Environment ID to create the job in
        :param pulumi.Input[_builtins.bool] errors_on_lint_failure: Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] execute_steps: List of commands to execute for the job
        :param pulumi.Input[_builtins.bool] generate_docs: Flag for whether the job should generate documentation
        :param pulumi.Input[_builtins.bool] is_active: Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        :param pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        :param pulumi.Input[_builtins.int] job_id: Job identifier
        :param pulumi.Input[_builtins.str] job_type: Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        :param pulumi.Input[_builtins.str] name: Job name
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use in the job
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the job in
        :param pulumi.Input[_builtins.bool] run_compare_changes: Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        :param pulumi.Input[_builtins.bool] run_generate_sources: Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        :param pulumi.Input[_builtins.bool] run_lint: Whether the CI job should lint SQL changes. Defaults to `false`.
        :param pulumi.Input[_builtins.str] schedule_cron: Custom cron expression for schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_days: List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_hours: List of hours to execute the job at if running on a schedule
        :param pulumi.Input[_builtins.int] schedule_interval: Number of hours between job executions if running on a schedule
        :param pulumi.Input[_builtins.str] schedule_type: Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        :param pulumi.Input[_builtins.bool] self_deferring: Whether this job defers on a previous run of itself
        :param pulumi.Input[_builtins.str] target_name: Target name for the dbt profile
        :param pulumi.Input[_builtins.int] timeout_seconds: [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        :param pulumi.Input['JobTriggersArgs'] triggers: Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        :param pulumi.Input[_builtins.bool] triggers_on_draft_pr: Whether the CI job should be automatically triggered on draft PRs
        """
        if compare_changes_flags is not None:
            pulumi.set(__self__, "compare_changes_flags", compare_changes_flags)
        if dbt_version is not None:
            pulumi.set(__self__, "dbt_version", dbt_version)
        if deferring_environment_id is not None:
            pulumi.set(__self__, "deferring_environment_id", deferring_environment_id)
        if deferring_job_id is not None:
            pulumi.set(__self__, "deferring_job_id", deferring_job_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if errors_on_lint_failure is not None:
            pulumi.set(__self__, "errors_on_lint_failure", errors_on_lint_failure)
        if execute_steps is not None:
            pulumi.set(__self__, "execute_steps", execute_steps)
        if generate_docs is not None:
            pulumi.set(__self__, "generate_docs", generate_docs)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if job_completion_trigger_conditions is not None:
            pulumi.set(__self__, "job_completion_trigger_conditions", job_completion_trigger_conditions)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if run_compare_changes is not None:
            pulumi.set(__self__, "run_compare_changes", run_compare_changes)
        if run_generate_sources is not None:
            pulumi.set(__self__, "run_generate_sources", run_generate_sources)
        if run_lint is not None:
            pulumi.set(__self__, "run_lint", run_lint)
        if schedule_cron is not None:
            pulumi.set(__self__, "schedule_cron", schedule_cron)
        if schedule_days is not None:
            pulumi.set(__self__, "schedule_days", schedule_days)
        if schedule_hours is not None:
            pulumi.set(__self__, "schedule_hours", schedule_hours)
        if schedule_interval is not None:
            pulumi.set(__self__, "schedule_interval", schedule_interval)
        if schedule_type is not None:
            pulumi.set(__self__, "schedule_type", schedule_type)
        if self_deferring is not None:
            pulumi.set(__self__, "self_deferring", self_deferring)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if timeout_seconds is not None:
            warnings.warn("""Moved to execution.timeout_seconds""", DeprecationWarning)
            pulumi.log.warn("""timeout_seconds is deprecated: Moved to execution.timeout_seconds""")
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if triggers_on_draft_pr is not None:
            pulumi.set(__self__, "triggers_on_draft_pr", triggers_on_draft_pr)

    @_builtins.property
    @pulumi.getter(name="compareChangesFlags")
    def compare_changes_flags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model selector for checking changes in the compare changes Advanced CI feature
        """
        return pulumi.get(self, "compare_changes_flags")

    @compare_changes_flags.setter
    def compare_changes_flags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compare_changes_flags", value)

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        """
        return pulumi.get(self, "dbt_version")

    @dbt_version.setter
    def dbt_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dbt_version", value)

    @_builtins.property
    @pulumi.getter(name="deferringEnvironmentId")
    def deferring_environment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Environment identifier that this job defers to (new deferring approach)
        """
        return pulumi.get(self, "deferring_environment_id")

    @deferring_environment_id.setter
    def deferring_environment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deferring_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="deferringJobId")
    def deferring_job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Job identifier that this job defers to (legacy deferring approach)
        """
        return pulumi.get(self, "deferring_job_id")

    @deferring_job_id.setter
    def deferring_job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deferring_job_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the job
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Environment ID to create the job in
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="errorsOnLintFailure")
    def errors_on_lint_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        """
        return pulumi.get(self, "errors_on_lint_failure")

    @errors_on_lint_failure.setter
    def errors_on_lint_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "errors_on_lint_failure", value)

    @_builtins.property
    @pulumi.getter(name="executeSteps")
    def execute_steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of commands to execute for the job
        """
        return pulumi.get(self, "execute_steps")

    @execute_steps.setter
    def execute_steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "execute_steps", value)

    @_builtins.property
    @pulumi.getter(name="generateDocs")
    def generate_docs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag for whether the job should generate documentation
        """
        return pulumi.get(self, "generate_docs")

    @generate_docs.setter
    def generate_docs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_docs", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="jobCompletionTriggerConditions")
    def job_completion_trigger_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]]:
        """
        Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        """
        return pulumi.get(self, "job_completion_trigger_conditions")

    @job_completion_trigger_conditions.setter
    def job_completion_trigger_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobJobCompletionTriggerConditionArgs']]]]):
        pulumi.set(self, "job_completion_trigger_conditions", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Job identifier
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use in the job
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the job in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="runCompareChanges")
    def run_compare_changes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        """
        return pulumi.get(self, "run_compare_changes")

    @run_compare_changes.setter
    def run_compare_changes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_compare_changes", value)

    @_builtins.property
    @pulumi.getter(name="runGenerateSources")
    def run_generate_sources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        """
        return pulumi.get(self, "run_generate_sources")

    @run_generate_sources.setter
    def run_generate_sources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_generate_sources", value)

    @_builtins.property
    @pulumi.getter(name="runLint")
    def run_lint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should lint SQL changes. Defaults to `false`.
        """
        return pulumi.get(self, "run_lint")

    @run_lint.setter
    def run_lint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "run_lint", value)

    @_builtins.property
    @pulumi.getter(name="scheduleCron")
    def schedule_cron(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom cron expression for schedule
        """
        return pulumi.get(self, "schedule_cron")

    @schedule_cron.setter
    def schedule_cron(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_cron", value)

    @_builtins.property
    @pulumi.getter(name="scheduleDays")
    def schedule_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_days")

    @schedule_days.setter
    def schedule_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "schedule_days", value)

    @_builtins.property
    @pulumi.getter(name="scheduleHours")
    def schedule_hours(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of hours to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_hours")

    @schedule_hours.setter
    def schedule_hours(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "schedule_hours", value)

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of hours between job executions if running on a schedule
        """
        return pulumi.get(self, "schedule_interval")

    @schedule_interval.setter
    def schedule_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "schedule_interval", value)

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        """
        return pulumi.get(self, "schedule_type")

    @schedule_type.setter
    def schedule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_type", value)

    @_builtins.property
    @pulumi.getter(name="selfDeferring")
    def self_deferring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this job defers on a previous run of itself
        """
        return pulumi.get(self, "self_deferring")

    @self_deferring.setter
    def self_deferring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "self_deferring", value)

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target name for the dbt profile
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_name", value)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    @_utilities.deprecated("""Moved to execution.timeout_seconds""")
    def timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input['JobTriggersArgs']]:
        """
        Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input['JobTriggersArgs']]):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter(name="triggersOnDraftPr")
    def triggers_on_draft_pr(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the CI job should be automatically triggered on draft PRs
        """
        return pulumi.get(self, "triggers_on_draft_pr")

    @triggers_on_draft_pr.setter
    def triggers_on_draft_pr(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "triggers_on_draft_pr", value)


@pulumi.type_token("dbtcloud:index/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_changes_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deferring_environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 deferring_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 errors_on_lint_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_steps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_docs: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_completion_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobCompletionTriggerConditionArgs', 'JobJobCompletionTriggerConditionArgsDict']]]]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 run_compare_changes: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_generate_sources: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_lint: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_hours: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 self_deferring: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 triggers: Optional[pulumi.Input[Union['JobTriggersArgs', 'JobTriggersArgsDict']]] = None,
                 triggers_on_draft_pr: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_job.my_job

          id = "job_id"

        }

        import {

          to = dbtcloud_job.my_job

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/job:Job my_job "job_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/job:Job my_job 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compare_changes_flags: The model selector for checking changes in the compare changes Advanced CI feature
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        :param pulumi.Input[_builtins.int] deferring_environment_id: Environment identifier that this job defers to (new deferring approach)
        :param pulumi.Input[_builtins.int] deferring_job_id: Job identifier that this job defers to (legacy deferring approach)
        :param pulumi.Input[_builtins.str] description: Description for the job
        :param pulumi.Input[_builtins.int] environment_id: Environment ID to create the job in
        :param pulumi.Input[_builtins.bool] errors_on_lint_failure: Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] execute_steps: List of commands to execute for the job
        :param pulumi.Input[_builtins.bool] generate_docs: Flag for whether the job should generate documentation
        :param pulumi.Input[_builtins.bool] is_active: Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobCompletionTriggerConditionArgs', 'JobJobCompletionTriggerConditionArgsDict']]]] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        :param pulumi.Input[_builtins.str] job_type: Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        :param pulumi.Input[_builtins.str] name: Job name
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use in the job
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the job in
        :param pulumi.Input[_builtins.bool] run_compare_changes: Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        :param pulumi.Input[_builtins.bool] run_generate_sources: Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        :param pulumi.Input[_builtins.bool] run_lint: Whether the CI job should lint SQL changes. Defaults to `false`.
        :param pulumi.Input[_builtins.str] schedule_cron: Custom cron expression for schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_days: List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_hours: List of hours to execute the job at if running on a schedule
        :param pulumi.Input[_builtins.int] schedule_interval: Number of hours between job executions if running on a schedule
        :param pulumi.Input[_builtins.str] schedule_type: Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        :param pulumi.Input[_builtins.bool] self_deferring: Whether this job defers on a previous run of itself
        :param pulumi.Input[_builtins.str] target_name: Target name for the dbt profile
        :param pulumi.Input[_builtins.int] timeout_seconds: [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        :param pulumi.Input[Union['JobTriggersArgs', 'JobTriggersArgsDict']] triggers: Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        :param pulumi.Input[_builtins.bool] triggers_on_draft_pr: Whether the CI job should be automatically triggered on draft PRs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_job.my_job

          id = "job_id"

        }

        import {

          to = dbtcloud_job.my_job

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/job:Job my_job "job_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/job:Job my_job 12345
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compare_changes_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deferring_environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 deferring_job_id: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.int]] = None,
                 errors_on_lint_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 execute_steps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 generate_docs: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_completion_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobCompletionTriggerConditionArgs', 'JobJobCompletionTriggerConditionArgsDict']]]]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 run_compare_changes: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_generate_sources: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_lint: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_hours: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 schedule_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 self_deferring: Optional[pulumi.Input[_builtins.bool]] = None,
                 target_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 triggers: Optional[pulumi.Input[Union['JobTriggersArgs', 'JobTriggersArgsDict']]] = None,
                 triggers_on_draft_pr: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["compare_changes_flags"] = compare_changes_flags
            __props__.__dict__["dbt_version"] = dbt_version
            __props__.__dict__["deferring_environment_id"] = deferring_environment_id
            __props__.__dict__["deferring_job_id"] = deferring_job_id
            __props__.__dict__["description"] = description
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["errors_on_lint_failure"] = errors_on_lint_failure
            if execute_steps is None and not opts.urn:
                raise TypeError("Missing required property 'execute_steps'")
            __props__.__dict__["execute_steps"] = execute_steps
            __props__.__dict__["generate_docs"] = generate_docs
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["job_completion_trigger_conditions"] = job_completion_trigger_conditions
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["name"] = name
            __props__.__dict__["num_threads"] = num_threads
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["run_compare_changes"] = run_compare_changes
            __props__.__dict__["run_generate_sources"] = run_generate_sources
            __props__.__dict__["run_lint"] = run_lint
            __props__.__dict__["schedule_cron"] = schedule_cron
            __props__.__dict__["schedule_days"] = schedule_days
            __props__.__dict__["schedule_hours"] = schedule_hours
            __props__.__dict__["schedule_interval"] = schedule_interval
            __props__.__dict__["schedule_type"] = schedule_type
            __props__.__dict__["self_deferring"] = self_deferring
            __props__.__dict__["target_name"] = target_name
            __props__.__dict__["timeout_seconds"] = timeout_seconds
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["triggers_on_draft_pr"] = triggers_on_draft_pr
            __props__.__dict__["job_id"] = None
        super(Job, __self__).__init__(
            'dbtcloud:index/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compare_changes_flags: Optional[pulumi.Input[_builtins.str]] = None,
            dbt_version: Optional[pulumi.Input[_builtins.str]] = None,
            deferring_environment_id: Optional[pulumi.Input[_builtins.int]] = None,
            deferring_job_id: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.int]] = None,
            errors_on_lint_failure: Optional[pulumi.Input[_builtins.bool]] = None,
            execute_steps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            generate_docs: Optional[pulumi.Input[_builtins.bool]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            job_completion_trigger_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobJobCompletionTriggerConditionArgs', 'JobJobCompletionTriggerConditionArgsDict']]]]] = None,
            job_id: Optional[pulumi.Input[_builtins.int]] = None,
            job_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            num_threads: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            run_compare_changes: Optional[pulumi.Input[_builtins.bool]] = None,
            run_generate_sources: Optional[pulumi.Input[_builtins.bool]] = None,
            run_lint: Optional[pulumi.Input[_builtins.bool]] = None,
            schedule_cron: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_days: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            schedule_hours: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            schedule_interval: Optional[pulumi.Input[_builtins.int]] = None,
            schedule_type: Optional[pulumi.Input[_builtins.str]] = None,
            self_deferring: Optional[pulumi.Input[_builtins.bool]] = None,
            target_name: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            triggers: Optional[pulumi.Input[Union['JobTriggersArgs', 'JobTriggersArgsDict']]] = None,
            triggers_on_draft_pr: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compare_changes_flags: The model selector for checking changes in the compare changes Advanced CI feature
        :param pulumi.Input[_builtins.str] dbt_version: Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        :param pulumi.Input[_builtins.int] deferring_environment_id: Environment identifier that this job defers to (new deferring approach)
        :param pulumi.Input[_builtins.int] deferring_job_id: Job identifier that this job defers to (legacy deferring approach)
        :param pulumi.Input[_builtins.str] description: Description for the job
        :param pulumi.Input[_builtins.int] environment_id: Environment ID to create the job in
        :param pulumi.Input[_builtins.bool] errors_on_lint_failure: Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] execute_steps: List of commands to execute for the job
        :param pulumi.Input[_builtins.bool] generate_docs: Flag for whether the job should generate documentation
        :param pulumi.Input[_builtins.bool] is_active: Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobJobCompletionTriggerConditionArgs', 'JobJobCompletionTriggerConditionArgsDict']]]] job_completion_trigger_conditions: Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        :param pulumi.Input[_builtins.int] job_id: Job identifier
        :param pulumi.Input[_builtins.str] job_type: Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        :param pulumi.Input[_builtins.str] name: Job name
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use in the job
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the job in
        :param pulumi.Input[_builtins.bool] run_compare_changes: Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        :param pulumi.Input[_builtins.bool] run_generate_sources: Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        :param pulumi.Input[_builtins.bool] run_lint: Whether the CI job should lint SQL changes. Defaults to `false`.
        :param pulumi.Input[_builtins.str] schedule_cron: Custom cron expression for schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_days: List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] schedule_hours: List of hours to execute the job at if running on a schedule
        :param pulumi.Input[_builtins.int] schedule_interval: Number of hours between job executions if running on a schedule
        :param pulumi.Input[_builtins.str] schedule_type: Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        :param pulumi.Input[_builtins.bool] self_deferring: Whether this job defers on a previous run of itself
        :param pulumi.Input[_builtins.str] target_name: Target name for the dbt profile
        :param pulumi.Input[_builtins.int] timeout_seconds: [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        :param pulumi.Input[Union['JobTriggersArgs', 'JobTriggersArgsDict']] triggers: Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        :param pulumi.Input[_builtins.bool] triggers_on_draft_pr: Whether the CI job should be automatically triggered on draft PRs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["compare_changes_flags"] = compare_changes_flags
        __props__.__dict__["dbt_version"] = dbt_version
        __props__.__dict__["deferring_environment_id"] = deferring_environment_id
        __props__.__dict__["deferring_job_id"] = deferring_job_id
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["errors_on_lint_failure"] = errors_on_lint_failure
        __props__.__dict__["execute_steps"] = execute_steps
        __props__.__dict__["generate_docs"] = generate_docs
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["job_completion_trigger_conditions"] = job_completion_trigger_conditions
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["name"] = name
        __props__.__dict__["num_threads"] = num_threads
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["run_compare_changes"] = run_compare_changes
        __props__.__dict__["run_generate_sources"] = run_generate_sources
        __props__.__dict__["run_lint"] = run_lint
        __props__.__dict__["schedule_cron"] = schedule_cron
        __props__.__dict__["schedule_days"] = schedule_days
        __props__.__dict__["schedule_hours"] = schedule_hours
        __props__.__dict__["schedule_interval"] = schedule_interval
        __props__.__dict__["schedule_type"] = schedule_type
        __props__.__dict__["self_deferring"] = self_deferring
        __props__.__dict__["target_name"] = target_name
        __props__.__dict__["timeout_seconds"] = timeout_seconds
        __props__.__dict__["triggers"] = triggers
        __props__.__dict__["triggers_on_draft_pr"] = triggers_on_draft_pr
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compareChangesFlags")
    def compare_changes_flags(self) -> pulumi.Output[_builtins.str]:
        """
        The model selector for checking changes in the compare changes Advanced CI feature
        """
        return pulumi.get(self, "compare_changes_flags")

    @_builtins.property
    @pulumi.getter(name="dbtVersion")
    def dbt_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Version number of dbt to use in this job, usually in the format 1.2.0-latest rather than core versions
        """
        return pulumi.get(self, "dbt_version")

    @_builtins.property
    @pulumi.getter(name="deferringEnvironmentId")
    def deferring_environment_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Environment identifier that this job defers to (new deferring approach)
        """
        return pulumi.get(self, "deferring_environment_id")

    @_builtins.property
    @pulumi.getter(name="deferringJobId")
    def deferring_job_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Job identifier that this job defers to (legacy deferring approach)
        """
        return pulumi.get(self, "deferring_job_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description for the job
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.int]:
        """
        Environment ID to create the job in
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="errorsOnLintFailure")
    def errors_on_lint_failure(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the CI job should fail when a lint error is found. Only used when `run_lint` is set to `true`. Defaults to `true`.
        """
        return pulumi.get(self, "errors_on_lint_failure")

    @_builtins.property
    @pulumi.getter(name="executeSteps")
    def execute_steps(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of commands to execute for the job
        """
        return pulumi.get(self, "execute_steps")

    @_builtins.property
    @pulumi.getter(name="generateDocs")
    def generate_docs(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag for whether the job should generate documentation
        """
        return pulumi.get(self, "generate_docs")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Should always be set to true as setting it to false is the same as creating a job in a deleted state. To create/keep a job in a 'deactivated' state, check  the `triggers` config.
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="jobCompletionTriggerConditions")
    def job_completion_trigger_conditions(self) -> pulumi.Output[Optional[Sequence['outputs.JobJobCompletionTriggerCondition']]]:
        """
        Which other job should trigger this job when it finishes, and on which conditions (sometimes referred as 'job chaining').
        """
        return pulumi.get(self, "job_completion_trigger_conditions")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.int]:
        """
        Job identifier
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[_builtins.str]:
        """
        Can be used to enforce the job type betwen `ci`, `merge` and `scheduled`. Without this value the job type is inferred from the triggers configured
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Job name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Output[_builtins.int]:
        """
        Number of threads to use in the job
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the job in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="runCompareChanges")
    def run_compare_changes(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the CI job should compare data changes introduced by the code changes. Requires `deferring_environment_id` to be set. (Advanced CI needs to be activated in the dbt Cloud Account Settings first as well)
        """
        return pulumi.get(self, "run_compare_changes")

    @_builtins.property
    @pulumi.getter(name="runGenerateSources")
    def run_generate_sources(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag for whether the job should add a `dbt source freshness` step to the job. The difference between manually adding a step with `dbt source freshness` in the job steps or using this flag is that with this flag, a failed freshness will still allow the following steps to run.
        """
        return pulumi.get(self, "run_generate_sources")

    @_builtins.property
    @pulumi.getter(name="runLint")
    def run_lint(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the CI job should lint SQL changes. Defaults to `false`.
        """
        return pulumi.get(self, "run_lint")

    @_builtins.property
    @pulumi.getter(name="scheduleCron")
    def schedule_cron(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom cron expression for schedule
        """
        return pulumi.get(self, "schedule_cron")

    @_builtins.property
    @pulumi.getter(name="scheduleDays")
    def schedule_days(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        List of days of week as numbers (0 = Sunday, 7 = Saturday) to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_days")

    @_builtins.property
    @pulumi.getter(name="scheduleHours")
    def schedule_hours(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        List of hours to execute the job at if running on a schedule
        """
        return pulumi.get(self, "schedule_hours")

    @_builtins.property
    @pulumi.getter(name="scheduleInterval")
    def schedule_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Number of hours between job executions if running on a schedule
        """
        return pulumi.get(self, "schedule_interval")

    @_builtins.property
    @pulumi.getter(name="scheduleType")
    def schedule_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of schedule to use, one of every*day/ days*of*week/ custom*cron/ interval_cron
        """
        return pulumi.get(self, "schedule_type")

    @_builtins.property
    @pulumi.getter(name="selfDeferring")
    def self_deferring(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this job defers on a previous run of itself
        """
        return pulumi.get(self, "self_deferring")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> pulumi.Output[_builtins.str]:
        """
        Target name for the dbt profile
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    @_utilities.deprecated("""Moved to execution.timeout_seconds""")
    def timeout_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        [Deprectated - Moved to execution.timeout_seconds] Number of seconds to allow the job to run before timing out
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output['outputs.JobTriggers']:
        """
        Flags for which types of triggers to use, the values are `github_webhook`, `git_provider_webhook`, `schedule` and `on_merge`. All flags should be listed and set with `true` or `false`. When `on_merge` is `true`, all the other values must be false.\\n\\n`custom_branch_only` used to be allowed but has been deprecated from the API. The jobs will use the custom branch of the environment. Please remove the `custom_branch_only` from your config. \\n\\nTo create a job in a 'deactivated' state, set all to `false`.
        """
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter(name="triggersOnDraftPr")
    def triggers_on_draft_pr(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the CI job should be automatically triggered on draft PRs
        """
        return pulumi.get(self, "triggers_on_draft_pr")

