# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ModelNotificationsArgs', 'ModelNotifications']

@pulumi.input_type
class ModelNotificationsArgs:
    def __init__(__self__, *,
                 environment_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_skipped: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_warning: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ModelNotifications resource.
        :param pulumi.Input[_builtins.str] environment_id: The ID of the dbt Cloud environment
        :param pulumi.Input[_builtins.bool] enabled: Whether model notifications are enabled for this environment
        :param pulumi.Input[_builtins.bool] on_failure: Whether to send notifications for failed model runs
        :param pulumi.Input[_builtins.bool] on_skipped: Whether to send notifications for skipped model runs
        :param pulumi.Input[_builtins.bool] on_success: Whether to send notifications for successful model runs
        :param pulumi.Input[_builtins.bool] on_warning: Whether to send notifications for model runs with warnings
        """
        pulumi.set(__self__, "environment_id", environment_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_skipped is not None:
            pulumi.set(__self__, "on_skipped", on_skipped)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)
        if on_warning is not None:
            pulumi.set(__self__, "on_warning", on_warning)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dbt Cloud environment
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether model notifications are enabled for this environment
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for failed model runs
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_failure", value)

    @_builtins.property
    @pulumi.getter(name="onSkipped")
    def on_skipped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for skipped model runs
        """
        return pulumi.get(self, "on_skipped")

    @on_skipped.setter
    def on_skipped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_skipped", value)

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for successful model runs
        """
        return pulumi.get(self, "on_success")

    @on_success.setter
    def on_success(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_success", value)

    @_builtins.property
    @pulumi.getter(name="onWarning")
    def on_warning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for model runs with warnings
        """
        return pulumi.get(self, "on_warning")

    @on_warning.setter
    def on_warning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_warning", value)


@pulumi.input_type
class _ModelNotificationsState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_skipped: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_warning: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ModelNotifications resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether model notifications are enabled for this environment
        :param pulumi.Input[_builtins.str] environment_id: The ID of the dbt Cloud environment
        :param pulumi.Input[_builtins.bool] on_failure: Whether to send notifications for failed model runs
        :param pulumi.Input[_builtins.bool] on_skipped: Whether to send notifications for skipped model runs
        :param pulumi.Input[_builtins.bool] on_success: Whether to send notifications for successful model runs
        :param pulumi.Input[_builtins.bool] on_warning: Whether to send notifications for model runs with warnings
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_skipped is not None:
            pulumi.set(__self__, "on_skipped", on_skipped)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)
        if on_warning is not None:
            pulumi.set(__self__, "on_warning", on_warning)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether model notifications are enabled for this environment
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dbt Cloud environment
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for failed model runs
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_failure", value)

    @_builtins.property
    @pulumi.getter(name="onSkipped")
    def on_skipped(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for skipped model runs
        """
        return pulumi.get(self, "on_skipped")

    @on_skipped.setter
    def on_skipped(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_skipped", value)

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for successful model runs
        """
        return pulumi.get(self, "on_success")

    @on_success.setter
    def on_success(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_success", value)

    @_builtins.property
    @pulumi.getter(name="onWarning")
    def on_warning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send notifications for model runs with warnings
        """
        return pulumi.get(self, "on_warning")

    @on_warning.setter
    def on_warning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_warning", value)


@pulumi.type_token("dbtcloud:index/modelNotifications:ModelNotifications")
class ModelNotifications(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_skipped: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_warning: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Configure model notifications for a dbt Cloud environment. By default all the `on_...` are set to false. When destroyed, the model notifications are disabled.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        prod_model_notifications = dbtcloud.ModelNotifications("prod_model_notifications",
            environment_id=prod_environment["environmentId"],
            enabled=True,
            on_success=False,
            on_failure=True,
            on_warning=True)
        ```

        ## Import

        Model notifications are imported using the environment ID where the notifications are enabled

        Using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_model_notifications.my_model_notifications

          id = "environment_id"

        }

        import {

          to = dbtcloud_model_notifications.my_model_notifications

          id = "12345"

        }

        Using the older import command

        ```sh
        $ pulumi import dbtcloud:index/modelNotifications:ModelNotifications my_model_notifications "environment_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/modelNotifications:ModelNotifications my_model_notifications 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether model notifications are enabled for this environment
        :param pulumi.Input[_builtins.str] environment_id: The ID of the dbt Cloud environment
        :param pulumi.Input[_builtins.bool] on_failure: Whether to send notifications for failed model runs
        :param pulumi.Input[_builtins.bool] on_skipped: Whether to send notifications for skipped model runs
        :param pulumi.Input[_builtins.bool] on_success: Whether to send notifications for successful model runs
        :param pulumi.Input[_builtins.bool] on_warning: Whether to send notifications for model runs with warnings
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelNotificationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configure model notifications for a dbt Cloud environment. By default all the `on_...` are set to false. When destroyed, the model notifications are disabled.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        prod_model_notifications = dbtcloud.ModelNotifications("prod_model_notifications",
            environment_id=prod_environment["environmentId"],
            enabled=True,
            on_success=False,
            on_failure=True,
            on_warning=True)
        ```

        ## Import

        Model notifications are imported using the environment ID where the notifications are enabled

        Using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_model_notifications.my_model_notifications

          id = "environment_id"

        }

        import {

          to = dbtcloud_model_notifications.my_model_notifications

          id = "12345"

        }

        Using the older import command

        ```sh
        $ pulumi import dbtcloud:index/modelNotifications:ModelNotifications my_model_notifications "environment_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/modelNotifications:ModelNotifications my_model_notifications 12345
        ```

        :param str resource_name: The name of the resource.
        :param ModelNotificationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelNotificationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_skipped: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_success: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_warning: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelNotificationsArgs.__new__(ModelNotificationsArgs)

            __props__.__dict__["enabled"] = enabled
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["on_failure"] = on_failure
            __props__.__dict__["on_skipped"] = on_skipped
            __props__.__dict__["on_success"] = on_success
            __props__.__dict__["on_warning"] = on_warning
        super(ModelNotifications, __self__).__init__(
            'dbtcloud:index/modelNotifications:ModelNotifications',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            on_failure: Optional[pulumi.Input[_builtins.bool]] = None,
            on_skipped: Optional[pulumi.Input[_builtins.bool]] = None,
            on_success: Optional[pulumi.Input[_builtins.bool]] = None,
            on_warning: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ModelNotifications':
        """
        Get an existing ModelNotifications resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether model notifications are enabled for this environment
        :param pulumi.Input[_builtins.str] environment_id: The ID of the dbt Cloud environment
        :param pulumi.Input[_builtins.bool] on_failure: Whether to send notifications for failed model runs
        :param pulumi.Input[_builtins.bool] on_skipped: Whether to send notifications for skipped model runs
        :param pulumi.Input[_builtins.bool] on_success: Whether to send notifications for successful model runs
        :param pulumi.Input[_builtins.bool] on_warning: Whether to send notifications for model runs with warnings
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelNotificationsState.__new__(_ModelNotificationsState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["on_failure"] = on_failure
        __props__.__dict__["on_skipped"] = on_skipped
        __props__.__dict__["on_success"] = on_success
        __props__.__dict__["on_warning"] = on_warning
        return ModelNotifications(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether model notifications are enabled for this environment
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dbt Cloud environment
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to send notifications for failed model runs
        """
        return pulumi.get(self, "on_failure")

    @_builtins.property
    @pulumi.getter(name="onSkipped")
    def on_skipped(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to send notifications for skipped model runs
        """
        return pulumi.get(self, "on_skipped")

    @_builtins.property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to send notifications for successful model runs
        """
        return pulumi.get(self, "on_success")

    @_builtins.property
    @pulumi.getter(name="onWarning")
    def on_warning(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to send notifications for model runs with warnings
        """
        return pulumi.get(self, "on_warning")

