# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PartialEnvironmentVariableArgs', 'PartialEnvironmentVariable']

@pulumi.input_type
class PartialEnvironmentVariableArgs:
    def __init__(__self__, *,
                 environment_values: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 project_id: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PartialEnvironmentVariable resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_values: Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        :param pulumi.Input[_builtins.int] project_id: Project ID to create or update the environment variable in
        :param pulumi.Input[_builtins.str] name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        """
        pulumi.set(__self__, "environment_values", environment_values)
        pulumi.set(__self__, "project_id", project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="environmentValues")
    def environment_values(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        """
        return pulumi.get(self, "environment_values")

    @environment_values.setter
    def environment_values(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "environment_values", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create or update the environment variable in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PartialEnvironmentVariableState:
    def __init__(__self__, *,
                 environment_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PartialEnvironmentVariable resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_values: Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        :param pulumi.Input[_builtins.str] name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        :param pulumi.Input[_builtins.int] project_id: Project ID to create or update the environment variable in
        """
        if environment_values is not None:
            pulumi.set(__self__, "environment_values", environment_values)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="environmentValues")
    def environment_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        """
        return pulumi.get(self, "environment_values")

    @environment_values.setter
    def environment_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_values", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create or update the environment variable in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)


@pulumi.type_token("dbtcloud:index/partialEnvironmentVariable:PartialEnvironmentVariable")
class PartialEnvironmentVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### 

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_values: Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        :param pulumi.Input[_builtins.str] name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        :param pulumi.Input[_builtins.int] project_id: Project ID to create or update the environment variable in
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartialEnvironmentVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### 

        :param str resource_name: The name of the resource.
        :param PartialEnvironmentVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartialEnvironmentVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartialEnvironmentVariableArgs.__new__(PartialEnvironmentVariableArgs)

            if environment_values is None and not opts.urn:
                raise TypeError("Missing required property 'environment_values'")
            __props__.__dict__["environment_values"] = environment_values
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
        super(PartialEnvironmentVariable, __self__).__init__(
            'dbtcloud:index/partialEnvironmentVariable:PartialEnvironmentVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            environment_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'PartialEnvironmentVariable':
        """
        Get an existing PartialEnvironmentVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_values: Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        :param pulumi.Input[_builtins.str] name: Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        :param pulumi.Input[_builtins.int] project_id: Project ID to create or update the environment variable in
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PartialEnvironmentVariableState.__new__(_PartialEnvironmentVariableState)

        __props__.__dict__["environment_values"] = environment_values
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        return PartialEnvironmentVariable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="environmentValues")
    def environment_values(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map from environment names to respective variable value. This field is not set as sensitive so take precautions when using secret environment variables. Only the specified environment values will be managed by this resource.
        """
        return pulumi.get(self, "environment_values")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the variable, must be unique within a project, must be prefixed with 'DBT_'
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create or update the environment variable in
        """
        return pulumi.get(self, "project_id")

