# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScimGroupPermissionsArgs', 'ScimGroupPermissions']

@pulumi.input_type
class ScimGroupPermissionsArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.int],
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]] = None):
        """
        The set of arguments for constructing a ScimGroupPermissions resource.
        :param pulumi.Input[_builtins.int] group_id: The ID of the existing group to manage permissions for. This group must already exist.
        :param pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]] permissions: Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        pulumi.set(__self__, "group_id", group_id)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the existing group to manage permissions for. This group must already exist.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]]:
        """
        Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class _ScimGroupPermissionsState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering ScimGroupPermissions resources.
        :param pulumi.Input[_builtins.int] group_id: The ID of the existing group to manage permissions for. This group must already exist.
        :param pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]] permissions: Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the existing group to manage permissions for. This group must already exist.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]]:
        """
        Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScimGroupPermissionsPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.type_token("dbtcloud:index/scimGroupPermissions:ScimGroupPermissions")
class ScimGroupPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScimGroupPermissionsPermissionArgs', 'ScimGroupPermissionsPermissionArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a ScimGroupPermissions resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] group_id: The ID of the existing group to manage permissions for. This group must already exist.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScimGroupPermissionsPermissionArgs', 'ScimGroupPermissionsPermissionArgsDict']]]] permissions: Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScimGroupPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ScimGroupPermissions resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ScimGroupPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScimGroupPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.int]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScimGroupPermissionsPermissionArgs', 'ScimGroupPermissionsPermissionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScimGroupPermissionsArgs.__new__(ScimGroupPermissionsArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["permissions"] = permissions
        super(ScimGroupPermissions, __self__).__init__(
            'dbtcloud:index/scimGroupPermissions:ScimGroupPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.int]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScimGroupPermissionsPermissionArgs', 'ScimGroupPermissionsPermissionArgsDict']]]]] = None) -> 'ScimGroupPermissions':
        """
        Get an existing ScimGroupPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] group_id: The ID of the existing group to manage permissions for. This group must already exist.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScimGroupPermissionsPermissionArgs', 'ScimGroupPermissionsPermissionArgsDict']]]] permissions: Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScimGroupPermissionsState.__new__(_ScimGroupPermissionsState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["permissions"] = permissions
        return ScimGroupPermissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the existing group to manage permissions for. This group must already exist.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.ScimGroupPermissionsPermission']]]:
        """
        Set of permissions to apply to the group. This will replace all existing permissions for the group.
        """
        return pulumi.get(self, "permissions")

