# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SemanticLayerCredentialServiceTokenMappingArgs', 'SemanticLayerCredentialServiceTokenMapping']

@pulumi.input_type
class SemanticLayerCredentialServiceTokenMappingArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.int],
                 semantic_layer_credential_id: pulumi.Input[_builtins.int],
                 service_token_id: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a SemanticLayerCredentialServiceTokenMapping resource.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the semantic layer credential is associated.
        :param pulumi.Input[_builtins.int] semantic_layer_credential_id: The ID of the semantic layer credential to map.
        :param pulumi.Input[_builtins.int] service_token_id: The ID of the service token to map to the semantic layer credential.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "semantic_layer_credential_id", semantic_layer_credential_id)
        pulumi.set(__self__, "service_token_id", service_token_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the project to which the semantic layer credential is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredentialId")
    def semantic_layer_credential_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the semantic layer credential to map.
        """
        return pulumi.get(self, "semantic_layer_credential_id")

    @semantic_layer_credential_id.setter
    def semantic_layer_credential_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "semantic_layer_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceTokenId")
    def service_token_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the service token to map to the semantic layer credential.
        """
        return pulumi.get(self, "service_token_id")

    @service_token_id.setter
    def service_token_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "service_token_id", value)


@pulumi.input_type
class _SemanticLayerCredentialServiceTokenMappingState:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 service_token_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SemanticLayerCredentialServiceTokenMapping resources.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the semantic layer credential is associated.
        :param pulumi.Input[_builtins.int] semantic_layer_credential_id: The ID of the semantic layer credential to map.
        :param pulumi.Input[_builtins.int] service_token_id: The ID of the service token to map to the semantic layer credential.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if semantic_layer_credential_id is not None:
            pulumi.set(__self__, "semantic_layer_credential_id", semantic_layer_credential_id)
        if service_token_id is not None:
            pulumi.set(__self__, "service_token_id", service_token_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the project to which the semantic layer credential is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredentialId")
    def semantic_layer_credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the semantic layer credential to map.
        """
        return pulumi.get(self, "semantic_layer_credential_id")

    @semantic_layer_credential_id.setter
    def semantic_layer_credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "semantic_layer_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceTokenId")
    def service_token_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the service token to map to the semantic layer credential.
        """
        return pulumi.get(self, "service_token_id")

    @service_token_id.setter
    def service_token_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "service_token_id", value)


@pulumi.type_token("dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping")
class SemanticLayerCredentialServiceTokenMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 service_token_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_mapping = dbtcloud.SemanticLayerCredentialServiceTokenMapping("test_mapping",
            semantic_layer_credential_id=test["id"],
            service_token_id=test_service_token["id"],
            project_id=test_project["id"])
        ```

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_semantic_layer_credential_service_token_mapping.example

          id = "id"

        }

        import {

          to = dbtcloud_semantic_layer_credential_service_token_mapping.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping example "id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the semantic layer credential is associated.
        :param pulumi.Input[_builtins.int] semantic_layer_credential_id: The ID of the semantic layer credential to map.
        :param pulumi.Input[_builtins.int] service_token_id: The ID of the service token to map to the semantic layer credential.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SemanticLayerCredentialServiceTokenMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        test_mapping = dbtcloud.SemanticLayerCredentialServiceTokenMapping("test_mapping",
            semantic_layer_credential_id=test["id"],
            service_token_id=test_service_token["id"],
            project_id=test_project["id"])
        ```

        ## Import

        using import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_semantic_layer_credential_service_token_mapping.example

          id = "id"

        }

        import {

          to = dbtcloud_semantic_layer_credential_service_token_mapping.example

          id = "12345"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping example "id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping example 12345
        ```

        :param str resource_name: The name of the resource.
        :param SemanticLayerCredentialServiceTokenMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SemanticLayerCredentialServiceTokenMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 semantic_layer_credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 service_token_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SemanticLayerCredentialServiceTokenMappingArgs.__new__(SemanticLayerCredentialServiceTokenMappingArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if semantic_layer_credential_id is None and not opts.urn:
                raise TypeError("Missing required property 'semantic_layer_credential_id'")
            __props__.__dict__["semantic_layer_credential_id"] = semantic_layer_credential_id
            if service_token_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_token_id'")
            __props__.__dict__["service_token_id"] = service_token_id
        super(SemanticLayerCredentialServiceTokenMapping, __self__).__init__(
            'dbtcloud:index/semanticLayerCredentialServiceTokenMapping:SemanticLayerCredentialServiceTokenMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            semantic_layer_credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            service_token_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'SemanticLayerCredentialServiceTokenMapping':
        """
        Get an existing SemanticLayerCredentialServiceTokenMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] project_id: The ID of the project to which the semantic layer credential is associated.
        :param pulumi.Input[_builtins.int] semantic_layer_credential_id: The ID of the semantic layer credential to map.
        :param pulumi.Input[_builtins.int] service_token_id: The ID of the service token to map to the semantic layer credential.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SemanticLayerCredentialServiceTokenMappingState.__new__(_SemanticLayerCredentialServiceTokenMappingState)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["semantic_layer_credential_id"] = semantic_layer_credential_id
        __props__.__dict__["service_token_id"] = service_token_id
        return SemanticLayerCredentialServiceTokenMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the project to which the semantic layer credential is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredentialId")
    def semantic_layer_credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the semantic layer credential to map.
        """
        return pulumi.get(self, "semantic_layer_credential_id")

    @_builtins.property
    @pulumi.getter(name="serviceTokenId")
    def service_token_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the service token to map to the semantic layer credential.
        """
        return pulumi.get(self, "service_token_id")

