# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SnowflakeCredentialArgs', 'SnowflakeCredential']

@pulumi.input_type
class SnowflakeCredentialArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[_builtins.str],
                 num_threads: pulumi.Input[_builtins.int],
                 project_id: pulumi.Input[_builtins.int],
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SnowflakeCredential resource.
        :param pulumi.Input[_builtins.str] auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Snowflake credential in
        :param pulumi.Input[_builtins.str] database: The catalog to connect use
        :param pulumi.Input[_builtins.bool] is_active: Whether the Snowflake credential is active
        :param pulumi.Input[_builtins.str] password: The password for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key: The private key for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key
        :param pulumi.Input[_builtins.str] role: The role to assume
        :param pulumi.Input[_builtins.str] schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse to use
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "num_threads", num_threads)
        pulumi.set(__self__, "project_id", project_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Input[_builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the Snowflake credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Snowflake credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the Snowflake account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key for the Snowflake account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the private key
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role to assume
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The warehouse to use
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)


@pulumi.input_type
class _SnowflakeCredentialState:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SnowflakeCredential resources.
        :param pulumi.Input[_builtins.str] auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] database: The catalog to connect use
        :param pulumi.Input[_builtins.bool] is_active: Whether the Snowflake credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.str] password: The password for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key: The private key for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Snowflake credential in
        :param pulumi.Input[_builtins.str] role: The role to assume
        :param pulumi.Input[_builtins.str] schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse to use
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if num_threads is not None:
            pulumi.set(__self__, "num_threads", num_threads)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if semantic_layer_credential is not None:
            pulumi.set(__self__, "semantic_layer_credential", semantic_layer_credential)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Snowflake credential is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_active", value)

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @num_threads.setter
    def num_threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_threads", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the Snowflake account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key for the Snowflake account
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passphrase for the private key
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the Snowflake credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role to assume
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @semantic_layer_credential.setter
    def semantic_layer_credential(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "semantic_layer_credential", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The warehouse to use
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)


@pulumi.type_token("dbtcloud:index/snowflakeCredential:SnowflakeCredential")
class SnowflakeCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Snowflake credential resource. This resource is used both as a stand-alone credential, but also as part of the Semantic Layer credential definition for Snowflake.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        prod_credential = dbtcloud.SnowflakeCredential("prod_credential",
            project_id=dbt_project["id"],
            auth_type="password",
            num_threads=16,
            schema="SCHEMA",
            user="user",
            password="password")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_snowflake_credential.prod_snowflake_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_snowflake_credential.prod_snowflake_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/snowflakeCredential:SnowflakeCredential prod_snowflake_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/snowflakeCredential:SnowflakeCredential prod_snowflake_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param pulumi.Input[_builtins.str] database: The catalog to connect use
        :param pulumi.Input[_builtins.bool] is_active: Whether the Snowflake credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.str] password: The password for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key: The private key for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Snowflake credential in
        :param pulumi.Input[_builtins.str] role: The role to assume
        :param pulumi.Input[_builtins.str] schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse to use
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnowflakeCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Snowflake credential resource. This resource is used both as a stand-alone credential, but also as part of the Semantic Layer credential definition for Snowflake.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_dbtcloud as dbtcloud

        prod_credential = dbtcloud.SnowflakeCredential("prod_credential",
            project_id=dbt_project["id"],
            auth_type="password",
            num_threads=16,
            schema="SCHEMA",
            user="user",
            password="password")
        ```

        ## Import

        using  import blocks (requires Terraform >= 1.5)

        import {

          to = dbtcloud_snowflake_credential.prod_snowflake_credential

          id = "project_id:credential_id"

        }

        import {

          to = dbtcloud_snowflake_credential.prod_snowflake_credential

          id = "12345:6789"

        }

        using the older import command

        ```sh
        $ pulumi import dbtcloud:index/snowflakeCredential:SnowflakeCredential prod_snowflake_credential "project_id:credential_id"
        ```

        ```sh
        $ pulumi import dbtcloud:index/snowflakeCredential:SnowflakeCredential prod_snowflake_credential 12345:6789
        ```

        :param str resource_name: The name of the resource.
        :param SnowflakeCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnowflakeCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 is_active: Optional[pulumi.Input[_builtins.bool]] = None,
                 num_threads: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnowflakeCredentialArgs.__new__(SnowflakeCredentialArgs)

            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["database"] = database
            __props__.__dict__["is_active"] = is_active
            if num_threads is None and not opts.urn:
                raise TypeError("Missing required property 'num_threads'")
            __props__.__dict__["num_threads"] = num_threads
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["private_key_passphrase"] = None if private_key_passphrase is None else pulumi.Output.secret(private_key_passphrase)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["role"] = role
            __props__.__dict__["schema"] = schema
            __props__.__dict__["semantic_layer_credential"] = semantic_layer_credential
            __props__.__dict__["user"] = user
            __props__.__dict__["warehouse"] = warehouse
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "privateKey", "privateKeyPassphrase"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SnowflakeCredential, __self__).__init__(
            'dbtcloud:index/snowflakeCredential:SnowflakeCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_type: Optional[pulumi.Input[_builtins.str]] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            is_active: Optional[pulumi.Input[_builtins.bool]] = None,
            num_threads: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            semantic_layer_credential: Optional[pulumi.Input[_builtins.bool]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            warehouse: Optional[pulumi.Input[_builtins.str]] = None) -> 'SnowflakeCredential':
        """
        Get an existing SnowflakeCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_type: The type of Snowflake credential ('password' or 'keypair')
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] database: The catalog to connect use
        :param pulumi.Input[_builtins.bool] is_active: Whether the Snowflake credential is active
        :param pulumi.Input[_builtins.int] num_threads: Number of threads to use
        :param pulumi.Input[_builtins.str] password: The password for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key: The private key for the Snowflake account
        :param pulumi.Input[_builtins.str] private_key_passphrase: The passphrase for the private key
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Snowflake credential in
        :param pulumi.Input[_builtins.str] role: The role to assume
        :param pulumi.Input[_builtins.str] schema: The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.bool] semantic_layer_credential: This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        :param pulumi.Input[_builtins.str] user: The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        :param pulumi.Input[_builtins.str] warehouse: The warehouse to use
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnowflakeCredentialState.__new__(_SnowflakeCredentialState)

        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["database"] = database
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["num_threads"] = num_threads
        __props__.__dict__["password"] = password
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["private_key_passphrase"] = private_key_passphrase
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role"] = role
        __props__.__dict__["schema"] = schema
        __props__.__dict__["semantic_layer_credential"] = semantic_layer_credential
        __props__.__dict__["user"] = user
        __props__.__dict__["warehouse"] = warehouse
        return SnowflakeCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Snowflake credential ('password' or 'keypair')
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The catalog to connect use
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Snowflake credential is active
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="numThreads")
    def num_threads(self) -> pulumi.Output[_builtins.int]:
        """
        Number of threads to use
        """
        return pulumi.get(self, "num_threads")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the Snowflake account
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key for the Snowflake account
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> pulumi.Output[_builtins.str]:
        """
        The passphrase for the private key
        """
        return pulumi.get(self, "private_key_passphrase")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the Snowflake credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role to assume
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema where to create models. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="semanticLayerCredential")
    def semantic_layer_credential(self) -> pulumi.Output[_builtins.bool]:
        """
        This field indicates that the credential is used as part of the Semantic Layer configuration. It is used to create a Snowflake credential for the Semantic Layer.
        """
        return pulumi.get(self, "semantic_layer_credential")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The username for the Snowflake account. This is an optional field ONLY if the credential is used for Semantic Layer configuration, otherwise it is required.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The warehouse to use
        """
        return pulumi.get(self, "warehouse")

