# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TeradataCredentialArgs', 'TeradataCredential']

@pulumi.input_type
class TeradataCredentialArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.int],
                 schema: pulumi.Input[_builtins.str],
                 user: pulumi.Input[_builtins.str],
                 threads: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a TeradataCredential resource.
        :param pulumi.Input[_builtins.str] password: The password for the Teradata account
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Teradata/Trino credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create models
        :param pulumi.Input[_builtins.str] user: The username for the Teradata account
        :param pulumi.Input[_builtins.int] threads: The number of threads to use. Default is 1
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "user", user)
        if threads is not None:
            pulumi.set(__self__, "threads", threads)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password for the Teradata account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.int]:
        """
        Project ID to create the Teradata/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The username for the Teradata account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of threads to use. Default is 1
        """
        return pulumi.get(self, "threads")

    @threads.setter
    def threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threads", value)


@pulumi.input_type
class _TeradataCredentialState:
    def __init__(__self__, *,
                 credential_id: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 threads: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TeradataCredential resources.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] password: The password for the Teradata account
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Teradata/Trino credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create models
        :param pulumi.Input[_builtins.int] threads: The number of threads to use. Default is 1
        :param pulumi.Input[_builtins.str] user: The username for the Teradata account
        """
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if threads is not None:
            pulumi.set(__self__, "threads", threads)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the Teradata account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Project ID to create the Teradata/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def threads(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of threads to use. Default is 1
        """
        return pulumi.get(self, "threads")

    @threads.setter
    def threads(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "threads", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username for the Teradata account
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("dbtcloud:index/teradataCredential:TeradataCredential")
class TeradataCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 threads: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Teradata credential resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The password for the Teradata account
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Teradata/Trino credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create models
        :param pulumi.Input[_builtins.int] threads: The number of threads to use. Default is 1
        :param pulumi.Input[_builtins.str] user: The username for the Teradata account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeradataCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Teradata credential resource

        :param str resource_name: The name of the resource.
        :param TeradataCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeradataCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 threads: Optional[pulumi.Input[_builtins.int]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeradataCredentialArgs.__new__(TeradataCredentialArgs)

            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["threads"] = threads
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["credential_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TeradataCredential, __self__).__init__(
            'dbtcloud:index/teradataCredential:TeradataCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_id: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.int]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            threads: Optional[pulumi.Input[_builtins.int]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'TeradataCredential':
        """
        Get an existing TeradataCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credential_id: The internal credential ID
        :param pulumi.Input[_builtins.str] password: The password for the Teradata account
        :param pulumi.Input[_builtins.int] project_id: Project ID to create the Teradata/Trino credential in
        :param pulumi.Input[_builtins.str] schema: The schema where to create models
        :param pulumi.Input[_builtins.int] threads: The number of threads to use. Default is 1
        :param pulumi.Input[_builtins.str] user: The username for the Teradata account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeradataCredentialState.__new__(_TeradataCredentialState)

        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["schema"] = schema
        __props__.__dict__["threads"] = threads
        __props__.__dict__["user"] = user
        return TeradataCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.int]:
        """
        The internal credential ID
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password for the Teradata account
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.int]:
        """
        Project ID to create the Teradata/Trino credential in
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema where to create models
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def threads(self) -> pulumi.Output[_builtins.int]:
        """
        The number of threads to use. Default is 1
        """
        return pulumi.get(self, "threads")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The username for the Teradata account
        """
        return pulumi.get(self, "user")

