# Warning: this file is auto-generated. Do not edit.

from ctypes import c_int, c_uint64
import enum


def succeeded(result) -> bool:
    return result >= 0


def failed(result) -> bool:
    return result < 0


def unqualified_success(result) -> bool:
    return result == 0


class DefaultEnumMeta(enum.EnumMeta):
    """
    Metaclass to allow default values in enumerations.

    https://stackoverflow.com/questions/44867597/is-there-a-way-to-specify-a-default-value-for-python-enums
    """
    def __call__(cls, *args, **kwargs):
        if len(args) < 1:
            # Enums with a zero should default to zero
            try:
                result = cls(0)
            except ValueError:
                # Otherwise assume the first enum is default
                result = next(iter(cls))
            return result
        else:
            return super().__call__(*args, **kwargs)


class EnumBase(enum.IntEnum, metaclass=DefaultEnumMeta):
    @staticmethod
    def ctype():
        return c_int


class FlagBase(enum.IntFlag, metaclass=DefaultEnumMeta):
    @staticmethod
    def ctype():
        return c_uint64


class Result(EnumBase):
    SUCCESS = 0
    TIMEOUT_EXPIRED = 1
    SESSION_LOSS_PENDING = 3
    EVENT_UNAVAILABLE = 4
    SPACE_BOUNDS_UNAVAILABLE = 7
    SESSION_NOT_FOCUSED = 8
    FRAME_DISCARDED = 9
    ERROR_VALIDATION_FAILURE = -1
    ERROR_RUNTIME_FAILURE = -2
    ERROR_OUT_OF_MEMORY = -3
    ERROR_API_VERSION_UNSUPPORTED = -4
    ERROR_INITIALIZATION_FAILED = -6
    ERROR_FUNCTION_UNSUPPORTED = -7
    ERROR_FEATURE_UNSUPPORTED = -8
    ERROR_EXTENSION_NOT_PRESENT = -9
    ERROR_LIMIT_REACHED = -10
    ERROR_SIZE_INSUFFICIENT = -11
    ERROR_HANDLE_INVALID = -12
    ERROR_INSTANCE_LOST = -13
    ERROR_SESSION_RUNNING = -14
    ERROR_SESSION_NOT_RUNNING = -16
    ERROR_SESSION_LOST = -17
    ERROR_SYSTEM_INVALID = -18
    ERROR_PATH_INVALID = -19
    ERROR_PATH_COUNT_EXCEEDED = -20
    ERROR_PATH_FORMAT_INVALID = -21
    ERROR_PATH_UNSUPPORTED = -22
    ERROR_LAYER_INVALID = -23
    ERROR_LAYER_LIMIT_EXCEEDED = -24
    ERROR_SWAPCHAIN_RECT_INVALID = -25
    ERROR_SWAPCHAIN_FORMAT_UNSUPPORTED = -26
    ERROR_ACTION_TYPE_MISMATCH = -27
    ERROR_SESSION_NOT_READY = -28
    ERROR_SESSION_NOT_STOPPING = -29
    ERROR_TIME_INVALID = -30
    ERROR_REFERENCE_SPACE_UNSUPPORTED = -31
    ERROR_FILE_ACCESS_ERROR = -32
    ERROR_FILE_CONTENTS_INVALID = -33
    ERROR_FORM_FACTOR_UNSUPPORTED = -34
    ERROR_FORM_FACTOR_UNAVAILABLE = -35
    ERROR_API_LAYER_NOT_PRESENT = -36
    ERROR_CALL_ORDER_INVALID = -37
    ERROR_GRAPHICS_DEVICE_INVALID = -38
    ERROR_POSE_INVALID = -39
    ERROR_INDEX_OUT_OF_RANGE = -40
    ERROR_VIEW_CONFIGURATION_TYPE_UNSUPPORTED = -41
    ERROR_ENVIRONMENT_BLEND_MODE_UNSUPPORTED = -42
    ERROR_NAME_DUPLICATED = -44
    ERROR_NAME_INVALID = -45
    ERROR_ACTIONSET_NOT_ATTACHED = -46
    ERROR_ACTIONSETS_ALREADY_ATTACHED = -47
    ERROR_LOCALIZED_NAME_DUPLICATED = -48
    ERROR_LOCALIZED_NAME_INVALID = -49
    ERROR_GRAPHICS_REQUIREMENTS_CALL_MISSING = -50
    ERROR_RUNTIME_UNAVAILABLE = -51
    ERROR_EXTENSION_DEPENDENCY_NOT_ENABLED = -1000710001
    ERROR_PERMISSION_INSUFFICIENT = -1000710000
    ERROR_ANDROID_THREAD_SETTINGS_ID_INVALID_KHR = -1000003000
    ERROR_ANDROID_THREAD_SETTINGS_FAILURE_KHR = -1000003001
    ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT = -1000039001
    ERROR_SECONDARY_VIEW_CONFIGURATION_TYPE_NOT_ENABLED_MSFT = -1000053000
    ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT = -1000055000
    ERROR_REPROJECTION_MODE_UNSUPPORTED_MSFT = -1000066000
    ERROR_COMPUTE_NEW_SCENE_NOT_COMPLETED_MSFT = -1000097000
    ERROR_SCENE_COMPONENT_ID_INVALID_MSFT = -1000097001
    ERROR_SCENE_COMPONENT_TYPE_MISMATCH_MSFT = -1000097002
    ERROR_SCENE_MESH_BUFFER_ID_INVALID_MSFT = -1000097003
    ERROR_SCENE_COMPUTE_FEATURE_INCOMPATIBLE_MSFT = -1000097004
    ERROR_SCENE_COMPUTE_CONSISTENCY_MISMATCH_MSFT = -1000097005
    ERROR_DISPLAY_REFRESH_RATE_UNSUPPORTED_FB = -1000101000
    ERROR_COLOR_SPACE_UNSUPPORTED_FB = -1000108000
    ERROR_SPACE_COMPONENT_NOT_SUPPORTED_FB = -1000113000
    ERROR_SPACE_COMPONENT_NOT_ENABLED_FB = -1000113001
    ERROR_SPACE_COMPONENT_STATUS_PENDING_FB = -1000113002
    ERROR_SPACE_COMPONENT_STATUS_ALREADY_SET_FB = -1000113003
    ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB = -1000118000
    ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB = -1000118001
    ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB = -1000118002
    ERROR_NOT_PERMITTED_PASSTHROUGH_FB = -1000118003
    ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB = -1000118004
    ERROR_UNKNOWN_PASSTHROUGH_FB = -1000118050
    ERROR_RENDER_MODEL_KEY_INVALID_FB = -1000119000
    RENDER_MODEL_UNAVAILABLE_FB = 1000119020
    ERROR_MARKER_NOT_TRACKED_VARJO = -1000124000
    ERROR_MARKER_ID_INVALID_VARJO = -1000124001
    ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML = -1000138000
    ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML = -1000138001
    ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML = -1000138002
    ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML = -1000138003
    ERROR_MARKER_INVALID_ML = -1000138004
    ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML = -1000139000
    ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML = -1000139001
    ERROR_LOCALIZATION_MAP_FAIL_ML = -1000139002
    ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML = -1000139003
    ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML = -1000139004
    ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML = -1000139005
    ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML = -1000139006
    ERROR_SPATIAL_ANCHORS_PERMISSION_DENIED_ML = -1000140000
    ERROR_SPATIAL_ANCHORS_NOT_LOCALIZED_ML = -1000140001
    ERROR_SPATIAL_ANCHORS_OUT_OF_MAP_BOUNDS_ML = -1000140002
    ERROR_SPATIAL_ANCHORS_SPACE_NOT_LOCATABLE_ML = -1000140003
    ERROR_SPATIAL_ANCHORS_ANCHOR_NOT_FOUND_ML = -1000141000
    ERROR_SPATIAL_ANCHOR_NAME_NOT_FOUND_MSFT = -1000142001
    ERROR_SPATIAL_ANCHOR_NAME_INVALID_MSFT = -1000142002
    SCENE_MARKER_DATA_NOT_STRING_MSFT = 1000147000
    ERROR_SPACE_MAPPING_INSUFFICIENT_FB = -1000169000
    ERROR_SPACE_LOCALIZATION_FAILED_FB = -1000169001
    ERROR_SPACE_NETWORK_TIMEOUT_FB = -1000169002
    ERROR_SPACE_NETWORK_REQUEST_FAILED_FB = -1000169003
    ERROR_SPACE_CLOUD_STORAGE_DISABLED_FB = -1000169004
    ERROR_SPACE_INSUFFICIENT_RESOURCES_META = -1000259000
    ERROR_SPACE_STORAGE_AT_CAPACITY_META = -1000259001
    ERROR_SPACE_INSUFFICIENT_VIEW_META = -1000259002
    ERROR_SPACE_PERMISSION_INSUFFICIENT_META = -1000259003
    ERROR_SPACE_RATE_LIMITED_META = -1000259004
    ERROR_SPACE_TOO_DARK_META = -1000259005
    ERROR_SPACE_TOO_BRIGHT_META = -1000259006
    ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META = -1000266000
    ENVIRONMENT_DEPTH_NOT_AVAILABLE_META = 1000291000
    ERROR_RENDER_MODEL_ID_INVALID_EXT = -1000300000
    ERROR_RENDER_MODEL_ASSET_UNAVAILABLE_EXT = -1000300001
    ERROR_RENDER_MODEL_GLTF_EXTENSION_REQUIRED_EXT = -1000300002
    ERROR_NOT_INTERACTION_RENDER_MODEL_EXT = -1000301000
    ERROR_HINT_ALREADY_SET_QCOM = -1000306000
    ERROR_NOT_AN_ANCHOR_HTC = -1000319000
    ERROR_SPATIAL_ENTITY_ID_INVALID_BD = -1000389000
    ERROR_SPATIAL_SENSING_SERVICE_UNAVAILABLE_BD = -1000389001
    ERROR_ANCHOR_NOT_SUPPORTED_FOR_ENTITY_BD = -1000389002
    ERROR_SPATIAL_ANCHOR_NOT_FOUND_BD = -1000390000
    ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_TIMEOUT_BD = -1000391000
    ERROR_SPATIAL_ANCHOR_SHARING_AUTHENTICATION_FAILURE_BD = -1000391001
    ERROR_SPATIAL_ANCHOR_SHARING_NETWORK_FAILURE_BD = -1000391002
    ERROR_SPATIAL_ANCHOR_SHARING_LOCALIZATION_FAIL_BD = -1000391003
    ERROR_SPATIAL_ANCHOR_SHARING_MAP_INSUFFICIENT_BD = -1000391004
    ERROR_SCENE_CAPTURE_FAILURE_BD = -1000392000
    ERROR_SPACE_NOT_LOCATABLE_EXT = -1000429000
    ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT = -1000429001
    ERROR_MISMATCHING_TRACKABLE_TYPE_ANDROID = -1000455000
    ERROR_TRACKABLE_TYPE_NOT_SUPPORTED_ANDROID = -1000455001
    ERROR_ANCHOR_ID_NOT_FOUND_ANDROID = -1000457000
    ERROR_ANCHOR_ALREADY_PERSISTED_ANDROID = -1000457001
    ERROR_ANCHOR_NOT_TRACKING_ANDROID = -1000457002
    ERROR_PERSISTED_DATA_NOT_READY_ANDROID = -1000457003
    ERROR_FUTURE_PENDING_EXT = -1000469001
    ERROR_FUTURE_INVALID_EXT = -1000469002
    ERROR_SYSTEM_NOTIFICATION_PERMISSION_DENIED_ML = -1000473000
    ERROR_SYSTEM_NOTIFICATION_INCOMPATIBLE_SKU_ML = -1000473001
    ERROR_WORLD_MESH_DETECTOR_PERMISSION_DENIED_ML = -1000474000
    ERROR_WORLD_MESH_DETECTOR_SPACE_NOT_LOCATABLE_ML = -1000474001
    ERROR_FACIAL_EXPRESSION_PERMISSION_DENIED_ML = 1000482000
    ERROR_COLOCATION_DISCOVERY_NETWORK_FAILED_META = -1000571001
    ERROR_COLOCATION_DISCOVERY_NO_DISCOVERY_METHOD_META = -1000571002
    COLOCATION_DISCOVERY_ALREADY_ADVERTISING_META = 1000571003
    COLOCATION_DISCOVERY_ALREADY_DISCOVERING_META = 1000571004
    ERROR_SPACE_GROUP_NOT_FOUND_META = -1000572002
    ERROR_ANCHOR_NOT_OWNED_BY_CALLER_ANDROID = -1000701000
    ERROR_SPATIAL_CAPABILITY_UNSUPPORTED_EXT = -1000740001
    ERROR_SPATIAL_ENTITY_ID_INVALID_EXT = -1000740002
    ERROR_SPATIAL_BUFFER_ID_INVALID_EXT = -1000740003
    ERROR_SPATIAL_COMPONENT_UNSUPPORTED_FOR_CAPABILITY_EXT = -1000740004
    ERROR_SPATIAL_CAPABILITY_CONFIGURATION_INVALID_EXT = -1000740005
    ERROR_SPATIAL_COMPONENT_NOT_ENABLED_EXT = -1000740006
    ERROR_SPATIAL_PERSISTENCE_SCOPE_UNSUPPORTED_EXT = -1000763001
    ERROR_SPATIAL_PERSISTENCE_SCOPE_INCOMPATIBLE_EXT = -1000781001
    ERROR_EXTENSION_DEPENDENCY_NOT_ENABLED_KHR = -1000710001
    ERROR_PERMISSION_INSUFFICIENT_KHR = -1000710000


class StructureType(EnumBase):
    UNKNOWN = 0
    API_LAYER_PROPERTIES = 1
    EXTENSION_PROPERTIES = 2
    INSTANCE_CREATE_INFO = 3
    SYSTEM_GET_INFO = 4
    SYSTEM_PROPERTIES = 5
    VIEW_LOCATE_INFO = 6
    VIEW = 7
    SESSION_CREATE_INFO = 8
    SWAPCHAIN_CREATE_INFO = 9
    SESSION_BEGIN_INFO = 10
    VIEW_STATE = 11
    FRAME_END_INFO = 12
    HAPTIC_VIBRATION = 13
    EVENT_DATA_BUFFER = 16
    EVENT_DATA_INSTANCE_LOSS_PENDING = 17
    EVENT_DATA_SESSION_STATE_CHANGED = 18
    ACTION_STATE_BOOLEAN = 23
    ACTION_STATE_FLOAT = 24
    ACTION_STATE_VECTOR2F = 25
    ACTION_STATE_POSE = 27
    ACTION_SET_CREATE_INFO = 28
    ACTION_CREATE_INFO = 29
    INSTANCE_PROPERTIES = 32
    FRAME_WAIT_INFO = 33
    COMPOSITION_LAYER_PROJECTION = 35
    COMPOSITION_LAYER_QUAD = 36
    REFERENCE_SPACE_CREATE_INFO = 37
    ACTION_SPACE_CREATE_INFO = 38
    EVENT_DATA_REFERENCE_SPACE_CHANGE_PENDING = 40
    VIEW_CONFIGURATION_VIEW = 41
    SPACE_LOCATION = 42
    SPACE_VELOCITY = 43
    FRAME_STATE = 44
    VIEW_CONFIGURATION_PROPERTIES = 45
    FRAME_BEGIN_INFO = 46
    COMPOSITION_LAYER_PROJECTION_VIEW = 48
    EVENT_DATA_EVENTS_LOST = 49
    INTERACTION_PROFILE_SUGGESTED_BINDING = 51
    EVENT_DATA_INTERACTION_PROFILE_CHANGED = 52
    INTERACTION_PROFILE_STATE = 53
    SWAPCHAIN_IMAGE_ACQUIRE_INFO = 55
    SWAPCHAIN_IMAGE_WAIT_INFO = 56
    SWAPCHAIN_IMAGE_RELEASE_INFO = 57
    ACTION_STATE_GET_INFO = 58
    HAPTIC_ACTION_INFO = 59
    SESSION_ACTION_SETS_ATTACH_INFO = 60
    ACTIONS_SYNC_INFO = 61
    BOUND_SOURCES_FOR_ACTION_ENUMERATE_INFO = 62
    INPUT_SOURCE_LOCALIZED_NAME_GET_INFO = 63
    SPACES_LOCATE_INFO = 1000471000
    SPACE_LOCATIONS = 1000471001
    SPACE_VELOCITIES = 1000471002
    COMPOSITION_LAYER_CUBE_KHR = 1000006000
    INSTANCE_CREATE_INFO_ANDROID_KHR = 1000008000
    COMPOSITION_LAYER_DEPTH_INFO_KHR = 1000010000
    VULKAN_SWAPCHAIN_FORMAT_LIST_CREATE_INFO_KHR = 1000014000
    EVENT_DATA_PERF_SETTINGS_EXT = 1000015000
    COMPOSITION_LAYER_CYLINDER_KHR = 1000017000
    COMPOSITION_LAYER_EQUIRECT_KHR = 1000018000
    DEBUG_UTILS_OBJECT_NAME_INFO_EXT = 1000019000
    DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT = 1000019001
    DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT = 1000019002
    DEBUG_UTILS_LABEL_EXT = 1000019003
    GRAPHICS_BINDING_OPENGL_WIN32_KHR = 1000023000
    GRAPHICS_BINDING_OPENGL_XLIB_KHR = 1000023001
    GRAPHICS_BINDING_OPENGL_XCB_KHR = 1000023002
    GRAPHICS_BINDING_OPENGL_WAYLAND_KHR = 1000023003
    SWAPCHAIN_IMAGE_OPENGL_KHR = 1000023004
    GRAPHICS_REQUIREMENTS_OPENGL_KHR = 1000023005
    GRAPHICS_BINDING_OPENGL_ES_ANDROID_KHR = 1000024001
    SWAPCHAIN_IMAGE_OPENGL_ES_KHR = 1000024002
    GRAPHICS_REQUIREMENTS_OPENGL_ES_KHR = 1000024003
    GRAPHICS_BINDING_VULKAN_KHR = 1000025000
    SWAPCHAIN_IMAGE_VULKAN_KHR = 1000025001
    GRAPHICS_REQUIREMENTS_VULKAN_KHR = 1000025002
    GRAPHICS_BINDING_D3D11_KHR = 1000027000
    SWAPCHAIN_IMAGE_D3D11_KHR = 1000027001
    GRAPHICS_REQUIREMENTS_D3D11_KHR = 1000027002
    GRAPHICS_BINDING_D3D12_KHR = 1000028000
    SWAPCHAIN_IMAGE_D3D12_KHR = 1000028001
    GRAPHICS_REQUIREMENTS_D3D12_KHR = 1000028002
    GRAPHICS_BINDING_METAL_KHR = 1000029000
    SWAPCHAIN_IMAGE_METAL_KHR = 1000029001
    GRAPHICS_REQUIREMENTS_METAL_KHR = 1000029002
    SYSTEM_EYE_GAZE_INTERACTION_PROPERTIES_EXT = 1000030000
    EYE_GAZE_SAMPLE_TIME_EXT = 1000030001
    VISIBILITY_MASK_KHR = 1000031000
    EVENT_DATA_VISIBILITY_MASK_CHANGED_KHR = 1000031001
    SESSION_CREATE_INFO_OVERLAY_EXTX = 1000033000
    EVENT_DATA_MAIN_SESSION_VISIBILITY_CHANGED_EXTX = 1000033003
    COMPOSITION_LAYER_COLOR_SCALE_BIAS_KHR = 1000034000
    SPATIAL_ANCHOR_CREATE_INFO_MSFT = 1000039000
    SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT = 1000039001
    COMPOSITION_LAYER_IMAGE_LAYOUT_FB = 1000040000
    COMPOSITION_LAYER_ALPHA_BLEND_FB = 1000041001
    VIEW_CONFIGURATION_DEPTH_RANGE_EXT = 1000046000
    GRAPHICS_BINDING_EGL_MNDX = 1000048004
    SPATIAL_GRAPH_NODE_SPACE_CREATE_INFO_MSFT = 1000049000
    SPATIAL_GRAPH_STATIC_NODE_BINDING_CREATE_INFO_MSFT = 1000049001
    SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_GET_INFO_MSFT = 1000049002
    SPATIAL_GRAPH_NODE_BINDING_PROPERTIES_MSFT = 1000049003
    SYSTEM_HAND_TRACKING_PROPERTIES_EXT = 1000051000
    HAND_TRACKER_CREATE_INFO_EXT = 1000051001
    HAND_JOINTS_LOCATE_INFO_EXT = 1000051002
    HAND_JOINT_LOCATIONS_EXT = 1000051003
    HAND_JOINT_VELOCITIES_EXT = 1000051004
    SYSTEM_HAND_TRACKING_MESH_PROPERTIES_MSFT = 1000052000
    HAND_MESH_SPACE_CREATE_INFO_MSFT = 1000052001
    HAND_MESH_UPDATE_INFO_MSFT = 1000052002
    HAND_MESH_MSFT = 1000052003
    HAND_POSE_TYPE_INFO_MSFT = 1000052004
    SECONDARY_VIEW_CONFIGURATION_SESSION_BEGIN_INFO_MSFT = 1000053000
    SECONDARY_VIEW_CONFIGURATION_STATE_MSFT = 1000053001
    SECONDARY_VIEW_CONFIGURATION_FRAME_STATE_MSFT = 1000053002
    SECONDARY_VIEW_CONFIGURATION_FRAME_END_INFO_MSFT = 1000053003
    SECONDARY_VIEW_CONFIGURATION_LAYER_INFO_MSFT = 1000053004
    SECONDARY_VIEW_CONFIGURATION_SWAPCHAIN_CREATE_INFO_MSFT = 1000053005
    CONTROLLER_MODEL_KEY_STATE_MSFT = 1000055000
    CONTROLLER_MODEL_NODE_PROPERTIES_MSFT = 1000055001
    CONTROLLER_MODEL_PROPERTIES_MSFT = 1000055002
    CONTROLLER_MODEL_NODE_STATE_MSFT = 1000055003
    CONTROLLER_MODEL_STATE_MSFT = 1000055004
    VIEW_CONFIGURATION_VIEW_FOV_EPIC = 1000059000
    HOLOGRAPHIC_WINDOW_ATTACHMENT_MSFT = 1000063000
    COMPOSITION_LAYER_REPROJECTION_INFO_MSFT = 1000066000
    COMPOSITION_LAYER_REPROJECTION_PLANE_OVERRIDE_MSFT = 1000066001
    ANDROID_SURFACE_SWAPCHAIN_CREATE_INFO_FB = 1000070000
    COMPOSITION_LAYER_SECURE_CONTENT_FB = 1000072000
    BODY_TRACKER_CREATE_INFO_FB = 1000076001
    BODY_JOINTS_LOCATE_INFO_FB = 1000076002
    SYSTEM_BODY_TRACKING_PROPERTIES_FB = 1000076004
    BODY_JOINT_LOCATIONS_FB = 1000076005
    BODY_SKELETON_FB = 1000076006
    INTERACTION_PROFILE_DPAD_BINDING_EXT = 1000078000
    INTERACTION_PROFILE_ANALOG_THRESHOLD_VALVE = 1000079000
    HAND_JOINTS_MOTION_RANGE_INFO_EXT = 1000080000
    LOADER_INIT_INFO_ANDROID_KHR = 1000089000
    VULKAN_INSTANCE_CREATE_INFO_KHR = 1000090000
    VULKAN_DEVICE_CREATE_INFO_KHR = 1000090001
    VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR = 1000090003
    COMPOSITION_LAYER_EQUIRECT2_KHR = 1000091000
    SCENE_OBSERVER_CREATE_INFO_MSFT = 1000097000
    SCENE_CREATE_INFO_MSFT = 1000097001
    NEW_SCENE_COMPUTE_INFO_MSFT = 1000097002
    VISUAL_MESH_COMPUTE_LOD_INFO_MSFT = 1000097003
    SCENE_COMPONENTS_MSFT = 1000097004
    SCENE_COMPONENTS_GET_INFO_MSFT = 1000097005
    SCENE_COMPONENT_LOCATIONS_MSFT = 1000097006
    SCENE_COMPONENTS_LOCATE_INFO_MSFT = 1000097007
    SCENE_OBJECTS_MSFT = 1000097008
    SCENE_COMPONENT_PARENT_FILTER_INFO_MSFT = 1000097009
    SCENE_OBJECT_TYPES_FILTER_INFO_MSFT = 1000097010
    SCENE_PLANES_MSFT = 1000097011
    SCENE_PLANE_ALIGNMENT_FILTER_INFO_MSFT = 1000097012
    SCENE_MESHES_MSFT = 1000097013
    SCENE_MESH_BUFFERS_GET_INFO_MSFT = 1000097014
    SCENE_MESH_BUFFERS_MSFT = 1000097015
    SCENE_MESH_VERTEX_BUFFER_MSFT = 1000097016
    SCENE_MESH_INDICES_UINT32_MSFT = 1000097017
    SCENE_MESH_INDICES_UINT16_MSFT = 1000097018
    SERIALIZED_SCENE_FRAGMENT_DATA_GET_INFO_MSFT = 1000098000
    SCENE_DESERIALIZE_INFO_MSFT = 1000098001
    EVENT_DATA_DISPLAY_REFRESH_RATE_CHANGED_FB = 1000101000
    VIVE_TRACKER_PATHS_HTCX = 1000103000
    EVENT_DATA_VIVE_TRACKER_CONNECTED_HTCX = 1000103001
    SYSTEM_FACIAL_TRACKING_PROPERTIES_HTC = 1000104000
    FACIAL_TRACKER_CREATE_INFO_HTC = 1000104001
    FACIAL_EXPRESSIONS_HTC = 1000104002
    SYSTEM_COLOR_SPACE_PROPERTIES_FB = 1000108000
    HAND_TRACKING_MESH_FB = 1000110001
    HAND_TRACKING_SCALE_FB = 1000110003
    HAND_TRACKING_AIM_STATE_FB = 1000111001
    HAND_TRACKING_CAPSULES_STATE_FB = 1000112000
    SYSTEM_SPATIAL_ENTITY_PROPERTIES_FB = 1000113004
    SPATIAL_ANCHOR_CREATE_INFO_FB = 1000113003
    SPACE_COMPONENT_STATUS_SET_INFO_FB = 1000113007
    SPACE_COMPONENT_STATUS_FB = 1000113001
    EVENT_DATA_SPATIAL_ANCHOR_CREATE_COMPLETE_FB = 1000113005
    EVENT_DATA_SPACE_SET_STATUS_COMPLETE_FB = 1000113006
    FOVEATION_PROFILE_CREATE_INFO_FB = 1000114000
    SWAPCHAIN_CREATE_INFO_FOVEATION_FB = 1000114001
    SWAPCHAIN_STATE_FOVEATION_FB = 1000114002
    FOVEATION_LEVEL_PROFILE_CREATE_INFO_FB = 1000115000
    KEYBOARD_SPACE_CREATE_INFO_FB = 1000116009
    KEYBOARD_TRACKING_QUERY_FB = 1000116004
    SYSTEM_KEYBOARD_TRACKING_PROPERTIES_FB = 1000116002
    TRIANGLE_MESH_CREATE_INFO_FB = 1000117001
    SYSTEM_PASSTHROUGH_PROPERTIES_FB = 1000118000
    PASSTHROUGH_CREATE_INFO_FB = 1000118001
    PASSTHROUGH_LAYER_CREATE_INFO_FB = 1000118002
    COMPOSITION_LAYER_PASSTHROUGH_FB = 1000118003
    GEOMETRY_INSTANCE_CREATE_INFO_FB = 1000118004
    GEOMETRY_INSTANCE_TRANSFORM_FB = 1000118005
    SYSTEM_PASSTHROUGH_PROPERTIES2_FB = 1000118006
    PASSTHROUGH_STYLE_FB = 1000118020
    PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB = 1000118021
    PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB = 1000118022
    PASSTHROUGH_BRIGHTNESS_CONTRAST_SATURATION_FB = 1000118023
    EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB = 1000118030
    RENDER_MODEL_PATH_INFO_FB = 1000119000
    RENDER_MODEL_PROPERTIES_FB = 1000119001
    RENDER_MODEL_BUFFER_FB = 1000119002
    RENDER_MODEL_LOAD_INFO_FB = 1000119003
    SYSTEM_RENDER_MODEL_PROPERTIES_FB = 1000119004
    RENDER_MODEL_CAPABILITIES_REQUEST_FB = 1000119005
    BINDING_MODIFICATIONS_KHR = 1000120000
    VIEW_LOCATE_FOVEATED_RENDERING_VARJO = 1000121000
    FOVEATED_VIEW_CONFIGURATION_VIEW_VARJO = 1000121001
    SYSTEM_FOVEATED_RENDERING_PROPERTIES_VARJO = 1000121002
    COMPOSITION_LAYER_DEPTH_TEST_VARJO = 1000122000
    SYSTEM_MARKER_TRACKING_PROPERTIES_VARJO = 1000124000
    EVENT_DATA_MARKER_TRACKING_UPDATE_VARJO = 1000124001
    MARKER_SPACE_CREATE_INFO_VARJO = 1000124002
    FRAME_END_INFO_ML = 1000135000
    GLOBAL_DIMMER_FRAME_END_INFO_ML = 1000136000
    COORDINATE_SPACE_CREATE_INFO_ML = 1000137000
    SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML = 1000138000
    MARKER_DETECTOR_CREATE_INFO_ML = 1000138001
    MARKER_DETECTOR_ARUCO_INFO_ML = 1000138002
    MARKER_DETECTOR_SIZE_INFO_ML = 1000138003
    MARKER_DETECTOR_APRIL_TAG_INFO_ML = 1000138004
    MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML = 1000138005
    MARKER_DETECTOR_SNAPSHOT_INFO_ML = 1000138006
    MARKER_DETECTOR_STATE_ML = 1000138007
    MARKER_SPACE_CREATE_INFO_ML = 1000138008
    LOCALIZATION_MAP_ML = 1000139000
    EVENT_DATA_LOCALIZATION_CHANGED_ML = 1000139001
    MAP_LOCALIZATION_REQUEST_INFO_ML = 1000139002
    LOCALIZATION_MAP_IMPORT_INFO_ML = 1000139003
    LOCALIZATION_ENABLE_EVENTS_INFO_ML = 1000139004
    SPATIAL_ANCHORS_CREATE_INFO_FROM_POSE_ML = 1000140000
    CREATE_SPATIAL_ANCHORS_COMPLETION_ML = 1000140001
    SPATIAL_ANCHOR_STATE_ML = 1000140002
    SPATIAL_ANCHORS_CREATE_STORAGE_INFO_ML = 1000141000
    SPATIAL_ANCHORS_QUERY_INFO_RADIUS_ML = 1000141001
    SPATIAL_ANCHORS_QUERY_COMPLETION_ML = 1000141002
    SPATIAL_ANCHORS_CREATE_INFO_FROM_UUIDS_ML = 1000141003
    SPATIAL_ANCHORS_PUBLISH_INFO_ML = 1000141004
    SPATIAL_ANCHORS_PUBLISH_COMPLETION_ML = 1000141005
    SPATIAL_ANCHORS_DELETE_INFO_ML = 1000141006
    SPATIAL_ANCHORS_DELETE_COMPLETION_ML = 1000141007
    SPATIAL_ANCHORS_UPDATE_EXPIRATION_INFO_ML = 1000141008
    SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_ML = 1000141009
    SPATIAL_ANCHORS_PUBLISH_COMPLETION_DETAILS_ML = 1000141010
    SPATIAL_ANCHORS_DELETE_COMPLETION_DETAILS_ML = 1000141011
    SPATIAL_ANCHORS_UPDATE_EXPIRATION_COMPLETION_DETAILS_ML = 1000141012
    EVENT_DATA_HEADSET_FIT_CHANGED_ML = 1000472000
    EVENT_DATA_EYE_CALIBRATION_CHANGED_ML = 1000472001
    USER_CALIBRATION_ENABLE_EVENTS_INFO_ML = 1000472002
    SPATIAL_ANCHOR_PERSISTENCE_INFO_MSFT = 1000142000
    SPATIAL_ANCHOR_FROM_PERSISTED_ANCHOR_CREATE_INFO_MSFT = 1000142001
    SCENE_MARKERS_MSFT = 1000147000
    SCENE_MARKER_TYPE_FILTER_MSFT = 1000147001
    SCENE_MARKER_QR_CODES_MSFT = 1000147002
    SPACE_QUERY_INFO_FB = 1000156001
    SPACE_QUERY_RESULTS_FB = 1000156002
    SPACE_STORAGE_LOCATION_FILTER_INFO_FB = 1000156003
    SPACE_UUID_FILTER_INFO_FB = 1000156054
    SPACE_COMPONENT_FILTER_INFO_FB = 1000156052
    EVENT_DATA_SPACE_QUERY_RESULTS_AVAILABLE_FB = 1000156103
    EVENT_DATA_SPACE_QUERY_COMPLETE_FB = 1000156104
    SPACE_SAVE_INFO_FB = 1000158000
    SPACE_ERASE_INFO_FB = 1000158001
    EVENT_DATA_SPACE_SAVE_COMPLETE_FB = 1000158106
    EVENT_DATA_SPACE_ERASE_COMPLETE_FB = 1000158107
    SWAPCHAIN_IMAGE_FOVEATION_VULKAN_FB = 1000160000
    SWAPCHAIN_STATE_ANDROID_SURFACE_DIMENSIONS_FB = 1000161000
    SWAPCHAIN_STATE_SAMPLER_OPENGL_ES_FB = 1000162000
    SWAPCHAIN_STATE_SAMPLER_VULKAN_FB = 1000163000
    SPACE_SHARE_INFO_FB = 1000169001
    EVENT_DATA_SPACE_SHARE_COMPLETE_FB = 1000169002
    COMPOSITION_LAYER_SPACE_WARP_INFO_FB = 1000171000
    SYSTEM_SPACE_WARP_PROPERTIES_FB = 1000171001
    HAPTIC_AMPLITUDE_ENVELOPE_VIBRATION_FB = 1000173001
    SEMANTIC_LABELS_FB = 1000175000
    ROOM_LAYOUT_FB = 1000175001
    BOUNDARY_2D_FB = 1000175002
    SEMANTIC_LABELS_SUPPORT_INFO_FB = 1000175010
    DIGITAL_LENS_CONTROL_ALMALENCE = 1000196000
    EVENT_DATA_SCENE_CAPTURE_COMPLETE_FB = 1000198001
    SCENE_CAPTURE_REQUEST_INFO_FB = 1000198050
    SPACE_CONTAINER_FB = 1000199000
    FOVEATION_EYE_TRACKED_PROFILE_CREATE_INFO_META = 1000200000
    FOVEATION_EYE_TRACKED_STATE_META = 1000200001
    SYSTEM_FOVEATION_EYE_TRACKED_PROPERTIES_META = 1000200002
    SYSTEM_FACE_TRACKING_PROPERTIES_FB = 1000201004
    FACE_TRACKER_CREATE_INFO_FB = 1000201005
    FACE_EXPRESSION_INFO_FB = 1000201002
    FACE_EXPRESSION_WEIGHTS_FB = 1000201006
    EYE_TRACKER_CREATE_INFO_FB = 1000202001
    EYE_GAZES_INFO_FB = 1000202002
    EYE_GAZES_FB = 1000202003
    SYSTEM_EYE_TRACKING_PROPERTIES_FB = 1000202004
    PASSTHROUGH_KEYBOARD_HANDS_INTENSITY_FB = 1000203002
    COMPOSITION_LAYER_SETTINGS_FB = 1000204000
    HAPTIC_PCM_VIBRATION_FB = 1000209001
    DEVICE_PCM_SAMPLE_RATE_STATE_FB = 1000209002
    FRAME_SYNTHESIS_INFO_EXT = 1000211000
    FRAME_SYNTHESIS_CONFIG_VIEW_EXT = 1000211001
    COMPOSITION_LAYER_DEPTH_TEST_FB = 1000212000
    LOCAL_DIMMING_FRAME_END_INFO_META = 1000216000
    PASSTHROUGH_PREFERENCES_META = 1000217000
    SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META = 1000219001
    VIRTUAL_KEYBOARD_CREATE_INFO_META = 1000219002
    VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META = 1000219003
    VIRTUAL_KEYBOARD_LOCATION_INFO_META = 1000219004
    VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META = 1000219005
    VIRTUAL_KEYBOARD_ANIMATION_STATE_META = 1000219006
    VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META = 1000219007
    VIRTUAL_KEYBOARD_TEXTURE_DATA_META = 1000219009
    VIRTUAL_KEYBOARD_INPUT_INFO_META = 1000219010
    VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META = 1000219011
    EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META = 1000219014
    EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META = 1000219015
    EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META = 1000219016
    EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META = 1000219017
    EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META = 1000219018
    EXTERNAL_CAMERA_OCULUS = 1000226000
    VULKAN_SWAPCHAIN_CREATE_INFO_META = 1000227000
    PERFORMANCE_METRICS_STATE_META = 1000232001
    PERFORMANCE_METRICS_COUNTER_META = 1000232002
    SPACE_LIST_SAVE_INFO_FB = 1000238000
    EVENT_DATA_SPACE_LIST_SAVE_COMPLETE_FB = 1000238001
    SPACE_USER_CREATE_INFO_FB = 1000241001
    SYSTEM_HEADSET_ID_PROPERTIES_META = 1000245000
    SYSTEM_SPACE_DISCOVERY_PROPERTIES_META = 1000247000
    SPACE_DISCOVERY_INFO_META = 1000247001
    SPACE_FILTER_UUID_META = 1000247003
    SPACE_FILTER_COMPONENT_META = 1000247004
    SPACE_DISCOVERY_RESULT_META = 1000247005
    SPACE_DISCOVERY_RESULTS_META = 1000247006
    EVENT_DATA_SPACE_DISCOVERY_RESULTS_AVAILABLE_META = 1000247007
    EVENT_DATA_SPACE_DISCOVERY_COMPLETE_META = 1000247008
    RECOMMENDED_LAYER_RESOLUTION_META = 1000254000
    RECOMMENDED_LAYER_RESOLUTION_GET_INFO_META = 1000254001
    SYSTEM_SPACE_PERSISTENCE_PROPERTIES_META = 1000259000
    SPACES_SAVE_INFO_META = 1000259001
    EVENT_DATA_SPACES_SAVE_RESULT_META = 1000259002
    SPACES_ERASE_INFO_META = 1000259003
    EVENT_DATA_SPACES_ERASE_RESULT_META = 1000259004
    SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META = 1000266000
    PASSTHROUGH_COLOR_LUT_CREATE_INFO_META = 1000266001
    PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META = 1000266002
    PASSTHROUGH_COLOR_MAP_LUT_META = 1000266100
    PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META = 1000266101
    SPACE_TRIANGLE_MESH_GET_INFO_META = 1000269001
    SPACE_TRIANGLE_MESH_META = 1000269002
    SYSTEM_PROPERTIES_BODY_TRACKING_FULL_BODY_META = 1000274000
    EVENT_DATA_PASSTHROUGH_LAYER_RESUMED_META = 1000282000
    BODY_TRACKING_CALIBRATION_INFO_META = 1000283002
    BODY_TRACKING_CALIBRATION_STATUS_META = 1000283003
    SYSTEM_PROPERTIES_BODY_TRACKING_CALIBRATION_META = 1000283004
    SYSTEM_FACE_TRACKING_PROPERTIES2_FB = 1000287013
    FACE_TRACKER_CREATE_INFO2_FB = 1000287014
    FACE_EXPRESSION_INFO2_FB = 1000287015
    FACE_EXPRESSION_WEIGHTS2_FB = 1000287016
    SYSTEM_SPATIAL_ENTITY_SHARING_PROPERTIES_META = 1000290000
    SHARE_SPACES_INFO_META = 1000290001
    EVENT_DATA_SHARE_SPACES_COMPLETE_META = 1000290002
    ENVIRONMENT_DEPTH_PROVIDER_CREATE_INFO_META = 1000291000
    ENVIRONMENT_DEPTH_SWAPCHAIN_CREATE_INFO_META = 1000291001
    ENVIRONMENT_DEPTH_SWAPCHAIN_STATE_META = 1000291002
    ENVIRONMENT_DEPTH_IMAGE_ACQUIRE_INFO_META = 1000291003
    ENVIRONMENT_DEPTH_IMAGE_VIEW_META = 1000291004
    ENVIRONMENT_DEPTH_IMAGE_META = 1000291005
    ENVIRONMENT_DEPTH_HAND_REMOVAL_SET_INFO_META = 1000291006
    SYSTEM_ENVIRONMENT_DEPTH_PROPERTIES_META = 1000291007
    RENDER_MODEL_CREATE_INFO_EXT = 1000300000
    RENDER_MODEL_PROPERTIES_GET_INFO_EXT = 1000300001
    RENDER_MODEL_PROPERTIES_EXT = 1000300002
    RENDER_MODEL_SPACE_CREATE_INFO_EXT = 1000300003
    RENDER_MODEL_STATE_GET_INFO_EXT = 1000300004
    RENDER_MODEL_STATE_EXT = 1000300005
    RENDER_MODEL_ASSET_CREATE_INFO_EXT = 1000300006
    RENDER_MODEL_ASSET_DATA_GET_INFO_EXT = 1000300007
    RENDER_MODEL_ASSET_DATA_EXT = 1000300008
    RENDER_MODEL_ASSET_PROPERTIES_GET_INFO_EXT = 1000300009
    RENDER_MODEL_ASSET_PROPERTIES_EXT = 1000300010
    INTERACTION_RENDER_MODEL_IDS_ENUMERATE_INFO_EXT = 1000301000
    INTERACTION_RENDER_MODEL_SUBACTION_PATH_INFO_EXT = 1000301001
    EVENT_DATA_INTERACTION_RENDER_MODELS_CHANGED_EXT = 1000301002
    INTERACTION_RENDER_MODEL_TOP_LEVEL_USER_PATH_GET_INFO_EXT = 1000301003
    PASSTHROUGH_CREATE_INFO_HTC = 1000317001
    PASSTHROUGH_COLOR_HTC = 1000317002
    PASSTHROUGH_MESH_TRANSFORM_INFO_HTC = 1000317003
    COMPOSITION_LAYER_PASSTHROUGH_HTC = 1000317004
    FOVEATION_APPLY_INFO_HTC = 1000318000
    FOVEATION_DYNAMIC_MODE_INFO_HTC = 1000318001
    FOVEATION_CUSTOM_MODE_INFO_HTC = 1000318002
    SYSTEM_ANCHOR_PROPERTIES_HTC = 1000319000
    SPATIAL_ANCHOR_CREATE_INFO_HTC = 1000319001
    SYSTEM_BODY_TRACKING_PROPERTIES_HTC = 1000320000
    BODY_TRACKER_CREATE_INFO_HTC = 1000320001
    BODY_JOINTS_LOCATE_INFO_HTC = 1000320002
    BODY_JOINT_LOCATIONS_HTC = 1000320003
    BODY_SKELETON_HTC = 1000320004
    ACTIVE_ACTION_SET_PRIORITIES_EXT = 1000373000
    SYSTEM_FORCE_FEEDBACK_CURL_PROPERTIES_MNDX = 1000375000
    FORCE_FEEDBACK_CURL_APPLY_LOCATIONS_MNDX = 1000375001
    BODY_TRACKER_CREATE_INFO_BD = 1000385001
    BODY_JOINTS_LOCATE_INFO_BD = 1000385002
    BODY_JOINT_LOCATIONS_BD = 1000385003
    SYSTEM_BODY_TRACKING_PROPERTIES_BD = 1000385004
    SYSTEM_SPATIAL_SENSING_PROPERTIES_BD = 1000389000
    SPATIAL_ENTITY_COMPONENT_GET_INFO_BD = 1000389001
    SPATIAL_ENTITY_LOCATION_GET_INFO_BD = 1000389002
    SPATIAL_ENTITY_COMPONENT_DATA_LOCATION_BD = 1000389003
    SPATIAL_ENTITY_COMPONENT_DATA_SEMANTIC_BD = 1000389004
    SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_2D_BD = 1000389005
    SPATIAL_ENTITY_COMPONENT_DATA_POLYGON_BD = 1000389006
    SPATIAL_ENTITY_COMPONENT_DATA_BOUNDING_BOX_3D_BD = 1000389007
    SPATIAL_ENTITY_COMPONENT_DATA_TRIANGLE_MESH_BD = 1000389008
    SENSE_DATA_PROVIDER_CREATE_INFO_BD = 1000389009
    SENSE_DATA_PROVIDER_START_INFO_BD = 1000389010
    EVENT_DATA_SENSE_DATA_PROVIDER_STATE_CHANGED_BD = 1000389011
    EVENT_DATA_SENSE_DATA_UPDATED_BD = 1000389012
    SENSE_DATA_QUERY_INFO_BD = 1000389013
    SENSE_DATA_QUERY_COMPLETION_BD = 1000389014
    SENSE_DATA_FILTER_UUID_BD = 1000389015
    SENSE_DATA_FILTER_SEMANTIC_BD = 1000389016
    QUERIED_SENSE_DATA_GET_INFO_BD = 1000389017
    QUERIED_SENSE_DATA_BD = 1000389018
    SPATIAL_ENTITY_STATE_BD = 1000389019
    SPATIAL_ENTITY_ANCHOR_CREATE_INFO_BD = 1000389020
    ANCHOR_SPACE_CREATE_INFO_BD = 1000389021
    SYSTEM_SPATIAL_ANCHOR_PROPERTIES_BD = 1000390000
    SPATIAL_ANCHOR_CREATE_INFO_BD = 1000390001
    SPATIAL_ANCHOR_CREATE_COMPLETION_BD = 1000390002
    SPATIAL_ANCHOR_PERSIST_INFO_BD = 1000390003
    SPATIAL_ANCHOR_UNPERSIST_INFO_BD = 1000390004
    SYSTEM_SPATIAL_ANCHOR_SHARING_PROPERTIES_BD = 1000391000
    SPATIAL_ANCHOR_SHARE_INFO_BD = 1000391001
    SHARED_SPATIAL_ANCHOR_DOWNLOAD_INFO_BD = 1000391002
    SYSTEM_SPATIAL_SCENE_PROPERTIES_BD = 1000392000
    SCENE_CAPTURE_INFO_BD = 1000392001
    SYSTEM_SPATIAL_MESH_PROPERTIES_BD = 1000393000
    SENSE_DATA_PROVIDER_CREATE_INFO_SPATIAL_MESH_BD = 1000393001
    FUTURE_POLL_RESULT_PROGRESS_BD = 1000394001
    SYSTEM_SPATIAL_PLANE_PROPERTIES_BD = 1000396000
    SPATIAL_ENTITY_COMPONENT_DATA_PLANE_ORIENTATION_BD = 1000396001
    SENSE_DATA_FILTER_PLANE_ORIENTATION_BD = 1000396002
    HAND_TRACKING_DATA_SOURCE_INFO_EXT = 1000428000
    HAND_TRACKING_DATA_SOURCE_STATE_EXT = 1000428001
    PLANE_DETECTOR_CREATE_INFO_EXT = 1000429001
    PLANE_DETECTOR_BEGIN_INFO_EXT = 1000429002
    PLANE_DETECTOR_GET_INFO_EXT = 1000429003
    PLANE_DETECTOR_LOCATIONS_EXT = 1000429004
    PLANE_DETECTOR_LOCATION_EXT = 1000429005
    PLANE_DETECTOR_POLYGON_BUFFER_EXT = 1000429006
    SYSTEM_PLANE_DETECTION_PROPERTIES_EXT = 1000429007
    TRACKABLE_GET_INFO_ANDROID = 1000455000
    ANCHOR_SPACE_CREATE_INFO_ANDROID = 1000455001
    TRACKABLE_PLANE_ANDROID = 1000455003
    TRACKABLE_TRACKER_CREATE_INFO_ANDROID = 1000455004
    SYSTEM_TRACKABLES_PROPERTIES_ANDROID = 1000455005
    PERSISTED_ANCHOR_SPACE_CREATE_INFO_ANDROID = 1000457001
    PERSISTED_ANCHOR_SPACE_INFO_ANDROID = 1000457002
    DEVICE_ANCHOR_PERSISTENCE_CREATE_INFO_ANDROID = 1000457003
    SYSTEM_DEVICE_ANCHOR_PERSISTENCE_PROPERTIES_ANDROID = 1000457004
    PASSTHROUGH_CAMERA_STATE_GET_INFO_ANDROID = 1000460000
    SYSTEM_PASSTHROUGH_CAMERA_STATE_PROPERTIES_ANDROID = 1000460001
    RAYCAST_INFO_ANDROID = 1000463000
    RAYCAST_HIT_RESULTS_ANDROID = 1000463001
    TRACKABLE_OBJECT_ANDROID = 1000466000
    TRACKABLE_OBJECT_CONFIGURATION_ANDROID = 1000466001
    FUTURE_CANCEL_INFO_EXT = 1000469000
    FUTURE_POLL_INFO_EXT = 1000469001
    FUTURE_COMPLETION_EXT = 1000469002
    FUTURE_POLL_RESULT_EXT = 1000469003
    EVENT_DATA_USER_PRESENCE_CHANGED_EXT = 1000470000
    SYSTEM_USER_PRESENCE_PROPERTIES_EXT = 1000470001
    SYSTEM_NOTIFICATIONS_SET_INFO_ML = 1000473000
    WORLD_MESH_DETECTOR_CREATE_INFO_ML = 1000474001
    WORLD_MESH_STATE_REQUEST_INFO_ML = 1000474002
    WORLD_MESH_BLOCK_STATE_ML = 1000474003
    WORLD_MESH_STATE_REQUEST_COMPLETION_ML = 1000474004
    WORLD_MESH_BUFFER_RECOMMENDED_SIZE_INFO_ML = 1000474005
    WORLD_MESH_BUFFER_SIZE_ML = 1000474006
    WORLD_MESH_BUFFER_ML = 1000474007
    WORLD_MESH_BLOCK_REQUEST_ML = 1000474008
    WORLD_MESH_GET_INFO_ML = 1000474009
    WORLD_MESH_BLOCK_ML = 1000474010
    WORLD_MESH_REQUEST_COMPLETION_ML = 1000474011
    WORLD_MESH_REQUEST_COMPLETION_INFO_ML = 1000474012
    SYSTEM_FACIAL_EXPRESSION_PROPERTIES_ML = 1000482004
    FACIAL_EXPRESSION_CLIENT_CREATE_INFO_ML = 1000482005
    FACIAL_EXPRESSION_BLEND_SHAPE_GET_INFO_ML = 1000482006
    FACIAL_EXPRESSION_BLEND_SHAPE_PROPERTIES_ML = 1000482007
    SYSTEM_SIMULTANEOUS_HANDS_AND_CONTROLLERS_PROPERTIES_META = 1000532001
    SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_RESUME_INFO_META = 1000532002
    SIMULTANEOUS_HANDS_AND_CONTROLLERS_TRACKING_PAUSE_INFO_META = 1000532003
    COLOCATION_DISCOVERY_START_INFO_META = 1000571010
    COLOCATION_DISCOVERY_STOP_INFO_META = 1000571011
    COLOCATION_ADVERTISEMENT_START_INFO_META = 1000571012
    COLOCATION_ADVERTISEMENT_STOP_INFO_META = 1000571013
    EVENT_DATA_START_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571020
    EVENT_DATA_STOP_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571021
    EVENT_DATA_COLOCATION_ADVERTISEMENT_COMPLETE_META = 1000571022
    EVENT_DATA_START_COLOCATION_DISCOVERY_COMPLETE_META = 1000571023
    EVENT_DATA_COLOCATION_DISCOVERY_RESULT_META = 1000571024
    EVENT_DATA_COLOCATION_DISCOVERY_COMPLETE_META = 1000571025
    EVENT_DATA_STOP_COLOCATION_DISCOVERY_COMPLETE_META = 1000571026
    SYSTEM_COLOCATION_DISCOVERY_PROPERTIES_META = 1000571030
    SHARE_SPACES_RECIPIENT_GROUPS_META = 1000572000
    SPACE_GROUP_UUID_FILTER_INFO_META = 1000572001
    SYSTEM_SPATIAL_ENTITY_GROUP_SHARING_PROPERTIES_META = 1000572100
    ANCHOR_SHARING_INFO_ANDROID = 1000701000
    ANCHOR_SHARING_TOKEN_ANDROID = 1000701001
    SYSTEM_ANCHOR_SHARING_EXPORT_PROPERTIES_ANDROID = 1000701002
    SYSTEM_MARKER_TRACKING_PROPERTIES_ANDROID = 1000707000
    TRACKABLE_MARKER_CONFIGURATION_ANDROID = 1000707001
    TRACKABLE_MARKER_ANDROID = 1000707002
    SPATIAL_CAPABILITY_COMPONENT_TYPES_EXT = 1000740000
    SPATIAL_CONTEXT_CREATE_INFO_EXT = 1000740001
    CREATE_SPATIAL_CONTEXT_COMPLETION_EXT = 1000740002
    SPATIAL_DISCOVERY_SNAPSHOT_CREATE_INFO_EXT = 1000740003
    CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_INFO_EXT = 1000740004
    CREATE_SPATIAL_DISCOVERY_SNAPSHOT_COMPLETION_EXT = 1000740005
    SPATIAL_COMPONENT_DATA_QUERY_CONDITION_EXT = 1000740006
    SPATIAL_COMPONENT_DATA_QUERY_RESULT_EXT = 1000740007
    SPATIAL_BUFFER_GET_INFO_EXT = 1000740008
    SPATIAL_COMPONENT_BOUNDED_2D_LIST_EXT = 1000740009
    SPATIAL_COMPONENT_BOUNDED_3D_LIST_EXT = 1000740010
    SPATIAL_COMPONENT_PARENT_LIST_EXT = 1000740011
    SPATIAL_COMPONENT_MESH_3D_LIST_EXT = 1000740012
    SPATIAL_ENTITY_FROM_ID_CREATE_INFO_EXT = 1000740013
    SPATIAL_UPDATE_SNAPSHOT_CREATE_INFO_EXT = 1000740014
    EVENT_DATA_SPATIAL_DISCOVERY_RECOMMENDED_EXT = 1000740015
    SPATIAL_FILTER_TRACKING_STATE_EXT = 1000740016
    SPATIAL_CAPABILITY_CONFIGURATION_PLANE_TRACKING_EXT = 1000741000
    SPATIAL_COMPONENT_PLANE_ALIGNMENT_LIST_EXT = 1000741001
    SPATIAL_COMPONENT_MESH_2D_LIST_EXT = 1000741002
    SPATIAL_COMPONENT_POLYGON_2D_LIST_EXT = 1000741003
    SPATIAL_COMPONENT_PLANE_SEMANTIC_LABEL_LIST_EXT = 1000741004
    SPATIAL_CAPABILITY_CONFIGURATION_QR_CODE_EXT = 1000743000
    SPATIAL_CAPABILITY_CONFIGURATION_MICRO_QR_CODE_EXT = 1000743001
    SPATIAL_CAPABILITY_CONFIGURATION_ARUCO_MARKER_EXT = 1000743002
    SPATIAL_CAPABILITY_CONFIGURATION_APRIL_TAG_EXT = 1000743003
    SPATIAL_MARKER_SIZE_EXT = 1000743004
    SPATIAL_MARKER_STATIC_OPTIMIZATION_EXT = 1000743005
    SPATIAL_COMPONENT_MARKER_LIST_EXT = 1000743006
    SPATIAL_CAPABILITY_CONFIGURATION_ANCHOR_EXT = 1000762000
    SPATIAL_COMPONENT_ANCHOR_LIST_EXT = 1000762001
    SPATIAL_ANCHOR_CREATE_INFO_EXT = 1000762002
    SPATIAL_PERSISTENCE_CONTEXT_CREATE_INFO_EXT = 1000763000
    CREATE_SPATIAL_PERSISTENCE_CONTEXT_COMPLETION_EXT = 1000763001
    SPATIAL_CONTEXT_PERSISTENCE_CONFIG_EXT = 1000763002
    SPATIAL_DISCOVERY_PERSISTENCE_UUID_FILTER_EXT = 1000763003
    SPATIAL_COMPONENT_PERSISTENCE_LIST_EXT = 1000763004
    SPATIAL_ENTITY_PERSIST_INFO_EXT = 1000781000
    PERSIST_SPATIAL_ENTITY_COMPLETION_EXT = 1000781001
    SPATIAL_ENTITY_UNPERSIST_INFO_EXT = 1000781002
    UNPERSIST_SPATIAL_ENTITY_COMPLETION_EXT = 1000781003
    LOADER_INIT_INFO_PROPERTIES_EXT = 1000838000
    GRAPHICS_BINDING_VULKAN2_KHR = 1000025000
    SWAPCHAIN_IMAGE_VULKAN2_KHR = 1000025001
    GRAPHICS_REQUIREMENTS_VULKAN2_KHR = 1000025002
    DEVICE_PCM_SAMPLE_RATE_GET_INFO_FB = 1000209002
    SPACES_LOCATE_INFO_KHR = 1000471000
    SPACE_LOCATIONS_KHR = 1000471001
    SPACE_VELOCITIES_KHR = 1000471002


class FormFactor(EnumBase):
    HEAD_MOUNTED_DISPLAY = 1
    HANDHELD_DISPLAY = 2


class ViewConfigurationType(EnumBase):
    PRIMARY_MONO = 1
    PRIMARY_STEREO = 2
    PRIMARY_STEREO_WITH_FOVEATED_INSET = 1000037000
    SECONDARY_MONO_FIRST_PERSON_OBSERVER_MSFT = 1000054000
    PRIMARY_QUAD_VARJO = 1000037000


class EnvironmentBlendMode(EnumBase):
    OPAQUE = 1
    ADDITIVE = 2
    ALPHA_BLEND = 3


class ReferenceSpaceType(EnumBase):
    VIEW = 1
    LOCAL = 2
    STAGE = 3
    LOCAL_FLOOR = 1000426000
    UNBOUNDED_MSFT = 1000038000
    COMBINED_EYE_VARJO = 1000121000
    LOCALIZATION_MAP_ML = 1000139000
    LOCAL_FLOOR_EXT = 1000426000


class ActionType(EnumBase):
    BOOLEAN_INPUT = 1
    FLOAT_INPUT = 2
    VECTOR2F_INPUT = 3
    POSE_INPUT = 4
    VIBRATION_OUTPUT = 100


class EyeVisibility(EnumBase):
    BOTH = 0
    LEFT = 1
    RIGHT = 2


class SessionState(EnumBase):
    UNKNOWN = 0
    IDLE = 1
    READY = 2
    SYNCHRONIZED = 3
    VISIBLE = 4
    FOCUSED = 5
    STOPPING = 6
    LOSS_PENDING = 7
    EXITING = 8


class ObjectType(EnumBase):
    UNKNOWN = 0
    INSTANCE = 1
    SESSION = 2
    SWAPCHAIN = 3
    SPACE = 4
    ACTION_SET = 5
    ACTION = 6
    DEBUG_UTILS_MESSENGER_EXT = 1000019000
    SPATIAL_ANCHOR_MSFT = 1000039000
    SPATIAL_GRAPH_NODE_BINDING_MSFT = 1000049000
    HAND_TRACKER_EXT = 1000051000
    BODY_TRACKER_FB = 1000076000
    SCENE_OBSERVER_MSFT = 1000097000
    SCENE_MSFT = 1000097001
    FACIAL_TRACKER_HTC = 1000104000
    FOVEATION_PROFILE_FB = 1000114000
    TRIANGLE_MESH_FB = 1000117000
    PASSTHROUGH_FB = 1000118000
    PASSTHROUGH_LAYER_FB = 1000118002
    GEOMETRY_INSTANCE_FB = 1000118004
    MARKER_DETECTOR_ML = 1000138000
    EXPORTED_LOCALIZATION_MAP_ML = 1000139000
    SPATIAL_ANCHORS_STORAGE_ML = 1000141000
    SPATIAL_ANCHOR_STORE_CONNECTION_MSFT = 1000142000
    FACE_TRACKER_FB = 1000201000
    EYE_TRACKER_FB = 1000202000
    VIRTUAL_KEYBOARD_META = 1000219000
    SPACE_USER_FB = 1000241000
    PASSTHROUGH_COLOR_LUT_META = 1000266000
    FACE_TRACKER2_FB = 1000287012
    ENVIRONMENT_DEPTH_PROVIDER_META = 1000291000
    ENVIRONMENT_DEPTH_SWAPCHAIN_META = 1000291001
    RENDER_MODEL_EXT = 1000300000
    RENDER_MODEL_ASSET_EXT = 1000300001
    PASSTHROUGH_HTC = 1000317000
    BODY_TRACKER_HTC = 1000320000
    BODY_TRACKER_BD = 1000385000
    SENSE_DATA_PROVIDER_BD = 1000389000
    SENSE_DATA_SNAPSHOT_BD = 1000389001
    ANCHOR_BD = 1000389002
    PLANE_DETECTOR_EXT = 1000429000
    TRACKABLE_TRACKER_ANDROID = 1000455001
    DEVICE_ANCHOR_PERSISTENCE_ANDROID = 1000457000
    WORLD_MESH_DETECTOR_ML = 1000474000
    FACIAL_EXPRESSION_CLIENT_ML = 1000482000
    SPATIAL_ENTITY_EXT = 1000740000
    SPATIAL_CONTEXT_EXT = 1000740001
    SPATIAL_SNAPSHOT_EXT = 1000740002
    SPATIAL_PERSISTENCE_CONTEXT_EXT = 1000763000


class VisibilityMaskTypeKHR(EnumBase):
    HIDDEN_TRIANGLE_MESH = 1
    VISIBLE_TRIANGLE_MESH = 2
    LINE_LOOP = 3


class PerfSettingsDomainEXT(EnumBase):
    CPU = 1
    GPU = 2


class PerfSettingsSubDomainEXT(EnumBase):
    COMPOSITING = 1
    RENDERING = 2
    THERMAL = 3


class PerfSettingsLevelEXT(EnumBase):
    POWER_SAVINGS = 0
    SUSTAINED_LOW = 25
    SUSTAINED_HIGH = 50
    BOOST = 75


class PerfSettingsNotificationLevelEXT(EnumBase):
    NORMAL = 0
    WARNING = 25
    IMPAIRED = 75


class BlendFactorFB(EnumBase):
    ZERO = 0
    ONE = 1
    SRC_ALPHA = 2
    ONE_MINUS_SRC_ALPHA = 3
    DST_ALPHA = 4
    ONE_MINUS_DST_ALPHA = 5


class SpatialGraphNodeTypeMSFT(EnumBase):
    STATIC = 1
    DYNAMIC = 2


class HandEXT(EnumBase):
    LEFT = 1
    RIGHT = 2


class HandJointEXT(EnumBase):
    PALM = 0
    WRIST = 1
    THUMB_METACARPAL = 2
    THUMB_PROXIMAL = 3
    THUMB_DISTAL = 4
    THUMB_TIP = 5
    INDEX_METACARPAL = 6
    INDEX_PROXIMAL = 7
    INDEX_INTERMEDIATE = 8
    INDEX_DISTAL = 9
    INDEX_TIP = 10
    MIDDLE_METACARPAL = 11
    MIDDLE_PROXIMAL = 12
    MIDDLE_INTERMEDIATE = 13
    MIDDLE_DISTAL = 14
    MIDDLE_TIP = 15
    RING_METACARPAL = 16
    RING_PROXIMAL = 17
    RING_INTERMEDIATE = 18
    RING_DISTAL = 19
    RING_TIP = 20
    LITTLE_METACARPAL = 21
    LITTLE_PROXIMAL = 22
    LITTLE_INTERMEDIATE = 23
    LITTLE_DISTAL = 24
    LITTLE_TIP = 25


class HandJointSetEXT(EnumBase):
    DEFAULT = 0
    HAND_WITH_FOREARM_ULTRA = 1000149000


class HandPoseTypeMSFT(EnumBase):
    TRACKED = 0
    REFERENCE_OPEN_PALM = 1


class ReprojectionModeMSFT(EnumBase):
    DEPTH = 1
    PLANAR_FROM_DEPTH = 2
    PLANAR_MANUAL = 3
    ORIENTATION_ONLY = 4


class BodyJointFB(EnumBase):
    ROOT = 0
    HIPS = 1
    SPINE_LOWER = 2
    SPINE_MIDDLE = 3
    SPINE_UPPER = 4
    CHEST = 5
    NECK = 6
    HEAD = 7
    LEFT_SHOULDER = 8
    LEFT_SCAPULA = 9
    LEFT_ARM_UPPER = 10
    LEFT_ARM_LOWER = 11
    LEFT_HAND_WRIST_TWIST = 12
    RIGHT_SHOULDER = 13
    RIGHT_SCAPULA = 14
    RIGHT_ARM_UPPER = 15
    RIGHT_ARM_LOWER = 16
    RIGHT_HAND_WRIST_TWIST = 17
    LEFT_HAND_PALM = 18
    LEFT_HAND_WRIST = 19
    LEFT_HAND_THUMB_METACARPAL = 20
    LEFT_HAND_THUMB_PROXIMAL = 21
    LEFT_HAND_THUMB_DISTAL = 22
    LEFT_HAND_THUMB_TIP = 23
    LEFT_HAND_INDEX_METACARPAL = 24
    LEFT_HAND_INDEX_PROXIMAL = 25
    LEFT_HAND_INDEX_INTERMEDIATE = 26
    LEFT_HAND_INDEX_DISTAL = 27
    LEFT_HAND_INDEX_TIP = 28
    LEFT_HAND_MIDDLE_METACARPAL = 29
    LEFT_HAND_MIDDLE_PROXIMAL = 30
    LEFT_HAND_MIDDLE_INTERMEDIATE = 31
    LEFT_HAND_MIDDLE_DISTAL = 32
    LEFT_HAND_MIDDLE_TIP = 33
    LEFT_HAND_RING_METACARPAL = 34
    LEFT_HAND_RING_PROXIMAL = 35
    LEFT_HAND_RING_INTERMEDIATE = 36
    LEFT_HAND_RING_DISTAL = 37
    LEFT_HAND_RING_TIP = 38
    LEFT_HAND_LITTLE_METACARPAL = 39
    LEFT_HAND_LITTLE_PROXIMAL = 40
    LEFT_HAND_LITTLE_INTERMEDIATE = 41
    LEFT_HAND_LITTLE_DISTAL = 42
    LEFT_HAND_LITTLE_TIP = 43
    RIGHT_HAND_PALM = 44
    RIGHT_HAND_WRIST = 45
    RIGHT_HAND_THUMB_METACARPAL = 46
    RIGHT_HAND_THUMB_PROXIMAL = 47
    RIGHT_HAND_THUMB_DISTAL = 48
    RIGHT_HAND_THUMB_TIP = 49
    RIGHT_HAND_INDEX_METACARPAL = 50
    RIGHT_HAND_INDEX_PROXIMAL = 51
    RIGHT_HAND_INDEX_INTERMEDIATE = 52
    RIGHT_HAND_INDEX_DISTAL = 53
    RIGHT_HAND_INDEX_TIP = 54
    RIGHT_HAND_MIDDLE_METACARPAL = 55
    RIGHT_HAND_MIDDLE_PROXIMAL = 56
    RIGHT_HAND_MIDDLE_INTERMEDIATE = 57
    RIGHT_HAND_MIDDLE_DISTAL = 58
    RIGHT_HAND_MIDDLE_TIP = 59
    RIGHT_HAND_RING_METACARPAL = 60
    RIGHT_HAND_RING_PROXIMAL = 61
    RIGHT_HAND_RING_INTERMEDIATE = 62
    RIGHT_HAND_RING_DISTAL = 63
    RIGHT_HAND_RING_TIP = 64
    RIGHT_HAND_LITTLE_METACARPAL = 65
    RIGHT_HAND_LITTLE_PROXIMAL = 66
    RIGHT_HAND_LITTLE_INTERMEDIATE = 67
    RIGHT_HAND_LITTLE_DISTAL = 68
    RIGHT_HAND_LITTLE_TIP = 69
    COUNT = 70
    NONE = -1


class BodyJointSetFB(EnumBase):
    DEFAULT = 0
    FULL_BODY_M = 1000274000


class HandJointsMotionRangeEXT(EnumBase):
    UNOBSTRUCTED = 1
    CONFORMING_TO_CONTROLLER = 2


class SceneComputeFeatureMSFT(EnumBase):
    PLANE = 1
    PLANE_MESH = 2
    VISUAL_MESH = 3
    COLLIDER_MESH = 4
    SERIALIZE_SCENE = 1000098000
    MARKER = 1000147000


class SceneComputeConsistencyMSFT(EnumBase):
    SNAPSHOT_COMPLETE = 1
    SNAPSHOT_INCOMPLETE_FAST = 2
    OCCLUSION_OPTIMIZED = 3


class MeshComputeLodMSFT(EnumBase):
    COARSE = 1
    MEDIUM = 2
    FINE = 3
    UNLIMITED = 4


class SceneComponentTypeMSFT(EnumBase):
    INVALID = -1
    OBJECT = 1
    PLANE = 2
    VISUAL_MESH = 3
    COLLIDER_MESH = 4
    SERIALIZED_SCENE_FRAGMENT = 1000098000
    MARKER = 1000147000


class SceneObjectTypeMSFT(EnumBase):
    UNCATEGORIZED = -1
    BACKGROUND = 1
    WALL = 2
    FLOOR = 3
    CEILING = 4
    PLATFORM = 5
    INFERRED = 6


class ScenePlaneAlignmentTypeMSFT(EnumBase):
    NON_ORTHOGONAL = 0
    HORIZONTAL = 1
    VERTICAL = 2


class SceneComputeStateMSFT(EnumBase):
    NONE = 0
    UPDATING = 1
    COMPLETED = 2
    COMPLETED_WITH_ERROR = 3


class EyeExpressionHTC(EnumBase):
    LEFT_BLINK = 0
    LEFT_WIDE = 1
    RIGHT_BLINK = 2
    RIGHT_WIDE = 3
    LEFT_SQUEEZE = 4
    RIGHT_SQUEEZE = 5
    LEFT_DOWN = 6
    RIGHT_DOWN = 7
    LEFT_OUT = 8
    RIGHT_IN = 9
    LEFT_IN = 10
    RIGHT_OUT = 11
    LEFT_UP = 12
    RIGHT_UP = 13


class LipExpressionHTC(EnumBase):
    JAW_RIGHT = 0
    JAW_LEFT = 1
    JAW_FORWARD = 2
    JAW_OPEN = 3
    MOUTH_APE_SHAPE = 4
    MOUTH_UPPER_RIGHT = 5
    MOUTH_UPPER_LEFT = 6
    MOUTH_LOWER_RIGHT = 7
    MOUTH_LOWER_LEFT = 8
    MOUTH_UPPER_OVERTURN = 9
    MOUTH_LOWER_OVERTURN = 10
    MOUTH_POUT = 11
    MOUTH_RAISER_RIGHT = 12
    MOUTH_RAISER_LEFT = 13
    MOUTH_STRETCHER_RIGHT = 14
    MOUTH_STRETCHER_LEFT = 15
    CHEEK_PUFF_RIGHT = 16
    CHEEK_PUFF_LEFT = 17
    CHEEK_SUCK = 18
    MOUTH_UPPER_UPRIGHT = 19
    MOUTH_UPPER_UPLEFT = 20
    MOUTH_LOWER_DOWNRIGHT = 21
    MOUTH_LOWER_DOWNLEFT = 22
    MOUTH_UPPER_INSIDE = 23
    MOUTH_LOWER_INSIDE = 24
    MOUTH_LOWER_OVERLAY = 25
    TONGUE_LONGSTEP1 = 26
    TONGUE_LEFT = 27
    TONGUE_RIGHT = 28
    TONGUE_UP = 29
    TONGUE_DOWN = 30
    TONGUE_ROLL = 31
    TONGUE_LONGSTEP2 = 32
    TONGUE_UPRIGHT_MORPH = 33
    TONGUE_UPLEFT_MORPH = 34
    TONGUE_DOWNRIGHT_MORPH = 35
    TONGUE_DOWNLEFT_MORPH = 36
    MOUTH_SMILE_RIGHT = 12
    MOUTH_SMILE_LEFT = 13
    MOUTH_SAD_RIGHT = 14
    MOUTH_SAD_LEFT = 15


class FacialTrackingTypeHTC(EnumBase):
    EYE_DEFAULT = 1
    LIP_DEFAULT = 2


class ColorSpaceFB(EnumBase):
    UNMANAGED = 0
    REC2020 = 1
    REC709 = 2
    RIFT_CV1 = 3
    RIFT_S = 4
    QUEST = 5
    P3 = 6
    ADOBE_RGB = 7


class SpaceComponentTypeFB(EnumBase):
    LOCATABLE = 0
    STORABLE = 1
    SHARABLE = 2
    BOUNDED_2D = 3
    BOUNDED_3D = 4
    SEMANTIC_LABELS = 5
    ROOM_LAYOUT = 6
    SPACE_CONTAINER = 7
    TRIANGLE_MESH_M = 1000269000


class FoveationLevelFB(EnumBase):
    NONE = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3


class FoveationDynamicFB(EnumBase):
    DISABLED = 0
    LEVEL_ENABLED = 1


class WindingOrderFB(EnumBase):
    UNKNOWN = 0
    CW = 1
    CCW = 2


class PassthroughLayerPurposeFB(EnumBase):
    RECONSTRUCTION = 0
    PROJECTED = 1
    TRACKED_KEYBOARD_HANDS = 1000203001
    TRACKED_KEYBOARD_MASKED_HANDS = 1000203002


class MarkerDetectorProfileML(EnumBase):
    DEFAULT = 0
    SPEED = 1
    ACCURACY = 2
    SMALL_TARGETS = 3
    LARGE_FOV = 4
    CUSTOM = 5


class MarkerTypeML(EnumBase):
    ARUCO = 0
    APRIL_TAG = 1
    QR = 2
    EAN_13 = 3
    UPC_A = 4
    CODE_128 = 5


class MarkerArucoDictML(EnumBase):
    N4X4_50 = 0
    N4X4_100 = 1
    N4X4_250 = 2
    N4X4_1000 = 3
    N5X5_50 = 4
    N5X5_100 = 5
    N5X5_250 = 6
    N5X5_1000 = 7
    N6X6_50 = 8
    N6X6_100 = 9
    N6X6_250 = 10
    N6X6_1000 = 11
    N7X7_50 = 12
    N7X7_100 = 13
    N7X7_250 = 14
    N7X7_1000 = 15


class MarkerAprilTagDictML(EnumBase):
    N16H5 = 0
    N25H9 = 1
    N36H10 = 2
    N36H11 = 3


class MarkerDetectorFpsML(EnumBase):
    LOW = 0
    MEDIUM = 1
    HIGH = 2
    MAX = 3


class MarkerDetectorResolutionML(EnumBase):
    LOW = 0
    MEDIUM = 1
    HIGH = 2


class MarkerDetectorCameraML(EnumBase):
    RGB_CAMERA = 0
    WORLD_CAMERAS = 1


class MarkerDetectorCornerRefineMethodML(EnumBase):
    NONE = 0
    SUBPIX = 1
    CONTOUR = 2
    APRIL_TAG = 3


class MarkerDetectorFullAnalysisIntervalML(EnumBase):
    MAX = 0
    FAST = 1
    MEDIUM = 2
    SLOW = 3


class MarkerDetectorStatusML(EnumBase):
    PENDING = 0
    READY = 1
    ERROR = 2


class LocalizationMapStateML(EnumBase):
    NOT_LOCALIZED = 0
    LOCALIZED = 1
    LOCALIZATION_PENDING = 2
    LOCALIZATION_SLEEPING_BEFORE_RETRY = 3


class LocalizationMapTypeML(EnumBase):
    ON_DEVICE = 0
    CLOUD = 1


class LocalizationMapConfidenceML(EnumBase):
    POOR = 0
    FAIR = 1
    GOOD = 2
    EXCELLENT = 3


class SpatialAnchorConfidenceML(EnumBase):
    LOW = 0
    MEDIUM = 1
    HIGH = 2


class SceneMarkerTypeMSFT(EnumBase):
    QR_CODE = 1


class SceneMarkerQRCodeSymbolTypeMSFT(EnumBase):
    QR_CODE = 1
    MICRO_QR_CODE = 2


class HandForearmJointULTRALEAP(EnumBase):
    PALM = 0
    WRIST = 1
    THUMB_METACARPAL = 2
    THUMB_PROXIMAL = 3
    THUMB_DISTAL = 4
    THUMB_TIP = 5
    INDEX_METACARPAL = 6
    INDEX_PROXIMAL = 7
    INDEX_INTERMEDIATE = 8
    INDEX_DISTAL = 9
    INDEX_TIP = 10
    MIDDLE_METACARPAL = 11
    MIDDLE_PROXIMAL = 12
    MIDDLE_INTERMEDIATE = 13
    MIDDLE_DISTAL = 14
    MIDDLE_TIP = 15
    RING_METACARPAL = 16
    RING_PROXIMAL = 17
    RING_INTERMEDIATE = 18
    RING_DISTAL = 19
    RING_TIP = 20
    LITTLE_METACARPAL = 21
    LITTLE_PROXIMAL = 22
    LITTLE_INTERMEDIATE = 23
    LITTLE_DISTAL = 24
    LITTLE_TIP = 25
    ELBOW = 26


class SpaceQueryActionFB(EnumBase):
    LOAD = 0


class SpaceStorageLocationFB(EnumBase):
    INVALID = 0
    LOCAL = 1
    CLOUD = 2


class SpacePersistenceModeFB(EnumBase):
    INVALID = 0
    INDEFINITE = 1


class FaceExpressionFB(EnumBase):
    BROW_LOWERER_L = 0
    BROW_LOWERER_R = 1
    CHEEK_PUFF_L = 2
    CHEEK_PUFF_R = 3
    CHEEK_RAISER_L = 4
    CHEEK_RAISER_R = 5
    CHEEK_SUCK_L = 6
    CHEEK_SUCK_R = 7
    CHIN_RAISER_B = 8
    CHIN_RAISER_T = 9
    DIMPLER_L = 10
    DIMPLER_R = 11
    EYES_CLOSED_L = 12
    EYES_CLOSED_R = 13
    EYES_LOOK_DOWN_L = 14
    EYES_LOOK_DOWN_R = 15
    EYES_LOOK_LEFT_L = 16
    EYES_LOOK_LEFT_R = 17
    EYES_LOOK_RIGHT_L = 18
    EYES_LOOK_RIGHT_R = 19
    EYES_LOOK_UP_L = 20
    EYES_LOOK_UP_R = 21
    INNER_BROW_RAISER_L = 22
    INNER_BROW_RAISER_R = 23
    JAW_DROP = 24
    JAW_SIDEWAYS_LEFT = 25
    JAW_SIDEWAYS_RIGHT = 26
    JAW_THRUST = 27
    LID_TIGHTENER_L = 28
    LID_TIGHTENER_R = 29
    LIP_CORNER_DEPRESSOR_L = 30
    LIP_CORNER_DEPRESSOR_R = 31
    LIP_CORNER_PULLER_L = 32
    LIP_CORNER_PULLER_R = 33
    LIP_FUNNELER_LB = 34
    LIP_FUNNELER_LT = 35
    LIP_FUNNELER_RB = 36
    LIP_FUNNELER_RT = 37
    LIP_PRESSOR_L = 38
    LIP_PRESSOR_R = 39
    LIP_PUCKER_L = 40
    LIP_PUCKER_R = 41
    LIP_STRETCHER_L = 42
    LIP_STRETCHER_R = 43
    LIP_SUCK_LB = 44
    LIP_SUCK_LT = 45
    LIP_SUCK_RB = 46
    LIP_SUCK_RT = 47
    LIP_TIGHTENER_L = 48
    LIP_TIGHTENER_R = 49
    LIPS_TOWARD = 50
    LOWER_LIP_DEPRESSOR_L = 51
    LOWER_LIP_DEPRESSOR_R = 52
    MOUTH_LEFT = 53
    MOUTH_RIGHT = 54
    NOSE_WRINKLER_L = 55
    NOSE_WRINKLER_R = 56
    OUTER_BROW_RAISER_L = 57
    OUTER_BROW_RAISER_R = 58
    UPPER_LID_RAISER_L = 59
    UPPER_LID_RAISER_R = 60
    UPPER_LIP_RAISER_L = 61
    UPPER_LIP_RAISER_R = 62
    COUNT = 63


class FaceExpressionSetFB(EnumBase):
    DEFAULT = 0


class FaceConfidenceFB(EnumBase):
    LOWER_FACE = 0
    UPPER_FACE = 1
    COUNT = 2


class EyePositionFB(EnumBase):
    LEFT = 0
    RIGHT = 1
    COUNT = 2


class CompareOpFB(EnumBase):
    NEVER = 0
    LESS = 1
    EQUAL = 2
    LESS_OR_EQUAL = 3
    GREATER = 4
    NOT_EQUAL = 5
    GREATER_OR_EQUAL = 6
    ALWAYS = 7


class LocalDimmingModeMETA(EnumBase):
    OFF = 0
    ON = 1


class VirtualKeyboardLocationTypeMETA(EnumBase):
    CUSTOM = 0
    FAR = 1
    DIRECT = 2


class VirtualKeyboardInputSourceMETA(EnumBase):
    CONTROLLER_RAY_LEFT = 1
    CONTROLLER_RAY_RIGHT = 2
    HAND_RAY_LEFT = 3
    HAND_RAY_RIGHT = 4
    CONTROLLER_DIRECT_LEFT = 5
    CONTROLLER_DIRECT_RIGHT = 6
    HAND_DIRECT_INDEX_TIP_LEFT = 7
    HAND_DIRECT_INDEX_TIP_RIGHT = 8


class ExternalCameraAttachedToDeviceOCULUS(EnumBase):
    NONE = 0
    HMD = 1
    LTOUCH = 2
    RTOUCH = 3


class PerformanceMetricsCounterUnitMETA(EnumBase):
    GENERIC = 0
    PERCENTAGE = 1
    MILLISECONDS = 2
    BYTES = 3
    HERTZ = 4


class PassthroughColorLutChannelsMETA(EnumBase):
    RGB = 1
    RGBA = 2


class FullBodyJointMETA(EnumBase):
    ROOT = 0
    HIPS = 1
    SPINE_LOWER = 2
    SPINE_MIDDLE = 3
    SPINE_UPPER = 4
    CHEST = 5
    NECK = 6
    HEAD = 7
    LEFT_SHOULDER = 8
    LEFT_SCAPULA = 9
    LEFT_ARM_UPPER = 10
    LEFT_ARM_LOWER = 11
    LEFT_HAND_WRIST_TWIST = 12
    RIGHT_SHOULDER = 13
    RIGHT_SCAPULA = 14
    RIGHT_ARM_UPPER = 15
    RIGHT_ARM_LOWER = 16
    RIGHT_HAND_WRIST_TWIST = 17
    LEFT_HAND_PALM = 18
    LEFT_HAND_WRIST = 19
    LEFT_HAND_THUMB_METACARPAL = 20
    LEFT_HAND_THUMB_PROXIMAL = 21
    LEFT_HAND_THUMB_DISTAL = 22
    LEFT_HAND_THUMB_TIP = 23
    LEFT_HAND_INDEX_METACARPAL = 24
    LEFT_HAND_INDEX_PROXIMAL = 25
    LEFT_HAND_INDEX_INTERMEDIATE = 26
    LEFT_HAND_INDEX_DISTAL = 27
    LEFT_HAND_INDEX_TIP = 28
    LEFT_HAND_MIDDLE_METACARPAL = 29
    LEFT_HAND_MIDDLE_PROXIMAL = 30
    LEFT_HAND_MIDDLE_INTERMEDIATE = 31
    LEFT_HAND_MIDDLE_DISTAL = 32
    LEFT_HAND_MIDDLE_TIP = 33
    LEFT_HAND_RING_METACARPAL = 34
    LEFT_HAND_RING_PROXIMAL = 35
    LEFT_HAND_RING_INTERMEDIATE = 36
    LEFT_HAND_RING_DISTAL = 37
    LEFT_HAND_RING_TIP = 38
    LEFT_HAND_LITTLE_METACARPAL = 39
    LEFT_HAND_LITTLE_PROXIMAL = 40
    LEFT_HAND_LITTLE_INTERMEDIATE = 41
    LEFT_HAND_LITTLE_DISTAL = 42
    LEFT_HAND_LITTLE_TIP = 43
    RIGHT_HAND_PALM = 44
    RIGHT_HAND_WRIST = 45
    RIGHT_HAND_THUMB_METACARPAL = 46
    RIGHT_HAND_THUMB_PROXIMAL = 47
    RIGHT_HAND_THUMB_DISTAL = 48
    RIGHT_HAND_THUMB_TIP = 49
    RIGHT_HAND_INDEX_METACARPAL = 50
    RIGHT_HAND_INDEX_PROXIMAL = 51
    RIGHT_HAND_INDEX_INTERMEDIATE = 52
    RIGHT_HAND_INDEX_DISTAL = 53
    RIGHT_HAND_INDEX_TIP = 54
    RIGHT_HAND_MIDDLE_METACARPAL = 55
    RIGHT_HAND_MIDDLE_PROXIMAL = 56
    RIGHT_HAND_MIDDLE_INTERMEDIATE = 57
    RIGHT_HAND_MIDDLE_DISTAL = 58
    RIGHT_HAND_MIDDLE_TIP = 59
    RIGHT_HAND_RING_METACARPAL = 60
    RIGHT_HAND_RING_PROXIMAL = 61
    RIGHT_HAND_RING_INTERMEDIATE = 62
    RIGHT_HAND_RING_DISTAL = 63
    RIGHT_HAND_RING_TIP = 64
    RIGHT_HAND_LITTLE_METACARPAL = 65
    RIGHT_HAND_LITTLE_PROXIMAL = 66
    RIGHT_HAND_LITTLE_INTERMEDIATE = 67
    RIGHT_HAND_LITTLE_DISTAL = 68
    RIGHT_HAND_LITTLE_TIP = 69
    LEFT_UPPER_LEG = 70
    LEFT_LOWER_LEG = 71
    LEFT_FOOT_ANKLE_TWIST = 72
    LEFT_FOOT_ANKLE = 73
    LEFT_FOOT_SUBTALAR = 74
    LEFT_FOOT_TRANSVERSE = 75
    LEFT_FOOT_BALL = 76
    RIGHT_UPPER_LEG = 77
    RIGHT_LOWER_LEG = 78
    RIGHT_FOOT_ANKLE_TWIST = 79
    RIGHT_FOOT_ANKLE = 80
    RIGHT_FOOT_SUBTALAR = 81
    RIGHT_FOOT_TRANSVERSE = 82
    RIGHT_FOOT_BALL = 83
    COUNT = 84
    NONE = 85


class BodyTrackingCalibrationStateMETA(EnumBase):
    VALID = 1
    CALIBRATING = 2
    INVALID = 3


class FaceExpression2FB(EnumBase):
    BROW_LOWERER_L = 0
    BROW_LOWERER_R = 1
    CHEEK_PUFF_L = 2
    CHEEK_PUFF_R = 3
    CHEEK_RAISER_L = 4
    CHEEK_RAISER_R = 5
    CHEEK_SUCK_L = 6
    CHEEK_SUCK_R = 7
    CHIN_RAISER_B = 8
    CHIN_RAISER_T = 9
    DIMPLER_L = 10
    DIMPLER_R = 11
    EYES_CLOSED_L = 12
    EYES_CLOSED_R = 13
    EYES_LOOK_DOWN_L = 14
    EYES_LOOK_DOWN_R = 15
    EYES_LOOK_LEFT_L = 16
    EYES_LOOK_LEFT_R = 17
    EYES_LOOK_RIGHT_L = 18
    EYES_LOOK_RIGHT_R = 19
    EYES_LOOK_UP_L = 20
    EYES_LOOK_UP_R = 21
    INNER_BROW_RAISER_L = 22
    INNER_BROW_RAISER_R = 23
    JAW_DROP = 24
    JAW_SIDEWAYS_LEFT = 25
    JAW_SIDEWAYS_RIGHT = 26
    JAW_THRUST = 27
    LID_TIGHTENER_L = 28
    LID_TIGHTENER_R = 29
    LIP_CORNER_DEPRESSOR_L = 30
    LIP_CORNER_DEPRESSOR_R = 31
    LIP_CORNER_PULLER_L = 32
    LIP_CORNER_PULLER_R = 33
    LIP_FUNNELER_LB = 34
    LIP_FUNNELER_LT = 35
    LIP_FUNNELER_RB = 36
    LIP_FUNNELER_RT = 37
    LIP_PRESSOR_L = 38
    LIP_PRESSOR_R = 39
    LIP_PUCKER_L = 40
    LIP_PUCKER_R = 41
    LIP_STRETCHER_L = 42
    LIP_STRETCHER_R = 43
    LIP_SUCK_LB = 44
    LIP_SUCK_LT = 45
    LIP_SUCK_RB = 46
    LIP_SUCK_RT = 47
    LIP_TIGHTENER_L = 48
    LIP_TIGHTENER_R = 49
    LIPS_TOWARD = 50
    LOWER_LIP_DEPRESSOR_L = 51
    LOWER_LIP_DEPRESSOR_R = 52
    MOUTH_LEFT = 53
    MOUTH_RIGHT = 54
    NOSE_WRINKLER_L = 55
    NOSE_WRINKLER_R = 56
    OUTER_BROW_RAISER_L = 57
    OUTER_BROW_RAISER_R = 58
    UPPER_LID_RAISER_L = 59
    UPPER_LID_RAISER_R = 60
    UPPER_LIP_RAISER_L = 61
    UPPER_LIP_RAISER_R = 62
    TONGUE_TIP_INTERDENTAL = 63
    TONGUE_TIP_ALVEOLAR = 64
    TONGUE_FRONT_DORSAL_PALATE = 65
    TONGUE_MID_DORSAL_PALATE = 66
    TONGUE_BACK_DORSAL_VELAR = 67
    TONGUE_OUT = 68
    TONGUE_RETREAT = 69
    COUNT = 70


class FaceExpressionSet2FB(EnumBase):
    DEFAULT = 0


class FaceTrackingDataSource2FB(EnumBase):
    VISUAL = 0
    AUDIO = 1


class FaceConfidence2FB(EnumBase):
    LOWER_FACE = 0
    UPPER_FACE = 1
    COUNT = 2


class TrackingOptimizationSettingsDomainQCOM(EnumBase):
    ALL = 1


class TrackingOptimizationSettingsHintQCOM(EnumBase):
    NONE = 0
    LONG_RANGE_PRIORIZATION = 1
    CLOSE_RANGE_PRIORIZATION = 2
    LOW_POWER_PRIORIZATION = 3
    HIGH_POWER_PRIORIZATION = 4


class PassthroughFormHTC(EnumBase):
    PLANAR = 0
    PROJECTED = 1


class FoveationModeHTC(EnumBase):
    DISABLE = 0
    FIXED = 1
    DYNAMIC = 2
    CUSTOM = 3


class FoveationLevelHTC(EnumBase):
    NONE = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3


class BodyJointHTC(EnumBase):
    PELVIS = 0
    LEFT_HIP = 1
    LEFT_KNEE = 2
    LEFT_ANKLE = 3
    LEFT_FEET = 4
    RIGHT_HIP = 5
    RIGHT_KNEE = 6
    RIGHT_ANKLE = 7
    RIGHT_FEET = 8
    WAIST = 9
    SPINE_LOWER = 10
    SPINE_MIDDLE = 11
    SPINE_HIGH = 12
    CHEST = 13
    NECK = 14
    HEAD = 15
    LEFT_CLAVICLE = 16
    LEFT_SCAPULA = 17
    LEFT_ARM = 18
    LEFT_ELBOW = 19
    LEFT_WRIST = 20
    RIGHT_CLAVICLE = 21
    RIGHT_SCAPULA = 22
    RIGHT_ARM = 23
    RIGHT_ELBOW = 24
    RIGHT_WRIST = 25


class BodyJointSetHTC(EnumBase):
    FULL = 0


class BodyJointConfidenceHTC(EnumBase):
    NONE = 0
    LOW = 1
    HIGH = 2


class ForceFeedbackCurlLocationMNDX(EnumBase):
    THUMB_CURL = 0
    INDEX_CURL = 1
    MIDDLE_CURL = 2
    RING_CURL = 3
    LITTLE_CURL = 4


class BodyJointBD(EnumBase):
    PELVIS = 0
    LEFT_HIP = 1
    RIGHT_HIP = 2
    SPINE1 = 3
    LEFT_KNEE = 4
    RIGHT_KNEE = 5
    SPINE2 = 6
    LEFT_ANKLE = 7
    RIGHT_ANKLE = 8
    SPINE3 = 9
    LEFT_FOOT = 10
    RIGHT_FOOT = 11
    NECK = 12
    LEFT_COLLAR = 13
    RIGHT_COLLAR = 14
    HEAD = 15
    LEFT_SHOULDER = 16
    RIGHT_SHOULDER = 17
    LEFT_ELBOW = 18
    RIGHT_ELBOW = 19
    LEFT_WRIST = 20
    RIGHT_WRIST = 21
    LEFT_HAND = 22
    RIGHT_HAND = 23


class BodyJointSetBD(EnumBase):
    BODY_WITHOUT_ARM = 1
    FULL_BODY_JOINTS = 2


class SpatialEntityComponentTypeBD(EnumBase):
    LOCATION = 0
    SEMANTIC = 1
    BOUNDING_BOX_2D = 2
    POLYGON = 3
    BOUNDING_BOX_3D = 4
    TRIANGLE_MESH = 5
    PLANE_ORIENTATION = 1000396000


class SemanticLabelBD(EnumBase):
    UNKNOWN = 0
    FLOOR = 1
    CEILING = 2
    WALL = 3
    DOOR = 4
    WINDOW = 5
    OPENING = 6
    TABLE = 7
    SOFA = 8
    CHAIR = 9
    HUMAN = 10
    BEAM = 11
    COLUMN = 12
    CURTAIN = 13
    CABINET = 14
    BED = 15
    PLANT = 16
    SCREEN = 17
    VIRTUAL_WALL = 18
    REFRIGERATOR = 19
    WASHING_MACHINE = 20
    AIR_CONDITIONER = 21
    LAMP = 22
    WALL_ART = 23
    STAIRWAY = 24


class SenseDataProviderTypeBD(EnumBase):
    ANCHOR = 1000390000
    SCENE = 1000392000
    MESH = 1000393000
    PLANE = 1000396000


class SenseDataProviderStateBD(EnumBase):
    INITIALIZED = 0
    RUNNING = 1
    STOPPED = 2


class PersistenceLocationBD(EnumBase):
    LOCAL = 0


class SpatialMeshLodBD(EnumBase):
    COARSE = 0
    MEDIUM = 1
    FINE = 2


class PlaneOrientationBD(EnumBase):
    HORIZONTAL_UPWARD = 0
    HORIZONTAL_DOWNWARD = 1
    VERTICAL = 2
    ARBITRARY = 3


class HandTrackingDataSourceEXT(EnumBase):
    UNOBSTRUCTED = 1
    CONTROLLER = 2


class PlaneDetectorOrientationEXT(EnumBase):
    HORIZONTAL_UPWARD = 0
    HORIZONTAL_DOWNWARD = 1
    VERTICAL = 2
    ARBITRARY = 3


class PlaneDetectorSemanticTypeEXT(EnumBase):
    UNDEFINED = 0
    CEILING = 1
    FLOOR = 2
    WALL = 3
    PLATFORM = 4


class PlaneDetectionStateEXT(EnumBase):
    NONE = 0
    PENDING = 1
    DONE = 2
    ERROR = 3
    FATAL = 4


class TrackingStateANDROID(EnumBase):
    PAUSED = 0
    STOPPED = 1
    TRACKING = 2


class TrackableTypeANDROID(EnumBase):
    NOT_VALID = 0
    PLANE = 1
    DEPTH = 1000463000
    OBJECT = 1000466000
    MARKER = 1000707000


class PlaneTypeANDROID(EnumBase):
    HORIZONTAL_DOWNWARD_FACING = 0
    HORIZONTAL_UPWARD_FACING = 1
    VERTICAL = 2
    ARBITRARY = 3


class PlaneLabelANDROID(EnumBase):
    UNKNOWN = 0
    WALL = 1
    FLOOR = 2
    CEILING = 3
    TABLE = 4


class AnchorPersistStateANDROID(EnumBase):
    PERSIST_NOT_REQUESTED = 0
    PERSIST_PENDING = 1
    PERSISTED = 2


class PassthroughCameraStateANDROID(EnumBase):
    DISABLED = 0
    INITIALIZING = 1
    READY = 2
    ERROR = 3


class ObjectLabelANDROID(EnumBase):
    UNKNOWN = 0
    KEYBOARD = 1
    MOUSE = 2
    LAPTOP = 3


class FutureStateEXT(EnumBase):
    PENDING = 1
    READY = 2


class HeadsetFitStatusML(EnumBase):
    UNKNOWN = 0
    NOT_WORN = 1
    GOOD_FIT = 2
    BAD_FIT = 3


class EyeCalibrationStatusML(EnumBase):
    UNKNOWN = 0
    NONE = 1
    COARSE = 2
    FINE = 3


class WorldMeshDetectorLodML(EnumBase):
    MINIMUM = 0
    MEDIUM = 1
    MAXIMUM = 2


class WorldMeshBlockStatusML(EnumBase):
    NEW = 0
    UPDATED = 1
    DELETED = 2
    UNCHANGED = 3


class WorldMeshBlockResultML(EnumBase):
    SUCCESS = 0
    FAILED = 1
    PENDING = 2
    PARTIAL_UPDATE = 3


class FacialBlendShapeML(EnumBase):
    BROW_LOWERER_L = 0
    BROW_LOWERER_R = 1
    CHEEK_RAISER_L = 2
    CHEEK_RAISER_R = 3
    CHIN_RAISER = 4
    DIMPLER_L = 5
    DIMPLER_R = 6
    EYES_CLOSED_L = 7
    EYES_CLOSED_R = 8
    INNER_BROW_RAISER_L = 9
    INNER_BROW_RAISER_R = 10
    JAW_DROP = 11
    LID_TIGHTENER_L = 12
    LID_TIGHTENER_R = 13
    LIP_CORNER_DEPRESSOR_L = 14
    LIP_CORNER_DEPRESSOR_R = 15
    LIP_CORNER_PULLER_L = 16
    LIP_CORNER_PULLER_R = 17
    LIP_FUNNELER_LB = 18
    LIP_FUNNELER_LT = 19
    LIP_FUNNELER_RB = 20
    LIP_FUNNELER_RT = 21
    LIP_PRESSOR_L = 22
    LIP_PRESSOR_R = 23
    LIP_PUCKER_L = 24
    LIP_PUCKER_R = 25
    LIP_STRETCHER_L = 26
    LIP_STRETCHER_R = 27
    LIP_SUCK_LB = 28
    LIP_SUCK_LT = 29
    LIP_SUCK_RB = 30
    LIP_SUCK_RT = 31
    LIP_TIGHTENER_L = 32
    LIP_TIGHTENER_R = 33
    LIPS_TOWARD = 34
    LOWER_LIP_DEPRESSOR_L = 35
    LOWER_LIP_DEPRESSOR_R = 36
    NOSE_WRINKLER_L = 37
    NOSE_WRINKLER_R = 38
    OUTER_BROW_RAISER_L = 39
    OUTER_BROW_RAISER_R = 40
    UPPER_LID_RAISER_L = 41
    UPPER_LID_RAISER_R = 42
    UPPER_LIP_RAISER_L = 43
    UPPER_LIP_RAISER_R = 44
    TONGUE_OUT = 45


class TrackableMarkerTrackingModeANDROID(EnumBase):
    DYNAMIC = 0
    STATIC = 1


class TrackableMarkerDictionaryANDROID(EnumBase):
    ARUCO_4X4_50 = 0
    ARUCO_4X4_100 = 1
    ARUCO_4X4_250 = 2
    ARUCO_4X4_1000 = 3
    ARUCO_5X5_50 = 4
    ARUCO_5X5_100 = 5
    ARUCO_5X5_250 = 6
    ARUCO_5X5_1000 = 7
    ARUCO_6X6_50 = 8
    ARUCO_6X6_100 = 9
    ARUCO_6X6_250 = 10
    ARUCO_6X6_1000 = 11
    ARUCO_7X7_50 = 12
    ARUCO_7X7_100 = 13
    ARUCO_7X7_250 = 14
    ARUCO_7X7_1000 = 15
    APRILTAG_16H5 = 16
    APRILTAG_25H9 = 17
    APRILTAG_36H10 = 18
    APRILTAG_36H11 = 19


class SpatialCapabilityEXT(EnumBase):
    PLANE_TRACKING = 1000741000
    MARKER_TRACKING_QR_CODE = 1000743000
    MARKER_TRACKING_MICRO_QR_CODE = 1000743001
    MARKER_TRACKING_ARUCO_MARKER = 1000743002
    MARKER_TRACKING_APRIL_TAG = 1000743003
    ANCHOR = 1000762000


class SpatialCapabilityFeatureEXT(EnumBase):
    MARKER_TRACKING_FIXED_SIZE_MARKERS = 1000743000
    MARKER_TRACKING_STATIC_MARKERS = 1000743001


class SpatialComponentTypeEXT(EnumBase):
    BOUNDED_2D = 1
    BOUNDED_3D = 2
    PARENT = 3
    MESH_3D = 4
    PLANE_ALIGNMENT = 1000741000
    MESH_2D = 1000741001
    POLYGON_2D = 1000741002
    PLANE_SEMANTIC_LABEL = 1000741003
    MARKER = 1000743000
    ANCHOR = 1000762000
    PERSISTENCE = 1000763000


class SpatialEntityTrackingStateEXT(EnumBase):
    STOPPED = 1
    PAUSED = 2
    TRACKING = 3


class SpatialBufferTypeEXT(EnumBase):
    UNKNOWN = 0
    STRING = 1
    UINT8 = 2
    UINT16 = 3
    UINT32 = 4
    FLOAT = 5
    VECTOR2F = 6
    VECTOR3F = 7


class SpatialPlaneAlignmentEXT(EnumBase):
    HORIZONTAL_UPWARD = 0
    HORIZONTAL_DOWNWARD = 1
    VERTICAL = 2
    ARBITRARY = 3


class SpatialPlaneSemanticLabelEXT(EnumBase):
    UNCATEGORIZED = 1
    FLOOR = 2
    WALL = 3
    CEILING = 4
    TABLE = 5


class SpatialMarkerArucoDictEXT(EnumBase):
    N4X4_50 = 1
    N4X4_100 = 2
    N4X4_250 = 3
    N4X4_1000 = 4
    N5X5_50 = 5
    N5X5_100 = 6
    N5X5_250 = 7
    N5X5_1000 = 8
    N6X6_50 = 9
    N6X6_100 = 10
    N6X6_250 = 11
    N6X6_1000 = 12
    N7X7_50 = 13
    N7X7_100 = 14
    N7X7_250 = 15
    N7X7_1000 = 16


class SpatialMarkerAprilTagDictEXT(EnumBase):
    N16H5 = 1
    N25H9 = 2
    N36H10 = 3
    N36H11 = 4


class SpatialPersistenceScopeEXT(EnumBase):
    SYSTEM_MANAGED = 1
    LOCAL_ANCHORS = 1000781000


class SpatialPersistenceContextResultEXT(EnumBase):
    SUCCESS = 0
    ENTITY_NOT_TRACKING = -1000781001
    PERSIST_UUID_NOT_FOUND = -1000781002


class SpatialPersistenceStateEXT(EnumBase):
    LOADED = 1
    NOT_FOUND = 2


class InstanceCreateFlags(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class SessionCreateFlags(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class SpaceVelocityFlags(FlagBase):
    NONE = 0x00000000
    LINEAR_VALID_BIT = 0x00000001
    ANGULAR_VALID_BIT = 0x00000002
    ALL = LINEAR_VALID_BIT | ANGULAR_VALID_BIT


class SpaceLocationFlags(FlagBase):
    NONE = 0x00000000
    ORIENTATION_VALID_BIT = 0x00000001
    POSITION_VALID_BIT = 0x00000002
    ORIENTATION_TRACKED_BIT = 0x00000004
    POSITION_TRACKED_BIT = 0x00000008
    ALL = ORIENTATION_VALID_BIT | POSITION_VALID_BIT | ORIENTATION_TRACKED_BIT | POSITION_TRACKED_BIT


class SwapchainCreateFlags(FlagBase):
    NONE = 0x00000000
    PROTECTED_CONTENT_BIT = 0x00000001
    STATIC_IMAGE_BIT = 0x00000002
    ALL = PROTECTED_CONTENT_BIT | STATIC_IMAGE_BIT


class SwapchainUsageFlags(FlagBase):
    NONE = 0x00000000
    COLOR_ATTACHMENT_BIT = 0x00000001
    DEPTH_STENCIL_ATTACHMENT_BIT = 0x00000002
    UNORDERED_ACCESS_BIT = 0x00000004
    TRANSFER_SRC_BIT = 0x00000008
    TRANSFER_DST_BIT = 0x00000010
    SAMPLED_BIT = 0x00000020
    MUTABLE_FORMAT_BIT = 0x00000040
    INPUT_ATTACHMENT_BIT_MND = 0x00000080
    INPUT_ATTACHMENT_BIT_KHR = 0x00000080
    ALL = COLOR_ATTACHMENT_BIT | DEPTH_STENCIL_ATTACHMENT_BIT | UNORDERED_ACCESS_BIT | TRANSFER_SRC_BIT | TRANSFER_DST_BIT | SAMPLED_BIT | MUTABLE_FORMAT_BIT | INPUT_ATTACHMENT_BIT_MND | INPUT_ATTACHMENT_BIT_KHR


class CompositionLayerFlags(FlagBase):
    NONE = 0x00000000
    CORRECT_CHROMATIC_ABERRATION_BIT = 0x00000001
    BLEND_TEXTURE_SOURCE_ALPHA_BIT = 0x00000002
    UNPREMULTIPLIED_ALPHA_BIT = 0x00000004
    INVERTED_ALPHA_BIT_EXT = 0x00000008
    ALL = CORRECT_CHROMATIC_ABERRATION_BIT | BLEND_TEXTURE_SOURCE_ALPHA_BIT | UNPREMULTIPLIED_ALPHA_BIT | INVERTED_ALPHA_BIT_EXT


class ViewStateFlags(FlagBase):
    NONE = 0x00000000
    ORIENTATION_VALID_BIT = 0x00000001
    POSITION_VALID_BIT = 0x00000002
    ORIENTATION_TRACKED_BIT = 0x00000004
    POSITION_TRACKED_BIT = 0x00000008
    ALL = ORIENTATION_VALID_BIT | POSITION_VALID_BIT | ORIENTATION_TRACKED_BIT | POSITION_TRACKED_BIT


class InputSourceLocalizedNameFlags(FlagBase):
    NONE = 0x00000000
    USER_PATH_BIT = 0x00000001
    INTERACTION_PROFILE_BIT = 0x00000002
    COMPONENT_BIT = 0x00000004
    ALL = USER_PATH_BIT | INTERACTION_PROFILE_BIT | COMPONENT_BIT


class DebugUtilsMessageSeverityFlagsEXT(FlagBase):
    NONE = 0x00000000
    VERBOSE_BIT = 0x00000001
    INFO_BIT = 0x00000010
    WARNING_BIT = 0x00000100
    ERROR_BIT = 0x00001000
    ALL = VERBOSE_BIT | INFO_BIT | WARNING_BIT | ERROR_BIT


class DebugUtilsMessageTypeFlagsEXT(FlagBase):
    NONE = 0x00000000
    GENERAL_BIT = 0x00000001
    VALIDATION_BIT = 0x00000002
    PERFORMANCE_BIT = 0x00000004
    CONFORMANCE_BIT = 0x00000008
    ALL = GENERAL_BIT | VALIDATION_BIT | PERFORMANCE_BIT | CONFORMANCE_BIT


class OverlaySessionCreateFlagsEXTX(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class OverlayMainSessionFlagsEXTX(FlagBase):
    NONE = 0x00000000
    ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT = 0x00000001
    ALL = ENABLED_COMPOSITION_LAYER_INFO_DEPTH_BIT


class CompositionLayerImageLayoutFlagsFB(FlagBase):
    NONE = 0x00000000
    VERTICAL_FLIP_BIT = 0x00000001
    ALL = VERTICAL_FLIP_BIT


class CompositionLayerSecureContentFlagsFB(FlagBase):
    NONE = 0x00000000
    EXCLUDE_LAYER_BIT = 0x00000001
    REPLACE_LAYER_BIT = 0x00000002
    ALL = EXCLUDE_LAYER_BIT | REPLACE_LAYER_BIT


class HandTrackingAimFlagsFB(FlagBase):
    NONE = 0x00000000
    COMPUTED_BIT = 0x00000001
    VALID_BIT = 0x00000002
    INDEX_PINCHING_BIT = 0x00000004
    MIDDLE_PINCHING_BIT = 0x00000008
    RING_PINCHING_BIT = 0x00000010
    LITTLE_PINCHING_BIT = 0x00000020
    SYSTEM_GESTURE_BIT = 0x00000040
    DOMINANT_HAND_BIT = 0x00000080
    MENU_PRESSED_BIT = 0x00000100
    ALL = COMPUTED_BIT | VALID_BIT | INDEX_PINCHING_BIT | MIDDLE_PINCHING_BIT | RING_PINCHING_BIT | LITTLE_PINCHING_BIT | SYSTEM_GESTURE_BIT | DOMINANT_HAND_BIT | MENU_PRESSED_BIT


class SwapchainCreateFoveationFlagsFB(FlagBase):
    NONE = 0x00000000
    SCALED_BIN_BIT = 0x00000001
    FRAGMENT_DENSITY_MAP_BIT = 0x00000002
    ALL = SCALED_BIN_BIT | FRAGMENT_DENSITY_MAP_BIT


class SwapchainStateFoveationFlagsFB(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class KeyboardTrackingFlagsFB(FlagBase):
    NONE = 0x00000000
    EXISTS_BIT = 0x00000001
    LOCAL_BIT = 0x00000002
    REMOTE_BIT = 0x00000004
    CONNECTED_BIT = 0x00000008
    ALL = EXISTS_BIT | LOCAL_BIT | REMOTE_BIT | CONNECTED_BIT


class KeyboardTrackingQueryFlagsFB(FlagBase):
    NONE = 0x00000000
    LOCAL_BIT = 0x00000002
    REMOTE_BIT = 0x00000004
    ALL = LOCAL_BIT | REMOTE_BIT


class TriangleMeshFlagsFB(FlagBase):
    NONE = 0x00000000
    MUTABLE_BIT = 0x00000001
    ALL = MUTABLE_BIT


class PassthroughCapabilityFlagsFB(FlagBase):
    NONE = 0x00000000
    BIT = 0x00000001
    COLOR_BIT = 0x00000002
    LAYER_DEPTH_BIT = 0x00000004
    ALL = BIT | COLOR_BIT | LAYER_DEPTH_BIT


class PassthroughFlagsFB(FlagBase):
    NONE = 0x00000000
    IS_RUNNING_AT_CREATION_BIT = 0x00000001
    LAYER_DEPTH_BIT = 0x00000002
    ALL = IS_RUNNING_AT_CREATION_BIT | LAYER_DEPTH_BIT


class PassthroughStateChangedFlagsFB(FlagBase):
    NONE = 0x00000000
    REINIT_REQUIRED_BIT = 0x00000001
    NON_RECOVERABLE_ERROR_BIT = 0x00000002
    RECOVERABLE_ERROR_BIT = 0x00000004
    RESTORED_ERROR_BIT = 0x00000008
    ALL = REINIT_REQUIRED_BIT | NON_RECOVERABLE_ERROR_BIT | RECOVERABLE_ERROR_BIT | RESTORED_ERROR_BIT


class RenderModelFlagsFB(FlagBase):
    NONE = 0x00000000
    SUPPORTS_GLTF_2_0_SUBSET_1_BIT = 0x00000001
    SUPPORTS_GLTF_2_0_SUBSET_2_BIT = 0x00000002
    ALL = SUPPORTS_GLTF_2_0_SUBSET_1_BIT | SUPPORTS_GLTF_2_0_SUBSET_2_BIT


class FrameEndInfoFlagsML(FlagBase):
    NONE = 0x00000000
    PROTECTED_BIT = 0x00000001
    VIGNETTE_BIT = 0x00000002
    ALL = PROTECTED_BIT | VIGNETTE_BIT


class GlobalDimmerFrameEndInfoFlagsML(FlagBase):
    NONE = 0x00000000
    ENABLED_BIT = 0x00000001
    ALL = ENABLED_BIT


class LocalizationMapErrorFlagsML(FlagBase):
    NONE = 0x00000000
    UNKNOWN_BIT = 0x00000001
    OUT_OF_MAPPED_AREA_BIT = 0x00000002
    LOW_FEATURE_COUNT_BIT = 0x00000004
    EXCESSIVE_MOTION_BIT = 0x00000008
    LOW_LIGHT_BIT = 0x00000010
    HEADPOSE_BIT = 0x00000020
    ALL = UNKNOWN_BIT | OUT_OF_MAPPED_AREA_BIT | LOW_FEATURE_COUNT_BIT | EXCESSIVE_MOTION_BIT | LOW_LIGHT_BIT | HEADPOSE_BIT


class CompositionLayerSpaceWarpInfoFlagsFB(FlagBase):
    NONE = 0x00000000
    FRAME_SKIP_BIT = 0x00000001
    ALL = FRAME_SKIP_BIT


class SemanticLabelsSupportFlagsFB(FlagBase):
    NONE = 0x00000000
    MULTIPLE_SEMANTIC_LABELS_BIT = 0x00000001
    ACCEPT_DESK_TO_TABLE_MIGRATION_BIT = 0x00000002
    ACCEPT_INVISIBLE_WALL_FACE_BIT = 0x00000004
    ALL = MULTIPLE_SEMANTIC_LABELS_BIT | ACCEPT_DESK_TO_TABLE_MIGRATION_BIT | ACCEPT_INVISIBLE_WALL_FACE_BIT


class DigitalLensControlFlagsALMALENCE(FlagBase):
    NONE = 0x00000000
    PROCESSING_DISABLE_BIT = 0x00000001
    ALL = PROCESSING_DISABLE_BIT


class FoveationEyeTrackedProfileCreateFlagsMETA(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class FoveationEyeTrackedStateFlagsMETA(FlagBase):
    NONE = 0x00000000
    VALID_BIT = 0x00000001
    ALL = VALID_BIT


class CompositionLayerSettingsFlagsFB(FlagBase):
    NONE = 0x00000000
    NORMAL_SUPER_SAMPLING_BIT = 0x00000001
    QUALITY_SUPER_SAMPLING_BIT = 0x00000002
    NORMAL_SHARPENING_BIT = 0x00000004
    QUALITY_SHARPENING_BIT = 0x00000008
    AUTO_LAYER_FILTER_BIT = 0x00000020
    ALL = NORMAL_SUPER_SAMPLING_BIT | QUALITY_SUPER_SAMPLING_BIT | NORMAL_SHARPENING_BIT | QUALITY_SHARPENING_BIT | AUTO_LAYER_FILTER_BIT


class FrameSynthesisInfoFlagsEXT(FlagBase):
    NONE = 0x00000000
    USE_2D_MOTION_VECTOR_BIT = 0x00000001
    REQUEST_RELAXED_FRAME_INTERVAL_BIT = 0x00000002
    ALL = USE_2D_MOTION_VECTOR_BIT | REQUEST_RELAXED_FRAME_INTERVAL_BIT


class PassthroughPreferenceFlagsMETA(FlagBase):
    NONE = 0x00000000
    DEFAULT_TO_ACTIVE_BIT = 0x00000001
    ALL = DEFAULT_TO_ACTIVE_BIT


class VirtualKeyboardInputStateFlagsMETA(FlagBase):
    NONE = 0x00000000
    PRESSED_BIT = 0x00000001
    ALL = PRESSED_BIT


class ExternalCameraStatusFlagsOCULUS(FlagBase):
    NONE = 0x00000000
    CONNECTED_BIT = 0x00000001
    CALIBRATING_BIT = 0x00000002
    CALIBRATION_FAILED_BIT = 0x00000004
    CALIBRATED_BIT = 0x00000008
    CAPTURING_BIT = 0x00000010
    ALL = CONNECTED_BIT | CALIBRATING_BIT | CALIBRATION_FAILED_BIT | CALIBRATED_BIT | CAPTURING_BIT


class PerformanceMetricsCounterFlagsMETA(FlagBase):
    NONE = 0x00000000
    ANY_VALUE_VALID_BIT = 0x00000001
    UINT_VALUE_VALID_BIT = 0x00000002
    FLOAT_VALUE_VALID_BIT = 0x00000004
    ALL = ANY_VALUE_VALID_BIT | UINT_VALUE_VALID_BIT | FLOAT_VALUE_VALID_BIT


class EnvironmentDepthProviderCreateFlagsMETA(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class EnvironmentDepthSwapchainCreateFlagsMETA(FlagBase):
    NONE = 0x00000000
    ALL = NONE


class FoveationDynamicFlagsHTC(FlagBase):
    NONE = 0x00000000
    LEVEL_ENABLED_BIT = 0x00000001
    CLEAR_FOV_ENABLED_BIT = 0x00000002
    FOCAL_CENTER_OFFSET_ENABLED_BIT = 0x00000004
    ALL = LEVEL_ENABLED_BIT | CLEAR_FOV_ENABLED_BIT | FOCAL_CENTER_OFFSET_ENABLED_BIT


class SpatialMeshConfigFlagsBD(FlagBase):
    NONE = 0x00000000
    SEMANTIC_BIT = 0x00000001
    ALIGN_SEMANTIC_WITH_VERTEX_BIT = 0x00000002
    ALL = SEMANTIC_BIT | ALIGN_SEMANTIC_WITH_VERTEX_BIT


class PlaneDetectionCapabilityFlagsEXT(FlagBase):
    NONE = 0x00000000
    PLANE_DETECTION_BIT = 0x00000001
    PLANE_HOLES_BIT = 0x00000002
    SEMANTIC_CEILING_BIT = 0x00000004
    SEMANTIC_FLOOR_BIT = 0x00000008
    SEMANTIC_WALL_BIT = 0x00000010
    SEMANTIC_PLATFORM_BIT = 0x00000020
    ORIENTATION_BIT = 0x00000040
    ALL = PLANE_DETECTION_BIT | PLANE_HOLES_BIT | SEMANTIC_CEILING_BIT | SEMANTIC_FLOOR_BIT | SEMANTIC_WALL_BIT | SEMANTIC_PLATFORM_BIT | ORIENTATION_BIT


class PlaneDetectorFlagsEXT(FlagBase):
    NONE = 0x00000000
    ENABLE_CONTOUR_BIT = 0x00000001
    ALL = ENABLE_CONTOUR_BIT


class WorldMeshDetectorFlagsML(FlagBase):
    NONE = 0x00000000
    POINT_CLOUD_BIT = 0x00000001
    COMPUTE_NORMALS_BIT = 0x00000002
    COMPUTE_CONFIDENCE_BIT = 0x00000004
    PLANARIZE_BIT = 0x00000008
    REMOVE_MESH_SKIRT_BIT = 0x00000010
    INDEX_ORDER_CW_BIT = 0x00000020
    ALL = POINT_CLOUD_BIT | COMPUTE_NORMALS_BIT | COMPUTE_CONFIDENCE_BIT | PLANARIZE_BIT | REMOVE_MESH_SKIRT_BIT | INDEX_ORDER_CW_BIT


class FacialExpressionBlendShapePropertiesFlagsML(FlagBase):
    NONE = 0x00000000
    VALID_BIT = 0x00000001
    TRACKED_BIT = 0x00000002
    ALL = VALID_BIT | TRACKED_BIT


__all__ = [
    "ActionType",
    "AnchorPersistStateANDROID",
    "BlendFactorFB",
    "BodyJointBD",
    "BodyJointConfidenceHTC",
    "BodyJointFB",
    "BodyJointHTC",
    "BodyJointSetBD",
    "BodyJointSetFB",
    "BodyJointSetHTC",
    "BodyTrackingCalibrationStateMETA",
    "ColorSpaceFB",
    "CompareOpFB",
    "CompositionLayerFlags",
    "CompositionLayerImageLayoutFlagsFB",
    "CompositionLayerSecureContentFlagsFB",
    "CompositionLayerSettingsFlagsFB",
    "CompositionLayerSpaceWarpInfoFlagsFB",
    "DebugUtilsMessageSeverityFlagsEXT",
    "DebugUtilsMessageTypeFlagsEXT",
    "DigitalLensControlFlagsALMALENCE",
    "EnumBase",
    "EnvironmentBlendMode",
    "EnvironmentDepthProviderCreateFlagsMETA",
    "EnvironmentDepthSwapchainCreateFlagsMETA",
    "ExternalCameraAttachedToDeviceOCULUS",
    "ExternalCameraStatusFlagsOCULUS",
    "EyeCalibrationStatusML",
    "EyeExpressionHTC",
    "EyePositionFB",
    "EyeVisibility",
    "FaceConfidence2FB",
    "FaceConfidenceFB",
    "FaceExpression2FB",
    "FaceExpressionFB",
    "FaceExpressionSet2FB",
    "FaceExpressionSetFB",
    "FaceTrackingDataSource2FB",
    "FacialBlendShapeML",
    "FacialExpressionBlendShapePropertiesFlagsML",
    "FacialTrackingTypeHTC",
    "FlagBase",
    "ForceFeedbackCurlLocationMNDX",
    "FormFactor",
    "FoveationDynamicFB",
    "FoveationDynamicFlagsHTC",
    "FoveationEyeTrackedProfileCreateFlagsMETA",
    "FoveationEyeTrackedStateFlagsMETA",
    "FoveationLevelFB",
    "FoveationLevelHTC",
    "FoveationModeHTC",
    "FrameEndInfoFlagsML",
    "FrameSynthesisInfoFlagsEXT",
    "FullBodyJointMETA",
    "FutureStateEXT",
    "GlobalDimmerFrameEndInfoFlagsML",
    "HandEXT",
    "HandForearmJointULTRALEAP",
    "HandJointEXT",
    "HandJointSetEXT",
    "HandJointsMotionRangeEXT",
    "HandPoseTypeMSFT",
    "HandTrackingAimFlagsFB",
    "HandTrackingDataSourceEXT",
    "HeadsetFitStatusML",
    "InputSourceLocalizedNameFlags",
    "InstanceCreateFlags",
    "KeyboardTrackingFlagsFB",
    "KeyboardTrackingQueryFlagsFB",
    "LipExpressionHTC",
    "LocalDimmingModeMETA",
    "LocalizationMapConfidenceML",
    "LocalizationMapErrorFlagsML",
    "LocalizationMapStateML",
    "LocalizationMapTypeML",
    "MarkerAprilTagDictML",
    "MarkerArucoDictML",
    "MarkerDetectorCameraML",
    "MarkerDetectorCornerRefineMethodML",
    "MarkerDetectorFpsML",
    "MarkerDetectorFullAnalysisIntervalML",
    "MarkerDetectorProfileML",
    "MarkerDetectorResolutionML",
    "MarkerDetectorStatusML",
    "MarkerTypeML",
    "MeshComputeLodMSFT",
    "ObjectLabelANDROID",
    "ObjectType",
    "OverlayMainSessionFlagsEXTX",
    "OverlaySessionCreateFlagsEXTX",
    "PassthroughCameraStateANDROID",
    "PassthroughCapabilityFlagsFB",
    "PassthroughColorLutChannelsMETA",
    "PassthroughFlagsFB",
    "PassthroughFormHTC",
    "PassthroughLayerPurposeFB",
    "PassthroughPreferenceFlagsMETA",
    "PassthroughStateChangedFlagsFB",
    "PerfSettingsDomainEXT",
    "PerfSettingsLevelEXT",
    "PerfSettingsNotificationLevelEXT",
    "PerfSettingsSubDomainEXT",
    "PerformanceMetricsCounterFlagsMETA",
    "PerformanceMetricsCounterUnitMETA",
    "PersistenceLocationBD",
    "PlaneDetectionCapabilityFlagsEXT",
    "PlaneDetectionStateEXT",
    "PlaneDetectorFlagsEXT",
    "PlaneDetectorOrientationEXT",
    "PlaneDetectorSemanticTypeEXT",
    "PlaneLabelANDROID",
    "PlaneOrientationBD",
    "PlaneTypeANDROID",
    "ReferenceSpaceType",
    "RenderModelFlagsFB",
    "ReprojectionModeMSFT",
    "Result",
    "SceneComponentTypeMSFT",
    "SceneComputeConsistencyMSFT",
    "SceneComputeFeatureMSFT",
    "SceneComputeStateMSFT",
    "SceneMarkerQRCodeSymbolTypeMSFT",
    "SceneMarkerTypeMSFT",
    "SceneObjectTypeMSFT",
    "ScenePlaneAlignmentTypeMSFT",
    "SemanticLabelBD",
    "SemanticLabelsSupportFlagsFB",
    "SenseDataProviderStateBD",
    "SenseDataProviderTypeBD",
    "SessionCreateFlags",
    "SessionState",
    "SpaceComponentTypeFB",
    "SpaceLocationFlags",
    "SpacePersistenceModeFB",
    "SpaceQueryActionFB",
    "SpaceStorageLocationFB",
    "SpaceVelocityFlags",
    "SpatialAnchorConfidenceML",
    "SpatialBufferTypeEXT",
    "SpatialCapabilityEXT",
    "SpatialCapabilityFeatureEXT",
    "SpatialComponentTypeEXT",
    "SpatialEntityComponentTypeBD",
    "SpatialEntityTrackingStateEXT",
    "SpatialGraphNodeTypeMSFT",
    "SpatialMarkerAprilTagDictEXT",
    "SpatialMarkerArucoDictEXT",
    "SpatialMeshConfigFlagsBD",
    "SpatialMeshLodBD",
    "SpatialPersistenceContextResultEXT",
    "SpatialPersistenceScopeEXT",
    "SpatialPersistenceStateEXT",
    "SpatialPlaneAlignmentEXT",
    "SpatialPlaneSemanticLabelEXT",
    "StructureType",
    "SwapchainCreateFlags",
    "SwapchainCreateFoveationFlagsFB",
    "SwapchainStateFoveationFlagsFB",
    "SwapchainUsageFlags",
    "TrackableMarkerDictionaryANDROID",
    "TrackableMarkerTrackingModeANDROID",
    "TrackableTypeANDROID",
    "TrackingOptimizationSettingsDomainQCOM",
    "TrackingOptimizationSettingsHintQCOM",
    "TrackingStateANDROID",
    "TriangleMeshFlagsFB",
    "ViewConfigurationType",
    "ViewStateFlags",
    "VirtualKeyboardInputSourceMETA",
    "VirtualKeyboardInputStateFlagsMETA",
    "VirtualKeyboardLocationTypeMETA",
    "VisibilityMaskTypeKHR",
    "WindingOrderFB",
    "WorldMeshBlockResultML",
    "WorldMeshBlockStatusML",
    "WorldMeshDetectorFlagsML",
    "WorldMeshDetectorLodML",
    "failed",
    "succeeded",
    "unqualified_success",
]
