import sys
import os
from setuptools import setup
from setuptools.command.install import install
from setuptools.dist import Distribution
from distutils.command.build import build
from multiprocessing import cpu_count
from subprocess import call
import platform


requirements = [
    "IBMQuantumExperience>=1.8.26",
    "matplotlib>=2.1,<2.2",
    "networkx>=1.11,<2.1",
    "numpy>=1.13,<1.15",
    "ply==3.10",
    "scipy>=0.19,<1.1",
    "Sphinx>=1.6,<1.7",
    "sympy>=1.0"
]


packages = ["qiskit",
            "qiskit.backends",
            "qiskit.dagcircuit",
            "qiskit.extensions",
            "qiskit.extensions.standard",
            "qiskit.extensions.qiskit_simulator",
            "qiskit.extensions.quantum_initializer",
            "qiskit.mapper",
            "qiskit.qasm",
            "qiskit.qasm._node",
            "qiskit.unroll",
            "qiskit.tools",
            "qiskit.tools.apps",
            "qiskit.tools.qcvv",
            "qiskit.tools.qi"]


# C++ components compilation
class QiskitSimulatorBuild(build):
    def run(self):
        build.run(self)
        supported_platforms = ['Linux', 'Darwin', 'Windows']
        current_platform = platform.system()
        if not current_platform in supported_platforms:
            print('WARNING: QISKit cpp simulator is ment to be built with these '
                  'platforms: {}. We will support other platforms soon!'
                  .format(supported_platforms))
            return

        cmd_cmake = ['cmake', '-vvv']
        if 'USER_LIB_PATH' in os.environ:
            cmd_cmake.append('-DUSER_LIB_PATH={}'.format(os.environ['USER_LIB_PATH']))
        if current_platform == 'Windows':
            # We only support MinGW so far
            cmd_cmake.append("-GMinGW Makefiles")
        cmd_cmake.append('..')

        cmd_make = ['make', 'pypi_package_copy_qiskit_simulator']

        try:
            cmd_make.append('-j%d' % cpu_count())
        except NotImplementedError:
            print('WARNING: Unable to determine number of CPUs. Using single threaded make.')

        def compile():
            self.mkpath('out')
            os.chdir('out')
            call(cmd_cmake)
            call(cmd_make)
            os.chdir('..')

        try:
            self.execute(compile, [], 'Compiling QISKit C++ Simulator')
        except:
            print("WARNING: Seems like the cpp simulator can't be built, Qiskit will "
                  "install anyway, but won't have this simulator support.")
            return

# This is for creating wheel specific platforms
class BinaryDistribution(Distribution):
    def has_ext_modules(self):
        return True

setup(
    name="qiskit",
    version="0.4.9",
    description="Software for developing quantum computing programs",
    long_description="""QISKit is a software development kit for writing
        quantum computing experiments, programs, and applications. Works with
        Python 3.5 and 3.6""",
    url="https://github.com/QISKit/qiskit-sdk-py",
    author="QISKit Development Team",
    author_email="qiskit@us.ibm.com",
    license="Apache 2.0",
    classifiers=[
        "Environment :: Console",
        "License :: OSI Approved :: Apache Software License",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: MacOS",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Topic :: Scientific/Engineering",
    ],
    keywords="qiskit sdk quantum",
    packages=packages,
    install_requires=requirements,
    include_package_data=True,
    python_requires=">=3.5",
    cmdclass={
        'build': QiskitSimulatorBuild,
    },
    distclass=BinaryDistribution
)
