# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List
from scope_client.api_bindings.models.connector_spec_schema_field import ConnectorSpecSchemaField
from scope_client.api_bindings.models.connector_type import ConnectorType
from scope_client.api_bindings.models.dataset_locator_schema import DatasetLocatorSchema
from typing import Optional, Set
from typing_extensions import Self

class ConnectorSpecSchema(BaseModel):
    """
    ConnectorSpecSchema
    """ # noqa: E501
    created_at: datetime = Field(description="Time of record creation.")
    updated_at: datetime = Field(description="Time of last record update.")
    connector_type: ConnectorType = Field(description="Connector type for the schema. Must be unique.")
    fields: List[ConnectorSpecSchemaField] = Field(description="Metadata for optional and required connector fields.")
    dataset_locator_schema: DatasetLocatorSchema = Field(description="Schema with dataset locator metadata for all datasets using the connector type.")
    supports_dataset_listing: StrictBool = Field(description="Indicates whether this connector supports listing available datasets.")
    __properties: ClassVar[List[str]] = ["created_at", "updated_at", "connector_type", "fields", "dataset_locator_schema", "supports_dataset_listing"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectorSpecSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of dataset_locator_schema
        if self.dataset_locator_schema:
            _dict['dataset_locator_schema'] = self.dataset_locator_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectorSpecSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "connector_type": obj.get("connector_type"),
            "fields": [ConnectorSpecSchemaField.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "dataset_locator_schema": DatasetLocatorSchema.from_dict(obj["dataset_locator_schema"]) if obj.get("dataset_locator_schema") is not None else None,
            "supports_dataset_listing": obj.get("supports_dataset_listing")
        })
        return _obj


