# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from scope_client.api_bindings.models.put_model_metric_spec import PutModelMetricSpec
from typing import Optional, Set
from typing_extensions import Self

class PostModel(BaseModel):
    """
    PostModel
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the model.")
    description: Optional[StrictStr]
    onboarding_identifier: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = None
    metric_config: Optional[PutModelMetricSpec] = None
    dataset_ids: List[StrictStr] = Field(description="IDs of datasets for the model.")
    __properties: ClassVar[List[str]] = ["name", "description", "onboarding_identifier", "metric_config", "dataset_ids"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metric_config
        if self.metric_config:
            _dict['metric_config'] = self.metric_config.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if onboarding_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_identifier is None and "onboarding_identifier" in self.model_fields_set:
            _dict['onboarding_identifier'] = None

        # set to None if metric_config (nullable) is None
        # and model_fields_set contains the field
        if self.metric_config is None and "metric_config" in self.model_fields_set:
            _dict['metric_config'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "onboarding_identifier": obj.get("onboarding_identifier"),
            "metric_config": PutModelMetricSpec.from_dict(obj["metric_config"]) if obj.get("metric_config") is not None else None,
            "dataset_ids": obj.get("dataset_ids")
        })
        return _obj


