<p align="center">
  <a href="https://github.com/1minds3t/omnipkg/actions/workflows/security_audit.yml"><img src="https://github.com/1minds3t/omnipkg/actions/workflows/security_audit.yml/badge.svg" alt="Security Audit"></a>
  <a href="https://pypi.org/project/omnipkg/"><img src="https://img.shields.io/pypi/v/omnipkg.svg" alt="PyPI version"></a>
  <a href="https://www.gnu.org/licenses/agpl-3.0"><img src="https://img.shields.io/badge/License-AGPLv3-red.svg" alt="License: AGPLv3"></a>
</p>

# 📢 Announcement: macOS Compatibility Confirmed!

🎉 The `omnipkg` stress test has been successfully validated on macOS with Python 3.11.

✅ **Key Successes:**
- Flawless installation of large scientific packages like NumPy and SciPy.
- Zero-setup installation on a clean system.
- Confirmed stability of the `omnipkg` version "bubble" system on macOS.

⚠️ **Important Note:**
This tool is primarily designed and validated for Python 3.11, especially for the stress test. While `omnipkg` supports other versions, for a guaranteed seamless experience, Python 3.11 is recommended. We are actively working on adding pre-launch checks to automatically help users configure their environments and fix common issues.

# omnipkg - The Dependency Orchestration Engine

One environment. Infinite packages/versions/dependencies. No duplicates/downgrades ever again. You can significantly reduce your reliance on pipx, uv, conda, Docker, etc. today.

## 💥 The Proof: Orchestrating an "Impossible" Install

Other tools attempt dependency resolution. Omnipkg orchestrates dependency symphonies.

To prove this, we'll do something no other tool can: install two conflicting versions of PyTorch in a single command, provided in the "wrong" order.

### Step 1: Request the Impossible
```bash
$ omnipkg install torch==2.0.0 torch==2.7.1
```

### Step 2: Watch the Magic

omnipkg doesn’t fail. It orchestrates. It intelligently reorders the request for optimal execution, installs the newest version, then isolates the older, conflicting version in a bubble.

```
🔄 Reordered packages for optimal installation: torch==2.7.1, torch==2.0.0

────────────────────────────────────────────────────────────
📦 Processing: torch==2.7.1
...
✅ No downgrades detected. Installation completed safely.

────────────────────────────────────────────────────────────
📦 Processing: torch==2.0.0
...
🛡️ DOWNGRADE PROTECTION ACTIVATED!
    -> Fixing downgrade: torch from v2.7.1 to v2.0.0
🫧 Creating isolated bubble for torch v2.0.0
    ...
    🔄 Restoring 'torch' to safe version v2.7.1 in main environment...
✅ Environment protection complete!
```

The operation leaves a pristine main environment and a perfectly isolated older version, ready for use.

## The Unsolvable Problem, Solved.

For decades, the Python community has accepted a frustrating reality: if you need two versions of the same package, you need two virtual environments. A legacy project needing tensorflow==1.15 and a new project needing tensorflow==2.10 could not coexist. We’ve been stuck in dependency hell.

omnipkg ends dependency hell once and for all.

It is a revolutionary package manager that allows you to run multiple, conflicting packages and dependencies in a single Python environment. omnipkg intelligently isolates only the conflicting package and its historically-correct dependencies, while your entire environment continues to share all other compatible packages. Our roadmap includes a “time machine” builder that can even handle legacy packages that no longer build on modern systems, giving you access to ancient dependencies with a single command.

The result is one clean environment, infinite versions, and zero waste.

## 🛠️ Easy Install

Get started in under 1 minute.

```bash
# First, install omnipkg (after installing Redis)
pip install omnipkg

# Then, run the fully automated stress test
omnipkg stress-test
```

## 🌍 Real-World Example

Imagine maintaining a Flask app that needs:

- flask-login==0.4.1 (legacy)
- requests==2.28.0 (new)
- scikit-learn==0.24 (ML)

**Traditional**: 3 separate environments  
**omnipkg**: Single environment

## 🏢 Enterprise Impact

|Metric          |Before omnipkg|After omnipkg|
|----------------|--------------|-------------|
|CI/CD Complexity|5 envs        |1 env        |
|Storage Overhead|8.7GB         |3.5GB        |
|Setup Time      |22 min        |30 sec       |
|Deduplication   |0%            |~60%         |
|KB Build Speed  |N/A           |7 pkgs/sec   |
|Recovery Time   |Hours         |Seconds      |

## 🧠 Key Features

- **Intelligent Task Reordering**: Automatically sorts packages to install newest versions first, ensuring downgrade protection is triggered with surgical precision.
- **Intelligent Downgrade Protection**: Automatically detects and prevents pip installs that would break your existing environment.
- **Surgical Version Bubbles**: Creates lightweight, self-contained bubbles for conflicting packages and their entire historical dependency trees.
- **Efficient Deduplication**: Bubbles only contain the necessary files. All compatible dependencies are shared with the main environment, saving on average 60% of disk space.
- **Dynamic Runtime Switching**: A seamless loader allows your scripts to activate a specific bubbled version on-demand, without changing your environment.
- **Atomic Environment Cleansing**: A core design principle that surgically prepares the environment before complex operations.
- **Lightning-Fast Knowledge Base**: Builds metadata at 7 packages/second with intelligent caching and delta updates.
- **Nuclear-Grade C-Extension Mixing**: 100% reliable runtime swapping of numpy, scipy, and other C-extensions that was previously “impossible”.
- **The Guardian Protocol**: omnipkg revert with automatic environment snapshots - your ultimate undo button.
- **Registry-Based Deduplication (Coming Soon)**: A future feature to expand space savings by sharing files across bubbles.
- **Multi-Interpreter Support (Coming Soon)**: Seamlessly switch between different Python versions in a single environment.
- **Extreme Scale Testing**: Battle-tested with 35GB+ of bubbles in tmpfs (until the developer’s RAM gave up!).

## Your Environment Visualized

```
├── numpy==1.26
├── pandas==2.1
└── .omnipkg_versions (bubbles)
    ├── tensorflow-1.15
    │   ├── numpy==1.16  # isolated, 58% space saved
    └── tensorflow-2.10
        ├── numpy==1.24  # isolated, 62% space saved
```

## 🎯 Why omnipkg Changes Everything

### 🏢 Enterprise Scenario

“Our data science team needed 3 versions of TensorFlow (1.15, 2.4, 2.9) in the same JupyterHub environment. omnipkg made it work with zero conflicts and saved us 60% storage space.”

**Before omnipkg**:

- Need Django 3.2 for one project, Django 4.0 for another? → Two virtual environments
- Legacy package needs requests==2.20.0 but your app needs 2.28.0? → Dependency hell
- Want to test your code against multiple package versions? → Complex CI/CD setup
- Made a mistake? → Start over from scratch

**With omnipkg**:

- One environment, infinite package versions
- Zero conflicts, zero waste (60% deduplication on average)
- Runtime version switching without pip
- Install from requirements.txt with intelligent conflict handling
- omnipkg revert for instant rollback
- Just install and import - things simply work
- Only specify versions when you need runtime switching

## 🔥 Ultimate Validation: NumPy & SciPy Version Matrix

<details>
<summary><strong>🚀 omnipkg Ultimate Validation Suite</strong></summary>

**🚀 PHASE 1: Clean Environment Preparation**

```
...
Successfully installed numpy-1.26.4

🔬 Analyzing changes...

🛡️ PROTECTION ACTIVATED!
-> Handling: numpy v2.3.2 → v1.26.4
🫧 Creating bubble for numpy v1.26.4
...
✅ Bubble created: 1407 files
📊 Space saved: 0.0%
🔄 Restoring numpy v2.3.2...

✅ Environment secured!
```

**🚀 PHASE 2: Multi-Version Bubble Creation**

```
...
--- Creating numpy==1.24.3 bubble ---
🫧 Isolating numpy v1.24.3
    ✅ Bubble created: 1363 files

--- Creating scipy==1.12.0 bubble ---
🫧 Isolating scipy v1.12.0
✅ Bubble created: 3551 files
```

**🚀 PHASE 3: Runtime Validation**

**💥 NUMPY VERSION SWITCHING:**

```
⚡ Activating numpy==1.24.3
✅ Version: 1.24.3
🔢 Array sum: 6

⚡ Activating numpy==1.26.4
✅ Version: 1.26.4
🔢 Array sum: 6
```

**🔥 SCIPY EXTENSION VALIDATION:**

```
🌋 Activating scipy==1.12.0
✅ Version: 1.12.0
♻️ Sparse matrix: 3 non-zeros

🌋 Activating scipy==1.16.1
✅ Version: 1.16.1
♻️ Sparse matrix: 3 non-zeros
```

**🤯 COMBINATION TESTING:**

```
🌀 Mix: numpy==1.24.3 + scipy==1.12.0
...
🧪 Compatibility: [1. 2. 3.]

🌀 Mix: numpy==1.26.4 + scipy==1.16.1
...
🧪 Compatibility: [1. 2. 3.]
```

**🚀 VALIDATION SUCCESSFUL! 🎇**

**🚀 PHASE 4: Environment Restoration**

```
- Removing bubble: numpy-1.24.3
- Removing bubble: numpy-1.26.4
- Removing bubble: scipy-1.12.0

✅ Environment restored to initial state.
```

</details>

## 🔬 Live Example: Safe Flask-Login Downgrade

<details>
<summary><strong>🔬 Live Example: Safe Flask-Login Downgrade</strong></summary>

```bash
# Install conflicting flask-login version
$ omnipkg install flask-login==0.4.1

📸 Taking LIVE pre-installation snapshot...
    - Found 545 packages

🛡️ DOWNGRADE PROTECTION ACTIVATED!
-> Detected conflict: flask-login v0.6.3 → v0.4.1
🫧 Creating bubble for flask-login v0.4.1
    -> Strategy 1: pip dry-run...
    -> Strategy 2: PyPI API...
    ✅ Dependencies resolved via PyPI API
📦 Installing to temporary location...
🧹 Creating deduplicated bubble...
⚡️ Loading hash index from cache...
📈 Loaded 203,032 file hashes
⚠️ Native isolation: MarkupSafe
✅ Bubble created: 151 files copied, 188 deduplicated
📊 Space saved: 55.5%
🔄 Restoring flask-login v0.6.3...

✅ Environment secured!

# Verify final state
$ omnipkg info flask-login

📋 flask-login STATUS:
----------------------------------------
🎯 Active: 0.6.3 (protected)
🫧 Available: 0.4.1
📊 Space Saved: 55.5% (188 files deduplicated)
🔄 Switch: omnipkg activate flask-login==0.4.1
```

You now have both versions available without virtual environments or conflicts.

</details>


> Professional enough for enterprises, fun enough for developers

## For the memes

```
 ___________________________________________
/                                           \
|  pip is in omnipkg jail 🔒                |
|  Status: Reflecting on better ways        |
|         to manage packages...             |
|                                           |
|  💭 'Maybe breaking environments isn't    |
|     the best approach...'                 |
\___________________________________________/
        \   ^__^
         \  (oo)\_______
            (__)\       )\/\
                ||----w |
                ||     ||
```

## 📄 Licensing

omnipkg uses a dual-license model:

- **AGPLv3**: For open-source and academic use ([View License](https://www.gnu.org/licenses/agpl-3.0))
- **Commercial License**: For proprietary systems and organizations

Commercial inquiries: [omnipkg@proton.me](mailto:omnipkg@proton.me)

## 🤝 Contributing

This project was born out of a real-world problem, and it thrives on community collaboration. Contributions, bug reports, and feature requests are incredibly welcome. Please feel free to check the [issues page](https://github.com/1minds3t/omnipkg/issues) to get started.

```

```