import synapse.lib.module as s_module

class MathModule(s_module.CoreModule):

    def getModelDefs(self):
        return (('math', {
            'types': (

                ('math:algorithm', ('guid', {}), {
                    'doc': 'A mathematical algorithm.'}),

                ('math:algorithm:type:taxonomy', ('taxonomy', {}), {
                    'interfaces': ('meta:taxonomy',),
                    'doc': 'A hierarchical taxonomy of algorithm types.'}),
            ),
            'edges': (

                (('risk:tool:software', 'uses', 'math:algorithm'), {
                    'doc': 'The tool uses the algorithm.'}),

                (('it:prod:softver', 'uses', 'math:algorithm'), {
                    'doc': 'The software uses the algorithm.'}),

                (('file:bytes', 'uses', 'math:algorithm'), {
                    'doc': 'The file uses the algorithm.'}),

                (('math:algorithm', 'generates', None), {
                    'doc': 'The target node was generated by the algorithm.'}),
            ),
            'forms': (

                ('math:algorithm:type:taxonomy', {}, ()),

                ('math:algorithm', {}, (

                    ('name', ('str', {'lower': True, 'onespace': True}), {
                        'doc': 'The name of the algorithm.'}),

                    ('type', ('math:algorithm:type:taxonomy', {}), {
                        'doc': 'The type of algorithm.'}),

                    ('desc', ('str', {}), {
                        'disp': {'hint': 'text'},
                        'doc': 'A description of the algorithm.'}),

                    ('created', ('time', {}), {
                        'doc': 'The time that the algorithm was authored.'}),
                )),
            ),
        }),)
