# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertArgs', 'Alert']

@pulumi.input_type
class AlertArgs:
    def __init__(__self__, *,
                 aggregation: pulumi.Input[str],
                 alert_items: pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]],
                 description: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 severity: pulumi.Input[str],
                 target_variable: pulumi.Input[str],
                 thresholds: pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]],
                 time_window: pulumi.Input[int],
                 type: pulumi.Input[str],
                 cron_dom: Optional[pulumi.Input[int]] = None,
                 cron_dow: Optional[pulumi.Input[int]] = None,
                 cron_hours: Optional[pulumi.Input[int]] = None,
                 cron_minutes: Optional[pulumi.Input[int]] = None,
                 cron_month: Optional[pulumi.Input[int]] = None,
                 cron_year: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_unit: Optional[pulumi.Input[str]] = None,
                 rate_value: Optional[pulumi.Input[int]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]] = None):
        """
        The set of arguments for constructing a Alert resource.
        :param pulumi.Input[str] aggregation: aggregation to be applied to reads before comparisson
        :param pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]] alert_items: traces to be used to compute the results
        :param pulumi.Input[str] description: The description of the resource
        :param pulumi.Input[str] operator: operator to be used to compare the read value with the threshold value
        :param pulumi.Input[str] severity: [sev1,...,sev8] severity for the alert
        :param pulumi.Input[str] target_variable: variable to be used to compare with thresholds
        :param pulumi.Input[int] time_window: window to fetch data from. Data out of that window will not be considered for evaluation
        :param pulumi.Input[str] type: [cron|rate] type for the cron
        :param pulumi.Input[int] cron_dom: schedule value for cron
        :param pulumi.Input[int] cron_dow: schedule value for cron
        :param pulumi.Input[int] cron_hours: schedule value for cron
        :param pulumi.Input[int] cron_minutes: schedule value for cron
        :param pulumi.Input[int] cron_month: schedule value for cron
        :param pulumi.Input[int] cron_year: schedule value for cron
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[str] rate_unit: [day|hour|minute] schedule unit
        :param pulumi.Input[int] rate_value: schedule value
        :param pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]] tags: tags of the resource
        """
        pulumi.set(__self__, "aggregation", aggregation)
        pulumi.set(__self__, "alert_items", alert_items)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "target_variable", target_variable)
        pulumi.set(__self__, "thresholds", thresholds)
        pulumi.set(__self__, "time_window", time_window)
        pulumi.set(__self__, "type", type)
        if cron_dom is not None:
            pulumi.set(__self__, "cron_dom", cron_dom)
        if cron_dow is not None:
            pulumi.set(__self__, "cron_dow", cron_dow)
        if cron_hours is not None:
            pulumi.set(__self__, "cron_hours", cron_hours)
        if cron_minutes is not None:
            pulumi.set(__self__, "cron_minutes", cron_minutes)
        if cron_month is not None:
            pulumi.set(__self__, "cron_month", cron_month)
        if cron_year is not None:
            pulumi.set(__self__, "cron_year", cron_year)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_unit is not None:
            pulumi.set(__self__, "rate_unit", rate_unit)
        if rate_value is not None:
            pulumi.set(__self__, "rate_value", rate_value)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def aggregation(self) -> pulumi.Input[str]:
        """
        aggregation to be applied to reads before comparisson
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: pulumi.Input[str]):
        pulumi.set(self, "aggregation", value)

    @property
    @pulumi.getter(name="alertItems")
    def alert_items(self) -> pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]]:
        """
        traces to be used to compute the results
        """
        return pulumi.get(self, "alert_items")

    @alert_items.setter
    def alert_items(self, value: pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]]):
        pulumi.set(self, "alert_items", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        operator to be used to compare the read value with the threshold value
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[str]:
        """
        [sev1,...,sev8] severity for the alert
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[str]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="targetVariable")
    def target_variable(self) -> pulumi.Input[str]:
        """
        variable to be used to compare with thresholds
        """
        return pulumi.get(self, "target_variable")

    @target_variable.setter
    def target_variable(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_variable", value)

    @property
    @pulumi.getter
    def thresholds(self) -> pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]]:
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input[int]:
        """
        window to fetch data from. Data out of that window will not be considered for evaluation
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input[int]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        [cron|rate] type for the cron
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cronDom")
    def cron_dom(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dom")

    @cron_dom.setter
    def cron_dom(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_dom", value)

    @property
    @pulumi.getter(name="cronDow")
    def cron_dow(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dow")

    @cron_dow.setter
    def cron_dow(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_dow", value)

    @property
    @pulumi.getter(name="cronHours")
    def cron_hours(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_hours")

    @cron_hours.setter
    def cron_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_hours", value)

    @property
    @pulumi.getter(name="cronMinutes")
    def cron_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_minutes")

    @cron_minutes.setter
    def cron_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_minutes", value)

    @property
    @pulumi.getter(name="cronMonth")
    def cron_month(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_month")

    @cron_month.setter
    def cron_month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_month", value)

    @property
    @pulumi.getter(name="cronYear")
    def cron_year(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_year")

    @cron_year.setter
    def cron_year(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_year", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateUnit")
    def rate_unit(self) -> Optional[pulumi.Input[str]]:
        """
        [day|hour|minute] schedule unit
        """
        return pulumi.get(self, "rate_unit")

    @rate_unit.setter
    def rate_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate_unit", value)

    @property
    @pulumi.getter(name="rateValue")
    def rate_value(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value
        """
        return pulumi.get(self, "rate_value")

    @rate_value.setter
    def rate_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rate_value", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AlertState:
    def __init__(__self__, *,
                 aggregation: Optional[pulumi.Input[str]] = None,
                 alert_items: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]]] = None,
                 cron_dom: Optional[pulumi.Input[int]] = None,
                 cron_dow: Optional[pulumi.Input[int]] = None,
                 cron_hours: Optional[pulumi.Input[int]] = None,
                 cron_minutes: Optional[pulumi.Input[int]] = None,
                 cron_month: Optional[pulumi.Input[int]] = None,
                 cron_year: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 rate_unit: Optional[pulumi.Input[str]] = None,
                 rate_value: Optional[pulumi.Input[int]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]] = None,
                 target_variable: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]]] = None,
                 time_window: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Alert resources.
        :param pulumi.Input[str] aggregation: aggregation to be applied to reads before comparisson
        :param pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]] alert_items: traces to be used to compute the results
        :param pulumi.Input[int] cron_dom: schedule value for cron
        :param pulumi.Input[int] cron_dow: schedule value for cron
        :param pulumi.Input[int] cron_hours: schedule value for cron
        :param pulumi.Input[int] cron_minutes: schedule value for cron
        :param pulumi.Input[int] cron_month: schedule value for cron
        :param pulumi.Input[int] cron_year: schedule value for cron
        :param pulumi.Input[str] description: The description of the resource
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[str] operator: operator to be used to compare the read value with the threshold value
        :param pulumi.Input[str] rate_unit: [day|hour|minute] schedule unit
        :param pulumi.Input[int] rate_value: schedule value
        :param pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[str] severity: [sev1,...,sev8] severity for the alert
        :param pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]] tags: tags of the resource
        :param pulumi.Input[str] target_variable: variable to be used to compare with thresholds
        :param pulumi.Input[int] time_window: window to fetch data from. Data out of that window will not be considered for evaluation
        :param pulumi.Input[str] type: [cron|rate] type for the cron
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if alert_items is not None:
            pulumi.set(__self__, "alert_items", alert_items)
        if cron_dom is not None:
            pulumi.set(__self__, "cron_dom", cron_dom)
        if cron_dow is not None:
            pulumi.set(__self__, "cron_dow", cron_dow)
        if cron_hours is not None:
            pulumi.set(__self__, "cron_hours", cron_hours)
        if cron_minutes is not None:
            pulumi.set(__self__, "cron_minutes", cron_minutes)
        if cron_month is not None:
            pulumi.set(__self__, "cron_month", cron_month)
        if cron_year is not None:
            pulumi.set(__self__, "cron_year", cron_year)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if rate_unit is not None:
            pulumi.set(__self__, "rate_unit", rate_unit)
        if rate_value is not None:
            pulumi.set(__self__, "rate_value", rate_value)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_variable is not None:
            pulumi.set(__self__, "target_variable", target_variable)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[pulumi.Input[str]]:
        """
        aggregation to be applied to reads before comparisson
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aggregation", value)

    @property
    @pulumi.getter(name="alertItems")
    def alert_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]]]:
        """
        traces to be used to compute the results
        """
        return pulumi.get(self, "alert_items")

    @alert_items.setter
    def alert_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertAlertItemArgs']]]]):
        pulumi.set(self, "alert_items", value)

    @property
    @pulumi.getter(name="cronDom")
    def cron_dom(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dom")

    @cron_dom.setter
    def cron_dom(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_dom", value)

    @property
    @pulumi.getter(name="cronDow")
    def cron_dow(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dow")

    @cron_dow.setter
    def cron_dow(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_dow", value)

    @property
    @pulumi.getter(name="cronHours")
    def cron_hours(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_hours")

    @cron_hours.setter
    def cron_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_hours", value)

    @property
    @pulumi.getter(name="cronMinutes")
    def cron_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_minutes")

    @cron_minutes.setter
    def cron_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_minutes", value)

    @property
    @pulumi.getter(name="cronMonth")
    def cron_month(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_month")

    @cron_month.setter
    def cron_month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_month", value)

    @property
    @pulumi.getter(name="cronYear")
    def cron_year(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_year")

    @cron_year.setter
    def cron_year(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cron_year", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        operator to be used to compare the read value with the threshold value
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="rateUnit")
    def rate_unit(self) -> Optional[pulumi.Input[str]]:
        """
        [day|hour|minute] schedule unit
        """
        return pulumi.get(self, "rate_unit")

    @rate_unit.setter
    def rate_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rate_unit", value)

    @property
    @pulumi.getter(name="rateValue")
    def rate_value(self) -> Optional[pulumi.Input[int]]:
        """
        schedule value
        """
        return pulumi.get(self, "rate_value")

    @rate_value.setter
    def rate_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rate_value", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        [sev1,...,sev8] severity for the alert
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetVariable")
    def target_variable(self) -> Optional[pulumi.Input[str]]:
        """
        variable to be used to compare with thresholds
        """
        return pulumi.get(self, "target_variable")

    @target_variable.setter
    def target_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_variable", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]]]:
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[pulumi.Input[int]]:
        """
        window to fetch data from. Data out of that window will not be considered for evaluation
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [cron|rate] type for the cron
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Alert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation: Optional[pulumi.Input[str]] = None,
                 alert_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertItemArgs', 'AlertAlertItemArgsDict']]]]] = None,
                 cron_dom: Optional[pulumi.Input[int]] = None,
                 cron_dow: Optional[pulumi.Input[int]] = None,
                 cron_hours: Optional[pulumi.Input[int]] = None,
                 cron_minutes: Optional[pulumi.Input[int]] = None,
                 cron_month: Optional[pulumi.Input[int]] = None,
                 cron_year: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 rate_unit: Optional[pulumi.Input[str]] = None,
                 rate_value: Optional[pulumi.Input[int]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRelatedAssetArgs', 'AlertRelatedAssetArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertTagArgs', 'AlertTagArgsDict']]]]] = None,
                 target_variable: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertThresholdArgs', 'AlertThresholdArgsDict']]]]] = None,
                 time_window: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/alert:Alert [options] splight_alert.<name> <alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aggregation: aggregation to be applied to reads before comparisson
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertItemArgs', 'AlertAlertItemArgsDict']]]] alert_items: traces to be used to compute the results
        :param pulumi.Input[int] cron_dom: schedule value for cron
        :param pulumi.Input[int] cron_dow: schedule value for cron
        :param pulumi.Input[int] cron_hours: schedule value for cron
        :param pulumi.Input[int] cron_minutes: schedule value for cron
        :param pulumi.Input[int] cron_month: schedule value for cron
        :param pulumi.Input[int] cron_year: schedule value for cron
        :param pulumi.Input[str] description: The description of the resource
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[str] operator: operator to be used to compare the read value with the threshold value
        :param pulumi.Input[str] rate_unit: [day|hour|minute] schedule unit
        :param pulumi.Input[int] rate_value: schedule value
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRelatedAssetArgs', 'AlertRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[str] severity: [sev1,...,sev8] severity for the alert
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertTagArgs', 'AlertTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[str] target_variable: variable to be used to compare with thresholds
        :param pulumi.Input[int] time_window: window to fetch data from. Data out of that window will not be considered for evaluation
        :param pulumi.Input[str] type: [cron|rate] type for the cron
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/alert:Alert [options] splight_alert.<name> <alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param AlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation: Optional[pulumi.Input[str]] = None,
                 alert_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertItemArgs', 'AlertAlertItemArgsDict']]]]] = None,
                 cron_dom: Optional[pulumi.Input[int]] = None,
                 cron_dow: Optional[pulumi.Input[int]] = None,
                 cron_hours: Optional[pulumi.Input[int]] = None,
                 cron_minutes: Optional[pulumi.Input[int]] = None,
                 cron_month: Optional[pulumi.Input[int]] = None,
                 cron_year: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 rate_unit: Optional[pulumi.Input[str]] = None,
                 rate_value: Optional[pulumi.Input[int]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRelatedAssetArgs', 'AlertRelatedAssetArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertTagArgs', 'AlertTagArgsDict']]]]] = None,
                 target_variable: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertThresholdArgs', 'AlertThresholdArgsDict']]]]] = None,
                 time_window: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertArgs.__new__(AlertArgs)

            if aggregation is None and not opts.urn:
                raise TypeError("Missing required property 'aggregation'")
            __props__.__dict__["aggregation"] = aggregation
            if alert_items is None and not opts.urn:
                raise TypeError("Missing required property 'alert_items'")
            __props__.__dict__["alert_items"] = alert_items
            __props__.__dict__["cron_dom"] = cron_dom
            __props__.__dict__["cron_dow"] = cron_dow
            __props__.__dict__["cron_hours"] = cron_hours
            __props__.__dict__["cron_minutes"] = cron_minutes
            __props__.__dict__["cron_month"] = cron_month
            __props__.__dict__["cron_year"] = cron_year
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if operator is None and not opts.urn:
                raise TypeError("Missing required property 'operator'")
            __props__.__dict__["operator"] = operator
            __props__.__dict__["rate_unit"] = rate_unit
            __props__.__dict__["rate_value"] = rate_value
            __props__.__dict__["related_assets"] = related_assets
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["tags"] = tags
            if target_variable is None and not opts.urn:
                raise TypeError("Missing required property 'target_variable'")
            __props__.__dict__["target_variable"] = target_variable
            if thresholds is None and not opts.urn:
                raise TypeError("Missing required property 'thresholds'")
            __props__.__dict__["thresholds"] = thresholds
            if time_window is None and not opts.urn:
                raise TypeError("Missing required property 'time_window'")
            __props__.__dict__["time_window"] = time_window
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Alert, __self__).__init__(
            'splight:index/alert:Alert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation: Optional[pulumi.Input[str]] = None,
            alert_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertItemArgs', 'AlertAlertItemArgsDict']]]]] = None,
            cron_dom: Optional[pulumi.Input[int]] = None,
            cron_dow: Optional[pulumi.Input[int]] = None,
            cron_hours: Optional[pulumi.Input[int]] = None,
            cron_minutes: Optional[pulumi.Input[int]] = None,
            cron_month: Optional[pulumi.Input[int]] = None,
            cron_year: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            operator: Optional[pulumi.Input[str]] = None,
            rate_unit: Optional[pulumi.Input[str]] = None,
            rate_value: Optional[pulumi.Input[int]] = None,
            related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRelatedAssetArgs', 'AlertRelatedAssetArgsDict']]]]] = None,
            severity: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertTagArgs', 'AlertTagArgsDict']]]]] = None,
            target_variable: Optional[pulumi.Input[str]] = None,
            thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertThresholdArgs', 'AlertThresholdArgsDict']]]]] = None,
            time_window: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Alert':
        """
        Get an existing Alert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aggregation: aggregation to be applied to reads before comparisson
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertAlertItemArgs', 'AlertAlertItemArgsDict']]]] alert_items: traces to be used to compute the results
        :param pulumi.Input[int] cron_dom: schedule value for cron
        :param pulumi.Input[int] cron_dow: schedule value for cron
        :param pulumi.Input[int] cron_hours: schedule value for cron
        :param pulumi.Input[int] cron_minutes: schedule value for cron
        :param pulumi.Input[int] cron_month: schedule value for cron
        :param pulumi.Input[int] cron_year: schedule value for cron
        :param pulumi.Input[str] description: The description of the resource
        :param pulumi.Input[str] name: The name of the resource
        :param pulumi.Input[str] operator: operator to be used to compare the read value with the threshold value
        :param pulumi.Input[str] rate_unit: [day|hour|minute] schedule unit
        :param pulumi.Input[int] rate_value: schedule value
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRelatedAssetArgs', 'AlertRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[str] severity: [sev1,...,sev8] severity for the alert
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertTagArgs', 'AlertTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[str] target_variable: variable to be used to compare with thresholds
        :param pulumi.Input[int] time_window: window to fetch data from. Data out of that window will not be considered for evaluation
        :param pulumi.Input[str] type: [cron|rate] type for the cron
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertState.__new__(_AlertState)

        __props__.__dict__["aggregation"] = aggregation
        __props__.__dict__["alert_items"] = alert_items
        __props__.__dict__["cron_dom"] = cron_dom
        __props__.__dict__["cron_dow"] = cron_dow
        __props__.__dict__["cron_hours"] = cron_hours
        __props__.__dict__["cron_minutes"] = cron_minutes
        __props__.__dict__["cron_month"] = cron_month
        __props__.__dict__["cron_year"] = cron_year
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["operator"] = operator
        __props__.__dict__["rate_unit"] = rate_unit
        __props__.__dict__["rate_value"] = rate_value
        __props__.__dict__["related_assets"] = related_assets
        __props__.__dict__["severity"] = severity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_variable"] = target_variable
        __props__.__dict__["thresholds"] = thresholds
        __props__.__dict__["time_window"] = time_window
        __props__.__dict__["type"] = type
        return Alert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aggregation(self) -> pulumi.Output[str]:
        """
        aggregation to be applied to reads before comparisson
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter(name="alertItems")
    def alert_items(self) -> pulumi.Output[Sequence['outputs.AlertAlertItem']]:
        """
        traces to be used to compute the results
        """
        return pulumi.get(self, "alert_items")

    @property
    @pulumi.getter(name="cronDom")
    def cron_dom(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dom")

    @property
    @pulumi.getter(name="cronDow")
    def cron_dow(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_dow")

    @property
    @pulumi.getter(name="cronHours")
    def cron_hours(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_hours")

    @property
    @pulumi.getter(name="cronMinutes")
    def cron_minutes(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_minutes")

    @property
    @pulumi.getter(name="cronMonth")
    def cron_month(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_month")

    @property
    @pulumi.getter(name="cronYear")
    def cron_year(self) -> pulumi.Output[int]:
        """
        schedule value for cron
        """
        return pulumi.get(self, "cron_year")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Output[str]:
        """
        operator to be used to compare the read value with the threshold value
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="rateUnit")
    def rate_unit(self) -> pulumi.Output[str]:
        """
        [day|hour|minute] schedule unit
        """
        return pulumi.get(self, "rate_unit")

    @property
    @pulumi.getter(name="rateValue")
    def rate_value(self) -> pulumi.Output[int]:
        """
        schedule value
        """
        return pulumi.get(self, "rate_value")

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRelatedAsset']]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[str]:
        """
        [sev1,...,sev8] severity for the alert
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AlertTag']]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetVariable")
    def target_variable(self) -> pulumi.Output[str]:
        """
        variable to be used to compare with thresholds
        """
        return pulumi.get(self, "target_variable")

    @property
    @pulumi.getter
    def thresholds(self) -> pulumi.Output[Sequence['outputs.AlertThreshold']]:
        return pulumi.get(self, "thresholds")

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Output[int]:
        """
        window to fetch data from. Data out of that window will not be considered for evaluation
        """
        return pulumi.get(self, "time_window")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        [cron|rate] type for the cron
        """
        return pulumi.get(self, "type")

