# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComponentRoutineArgs', 'ComponentRoutine']

@pulumi.input_type
class ComponentRoutineArgs:
    def __init__(__self__, *,
                 component_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]] = None):
        """
        The set of arguments for constructing a ComponentRoutine resource.
        :param pulumi.Input[str] component_id: reference to component to be attached
        :param pulumi.Input[str] type: [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional complementary information about the routine
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]] inputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] name: name of the routine
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]] outputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "type", type)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Input[str]:
        """
        reference to component to be attached
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        optional complementary information about the routine
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the routine
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]]):
        pulumi.set(self, "outputs", value)


@pulumi.input_type
class _ComponentRoutineState:
    def __init__(__self__, *,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComponentRoutine resources.
        :param pulumi.Input[str] component_id: reference to component to be attached
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional complementary information about the routine
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]] inputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] name: name of the routine
        :param pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]] outputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] type: [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        reference to component to be attached
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        optional complementary information about the routine
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the routine
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentRoutineOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ComponentRoutine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineConfigArgs', 'ComponentRoutineConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineInputArgs', 'ComponentRoutineInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineOutputArgs', 'ComponentRoutineOutputArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/componentRoutine:ComponentRoutine [options] splight_component_routine.<name> <component_routine_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] component_id: reference to component to be attached
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineConfigArgs', 'ComponentRoutineConfigArgsDict']]]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional complementary information about the routine
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineInputArgs', 'ComponentRoutineInputArgsDict']]]] inputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] name: name of the routine
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineOutputArgs', 'ComponentRoutineOutputArgsDict']]]] outputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] type: [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComponentRoutineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/componentRoutine:ComponentRoutine [options] splight_component_routine.<name> <component_routine_id>
        ```

        :param str resource_name: The name of the resource.
        :param ComponentRoutineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComponentRoutineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineConfigArgs', 'ComponentRoutineConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineInputArgs', 'ComponentRoutineInputArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineOutputArgs', 'ComponentRoutineOutputArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComponentRoutineArgs.__new__(ComponentRoutineArgs)

            if component_id is None and not opts.urn:
                raise TypeError("Missing required property 'component_id'")
            __props__.__dict__["component_id"] = component_id
            __props__.__dict__["configs"] = configs
            __props__.__dict__["description"] = description
            __props__.__dict__["inputs"] = inputs
            __props__.__dict__["name"] = name
            __props__.__dict__["outputs"] = outputs
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(ComponentRoutine, __self__).__init__(
            'splight:index/componentRoutine:ComponentRoutine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            component_id: Optional[pulumi.Input[str]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineConfigArgs', 'ComponentRoutineConfigArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineInputArgs', 'ComponentRoutineInputArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineOutputArgs', 'ComponentRoutineOutputArgsDict']]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ComponentRoutine':
        """
        Get an existing ComponentRoutine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] component_id: reference to component to be attached
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineConfigArgs', 'ComponentRoutineConfigArgsDict']]]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional complementary information about the routine
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineInputArgs', 'ComponentRoutineInputArgsDict']]]] inputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] name: name of the routine
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComponentRoutineOutputArgs', 'ComponentRoutineOutputArgsDict']]]] outputs: asset attribute where to ingest data. Only valid for IncomingRoutine
        :param pulumi.Input[str] type: [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComponentRoutineState.__new__(_ComponentRoutineState)

        __props__.__dict__["component_id"] = component_id
        __props__.__dict__["configs"] = configs
        __props__.__dict__["description"] = description
        __props__.__dict__["inputs"] = inputs
        __props__.__dict__["name"] = name
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["type"] = type
        return ComponentRoutine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Output[str]:
        """
        reference to component to be attached
        """
        return pulumi.get(self, "component_id")

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Optional[Sequence['outputs.ComponentRoutineConfig']]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        optional complementary information about the routine
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def inputs(self) -> pulumi.Output[Optional[Sequence['outputs.ComponentRoutineInput']]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of the routine
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Optional[Sequence['outputs.ComponentRoutineOutput']]]:
        """
        asset attribute where to ingest data. Only valid for IncomingRoutine
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        [IncomingRoutine|OutgoingRoutine] direction of the data flow (from device to system or from system to device)
        """
        return pulumi.get(self, "type")

