# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[str] description: dashboard description
        :param pulumi.Input[str] name: dashboard name
        :param pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]] tags: tags of the resource
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        dashboard description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        dashboard name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[str] description: dashboard description
        :param pulumi.Input[str] name: dashboard name
        :param pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]] tags: tags of the resource
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        dashboard description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        dashboard name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardRelatedAssetArgs', 'DashboardRelatedAssetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTagArgs', 'DashboardTagArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/dashboard:Dashboard [options] splight_dashboard.<name> <dashboard_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: dashboard description
        :param pulumi.Input[str] name: dashboard name
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardRelatedAssetArgs', 'DashboardRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardTagArgs', 'DashboardTagArgsDict']]]] tags: tags of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DashboardArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/dashboard:Dashboard [options] splight_dashboard.<name> <dashboard_id>
        ```

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardRelatedAssetArgs', 'DashboardRelatedAssetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTagArgs', 'DashboardTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["related_assets"] = related_assets
            __props__.__dict__["tags"] = tags
        super(Dashboard, __self__).__init__(
            'splight:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardRelatedAssetArgs', 'DashboardRelatedAssetArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardTagArgs', 'DashboardTagArgsDict']]]]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: dashboard description
        :param pulumi.Input[str] name: dashboard name
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardRelatedAssetArgs', 'DashboardRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardTagArgs', 'DashboardTagArgsDict']]]] tags: tags of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["related_assets"] = related_assets
        __props__.__dict__["tags"] = tags
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        dashboard description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        dashboard name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardRelatedAsset']]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardTag']]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

