# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardGaugeChartArgs', 'DashboardGaugeChart']

@pulumi.input_type
class DashboardGaugeChartArgs:
    def __init__(__self__, *,
                 chart_items: pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]],
                 tab: pulumi.Input[str],
                 timestamp_gte: pulumi.Input[str],
                 timestamp_lte: pulumi.Input[str],
                 collection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_time_range: Optional[pulumi.Input[bool]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 labels_aggregation: Optional[pulumi.Input[str]] = None,
                 labels_display: Optional[pulumi.Input[bool]] = None,
                 labels_placement: Optional[pulumi.Input[str]] = None,
                 max_limit: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None,
                 min_width: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_decimals: Optional[pulumi.Input[int]] = None,
                 position_x: Optional[pulumi.Input[int]] = None,
                 position_y: Optional[pulumi.Input[int]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 relative_window_time: Optional[pulumi.Input[str]] = None,
                 show_beyond_data: Optional[pulumi.Input[bool]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 value_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DashboardGaugeChart resource.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]] chart_items: chart traces to be included
        :param pulumi.Input[str] tab: id for the tab where to place the chart
        :param pulumi.Input[str] timestamp_gte: date in isoformat or shortcut string where to end reading
        :param pulumi.Input[str] timestamp_lte: date in isoformat or shortcut string where to start reading
        :param pulumi.Input[str] description: chart description
        :param pulumi.Input[bool] display_time_range: whether to display the time range or not
        :param pulumi.Input[int] height: chart height in px
        :param pulumi.Input[str] labels_aggregation: [last|avg|...] aggregation
        :param pulumi.Input[bool] labels_display: whether to display the labels or not
        :param pulumi.Input[str] labels_placement: [right|bottom] placement
        :param pulumi.Input[int] max_limit: bar gauge max limit
        :param pulumi.Input[int] min_height: minimum chart height
        :param pulumi.Input[int] min_width: minimum chart width
        :param pulumi.Input[str] name: name of the chart
        :param pulumi.Input[int] number_of_decimals: number of decimals
        :param pulumi.Input[int] position_x: chart x position
        :param pulumi.Input[int] position_y: chart y position
        :param pulumi.Input[str] refresh_interval: refresh interval
        :param pulumi.Input[str] relative_window_time: relative window time
        :param pulumi.Input[bool] show_beyond_data: whether to show data which is beyond timestamp_lte or not
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]] thresholds: optional static lines to be added to the chart as references
        :param pulumi.Input[str] timezone: chart timezone
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]] value_mappings: optional mappings to transform data with rules
        :param pulumi.Input[int] width: chart width in cols (max 20)
        """
        pulumi.set(__self__, "chart_items", chart_items)
        pulumi.set(__self__, "tab", tab)
        pulumi.set(__self__, "timestamp_gte", timestamp_gte)
        pulumi.set(__self__, "timestamp_lte", timestamp_lte)
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_time_range is not None:
            pulumi.set(__self__, "display_time_range", display_time_range)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if labels_aggregation is not None:
            pulumi.set(__self__, "labels_aggregation", labels_aggregation)
        if labels_display is not None:
            pulumi.set(__self__, "labels_display", labels_display)
        if labels_placement is not None:
            pulumi.set(__self__, "labels_placement", labels_placement)
        if max_limit is not None:
            pulumi.set(__self__, "max_limit", max_limit)
        if min_height is not None:
            pulumi.set(__self__, "min_height", min_height)
        if min_width is not None:
            pulumi.set(__self__, "min_width", min_width)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_decimals is not None:
            pulumi.set(__self__, "number_of_decimals", number_of_decimals)
        if position_x is not None:
            pulumi.set(__self__, "position_x", position_x)
        if position_y is not None:
            pulumi.set(__self__, "position_y", position_y)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if relative_window_time is not None:
            pulumi.set(__self__, "relative_window_time", relative_window_time)
        if show_beyond_data is not None:
            pulumi.set(__self__, "show_beyond_data", show_beyond_data)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if value_mappings is not None:
            pulumi.set(__self__, "value_mappings", value_mappings)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="chartItems")
    def chart_items(self) -> pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]]:
        """
        chart traces to be included
        """
        return pulumi.get(self, "chart_items")

    @chart_items.setter
    def chart_items(self, value: pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]]):
        pulumi.set(self, "chart_items", value)

    @property
    @pulumi.getter
    def tab(self) -> pulumi.Input[str]:
        """
        id for the tab where to place the chart
        """
        return pulumi.get(self, "tab")

    @tab.setter
    def tab(self, value: pulumi.Input[str]):
        pulumi.set(self, "tab", value)

    @property
    @pulumi.getter(name="timestampGte")
    def timestamp_gte(self) -> pulumi.Input[str]:
        """
        date in isoformat or shortcut string where to end reading
        """
        return pulumi.get(self, "timestamp_gte")

    @timestamp_gte.setter
    def timestamp_gte(self, value: pulumi.Input[str]):
        pulumi.set(self, "timestamp_gte", value)

    @property
    @pulumi.getter(name="timestampLte")
    def timestamp_lte(self) -> pulumi.Input[str]:
        """
        date in isoformat or shortcut string where to start reading
        """
        return pulumi.get(self, "timestamp_lte")

    @timestamp_lte.setter
    def timestamp_lte(self, value: pulumi.Input[str]):
        pulumi.set(self, "timestamp_lte", value)

    @property
    @pulumi.getter
    def collection(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        chart description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayTimeRange")
    def display_time_range(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to display the time range or not
        """
        return pulumi.get(self, "display_time_range")

    @display_time_range.setter
    def display_time_range(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "display_time_range", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        chart height in px
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="labelsAggregation")
    def labels_aggregation(self) -> Optional[pulumi.Input[str]]:
        """
        [last|avg|...] aggregation
        """
        return pulumi.get(self, "labels_aggregation")

    @labels_aggregation.setter
    def labels_aggregation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels_aggregation", value)

    @property
    @pulumi.getter(name="labelsDisplay")
    def labels_display(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to display the labels or not
        """
        return pulumi.get(self, "labels_display")

    @labels_display.setter
    def labels_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "labels_display", value)

    @property
    @pulumi.getter(name="labelsPlacement")
    def labels_placement(self) -> Optional[pulumi.Input[str]]:
        """
        [right|bottom] placement
        """
        return pulumi.get(self, "labels_placement")

    @labels_placement.setter
    def labels_placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels_placement", value)

    @property
    @pulumi.getter(name="maxLimit")
    def max_limit(self) -> Optional[pulumi.Input[int]]:
        """
        bar gauge max limit
        """
        return pulumi.get(self, "max_limit")

    @max_limit.setter
    def max_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_limit", value)

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> Optional[pulumi.Input[int]]:
        """
        minimum chart height
        """
        return pulumi.get(self, "min_height")

    @min_height.setter
    def min_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_height", value)

    @property
    @pulumi.getter(name="minWidth")
    def min_width(self) -> Optional[pulumi.Input[int]]:
        """
        minimum chart width
        """
        return pulumi.get(self, "min_width")

    @min_width.setter
    def min_width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_width", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the chart
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfDecimals")
    def number_of_decimals(self) -> Optional[pulumi.Input[int]]:
        """
        number of decimals
        """
        return pulumi.get(self, "number_of_decimals")

    @number_of_decimals.setter
    def number_of_decimals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_decimals", value)

    @property
    @pulumi.getter(name="positionX")
    def position_x(self) -> Optional[pulumi.Input[int]]:
        """
        chart x position
        """
        return pulumi.get(self, "position_x")

    @position_x.setter
    def position_x(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position_x", value)

    @property
    @pulumi.getter(name="positionY")
    def position_y(self) -> Optional[pulumi.Input[int]]:
        """
        chart y position
        """
        return pulumi.get(self, "position_y")

    @position_y.setter
    def position_y(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position_y", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[str]]:
        """
        refresh interval
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="relativeWindowTime")
    def relative_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        relative window time
        """
        return pulumi.get(self, "relative_window_time")

    @relative_window_time.setter
    def relative_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_window_time", value)

    @property
    @pulumi.getter(name="showBeyondData")
    def show_beyond_data(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to show data which is beyond timestamp_lte or not
        """
        return pulumi.get(self, "show_beyond_data")

    @show_beyond_data.setter
    def show_beyond_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_beyond_data", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]]:
        """
        optional static lines to be added to the chart as references
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        chart timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="valueMappings")
    def value_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]]:
        """
        optional mappings to transform data with rules
        """
        return pulumi.get(self, "value_mappings")

    @value_mappings.setter
    def value_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]]):
        pulumi.set(self, "value_mappings", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        chart width in cols (max 20)
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class _DashboardGaugeChartState:
    def __init__(__self__, *,
                 chart_items: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]]] = None,
                 collection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_time_range: Optional[pulumi.Input[bool]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 labels_aggregation: Optional[pulumi.Input[str]] = None,
                 labels_display: Optional[pulumi.Input[bool]] = None,
                 labels_placement: Optional[pulumi.Input[str]] = None,
                 max_limit: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None,
                 min_width: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_decimals: Optional[pulumi.Input[int]] = None,
                 position_x: Optional[pulumi.Input[int]] = None,
                 position_y: Optional[pulumi.Input[int]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 relative_window_time: Optional[pulumi.Input[str]] = None,
                 show_beyond_data: Optional[pulumi.Input[bool]] = None,
                 tab: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]] = None,
                 timestamp_gte: Optional[pulumi.Input[str]] = None,
                 timestamp_lte: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 value_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering DashboardGaugeChart resources.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]] chart_items: chart traces to be included
        :param pulumi.Input[str] description: chart description
        :param pulumi.Input[bool] display_time_range: whether to display the time range or not
        :param pulumi.Input[int] height: chart height in px
        :param pulumi.Input[str] labels_aggregation: [last|avg|...] aggregation
        :param pulumi.Input[bool] labels_display: whether to display the labels or not
        :param pulumi.Input[str] labels_placement: [right|bottom] placement
        :param pulumi.Input[int] max_limit: bar gauge max limit
        :param pulumi.Input[int] min_height: minimum chart height
        :param pulumi.Input[int] min_width: minimum chart width
        :param pulumi.Input[str] name: name of the chart
        :param pulumi.Input[int] number_of_decimals: number of decimals
        :param pulumi.Input[int] position_x: chart x position
        :param pulumi.Input[int] position_y: chart y position
        :param pulumi.Input[str] refresh_interval: refresh interval
        :param pulumi.Input[str] relative_window_time: relative window time
        :param pulumi.Input[bool] show_beyond_data: whether to show data which is beyond timestamp_lte or not
        :param pulumi.Input[str] tab: id for the tab where to place the chart
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]] thresholds: optional static lines to be added to the chart as references
        :param pulumi.Input[str] timestamp_gte: date in isoformat or shortcut string where to end reading
        :param pulumi.Input[str] timestamp_lte: date in isoformat or shortcut string where to start reading
        :param pulumi.Input[str] timezone: chart timezone
        :param pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]] value_mappings: optional mappings to transform data with rules
        :param pulumi.Input[int] width: chart width in cols (max 20)
        """
        if chart_items is not None:
            pulumi.set(__self__, "chart_items", chart_items)
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_time_range is not None:
            pulumi.set(__self__, "display_time_range", display_time_range)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if labels_aggregation is not None:
            pulumi.set(__self__, "labels_aggregation", labels_aggregation)
        if labels_display is not None:
            pulumi.set(__self__, "labels_display", labels_display)
        if labels_placement is not None:
            pulumi.set(__self__, "labels_placement", labels_placement)
        if max_limit is not None:
            pulumi.set(__self__, "max_limit", max_limit)
        if min_height is not None:
            pulumi.set(__self__, "min_height", min_height)
        if min_width is not None:
            pulumi.set(__self__, "min_width", min_width)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_decimals is not None:
            pulumi.set(__self__, "number_of_decimals", number_of_decimals)
        if position_x is not None:
            pulumi.set(__self__, "position_x", position_x)
        if position_y is not None:
            pulumi.set(__self__, "position_y", position_y)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if relative_window_time is not None:
            pulumi.set(__self__, "relative_window_time", relative_window_time)
        if show_beyond_data is not None:
            pulumi.set(__self__, "show_beyond_data", show_beyond_data)
        if tab is not None:
            pulumi.set(__self__, "tab", tab)
        if thresholds is not None:
            pulumi.set(__self__, "thresholds", thresholds)
        if timestamp_gte is not None:
            pulumi.set(__self__, "timestamp_gte", timestamp_gte)
        if timestamp_lte is not None:
            pulumi.set(__self__, "timestamp_lte", timestamp_lte)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if value_mappings is not None:
            pulumi.set(__self__, "value_mappings", value_mappings)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="chartItems")
    def chart_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]]]:
        """
        chart traces to be included
        """
        return pulumi.get(self, "chart_items")

    @chart_items.setter
    def chart_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartChartItemArgs']]]]):
        pulumi.set(self, "chart_items", value)

    @property
    @pulumi.getter
    def collection(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        chart description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayTimeRange")
    def display_time_range(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to display the time range or not
        """
        return pulumi.get(self, "display_time_range")

    @display_time_range.setter
    def display_time_range(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "display_time_range", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        chart height in px
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="labelsAggregation")
    def labels_aggregation(self) -> Optional[pulumi.Input[str]]:
        """
        [last|avg|...] aggregation
        """
        return pulumi.get(self, "labels_aggregation")

    @labels_aggregation.setter
    def labels_aggregation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels_aggregation", value)

    @property
    @pulumi.getter(name="labelsDisplay")
    def labels_display(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to display the labels or not
        """
        return pulumi.get(self, "labels_display")

    @labels_display.setter
    def labels_display(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "labels_display", value)

    @property
    @pulumi.getter(name="labelsPlacement")
    def labels_placement(self) -> Optional[pulumi.Input[str]]:
        """
        [right|bottom] placement
        """
        return pulumi.get(self, "labels_placement")

    @labels_placement.setter
    def labels_placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels_placement", value)

    @property
    @pulumi.getter(name="maxLimit")
    def max_limit(self) -> Optional[pulumi.Input[int]]:
        """
        bar gauge max limit
        """
        return pulumi.get(self, "max_limit")

    @max_limit.setter
    def max_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_limit", value)

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> Optional[pulumi.Input[int]]:
        """
        minimum chart height
        """
        return pulumi.get(self, "min_height")

    @min_height.setter
    def min_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_height", value)

    @property
    @pulumi.getter(name="minWidth")
    def min_width(self) -> Optional[pulumi.Input[int]]:
        """
        minimum chart width
        """
        return pulumi.get(self, "min_width")

    @min_width.setter
    def min_width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_width", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the chart
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfDecimals")
    def number_of_decimals(self) -> Optional[pulumi.Input[int]]:
        """
        number of decimals
        """
        return pulumi.get(self, "number_of_decimals")

    @number_of_decimals.setter
    def number_of_decimals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_decimals", value)

    @property
    @pulumi.getter(name="positionX")
    def position_x(self) -> Optional[pulumi.Input[int]]:
        """
        chart x position
        """
        return pulumi.get(self, "position_x")

    @position_x.setter
    def position_x(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position_x", value)

    @property
    @pulumi.getter(name="positionY")
    def position_y(self) -> Optional[pulumi.Input[int]]:
        """
        chart y position
        """
        return pulumi.get(self, "position_y")

    @position_y.setter
    def position_y(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position_y", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[str]]:
        """
        refresh interval
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter(name="relativeWindowTime")
    def relative_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        relative window time
        """
        return pulumi.get(self, "relative_window_time")

    @relative_window_time.setter
    def relative_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_window_time", value)

    @property
    @pulumi.getter(name="showBeyondData")
    def show_beyond_data(self) -> Optional[pulumi.Input[bool]]:
        """
        whether to show data which is beyond timestamp_lte or not
        """
        return pulumi.get(self, "show_beyond_data")

    @show_beyond_data.setter
    def show_beyond_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_beyond_data", value)

    @property
    @pulumi.getter
    def tab(self) -> Optional[pulumi.Input[str]]:
        """
        id for the tab where to place the chart
        """
        return pulumi.get(self, "tab")

    @tab.setter
    def tab(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tab", value)

    @property
    @pulumi.getter
    def thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]]:
        """
        optional static lines to be added to the chart as references
        """
        return pulumi.get(self, "thresholds")

    @thresholds.setter
    def thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartThresholdArgs']]]]):
        pulumi.set(self, "thresholds", value)

    @property
    @pulumi.getter(name="timestampGte")
    def timestamp_gte(self) -> Optional[pulumi.Input[str]]:
        """
        date in isoformat or shortcut string where to end reading
        """
        return pulumi.get(self, "timestamp_gte")

    @timestamp_gte.setter
    def timestamp_gte(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_gte", value)

    @property
    @pulumi.getter(name="timestampLte")
    def timestamp_lte(self) -> Optional[pulumi.Input[str]]:
        """
        date in isoformat or shortcut string where to start reading
        """
        return pulumi.get(self, "timestamp_lte")

    @timestamp_lte.setter
    def timestamp_lte(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_lte", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        chart timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="valueMappings")
    def value_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]]:
        """
        optional mappings to transform data with rules
        """
        return pulumi.get(self, "value_mappings")

    @value_mappings.setter
    def value_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardGaugeChartValueMappingArgs']]]]):
        pulumi.set(self, "value_mappings", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        chart width in cols (max 20)
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


class DashboardGaugeChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartChartItemArgs', 'DashboardGaugeChartChartItemArgsDict']]]]] = None,
                 collection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_time_range: Optional[pulumi.Input[bool]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 labels_aggregation: Optional[pulumi.Input[str]] = None,
                 labels_display: Optional[pulumi.Input[bool]] = None,
                 labels_placement: Optional[pulumi.Input[str]] = None,
                 max_limit: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None,
                 min_width: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_decimals: Optional[pulumi.Input[int]] = None,
                 position_x: Optional[pulumi.Input[int]] = None,
                 position_y: Optional[pulumi.Input[int]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 relative_window_time: Optional[pulumi.Input[str]] = None,
                 show_beyond_data: Optional[pulumi.Input[bool]] = None,
                 tab: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartThresholdArgs', 'DashboardGaugeChartThresholdArgsDict']]]]] = None,
                 timestamp_gte: Optional[pulumi.Input[str]] = None,
                 timestamp_lte: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 value_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartValueMappingArgs', 'DashboardGaugeChartValueMappingArgsDict']]]]] = None,
                 width: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_splight as splight

        asset_test = splight.Asset("assetTest",
            description="Created with Terraform",
            geometry=json.dumps({
                "type": "GeometryCollection",
                "geometries": [],
            }))
        attribute_test1 = splight.AssetAttribute("attributeTest1",
            type="Number",
            unit="meters",
            asset=asset_test.id)
        attribute_test2 = splight.AssetAttribute("attributeTest2",
            type="Number",
            unit="seconds",
            asset=asset_test.id)
        dashboard_test = splight.Dashboard("dashboardTest", related_assets=[])
        dashboard_tab_test = splight.DashboardTab("dashboardTabTest",
            order=0,
            dashboard=dashboard_test.id)
        dashboard_chart_test = splight.DashboardGaugeChart("dashboardChartTest",
            tab=dashboard_tab_test.id,
            timestamp_gte="now - 7d",
            timestamp_lte="now",
            description="Chart description",
            min_height=1,
            min_width=4,
            display_time_range=True,
            labels_display=True,
            labels_aggregation="last",
            labels_placement="bottom",
            show_beyond_data=True,
            height=10,
            width=20,
            collection="default",
            max_limit=100,
            number_of_decimals=2,
            chart_items=[
                {
                    "ref_id": "A",
                    "type": "QUERY",
                    "color": "red",
                    "expression_plain": "",
                    "query_filter_asset": {
                        "id": asset_test.id,
                        "name": asset_test.name,
                    },
                    "query_filter_attribute": {
                        "id": attribute_test1.id,
                        "name": attribute_test1.name,
                    },
                    "query_plain": pulumi.Output.json_dumps([
                        {
                            "_match": {
                                "asset": asset_test.id,
                                "attribute": attribute_test1.id,
                            },
                        },
                        {
                            "$addFields": {
                                "timestamp": {
                                    "$dateTrunc": {
                                        "date": "$timestamp",
                                        "unit": "day",
                                        "binSize": 1,
                                    },
                                },
                            },
                        },
                        {
                            "$group": {
                                "_id": "$timestamp",
                                "value": {
                                    "$last": "$value",
                                },
                                "timestamp": {
                                    "$last": "$timestamp",
                                },
                            },
                        },
                    ]),
                },
                {
                    "ref_id": "B",
                    "color": "blue",
                    "type": "QUERY",
                    "expression_plain": "",
                    "query_filter_asset": {
                        "id": asset_test.id,
                        "name": asset_test.name,
                    },
                    "query_filter_attribute": {
                        "id": attribute_test2.id,
                        "name": attribute_test2.name,
                    },
                    "query_plain": pulumi.Output.json_dumps([
                        {
                            "_match": {
                                "asset": asset_test.id,
                                "attribute": attribute_test2.id,
                            },
                        },
                        {
                            "$addFields": {
                                "timestamp": {
                                    "$dateTrunc": {
                                        "date": "$timestamp",
                                        "unit": "hour",
                                        "binSize": 1,
                                    },
                                },
                            },
                        },
                        {
                            "$group": {
                                "_id": "$timestamp",
                                "value": {
                                    "$last": "$value",
                                },
                                "timestamp": {
                                    "$last": "$timestamp",
                                },
                            },
                        },
                    ]),
                },
            ],
            thresholds=[{
                "color": "#00edcf",
                "display_text": "T1Test",
                "value": 13.1,
            }],
            value_mappings=[{
                "display_text": "MODIFICADO",
                "match_value": "123.3",
                "type": "exact_match",
                "order": 0,
            }])
        ```

        ## Import

        ```sh
        $ pulumi import splight:index/dashboardGaugeChart:DashboardGaugeChart [options] splight_dashboard_gauge_chart.<name> <dashboard_chart_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartChartItemArgs', 'DashboardGaugeChartChartItemArgsDict']]]] chart_items: chart traces to be included
        :param pulumi.Input[str] description: chart description
        :param pulumi.Input[bool] display_time_range: whether to display the time range or not
        :param pulumi.Input[int] height: chart height in px
        :param pulumi.Input[str] labels_aggregation: [last|avg|...] aggregation
        :param pulumi.Input[bool] labels_display: whether to display the labels or not
        :param pulumi.Input[str] labels_placement: [right|bottom] placement
        :param pulumi.Input[int] max_limit: bar gauge max limit
        :param pulumi.Input[int] min_height: minimum chart height
        :param pulumi.Input[int] min_width: minimum chart width
        :param pulumi.Input[str] name: name of the chart
        :param pulumi.Input[int] number_of_decimals: number of decimals
        :param pulumi.Input[int] position_x: chart x position
        :param pulumi.Input[int] position_y: chart y position
        :param pulumi.Input[str] refresh_interval: refresh interval
        :param pulumi.Input[str] relative_window_time: relative window time
        :param pulumi.Input[bool] show_beyond_data: whether to show data which is beyond timestamp_lte or not
        :param pulumi.Input[str] tab: id for the tab where to place the chart
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartThresholdArgs', 'DashboardGaugeChartThresholdArgsDict']]]] thresholds: optional static lines to be added to the chart as references
        :param pulumi.Input[str] timestamp_gte: date in isoformat or shortcut string where to end reading
        :param pulumi.Input[str] timestamp_lte: date in isoformat or shortcut string where to start reading
        :param pulumi.Input[str] timezone: chart timezone
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartValueMappingArgs', 'DashboardGaugeChartValueMappingArgsDict']]]] value_mappings: optional mappings to transform data with rules
        :param pulumi.Input[int] width: chart width in cols (max 20)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardGaugeChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_splight as splight

        asset_test = splight.Asset("assetTest",
            description="Created with Terraform",
            geometry=json.dumps({
                "type": "GeometryCollection",
                "geometries": [],
            }))
        attribute_test1 = splight.AssetAttribute("attributeTest1",
            type="Number",
            unit="meters",
            asset=asset_test.id)
        attribute_test2 = splight.AssetAttribute("attributeTest2",
            type="Number",
            unit="seconds",
            asset=asset_test.id)
        dashboard_test = splight.Dashboard("dashboardTest", related_assets=[])
        dashboard_tab_test = splight.DashboardTab("dashboardTabTest",
            order=0,
            dashboard=dashboard_test.id)
        dashboard_chart_test = splight.DashboardGaugeChart("dashboardChartTest",
            tab=dashboard_tab_test.id,
            timestamp_gte="now - 7d",
            timestamp_lte="now",
            description="Chart description",
            min_height=1,
            min_width=4,
            display_time_range=True,
            labels_display=True,
            labels_aggregation="last",
            labels_placement="bottom",
            show_beyond_data=True,
            height=10,
            width=20,
            collection="default",
            max_limit=100,
            number_of_decimals=2,
            chart_items=[
                {
                    "ref_id": "A",
                    "type": "QUERY",
                    "color": "red",
                    "expression_plain": "",
                    "query_filter_asset": {
                        "id": asset_test.id,
                        "name": asset_test.name,
                    },
                    "query_filter_attribute": {
                        "id": attribute_test1.id,
                        "name": attribute_test1.name,
                    },
                    "query_plain": pulumi.Output.json_dumps([
                        {
                            "_match": {
                                "asset": asset_test.id,
                                "attribute": attribute_test1.id,
                            },
                        },
                        {
                            "$addFields": {
                                "timestamp": {
                                    "$dateTrunc": {
                                        "date": "$timestamp",
                                        "unit": "day",
                                        "binSize": 1,
                                    },
                                },
                            },
                        },
                        {
                            "$group": {
                                "_id": "$timestamp",
                                "value": {
                                    "$last": "$value",
                                },
                                "timestamp": {
                                    "$last": "$timestamp",
                                },
                            },
                        },
                    ]),
                },
                {
                    "ref_id": "B",
                    "color": "blue",
                    "type": "QUERY",
                    "expression_plain": "",
                    "query_filter_asset": {
                        "id": asset_test.id,
                        "name": asset_test.name,
                    },
                    "query_filter_attribute": {
                        "id": attribute_test2.id,
                        "name": attribute_test2.name,
                    },
                    "query_plain": pulumi.Output.json_dumps([
                        {
                            "_match": {
                                "asset": asset_test.id,
                                "attribute": attribute_test2.id,
                            },
                        },
                        {
                            "$addFields": {
                                "timestamp": {
                                    "$dateTrunc": {
                                        "date": "$timestamp",
                                        "unit": "hour",
                                        "binSize": 1,
                                    },
                                },
                            },
                        },
                        {
                            "$group": {
                                "_id": "$timestamp",
                                "value": {
                                    "$last": "$value",
                                },
                                "timestamp": {
                                    "$last": "$timestamp",
                                },
                            },
                        },
                    ]),
                },
            ],
            thresholds=[{
                "color": "#00edcf",
                "display_text": "T1Test",
                "value": 13.1,
            }],
            value_mappings=[{
                "display_text": "MODIFICADO",
                "match_value": "123.3",
                "type": "exact_match",
                "order": 0,
            }])
        ```

        ## Import

        ```sh
        $ pulumi import splight:index/dashboardGaugeChart:DashboardGaugeChart [options] splight_dashboard_gauge_chart.<name> <dashboard_chart_id>
        ```

        :param str resource_name: The name of the resource.
        :param DashboardGaugeChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardGaugeChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartChartItemArgs', 'DashboardGaugeChartChartItemArgsDict']]]]] = None,
                 collection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_time_range: Optional[pulumi.Input[bool]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 labels_aggregation: Optional[pulumi.Input[str]] = None,
                 labels_display: Optional[pulumi.Input[bool]] = None,
                 labels_placement: Optional[pulumi.Input[str]] = None,
                 max_limit: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None,
                 min_width: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_decimals: Optional[pulumi.Input[int]] = None,
                 position_x: Optional[pulumi.Input[int]] = None,
                 position_y: Optional[pulumi.Input[int]] = None,
                 refresh_interval: Optional[pulumi.Input[str]] = None,
                 relative_window_time: Optional[pulumi.Input[str]] = None,
                 show_beyond_data: Optional[pulumi.Input[bool]] = None,
                 tab: Optional[pulumi.Input[str]] = None,
                 thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartThresholdArgs', 'DashboardGaugeChartThresholdArgsDict']]]]] = None,
                 timestamp_gte: Optional[pulumi.Input[str]] = None,
                 timestamp_lte: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 value_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartValueMappingArgs', 'DashboardGaugeChartValueMappingArgsDict']]]]] = None,
                 width: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardGaugeChartArgs.__new__(DashboardGaugeChartArgs)

            if chart_items is None and not opts.urn:
                raise TypeError("Missing required property 'chart_items'")
            __props__.__dict__["chart_items"] = chart_items
            __props__.__dict__["collection"] = collection
            __props__.__dict__["description"] = description
            __props__.__dict__["display_time_range"] = display_time_range
            __props__.__dict__["height"] = height
            __props__.__dict__["labels_aggregation"] = labels_aggregation
            __props__.__dict__["labels_display"] = labels_display
            __props__.__dict__["labels_placement"] = labels_placement
            __props__.__dict__["max_limit"] = max_limit
            __props__.__dict__["min_height"] = min_height
            __props__.__dict__["min_width"] = min_width
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_decimals"] = number_of_decimals
            __props__.__dict__["position_x"] = position_x
            __props__.__dict__["position_y"] = position_y
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["relative_window_time"] = relative_window_time
            __props__.__dict__["show_beyond_data"] = show_beyond_data
            if tab is None and not opts.urn:
                raise TypeError("Missing required property 'tab'")
            __props__.__dict__["tab"] = tab
            __props__.__dict__["thresholds"] = thresholds
            if timestamp_gte is None and not opts.urn:
                raise TypeError("Missing required property 'timestamp_gte'")
            __props__.__dict__["timestamp_gte"] = timestamp_gte
            if timestamp_lte is None and not opts.urn:
                raise TypeError("Missing required property 'timestamp_lte'")
            __props__.__dict__["timestamp_lte"] = timestamp_lte
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["value_mappings"] = value_mappings
            __props__.__dict__["width"] = width
        super(DashboardGaugeChart, __self__).__init__(
            'splight:index/dashboardGaugeChart:DashboardGaugeChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartChartItemArgs', 'DashboardGaugeChartChartItemArgsDict']]]]] = None,
            collection: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_time_range: Optional[pulumi.Input[bool]] = None,
            height: Optional[pulumi.Input[int]] = None,
            labels_aggregation: Optional[pulumi.Input[str]] = None,
            labels_display: Optional[pulumi.Input[bool]] = None,
            labels_placement: Optional[pulumi.Input[str]] = None,
            max_limit: Optional[pulumi.Input[int]] = None,
            min_height: Optional[pulumi.Input[int]] = None,
            min_width: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_decimals: Optional[pulumi.Input[int]] = None,
            position_x: Optional[pulumi.Input[int]] = None,
            position_y: Optional[pulumi.Input[int]] = None,
            refresh_interval: Optional[pulumi.Input[str]] = None,
            relative_window_time: Optional[pulumi.Input[str]] = None,
            show_beyond_data: Optional[pulumi.Input[bool]] = None,
            tab: Optional[pulumi.Input[str]] = None,
            thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartThresholdArgs', 'DashboardGaugeChartThresholdArgsDict']]]]] = None,
            timestamp_gte: Optional[pulumi.Input[str]] = None,
            timestamp_lte: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            value_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartValueMappingArgs', 'DashboardGaugeChartValueMappingArgsDict']]]]] = None,
            width: Optional[pulumi.Input[int]] = None) -> 'DashboardGaugeChart':
        """
        Get an existing DashboardGaugeChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartChartItemArgs', 'DashboardGaugeChartChartItemArgsDict']]]] chart_items: chart traces to be included
        :param pulumi.Input[str] description: chart description
        :param pulumi.Input[bool] display_time_range: whether to display the time range or not
        :param pulumi.Input[int] height: chart height in px
        :param pulumi.Input[str] labels_aggregation: [last|avg|...] aggregation
        :param pulumi.Input[bool] labels_display: whether to display the labels or not
        :param pulumi.Input[str] labels_placement: [right|bottom] placement
        :param pulumi.Input[int] max_limit: bar gauge max limit
        :param pulumi.Input[int] min_height: minimum chart height
        :param pulumi.Input[int] min_width: minimum chart width
        :param pulumi.Input[str] name: name of the chart
        :param pulumi.Input[int] number_of_decimals: number of decimals
        :param pulumi.Input[int] position_x: chart x position
        :param pulumi.Input[int] position_y: chart y position
        :param pulumi.Input[str] refresh_interval: refresh interval
        :param pulumi.Input[str] relative_window_time: relative window time
        :param pulumi.Input[bool] show_beyond_data: whether to show data which is beyond timestamp_lte or not
        :param pulumi.Input[str] tab: id for the tab where to place the chart
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartThresholdArgs', 'DashboardGaugeChartThresholdArgsDict']]]] thresholds: optional static lines to be added to the chart as references
        :param pulumi.Input[str] timestamp_gte: date in isoformat or shortcut string where to end reading
        :param pulumi.Input[str] timestamp_lte: date in isoformat or shortcut string where to start reading
        :param pulumi.Input[str] timezone: chart timezone
        :param pulumi.Input[Sequence[pulumi.Input[Union['DashboardGaugeChartValueMappingArgs', 'DashboardGaugeChartValueMappingArgsDict']]]] value_mappings: optional mappings to transform data with rules
        :param pulumi.Input[int] width: chart width in cols (max 20)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardGaugeChartState.__new__(_DashboardGaugeChartState)

        __props__.__dict__["chart_items"] = chart_items
        __props__.__dict__["collection"] = collection
        __props__.__dict__["description"] = description
        __props__.__dict__["display_time_range"] = display_time_range
        __props__.__dict__["height"] = height
        __props__.__dict__["labels_aggregation"] = labels_aggregation
        __props__.__dict__["labels_display"] = labels_display
        __props__.__dict__["labels_placement"] = labels_placement
        __props__.__dict__["max_limit"] = max_limit
        __props__.__dict__["min_height"] = min_height
        __props__.__dict__["min_width"] = min_width
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_decimals"] = number_of_decimals
        __props__.__dict__["position_x"] = position_x
        __props__.__dict__["position_y"] = position_y
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["relative_window_time"] = relative_window_time
        __props__.__dict__["show_beyond_data"] = show_beyond_data
        __props__.__dict__["tab"] = tab
        __props__.__dict__["thresholds"] = thresholds
        __props__.__dict__["timestamp_gte"] = timestamp_gte
        __props__.__dict__["timestamp_lte"] = timestamp_lte
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["value_mappings"] = value_mappings
        __props__.__dict__["width"] = width
        return DashboardGaugeChart(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chartItems")
    def chart_items(self) -> pulumi.Output[Sequence['outputs.DashboardGaugeChartChartItem']]:
        """
        chart traces to be included
        """
        return pulumi.get(self, "chart_items")

    @property
    @pulumi.getter
    def collection(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "collection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        chart description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayTimeRange")
    def display_time_range(self) -> pulumi.Output[Optional[bool]]:
        """
        whether to display the time range or not
        """
        return pulumi.get(self, "display_time_range")

    @property
    @pulumi.getter
    def height(self) -> pulumi.Output[Optional[int]]:
        """
        chart height in px
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter(name="labelsAggregation")
    def labels_aggregation(self) -> pulumi.Output[Optional[str]]:
        """
        [last|avg|...] aggregation
        """
        return pulumi.get(self, "labels_aggregation")

    @property
    @pulumi.getter(name="labelsDisplay")
    def labels_display(self) -> pulumi.Output[Optional[bool]]:
        """
        whether to display the labels or not
        """
        return pulumi.get(self, "labels_display")

    @property
    @pulumi.getter(name="labelsPlacement")
    def labels_placement(self) -> pulumi.Output[Optional[str]]:
        """
        [right|bottom] placement
        """
        return pulumi.get(self, "labels_placement")

    @property
    @pulumi.getter(name="maxLimit")
    def max_limit(self) -> pulumi.Output[Optional[int]]:
        """
        bar gauge max limit
        """
        return pulumi.get(self, "max_limit")

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> pulumi.Output[Optional[int]]:
        """
        minimum chart height
        """
        return pulumi.get(self, "min_height")

    @property
    @pulumi.getter(name="minWidth")
    def min_width(self) -> pulumi.Output[Optional[int]]:
        """
        minimum chart width
        """
        return pulumi.get(self, "min_width")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of the chart
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfDecimals")
    def number_of_decimals(self) -> pulumi.Output[Optional[int]]:
        """
        number of decimals
        """
        return pulumi.get(self, "number_of_decimals")

    @property
    @pulumi.getter(name="positionX")
    def position_x(self) -> pulumi.Output[Optional[int]]:
        """
        chart x position
        """
        return pulumi.get(self, "position_x")

    @property
    @pulumi.getter(name="positionY")
    def position_y(self) -> pulumi.Output[Optional[int]]:
        """
        chart y position
        """
        return pulumi.get(self, "position_y")

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[str]]:
        """
        refresh interval
        """
        return pulumi.get(self, "refresh_interval")

    @property
    @pulumi.getter(name="relativeWindowTime")
    def relative_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        relative window time
        """
        return pulumi.get(self, "relative_window_time")

    @property
    @pulumi.getter(name="showBeyondData")
    def show_beyond_data(self) -> pulumi.Output[Optional[bool]]:
        """
        whether to show data which is beyond timestamp_lte or not
        """
        return pulumi.get(self, "show_beyond_data")

    @property
    @pulumi.getter
    def tab(self) -> pulumi.Output[str]:
        """
        id for the tab where to place the chart
        """
        return pulumi.get(self, "tab")

    @property
    @pulumi.getter
    def thresholds(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardGaugeChartThreshold']]]:
        """
        optional static lines to be added to the chart as references
        """
        return pulumi.get(self, "thresholds")

    @property
    @pulumi.getter(name="timestampGte")
    def timestamp_gte(self) -> pulumi.Output[str]:
        """
        date in isoformat or shortcut string where to end reading
        """
        return pulumi.get(self, "timestamp_gte")

    @property
    @pulumi.getter(name="timestampLte")
    def timestamp_lte(self) -> pulumi.Output[str]:
        """
        date in isoformat or shortcut string where to start reading
        """
        return pulumi.get(self, "timestamp_lte")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        chart timezone
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="valueMappings")
    def value_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardGaugeChartValueMapping']]]:
        """
        optional mappings to transform data with rules
        """
        return pulumi.get(self, "value_mappings")

    @property
    @pulumi.getter
    def width(self) -> pulumi.Output[Optional[int]]:
        """
        chart width in cols (max 20)
        """
        return pulumi.get(self, "width")

