# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileArgs', 'File']

@pulumi.input_type
class FileArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]] = None):
        """
        The set of arguments for constructing a File resource.
        :param pulumi.Input[str] path: the path for the file resource in your system
        :param pulumi.Input[str] description: complementary information to describe the file
        :param pulumi.Input[str] parent: the id reference for a folder to be placed in
        :param pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]] tags: tags of the resource
        """
        pulumi.set(__self__, "path", path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        the path for the file resource in your system
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        complementary information to describe the file
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        the id reference for a folder to be placed in
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileState:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]] = None,
                 uploaded: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering File resources.
        :param pulumi.Input[str] description: complementary information to describe the file
        :param pulumi.Input[str] parent: the id reference for a folder to be placed in
        :param pulumi.Input[str] path: the path for the file resource in your system
        :param pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]] tags: tags of the resource
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if related_assets is not None:
            pulumi.set(__self__, "related_assets", related_assets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uploaded is not None:
            pulumi.set(__self__, "uploaded", uploaded)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        complementary information to describe the file
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        the id reference for a folder to be placed in
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        the path for the file resource in your system
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @related_assets.setter
    def related_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileRelatedAssetArgs']]]]):
        pulumi.set(self, "related_assets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def uploaded(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "uploaded")

    @uploaded.setter
    def uploaded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "uploaded", value)


class File(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileRelatedAssetArgs', 'FileRelatedAssetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileTagArgs', 'FileTagArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/file:File [options] splight_file.<name> <file_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: complementary information to describe the file
        :param pulumi.Input[str] parent: the id reference for a folder to be placed in
        :param pulumi.Input[str] path: the path for the file resource in your system
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileRelatedAssetArgs', 'FileRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileTagArgs', 'FileTagArgsDict']]]] tags: tags of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/file:File [options] splight_file.<name> <file_id>
        ```

        :param str resource_name: The name of the resource.
        :param FileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileRelatedAssetArgs', 'FileRelatedAssetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileTagArgs', 'FileTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileArgs.__new__(FileArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["parent"] = parent
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["related_assets"] = related_assets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["checksum"] = None
            __props__.__dict__["uploaded"] = None
        super(File, __self__).__init__(
            'splight:index/file:File',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checksum: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            related_assets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileRelatedAssetArgs', 'FileRelatedAssetArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileTagArgs', 'FileTagArgsDict']]]]] = None,
            uploaded: Optional[pulumi.Input[bool]] = None) -> 'File':
        """
        Get an existing File resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: complementary information to describe the file
        :param pulumi.Input[str] parent: the id reference for a folder to be placed in
        :param pulumi.Input[str] path: the path for the file resource in your system
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileRelatedAssetArgs', 'FileRelatedAssetArgsDict']]]] related_assets: related assets of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileTagArgs', 'FileTagArgsDict']]]] tags: tags of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileState.__new__(_FileState)

        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["description"] = description
        __props__.__dict__["parent"] = parent
        __props__.__dict__["path"] = path
        __props__.__dict__["related_assets"] = related_assets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["uploaded"] = uploaded
        return File(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[str]:
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        complementary information to describe the file
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[str]]:
        """
        the id reference for a folder to be placed in
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        the path for the file resource in your system
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="relatedAssets")
    def related_assets(self) -> pulumi.Output[Optional[Sequence['outputs.FileRelatedAsset']]]:
        """
        related assets of the resource
        """
        return pulumi.get(self, "related_assets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.FileTag']]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def uploaded(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "uploaded")

