# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LineArgs', 'Line']

@pulumi.input_type
class LineArgs:
    def __init__(__self__, *,
                 absorptivity: pulumi.Input['LineAbsorptivityArgs'],
                 atmosphere: pulumi.Input['LineAtmosphereArgs'],
                 capacitance: pulumi.Input['LineCapacitanceArgs'],
                 conductance: pulumi.Input['LineConductanceArgs'],
                 diameter: pulumi.Input['LineDiameterArgs'],
                 emissivity: pulumi.Input['LineEmissivityArgs'],
                 length: pulumi.Input['LineLengthArgs'],
                 maximum_allowed_current: pulumi.Input['LineMaximumAllowedCurrentArgs'],
                 maximum_allowed_power: pulumi.Input['LineMaximumAllowedPowerArgs'],
                 maximum_allowed_temperature: pulumi.Input['LineMaximumAllowedTemperatureArgs'],
                 maximum_allowed_temperature_lte: pulumi.Input['LineMaximumAllowedTemperatureLteArgs'],
                 maximum_allowed_temperature_ste: pulumi.Input['LineMaximumAllowedTemperatureSteArgs'],
                 number_of_conductors: pulumi.Input['LineNumberOfConductorsArgs'],
                 reactance: pulumi.Input['LineReactanceArgs'],
                 reference_resistance: pulumi.Input['LineReferenceResistanceArgs'],
                 resistance: pulumi.Input['LineResistanceArgs'],
                 safety_margin_for_power: pulumi.Input['LineSafetyMarginForPowerArgs'],
                 susceptance: pulumi.Input['LineSusceptanceArgs'],
                 temperature_coeff_resistance: pulumi.Input['LineTemperatureCoeffResistanceArgs'],
                 custom_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 geometry: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]] = None):
        """
        The set of arguments for constructing a Line resource.
        :param pulumi.Input['LineAbsorptivityArgs'] absorptivity: attribute of the resource
        :param pulumi.Input['LineAtmosphereArgs'] atmosphere: attribute of the resource
        :param pulumi.Input['LineCapacitanceArgs'] capacitance: attribute of the resource
        :param pulumi.Input['LineConductanceArgs'] conductance: attribute of the resource
        :param pulumi.Input['LineDiameterArgs'] diameter: attribute of the resource
        :param pulumi.Input['LineEmissivityArgs'] emissivity: attribute of the resource
        :param pulumi.Input['LineLengthArgs'] length: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedCurrentArgs'] maximum_allowed_current: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedPowerArgs'] maximum_allowed_power: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureArgs'] maximum_allowed_temperature: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureLteArgs'] maximum_allowed_temperature_lte: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureSteArgs'] maximum_allowed_temperature_ste: attribute of the resource
        :param pulumi.Input['LineNumberOfConductorsArgs'] number_of_conductors: attribute of the resource
        :param pulumi.Input['LineReactanceArgs'] reactance: attribute of the resource
        :param pulumi.Input['LineReferenceResistanceArgs'] reference_resistance: attribute of the resource
        :param pulumi.Input['LineResistanceArgs'] resistance: attribute of the resource
        :param pulumi.Input['LineSafetyMarginForPowerArgs'] safety_margin_for_power: attribute of the resource
        :param pulumi.Input['LineSusceptanceArgs'] susceptance: attribute of the resource
        :param pulumi.Input['LineTemperatureCoeffResistanceArgs'] temperature_coeff_resistance: attribute of the resource
        :param pulumi.Input[str] custom_timezone: timezone that overrides location-based timezone of the resource
        :param pulumi.Input[str] description: description of the resource
        :param pulumi.Input[str] geometry: geo position and shape of the resource
        :param pulumi.Input[str] name: name of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]] tags: tags of the resource
        """
        pulumi.set(__self__, "absorptivity", absorptivity)
        pulumi.set(__self__, "atmosphere", atmosphere)
        pulumi.set(__self__, "capacitance", capacitance)
        pulumi.set(__self__, "conductance", conductance)
        pulumi.set(__self__, "diameter", diameter)
        pulumi.set(__self__, "emissivity", emissivity)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "maximum_allowed_current", maximum_allowed_current)
        pulumi.set(__self__, "maximum_allowed_power", maximum_allowed_power)
        pulumi.set(__self__, "maximum_allowed_temperature", maximum_allowed_temperature)
        pulumi.set(__self__, "maximum_allowed_temperature_lte", maximum_allowed_temperature_lte)
        pulumi.set(__self__, "maximum_allowed_temperature_ste", maximum_allowed_temperature_ste)
        pulumi.set(__self__, "number_of_conductors", number_of_conductors)
        pulumi.set(__self__, "reactance", reactance)
        pulumi.set(__self__, "reference_resistance", reference_resistance)
        pulumi.set(__self__, "resistance", resistance)
        pulumi.set(__self__, "safety_margin_for_power", safety_margin_for_power)
        pulumi.set(__self__, "susceptance", susceptance)
        pulumi.set(__self__, "temperature_coeff_resistance", temperature_coeff_resistance)
        if custom_timezone is not None:
            pulumi.set(__self__, "custom_timezone", custom_timezone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if geometry is not None:
            pulumi.set(__self__, "geometry", geometry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def absorptivity(self) -> pulumi.Input['LineAbsorptivityArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "absorptivity")

    @absorptivity.setter
    def absorptivity(self, value: pulumi.Input['LineAbsorptivityArgs']):
        pulumi.set(self, "absorptivity", value)

    @property
    @pulumi.getter
    def atmosphere(self) -> pulumi.Input['LineAtmosphereArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "atmosphere")

    @atmosphere.setter
    def atmosphere(self, value: pulumi.Input['LineAtmosphereArgs']):
        pulumi.set(self, "atmosphere", value)

    @property
    @pulumi.getter
    def capacitance(self) -> pulumi.Input['LineCapacitanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "capacitance")

    @capacitance.setter
    def capacitance(self, value: pulumi.Input['LineCapacitanceArgs']):
        pulumi.set(self, "capacitance", value)

    @property
    @pulumi.getter
    def conductance(self) -> pulumi.Input['LineConductanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "conductance")

    @conductance.setter
    def conductance(self, value: pulumi.Input['LineConductanceArgs']):
        pulumi.set(self, "conductance", value)

    @property
    @pulumi.getter
    def diameter(self) -> pulumi.Input['LineDiameterArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "diameter")

    @diameter.setter
    def diameter(self, value: pulumi.Input['LineDiameterArgs']):
        pulumi.set(self, "diameter", value)

    @property
    @pulumi.getter
    def emissivity(self) -> pulumi.Input['LineEmissivityArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "emissivity")

    @emissivity.setter
    def emissivity(self, value: pulumi.Input['LineEmissivityArgs']):
        pulumi.set(self, "emissivity", value)

    @property
    @pulumi.getter
    def length(self) -> pulumi.Input['LineLengthArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input['LineLengthArgs']):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter(name="maximumAllowedCurrent")
    def maximum_allowed_current(self) -> pulumi.Input['LineMaximumAllowedCurrentArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_current")

    @maximum_allowed_current.setter
    def maximum_allowed_current(self, value: pulumi.Input['LineMaximumAllowedCurrentArgs']):
        pulumi.set(self, "maximum_allowed_current", value)

    @property
    @pulumi.getter(name="maximumAllowedPower")
    def maximum_allowed_power(self) -> pulumi.Input['LineMaximumAllowedPowerArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_power")

    @maximum_allowed_power.setter
    def maximum_allowed_power(self, value: pulumi.Input['LineMaximumAllowedPowerArgs']):
        pulumi.set(self, "maximum_allowed_power", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperature")
    def maximum_allowed_temperature(self) -> pulumi.Input['LineMaximumAllowedTemperatureArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature")

    @maximum_allowed_temperature.setter
    def maximum_allowed_temperature(self, value: pulumi.Input['LineMaximumAllowedTemperatureArgs']):
        pulumi.set(self, "maximum_allowed_temperature", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperatureLte")
    def maximum_allowed_temperature_lte(self) -> pulumi.Input['LineMaximumAllowedTemperatureLteArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_lte")

    @maximum_allowed_temperature_lte.setter
    def maximum_allowed_temperature_lte(self, value: pulumi.Input['LineMaximumAllowedTemperatureLteArgs']):
        pulumi.set(self, "maximum_allowed_temperature_lte", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperatureSte")
    def maximum_allowed_temperature_ste(self) -> pulumi.Input['LineMaximumAllowedTemperatureSteArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_ste")

    @maximum_allowed_temperature_ste.setter
    def maximum_allowed_temperature_ste(self, value: pulumi.Input['LineMaximumAllowedTemperatureSteArgs']):
        pulumi.set(self, "maximum_allowed_temperature_ste", value)

    @property
    @pulumi.getter(name="numberOfConductors")
    def number_of_conductors(self) -> pulumi.Input['LineNumberOfConductorsArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "number_of_conductors")

    @number_of_conductors.setter
    def number_of_conductors(self, value: pulumi.Input['LineNumberOfConductorsArgs']):
        pulumi.set(self, "number_of_conductors", value)

    @property
    @pulumi.getter
    def reactance(self) -> pulumi.Input['LineReactanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reactance")

    @reactance.setter
    def reactance(self, value: pulumi.Input['LineReactanceArgs']):
        pulumi.set(self, "reactance", value)

    @property
    @pulumi.getter(name="referenceResistance")
    def reference_resistance(self) -> pulumi.Input['LineReferenceResistanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reference_resistance")

    @reference_resistance.setter
    def reference_resistance(self, value: pulumi.Input['LineReferenceResistanceArgs']):
        pulumi.set(self, "reference_resistance", value)

    @property
    @pulumi.getter
    def resistance(self) -> pulumi.Input['LineResistanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "resistance")

    @resistance.setter
    def resistance(self, value: pulumi.Input['LineResistanceArgs']):
        pulumi.set(self, "resistance", value)

    @property
    @pulumi.getter(name="safetyMarginForPower")
    def safety_margin_for_power(self) -> pulumi.Input['LineSafetyMarginForPowerArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "safety_margin_for_power")

    @safety_margin_for_power.setter
    def safety_margin_for_power(self, value: pulumi.Input['LineSafetyMarginForPowerArgs']):
        pulumi.set(self, "safety_margin_for_power", value)

    @property
    @pulumi.getter
    def susceptance(self) -> pulumi.Input['LineSusceptanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "susceptance")

    @susceptance.setter
    def susceptance(self, value: pulumi.Input['LineSusceptanceArgs']):
        pulumi.set(self, "susceptance", value)

    @property
    @pulumi.getter(name="temperatureCoeffResistance")
    def temperature_coeff_resistance(self) -> pulumi.Input['LineTemperatureCoeffResistanceArgs']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "temperature_coeff_resistance")

    @temperature_coeff_resistance.setter
    def temperature_coeff_resistance(self, value: pulumi.Input['LineTemperatureCoeffResistanceArgs']):
        pulumi.set(self, "temperature_coeff_resistance", value)

    @property
    @pulumi.getter(name="customTimezone")
    def custom_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        timezone that overrides location-based timezone of the resource
        """
        return pulumi.get(self, "custom_timezone")

    @custom_timezone.setter
    def custom_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_timezone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def geometry(self) -> Optional[pulumi.Input[str]]:
        """
        geo position and shape of the resource
        """
        return pulumi.get(self, "geometry")

    @geometry.setter
    def geometry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geometry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LineState:
    def __init__(__self__, *,
                 absorptivity: Optional[pulumi.Input['LineAbsorptivityArgs']] = None,
                 active_power_ends: Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerEndArgs']]]] = None,
                 active_powers: Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerArgs']]]] = None,
                 ampacities: Optional[pulumi.Input[Sequence[pulumi.Input['LineAmpacityArgs']]]] = None,
                 atmosphere: Optional[pulumi.Input['LineAtmosphereArgs']] = None,
                 capacitance: Optional[pulumi.Input['LineCapacitanceArgs']] = None,
                 conductance: Optional[pulumi.Input['LineConductanceArgs']] = None,
                 current_rs: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentRArgs']]]] = None,
                 current_s: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]] = None,
                 current_ts: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentTArgs']]]] = None,
                 currents: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]] = None,
                 custom_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 diameter: Optional[pulumi.Input['LineDiameterArgs']] = None,
                 emissivity: Optional[pulumi.Input['LineEmissivityArgs']] = None,
                 energies: Optional[pulumi.Input[Sequence[pulumi.Input['LineEnergyArgs']]]] = None,
                 geometry: Optional[pulumi.Input[str]] = None,
                 kinds: Optional[pulumi.Input[Sequence[pulumi.Input['LineKindArgs']]]] = None,
                 length: Optional[pulumi.Input['LineLengthArgs']] = None,
                 max_temperatures: Optional[pulumi.Input[Sequence[pulumi.Input['LineMaxTemperatureArgs']]]] = None,
                 maximum_allowed_current: Optional[pulumi.Input['LineMaximumAllowedCurrentArgs']] = None,
                 maximum_allowed_power: Optional[pulumi.Input['LineMaximumAllowedPowerArgs']] = None,
                 maximum_allowed_temperature: Optional[pulumi.Input['LineMaximumAllowedTemperatureArgs']] = None,
                 maximum_allowed_temperature_lte: Optional[pulumi.Input['LineMaximumAllowedTemperatureLteArgs']] = None,
                 maximum_allowed_temperature_ste: Optional[pulumi.Input['LineMaximumAllowedTemperatureSteArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_conductors: Optional[pulumi.Input['LineNumberOfConductorsArgs']] = None,
                 reactance: Optional[pulumi.Input['LineReactanceArgs']] = None,
                 reactive_powers: Optional[pulumi.Input[Sequence[pulumi.Input['LineReactivePowerArgs']]]] = None,
                 reference_resistance: Optional[pulumi.Input['LineReferenceResistanceArgs']] = None,
                 resistance: Optional[pulumi.Input['LineResistanceArgs']] = None,
                 safety_margin_for_power: Optional[pulumi.Input['LineSafetyMarginForPowerArgs']] = None,
                 susceptance: Optional[pulumi.Input['LineSusceptanceArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]] = None,
                 temperature_coeff_resistance: Optional[pulumi.Input['LineTemperatureCoeffResistanceArgs']] = None,
                 voltage_rs: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageRArgs']]]] = None,
                 voltage_sts: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageStArgs']]]] = None,
                 voltage_trs: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageTrArgs']]]] = None):
        """
        Input properties used for looking up and filtering Line resources.
        :param pulumi.Input['LineAbsorptivityArgs'] absorptivity: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineActivePowerEndArgs']]] active_power_ends: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineActivePowerArgs']]] active_powers: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineAmpacityArgs']]] ampacities: attribute of the resource
        :param pulumi.Input['LineAtmosphereArgs'] atmosphere: attribute of the resource
        :param pulumi.Input['LineCapacitanceArgs'] capacitance: attribute of the resource
        :param pulumi.Input['LineConductanceArgs'] conductance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineCurrentRArgs']]] current_rs: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]] current_s: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineCurrentTArgs']]] current_ts: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]] currents: attribute of the resource
        :param pulumi.Input[str] custom_timezone: timezone that overrides location-based timezone of the resource
        :param pulumi.Input[str] description: description of the resource
        :param pulumi.Input['LineDiameterArgs'] diameter: attribute of the resource
        :param pulumi.Input['LineEmissivityArgs'] emissivity: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineEnergyArgs']]] energies: attribute of the resource
        :param pulumi.Input[str] geometry: geo position and shape of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineKindArgs']]] kinds: kind of the resource
        :param pulumi.Input['LineLengthArgs'] length: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineMaxTemperatureArgs']]] max_temperatures: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedCurrentArgs'] maximum_allowed_current: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedPowerArgs'] maximum_allowed_power: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureArgs'] maximum_allowed_temperature: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureLteArgs'] maximum_allowed_temperature_lte: attribute of the resource
        :param pulumi.Input['LineMaximumAllowedTemperatureSteArgs'] maximum_allowed_temperature_ste: attribute of the resource
        :param pulumi.Input[str] name: name of the resource
        :param pulumi.Input['LineNumberOfConductorsArgs'] number_of_conductors: attribute of the resource
        :param pulumi.Input['LineReactanceArgs'] reactance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineReactivePowerArgs']]] reactive_powers: attribute of the resource
        :param pulumi.Input['LineReferenceResistanceArgs'] reference_resistance: attribute of the resource
        :param pulumi.Input['LineResistanceArgs'] resistance: attribute of the resource
        :param pulumi.Input['LineSafetyMarginForPowerArgs'] safety_margin_for_power: attribute of the resource
        :param pulumi.Input['LineSusceptanceArgs'] susceptance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]] tags: tags of the resource
        :param pulumi.Input['LineTemperatureCoeffResistanceArgs'] temperature_coeff_resistance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineVoltageRArgs']]] voltage_rs: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineVoltageStArgs']]] voltage_sts: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input['LineVoltageTrArgs']]] voltage_trs: attribute of the resource
        """
        if absorptivity is not None:
            pulumi.set(__self__, "absorptivity", absorptivity)
        if active_power_ends is not None:
            pulumi.set(__self__, "active_power_ends", active_power_ends)
        if active_powers is not None:
            pulumi.set(__self__, "active_powers", active_powers)
        if ampacities is not None:
            pulumi.set(__self__, "ampacities", ampacities)
        if atmosphere is not None:
            pulumi.set(__self__, "atmosphere", atmosphere)
        if capacitance is not None:
            pulumi.set(__self__, "capacitance", capacitance)
        if conductance is not None:
            pulumi.set(__self__, "conductance", conductance)
        if current_rs is not None:
            pulumi.set(__self__, "current_rs", current_rs)
        if current_s is not None:
            pulumi.set(__self__, "current_s", current_s)
        if current_ts is not None:
            pulumi.set(__self__, "current_ts", current_ts)
        if currents is not None:
            pulumi.set(__self__, "currents", currents)
        if custom_timezone is not None:
            pulumi.set(__self__, "custom_timezone", custom_timezone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if diameter is not None:
            pulumi.set(__self__, "diameter", diameter)
        if emissivity is not None:
            pulumi.set(__self__, "emissivity", emissivity)
        if energies is not None:
            pulumi.set(__self__, "energies", energies)
        if geometry is not None:
            pulumi.set(__self__, "geometry", geometry)
        if kinds is not None:
            pulumi.set(__self__, "kinds", kinds)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if max_temperatures is not None:
            pulumi.set(__self__, "max_temperatures", max_temperatures)
        if maximum_allowed_current is not None:
            pulumi.set(__self__, "maximum_allowed_current", maximum_allowed_current)
        if maximum_allowed_power is not None:
            pulumi.set(__self__, "maximum_allowed_power", maximum_allowed_power)
        if maximum_allowed_temperature is not None:
            pulumi.set(__self__, "maximum_allowed_temperature", maximum_allowed_temperature)
        if maximum_allowed_temperature_lte is not None:
            pulumi.set(__self__, "maximum_allowed_temperature_lte", maximum_allowed_temperature_lte)
        if maximum_allowed_temperature_ste is not None:
            pulumi.set(__self__, "maximum_allowed_temperature_ste", maximum_allowed_temperature_ste)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_conductors is not None:
            pulumi.set(__self__, "number_of_conductors", number_of_conductors)
        if reactance is not None:
            pulumi.set(__self__, "reactance", reactance)
        if reactive_powers is not None:
            pulumi.set(__self__, "reactive_powers", reactive_powers)
        if reference_resistance is not None:
            pulumi.set(__self__, "reference_resistance", reference_resistance)
        if resistance is not None:
            pulumi.set(__self__, "resistance", resistance)
        if safety_margin_for_power is not None:
            pulumi.set(__self__, "safety_margin_for_power", safety_margin_for_power)
        if susceptance is not None:
            pulumi.set(__self__, "susceptance", susceptance)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temperature_coeff_resistance is not None:
            pulumi.set(__self__, "temperature_coeff_resistance", temperature_coeff_resistance)
        if voltage_rs is not None:
            pulumi.set(__self__, "voltage_rs", voltage_rs)
        if voltage_sts is not None:
            pulumi.set(__self__, "voltage_sts", voltage_sts)
        if voltage_trs is not None:
            pulumi.set(__self__, "voltage_trs", voltage_trs)

    @property
    @pulumi.getter
    def absorptivity(self) -> Optional[pulumi.Input['LineAbsorptivityArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "absorptivity")

    @absorptivity.setter
    def absorptivity(self, value: Optional[pulumi.Input['LineAbsorptivityArgs']]):
        pulumi.set(self, "absorptivity", value)

    @property
    @pulumi.getter(name="activePowerEnds")
    def active_power_ends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerEndArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "active_power_ends")

    @active_power_ends.setter
    def active_power_ends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerEndArgs']]]]):
        pulumi.set(self, "active_power_ends", value)

    @property
    @pulumi.getter(name="activePowers")
    def active_powers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "active_powers")

    @active_powers.setter
    def active_powers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineActivePowerArgs']]]]):
        pulumi.set(self, "active_powers", value)

    @property
    @pulumi.getter
    def ampacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineAmpacityArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "ampacities")

    @ampacities.setter
    def ampacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineAmpacityArgs']]]]):
        pulumi.set(self, "ampacities", value)

    @property
    @pulumi.getter
    def atmosphere(self) -> Optional[pulumi.Input['LineAtmosphereArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "atmosphere")

    @atmosphere.setter
    def atmosphere(self, value: Optional[pulumi.Input['LineAtmosphereArgs']]):
        pulumi.set(self, "atmosphere", value)

    @property
    @pulumi.getter
    def capacitance(self) -> Optional[pulumi.Input['LineCapacitanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "capacitance")

    @capacitance.setter
    def capacitance(self, value: Optional[pulumi.Input['LineCapacitanceArgs']]):
        pulumi.set(self, "capacitance", value)

    @property
    @pulumi.getter
    def conductance(self) -> Optional[pulumi.Input['LineConductanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "conductance")

    @conductance.setter
    def conductance(self, value: Optional[pulumi.Input['LineConductanceArgs']]):
        pulumi.set(self, "conductance", value)

    @property
    @pulumi.getter(name="currentRs")
    def current_rs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentRArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_rs")

    @current_rs.setter
    def current_rs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentRArgs']]]]):
        pulumi.set(self, "current_rs", value)

    @property
    @pulumi.getter(name="currentS")
    def current_s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_s")

    @current_s.setter
    def current_s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]]):
        pulumi.set(self, "current_s", value)

    @property
    @pulumi.getter(name="currentTs")
    def current_ts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentTArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_ts")

    @current_ts.setter
    def current_ts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentTArgs']]]]):
        pulumi.set(self, "current_ts", value)

    @property
    @pulumi.getter
    def currents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "currents")

    @currents.setter
    def currents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineCurrentArgs']]]]):
        pulumi.set(self, "currents", value)

    @property
    @pulumi.getter(name="customTimezone")
    def custom_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        timezone that overrides location-based timezone of the resource
        """
        return pulumi.get(self, "custom_timezone")

    @custom_timezone.setter
    def custom_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_timezone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def diameter(self) -> Optional[pulumi.Input['LineDiameterArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "diameter")

    @diameter.setter
    def diameter(self, value: Optional[pulumi.Input['LineDiameterArgs']]):
        pulumi.set(self, "diameter", value)

    @property
    @pulumi.getter
    def emissivity(self) -> Optional[pulumi.Input['LineEmissivityArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "emissivity")

    @emissivity.setter
    def emissivity(self, value: Optional[pulumi.Input['LineEmissivityArgs']]):
        pulumi.set(self, "emissivity", value)

    @property
    @pulumi.getter
    def energies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineEnergyArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "energies")

    @energies.setter
    def energies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineEnergyArgs']]]]):
        pulumi.set(self, "energies", value)

    @property
    @pulumi.getter
    def geometry(self) -> Optional[pulumi.Input[str]]:
        """
        geo position and shape of the resource
        """
        return pulumi.get(self, "geometry")

    @geometry.setter
    def geometry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "geometry", value)

    @property
    @pulumi.getter
    def kinds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineKindArgs']]]]:
        """
        kind of the resource
        """
        return pulumi.get(self, "kinds")

    @kinds.setter
    def kinds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineKindArgs']]]]):
        pulumi.set(self, "kinds", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input['LineLengthArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input['LineLengthArgs']]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter(name="maxTemperatures")
    def max_temperatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineMaxTemperatureArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "max_temperatures")

    @max_temperatures.setter
    def max_temperatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineMaxTemperatureArgs']]]]):
        pulumi.set(self, "max_temperatures", value)

    @property
    @pulumi.getter(name="maximumAllowedCurrent")
    def maximum_allowed_current(self) -> Optional[pulumi.Input['LineMaximumAllowedCurrentArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_current")

    @maximum_allowed_current.setter
    def maximum_allowed_current(self, value: Optional[pulumi.Input['LineMaximumAllowedCurrentArgs']]):
        pulumi.set(self, "maximum_allowed_current", value)

    @property
    @pulumi.getter(name="maximumAllowedPower")
    def maximum_allowed_power(self) -> Optional[pulumi.Input['LineMaximumAllowedPowerArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_power")

    @maximum_allowed_power.setter
    def maximum_allowed_power(self, value: Optional[pulumi.Input['LineMaximumAllowedPowerArgs']]):
        pulumi.set(self, "maximum_allowed_power", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperature")
    def maximum_allowed_temperature(self) -> Optional[pulumi.Input['LineMaximumAllowedTemperatureArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature")

    @maximum_allowed_temperature.setter
    def maximum_allowed_temperature(self, value: Optional[pulumi.Input['LineMaximumAllowedTemperatureArgs']]):
        pulumi.set(self, "maximum_allowed_temperature", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperatureLte")
    def maximum_allowed_temperature_lte(self) -> Optional[pulumi.Input['LineMaximumAllowedTemperatureLteArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_lte")

    @maximum_allowed_temperature_lte.setter
    def maximum_allowed_temperature_lte(self, value: Optional[pulumi.Input['LineMaximumAllowedTemperatureLteArgs']]):
        pulumi.set(self, "maximum_allowed_temperature_lte", value)

    @property
    @pulumi.getter(name="maximumAllowedTemperatureSte")
    def maximum_allowed_temperature_ste(self) -> Optional[pulumi.Input['LineMaximumAllowedTemperatureSteArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_ste")

    @maximum_allowed_temperature_ste.setter
    def maximum_allowed_temperature_ste(self, value: Optional[pulumi.Input['LineMaximumAllowedTemperatureSteArgs']]):
        pulumi.set(self, "maximum_allowed_temperature_ste", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfConductors")
    def number_of_conductors(self) -> Optional[pulumi.Input['LineNumberOfConductorsArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "number_of_conductors")

    @number_of_conductors.setter
    def number_of_conductors(self, value: Optional[pulumi.Input['LineNumberOfConductorsArgs']]):
        pulumi.set(self, "number_of_conductors", value)

    @property
    @pulumi.getter
    def reactance(self) -> Optional[pulumi.Input['LineReactanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reactance")

    @reactance.setter
    def reactance(self, value: Optional[pulumi.Input['LineReactanceArgs']]):
        pulumi.set(self, "reactance", value)

    @property
    @pulumi.getter(name="reactivePowers")
    def reactive_powers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineReactivePowerArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reactive_powers")

    @reactive_powers.setter
    def reactive_powers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineReactivePowerArgs']]]]):
        pulumi.set(self, "reactive_powers", value)

    @property
    @pulumi.getter(name="referenceResistance")
    def reference_resistance(self) -> Optional[pulumi.Input['LineReferenceResistanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reference_resistance")

    @reference_resistance.setter
    def reference_resistance(self, value: Optional[pulumi.Input['LineReferenceResistanceArgs']]):
        pulumi.set(self, "reference_resistance", value)

    @property
    @pulumi.getter
    def resistance(self) -> Optional[pulumi.Input['LineResistanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "resistance")

    @resistance.setter
    def resistance(self, value: Optional[pulumi.Input['LineResistanceArgs']]):
        pulumi.set(self, "resistance", value)

    @property
    @pulumi.getter(name="safetyMarginForPower")
    def safety_margin_for_power(self) -> Optional[pulumi.Input['LineSafetyMarginForPowerArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "safety_margin_for_power")

    @safety_margin_for_power.setter
    def safety_margin_for_power(self, value: Optional[pulumi.Input['LineSafetyMarginForPowerArgs']]):
        pulumi.set(self, "safety_margin_for_power", value)

    @property
    @pulumi.getter
    def susceptance(self) -> Optional[pulumi.Input['LineSusceptanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "susceptance")

    @susceptance.setter
    def susceptance(self, value: Optional[pulumi.Input['LineSusceptanceArgs']]):
        pulumi.set(self, "susceptance", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="temperatureCoeffResistance")
    def temperature_coeff_resistance(self) -> Optional[pulumi.Input['LineTemperatureCoeffResistanceArgs']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "temperature_coeff_resistance")

    @temperature_coeff_resistance.setter
    def temperature_coeff_resistance(self, value: Optional[pulumi.Input['LineTemperatureCoeffResistanceArgs']]):
        pulumi.set(self, "temperature_coeff_resistance", value)

    @property
    @pulumi.getter(name="voltageRs")
    def voltage_rs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageRArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_rs")

    @voltage_rs.setter
    def voltage_rs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageRArgs']]]]):
        pulumi.set(self, "voltage_rs", value)

    @property
    @pulumi.getter(name="voltageSts")
    def voltage_sts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageStArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_sts")

    @voltage_sts.setter
    def voltage_sts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageStArgs']]]]):
        pulumi.set(self, "voltage_sts", value)

    @property
    @pulumi.getter(name="voltageTrs")
    def voltage_trs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageTrArgs']]]]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_trs")

    @voltage_trs.setter
    def voltage_trs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LineVoltageTrArgs']]]]):
        pulumi.set(self, "voltage_trs", value)


class Line(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 absorptivity: Optional[pulumi.Input[Union['LineAbsorptivityArgs', 'LineAbsorptivityArgsDict']]] = None,
                 atmosphere: Optional[pulumi.Input[Union['LineAtmosphereArgs', 'LineAtmosphereArgsDict']]] = None,
                 capacitance: Optional[pulumi.Input[Union['LineCapacitanceArgs', 'LineCapacitanceArgsDict']]] = None,
                 conductance: Optional[pulumi.Input[Union['LineConductanceArgs', 'LineConductanceArgsDict']]] = None,
                 custom_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 diameter: Optional[pulumi.Input[Union['LineDiameterArgs', 'LineDiameterArgsDict']]] = None,
                 emissivity: Optional[pulumi.Input[Union['LineEmissivityArgs', 'LineEmissivityArgsDict']]] = None,
                 geometry: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[Union['LineLengthArgs', 'LineLengthArgsDict']]] = None,
                 maximum_allowed_current: Optional[pulumi.Input[Union['LineMaximumAllowedCurrentArgs', 'LineMaximumAllowedCurrentArgsDict']]] = None,
                 maximum_allowed_power: Optional[pulumi.Input[Union['LineMaximumAllowedPowerArgs', 'LineMaximumAllowedPowerArgsDict']]] = None,
                 maximum_allowed_temperature: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureArgs', 'LineMaximumAllowedTemperatureArgsDict']]] = None,
                 maximum_allowed_temperature_lte: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureLteArgs', 'LineMaximumAllowedTemperatureLteArgsDict']]] = None,
                 maximum_allowed_temperature_ste: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureSteArgs', 'LineMaximumAllowedTemperatureSteArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_conductors: Optional[pulumi.Input[Union['LineNumberOfConductorsArgs', 'LineNumberOfConductorsArgsDict']]] = None,
                 reactance: Optional[pulumi.Input[Union['LineReactanceArgs', 'LineReactanceArgsDict']]] = None,
                 reference_resistance: Optional[pulumi.Input[Union['LineReferenceResistanceArgs', 'LineReferenceResistanceArgsDict']]] = None,
                 resistance: Optional[pulumi.Input[Union['LineResistanceArgs', 'LineResistanceArgsDict']]] = None,
                 safety_margin_for_power: Optional[pulumi.Input[Union['LineSafetyMarginForPowerArgs', 'LineSafetyMarginForPowerArgsDict']]] = None,
                 susceptance: Optional[pulumi.Input[Union['LineSusceptanceArgs', 'LineSusceptanceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineTagArgs', 'LineTagArgsDict']]]]] = None,
                 temperature_coeff_resistance: Optional[pulumi.Input[Union['LineTemperatureCoeffResistanceArgs', 'LineTemperatureCoeffResistanceArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/line:Line [options] splight_line.<name> <line_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LineAbsorptivityArgs', 'LineAbsorptivityArgsDict']] absorptivity: attribute of the resource
        :param pulumi.Input[Union['LineAtmosphereArgs', 'LineAtmosphereArgsDict']] atmosphere: attribute of the resource
        :param pulumi.Input[Union['LineCapacitanceArgs', 'LineCapacitanceArgsDict']] capacitance: attribute of the resource
        :param pulumi.Input[Union['LineConductanceArgs', 'LineConductanceArgsDict']] conductance: attribute of the resource
        :param pulumi.Input[str] custom_timezone: timezone that overrides location-based timezone of the resource
        :param pulumi.Input[str] description: description of the resource
        :param pulumi.Input[Union['LineDiameterArgs', 'LineDiameterArgsDict']] diameter: attribute of the resource
        :param pulumi.Input[Union['LineEmissivityArgs', 'LineEmissivityArgsDict']] emissivity: attribute of the resource
        :param pulumi.Input[str] geometry: geo position and shape of the resource
        :param pulumi.Input[Union['LineLengthArgs', 'LineLengthArgsDict']] length: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedCurrentArgs', 'LineMaximumAllowedCurrentArgsDict']] maximum_allowed_current: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedPowerArgs', 'LineMaximumAllowedPowerArgsDict']] maximum_allowed_power: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureArgs', 'LineMaximumAllowedTemperatureArgsDict']] maximum_allowed_temperature: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureLteArgs', 'LineMaximumAllowedTemperatureLteArgsDict']] maximum_allowed_temperature_lte: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureSteArgs', 'LineMaximumAllowedTemperatureSteArgsDict']] maximum_allowed_temperature_ste: attribute of the resource
        :param pulumi.Input[str] name: name of the resource
        :param pulumi.Input[Union['LineNumberOfConductorsArgs', 'LineNumberOfConductorsArgsDict']] number_of_conductors: attribute of the resource
        :param pulumi.Input[Union['LineReactanceArgs', 'LineReactanceArgsDict']] reactance: attribute of the resource
        :param pulumi.Input[Union['LineReferenceResistanceArgs', 'LineReferenceResistanceArgsDict']] reference_resistance: attribute of the resource
        :param pulumi.Input[Union['LineResistanceArgs', 'LineResistanceArgsDict']] resistance: attribute of the resource
        :param pulumi.Input[Union['LineSafetyMarginForPowerArgs', 'LineSafetyMarginForPowerArgsDict']] safety_margin_for_power: attribute of the resource
        :param pulumi.Input[Union['LineSusceptanceArgs', 'LineSusceptanceArgsDict']] susceptance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineTagArgs', 'LineTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[Union['LineTemperatureCoeffResistanceArgs', 'LineTemperatureCoeffResistanceArgsDict']] temperature_coeff_resistance: attribute of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/line:Line [options] splight_line.<name> <line_id>
        ```

        :param str resource_name: The name of the resource.
        :param LineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 absorptivity: Optional[pulumi.Input[Union['LineAbsorptivityArgs', 'LineAbsorptivityArgsDict']]] = None,
                 atmosphere: Optional[pulumi.Input[Union['LineAtmosphereArgs', 'LineAtmosphereArgsDict']]] = None,
                 capacitance: Optional[pulumi.Input[Union['LineCapacitanceArgs', 'LineCapacitanceArgsDict']]] = None,
                 conductance: Optional[pulumi.Input[Union['LineConductanceArgs', 'LineConductanceArgsDict']]] = None,
                 custom_timezone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 diameter: Optional[pulumi.Input[Union['LineDiameterArgs', 'LineDiameterArgsDict']]] = None,
                 emissivity: Optional[pulumi.Input[Union['LineEmissivityArgs', 'LineEmissivityArgsDict']]] = None,
                 geometry: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[Union['LineLengthArgs', 'LineLengthArgsDict']]] = None,
                 maximum_allowed_current: Optional[pulumi.Input[Union['LineMaximumAllowedCurrentArgs', 'LineMaximumAllowedCurrentArgsDict']]] = None,
                 maximum_allowed_power: Optional[pulumi.Input[Union['LineMaximumAllowedPowerArgs', 'LineMaximumAllowedPowerArgsDict']]] = None,
                 maximum_allowed_temperature: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureArgs', 'LineMaximumAllowedTemperatureArgsDict']]] = None,
                 maximum_allowed_temperature_lte: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureLteArgs', 'LineMaximumAllowedTemperatureLteArgsDict']]] = None,
                 maximum_allowed_temperature_ste: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureSteArgs', 'LineMaximumAllowedTemperatureSteArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_conductors: Optional[pulumi.Input[Union['LineNumberOfConductorsArgs', 'LineNumberOfConductorsArgsDict']]] = None,
                 reactance: Optional[pulumi.Input[Union['LineReactanceArgs', 'LineReactanceArgsDict']]] = None,
                 reference_resistance: Optional[pulumi.Input[Union['LineReferenceResistanceArgs', 'LineReferenceResistanceArgsDict']]] = None,
                 resistance: Optional[pulumi.Input[Union['LineResistanceArgs', 'LineResistanceArgsDict']]] = None,
                 safety_margin_for_power: Optional[pulumi.Input[Union['LineSafetyMarginForPowerArgs', 'LineSafetyMarginForPowerArgsDict']]] = None,
                 susceptance: Optional[pulumi.Input[Union['LineSusceptanceArgs', 'LineSusceptanceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineTagArgs', 'LineTagArgsDict']]]]] = None,
                 temperature_coeff_resistance: Optional[pulumi.Input[Union['LineTemperatureCoeffResistanceArgs', 'LineTemperatureCoeffResistanceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LineArgs.__new__(LineArgs)

            if absorptivity is None and not opts.urn:
                raise TypeError("Missing required property 'absorptivity'")
            __props__.__dict__["absorptivity"] = absorptivity
            if atmosphere is None and not opts.urn:
                raise TypeError("Missing required property 'atmosphere'")
            __props__.__dict__["atmosphere"] = atmosphere
            if capacitance is None and not opts.urn:
                raise TypeError("Missing required property 'capacitance'")
            __props__.__dict__["capacitance"] = capacitance
            if conductance is None and not opts.urn:
                raise TypeError("Missing required property 'conductance'")
            __props__.__dict__["conductance"] = conductance
            __props__.__dict__["custom_timezone"] = custom_timezone
            __props__.__dict__["description"] = description
            if diameter is None and not opts.urn:
                raise TypeError("Missing required property 'diameter'")
            __props__.__dict__["diameter"] = diameter
            if emissivity is None and not opts.urn:
                raise TypeError("Missing required property 'emissivity'")
            __props__.__dict__["emissivity"] = emissivity
            __props__.__dict__["geometry"] = geometry
            if length is None and not opts.urn:
                raise TypeError("Missing required property 'length'")
            __props__.__dict__["length"] = length
            if maximum_allowed_current is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_allowed_current'")
            __props__.__dict__["maximum_allowed_current"] = maximum_allowed_current
            if maximum_allowed_power is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_allowed_power'")
            __props__.__dict__["maximum_allowed_power"] = maximum_allowed_power
            if maximum_allowed_temperature is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_allowed_temperature'")
            __props__.__dict__["maximum_allowed_temperature"] = maximum_allowed_temperature
            if maximum_allowed_temperature_lte is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_allowed_temperature_lte'")
            __props__.__dict__["maximum_allowed_temperature_lte"] = maximum_allowed_temperature_lte
            if maximum_allowed_temperature_ste is None and not opts.urn:
                raise TypeError("Missing required property 'maximum_allowed_temperature_ste'")
            __props__.__dict__["maximum_allowed_temperature_ste"] = maximum_allowed_temperature_ste
            __props__.__dict__["name"] = name
            if number_of_conductors is None and not opts.urn:
                raise TypeError("Missing required property 'number_of_conductors'")
            __props__.__dict__["number_of_conductors"] = number_of_conductors
            if reactance is None and not opts.urn:
                raise TypeError("Missing required property 'reactance'")
            __props__.__dict__["reactance"] = reactance
            if reference_resistance is None and not opts.urn:
                raise TypeError("Missing required property 'reference_resistance'")
            __props__.__dict__["reference_resistance"] = reference_resistance
            if resistance is None and not opts.urn:
                raise TypeError("Missing required property 'resistance'")
            __props__.__dict__["resistance"] = resistance
            if safety_margin_for_power is None and not opts.urn:
                raise TypeError("Missing required property 'safety_margin_for_power'")
            __props__.__dict__["safety_margin_for_power"] = safety_margin_for_power
            if susceptance is None and not opts.urn:
                raise TypeError("Missing required property 'susceptance'")
            __props__.__dict__["susceptance"] = susceptance
            __props__.__dict__["tags"] = tags
            if temperature_coeff_resistance is None and not opts.urn:
                raise TypeError("Missing required property 'temperature_coeff_resistance'")
            __props__.__dict__["temperature_coeff_resistance"] = temperature_coeff_resistance
            __props__.__dict__["active_power_ends"] = None
            __props__.__dict__["active_powers"] = None
            __props__.__dict__["ampacities"] = None
            __props__.__dict__["current_rs"] = None
            __props__.__dict__["current_s"] = None
            __props__.__dict__["current_ts"] = None
            __props__.__dict__["currents"] = None
            __props__.__dict__["energies"] = None
            __props__.__dict__["kinds"] = None
            __props__.__dict__["max_temperatures"] = None
            __props__.__dict__["reactive_powers"] = None
            __props__.__dict__["voltage_rs"] = None
            __props__.__dict__["voltage_sts"] = None
            __props__.__dict__["voltage_trs"] = None
        super(Line, __self__).__init__(
            'splight:index/line:Line',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            absorptivity: Optional[pulumi.Input[Union['LineAbsorptivityArgs', 'LineAbsorptivityArgsDict']]] = None,
            active_power_ends: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineActivePowerEndArgs', 'LineActivePowerEndArgsDict']]]]] = None,
            active_powers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineActivePowerArgs', 'LineActivePowerArgsDict']]]]] = None,
            ampacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineAmpacityArgs', 'LineAmpacityArgsDict']]]]] = None,
            atmosphere: Optional[pulumi.Input[Union['LineAtmosphereArgs', 'LineAtmosphereArgsDict']]] = None,
            capacitance: Optional[pulumi.Input[Union['LineCapacitanceArgs', 'LineCapacitanceArgsDict']]] = None,
            conductance: Optional[pulumi.Input[Union['LineConductanceArgs', 'LineConductanceArgsDict']]] = None,
            current_rs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentRArgs', 'LineCurrentRArgsDict']]]]] = None,
            current_s: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentArgs', 'LineCurrentArgsDict']]]]] = None,
            current_ts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentTArgs', 'LineCurrentTArgsDict']]]]] = None,
            currents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentArgs', 'LineCurrentArgsDict']]]]] = None,
            custom_timezone: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            diameter: Optional[pulumi.Input[Union['LineDiameterArgs', 'LineDiameterArgsDict']]] = None,
            emissivity: Optional[pulumi.Input[Union['LineEmissivityArgs', 'LineEmissivityArgsDict']]] = None,
            energies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineEnergyArgs', 'LineEnergyArgsDict']]]]] = None,
            geometry: Optional[pulumi.Input[str]] = None,
            kinds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineKindArgs', 'LineKindArgsDict']]]]] = None,
            length: Optional[pulumi.Input[Union['LineLengthArgs', 'LineLengthArgsDict']]] = None,
            max_temperatures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineMaxTemperatureArgs', 'LineMaxTemperatureArgsDict']]]]] = None,
            maximum_allowed_current: Optional[pulumi.Input[Union['LineMaximumAllowedCurrentArgs', 'LineMaximumAllowedCurrentArgsDict']]] = None,
            maximum_allowed_power: Optional[pulumi.Input[Union['LineMaximumAllowedPowerArgs', 'LineMaximumAllowedPowerArgsDict']]] = None,
            maximum_allowed_temperature: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureArgs', 'LineMaximumAllowedTemperatureArgsDict']]] = None,
            maximum_allowed_temperature_lte: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureLteArgs', 'LineMaximumAllowedTemperatureLteArgsDict']]] = None,
            maximum_allowed_temperature_ste: Optional[pulumi.Input[Union['LineMaximumAllowedTemperatureSteArgs', 'LineMaximumAllowedTemperatureSteArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_conductors: Optional[pulumi.Input[Union['LineNumberOfConductorsArgs', 'LineNumberOfConductorsArgsDict']]] = None,
            reactance: Optional[pulumi.Input[Union['LineReactanceArgs', 'LineReactanceArgsDict']]] = None,
            reactive_powers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineReactivePowerArgs', 'LineReactivePowerArgsDict']]]]] = None,
            reference_resistance: Optional[pulumi.Input[Union['LineReferenceResistanceArgs', 'LineReferenceResistanceArgsDict']]] = None,
            resistance: Optional[pulumi.Input[Union['LineResistanceArgs', 'LineResistanceArgsDict']]] = None,
            safety_margin_for_power: Optional[pulumi.Input[Union['LineSafetyMarginForPowerArgs', 'LineSafetyMarginForPowerArgsDict']]] = None,
            susceptance: Optional[pulumi.Input[Union['LineSusceptanceArgs', 'LineSusceptanceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineTagArgs', 'LineTagArgsDict']]]]] = None,
            temperature_coeff_resistance: Optional[pulumi.Input[Union['LineTemperatureCoeffResistanceArgs', 'LineTemperatureCoeffResistanceArgsDict']]] = None,
            voltage_rs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageRArgs', 'LineVoltageRArgsDict']]]]] = None,
            voltage_sts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageStArgs', 'LineVoltageStArgsDict']]]]] = None,
            voltage_trs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageTrArgs', 'LineVoltageTrArgsDict']]]]] = None) -> 'Line':
        """
        Get an existing Line resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LineAbsorptivityArgs', 'LineAbsorptivityArgsDict']] absorptivity: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineActivePowerEndArgs', 'LineActivePowerEndArgsDict']]]] active_power_ends: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineActivePowerArgs', 'LineActivePowerArgsDict']]]] active_powers: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineAmpacityArgs', 'LineAmpacityArgsDict']]]] ampacities: attribute of the resource
        :param pulumi.Input[Union['LineAtmosphereArgs', 'LineAtmosphereArgsDict']] atmosphere: attribute of the resource
        :param pulumi.Input[Union['LineCapacitanceArgs', 'LineCapacitanceArgsDict']] capacitance: attribute of the resource
        :param pulumi.Input[Union['LineConductanceArgs', 'LineConductanceArgsDict']] conductance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentRArgs', 'LineCurrentRArgsDict']]]] current_rs: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentArgs', 'LineCurrentArgsDict']]]] current_s: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentTArgs', 'LineCurrentTArgsDict']]]] current_ts: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineCurrentArgs', 'LineCurrentArgsDict']]]] currents: attribute of the resource
        :param pulumi.Input[str] custom_timezone: timezone that overrides location-based timezone of the resource
        :param pulumi.Input[str] description: description of the resource
        :param pulumi.Input[Union['LineDiameterArgs', 'LineDiameterArgsDict']] diameter: attribute of the resource
        :param pulumi.Input[Union['LineEmissivityArgs', 'LineEmissivityArgsDict']] emissivity: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineEnergyArgs', 'LineEnergyArgsDict']]]] energies: attribute of the resource
        :param pulumi.Input[str] geometry: geo position and shape of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineKindArgs', 'LineKindArgsDict']]]] kinds: kind of the resource
        :param pulumi.Input[Union['LineLengthArgs', 'LineLengthArgsDict']] length: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineMaxTemperatureArgs', 'LineMaxTemperatureArgsDict']]]] max_temperatures: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedCurrentArgs', 'LineMaximumAllowedCurrentArgsDict']] maximum_allowed_current: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedPowerArgs', 'LineMaximumAllowedPowerArgsDict']] maximum_allowed_power: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureArgs', 'LineMaximumAllowedTemperatureArgsDict']] maximum_allowed_temperature: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureLteArgs', 'LineMaximumAllowedTemperatureLteArgsDict']] maximum_allowed_temperature_lte: attribute of the resource
        :param pulumi.Input[Union['LineMaximumAllowedTemperatureSteArgs', 'LineMaximumAllowedTemperatureSteArgsDict']] maximum_allowed_temperature_ste: attribute of the resource
        :param pulumi.Input[str] name: name of the resource
        :param pulumi.Input[Union['LineNumberOfConductorsArgs', 'LineNumberOfConductorsArgsDict']] number_of_conductors: attribute of the resource
        :param pulumi.Input[Union['LineReactanceArgs', 'LineReactanceArgsDict']] reactance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineReactivePowerArgs', 'LineReactivePowerArgsDict']]]] reactive_powers: attribute of the resource
        :param pulumi.Input[Union['LineReferenceResistanceArgs', 'LineReferenceResistanceArgsDict']] reference_resistance: attribute of the resource
        :param pulumi.Input[Union['LineResistanceArgs', 'LineResistanceArgsDict']] resistance: attribute of the resource
        :param pulumi.Input[Union['LineSafetyMarginForPowerArgs', 'LineSafetyMarginForPowerArgsDict']] safety_margin_for_power: attribute of the resource
        :param pulumi.Input[Union['LineSusceptanceArgs', 'LineSusceptanceArgsDict']] susceptance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineTagArgs', 'LineTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[Union['LineTemperatureCoeffResistanceArgs', 'LineTemperatureCoeffResistanceArgsDict']] temperature_coeff_resistance: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageRArgs', 'LineVoltageRArgsDict']]]] voltage_rs: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageStArgs', 'LineVoltageStArgsDict']]]] voltage_sts: attribute of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['LineVoltageTrArgs', 'LineVoltageTrArgsDict']]]] voltage_trs: attribute of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LineState.__new__(_LineState)

        __props__.__dict__["absorptivity"] = absorptivity
        __props__.__dict__["active_power_ends"] = active_power_ends
        __props__.__dict__["active_powers"] = active_powers
        __props__.__dict__["ampacities"] = ampacities
        __props__.__dict__["atmosphere"] = atmosphere
        __props__.__dict__["capacitance"] = capacitance
        __props__.__dict__["conductance"] = conductance
        __props__.__dict__["current_rs"] = current_rs
        __props__.__dict__["current_s"] = current_s
        __props__.__dict__["current_ts"] = current_ts
        __props__.__dict__["currents"] = currents
        __props__.__dict__["custom_timezone"] = custom_timezone
        __props__.__dict__["description"] = description
        __props__.__dict__["diameter"] = diameter
        __props__.__dict__["emissivity"] = emissivity
        __props__.__dict__["energies"] = energies
        __props__.__dict__["geometry"] = geometry
        __props__.__dict__["kinds"] = kinds
        __props__.__dict__["length"] = length
        __props__.__dict__["max_temperatures"] = max_temperatures
        __props__.__dict__["maximum_allowed_current"] = maximum_allowed_current
        __props__.__dict__["maximum_allowed_power"] = maximum_allowed_power
        __props__.__dict__["maximum_allowed_temperature"] = maximum_allowed_temperature
        __props__.__dict__["maximum_allowed_temperature_lte"] = maximum_allowed_temperature_lte
        __props__.__dict__["maximum_allowed_temperature_ste"] = maximum_allowed_temperature_ste
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_conductors"] = number_of_conductors
        __props__.__dict__["reactance"] = reactance
        __props__.__dict__["reactive_powers"] = reactive_powers
        __props__.__dict__["reference_resistance"] = reference_resistance
        __props__.__dict__["resistance"] = resistance
        __props__.__dict__["safety_margin_for_power"] = safety_margin_for_power
        __props__.__dict__["susceptance"] = susceptance
        __props__.__dict__["tags"] = tags
        __props__.__dict__["temperature_coeff_resistance"] = temperature_coeff_resistance
        __props__.__dict__["voltage_rs"] = voltage_rs
        __props__.__dict__["voltage_sts"] = voltage_sts
        __props__.__dict__["voltage_trs"] = voltage_trs
        return Line(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def absorptivity(self) -> pulumi.Output['outputs.LineAbsorptivity']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "absorptivity")

    @property
    @pulumi.getter(name="activePowerEnds")
    def active_power_ends(self) -> pulumi.Output[Sequence['outputs.LineActivePowerEnd']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "active_power_ends")

    @property
    @pulumi.getter(name="activePowers")
    def active_powers(self) -> pulumi.Output[Sequence['outputs.LineActivePower']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "active_powers")

    @property
    @pulumi.getter
    def ampacities(self) -> pulumi.Output[Sequence['outputs.LineAmpacity']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "ampacities")

    @property
    @pulumi.getter
    def atmosphere(self) -> pulumi.Output['outputs.LineAtmosphere']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "atmosphere")

    @property
    @pulumi.getter
    def capacitance(self) -> pulumi.Output['outputs.LineCapacitance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "capacitance")

    @property
    @pulumi.getter
    def conductance(self) -> pulumi.Output['outputs.LineConductance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "conductance")

    @property
    @pulumi.getter(name="currentRs")
    def current_rs(self) -> pulumi.Output[Sequence['outputs.LineCurrentR']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_rs")

    @property
    @pulumi.getter(name="currentS")
    def current_s(self) -> pulumi.Output[Sequence['outputs.LineCurrent']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_s")

    @property
    @pulumi.getter(name="currentTs")
    def current_ts(self) -> pulumi.Output[Sequence['outputs.LineCurrentT']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "current_ts")

    @property
    @pulumi.getter
    def currents(self) -> pulumi.Output[Sequence['outputs.LineCurrent']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "currents")

    @property
    @pulumi.getter(name="customTimezone")
    def custom_timezone(self) -> pulumi.Output[Optional[str]]:
        """
        timezone that overrides location-based timezone of the resource
        """
        return pulumi.get(self, "custom_timezone")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        description of the resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def diameter(self) -> pulumi.Output['outputs.LineDiameter']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "diameter")

    @property
    @pulumi.getter
    def emissivity(self) -> pulumi.Output['outputs.LineEmissivity']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "emissivity")

    @property
    @pulumi.getter
    def energies(self) -> pulumi.Output[Sequence['outputs.LineEnergy']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "energies")

    @property
    @pulumi.getter
    def geometry(self) -> pulumi.Output[Optional[str]]:
        """
        geo position and shape of the resource
        """
        return pulumi.get(self, "geometry")

    @property
    @pulumi.getter
    def kinds(self) -> pulumi.Output[Sequence['outputs.LineKind']]:
        """
        kind of the resource
        """
        return pulumi.get(self, "kinds")

    @property
    @pulumi.getter
    def length(self) -> pulumi.Output['outputs.LineLength']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="maxTemperatures")
    def max_temperatures(self) -> pulumi.Output[Sequence['outputs.LineMaxTemperature']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "max_temperatures")

    @property
    @pulumi.getter(name="maximumAllowedCurrent")
    def maximum_allowed_current(self) -> pulumi.Output['outputs.LineMaximumAllowedCurrent']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_current")

    @property
    @pulumi.getter(name="maximumAllowedPower")
    def maximum_allowed_power(self) -> pulumi.Output['outputs.LineMaximumAllowedPower']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_power")

    @property
    @pulumi.getter(name="maximumAllowedTemperature")
    def maximum_allowed_temperature(self) -> pulumi.Output['outputs.LineMaximumAllowedTemperature']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature")

    @property
    @pulumi.getter(name="maximumAllowedTemperatureLte")
    def maximum_allowed_temperature_lte(self) -> pulumi.Output['outputs.LineMaximumAllowedTemperatureLte']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_lte")

    @property
    @pulumi.getter(name="maximumAllowedTemperatureSte")
    def maximum_allowed_temperature_ste(self) -> pulumi.Output['outputs.LineMaximumAllowedTemperatureSte']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "maximum_allowed_temperature_ste")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfConductors")
    def number_of_conductors(self) -> pulumi.Output['outputs.LineNumberOfConductors']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "number_of_conductors")

    @property
    @pulumi.getter
    def reactance(self) -> pulumi.Output['outputs.LineReactance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reactance")

    @property
    @pulumi.getter(name="reactivePowers")
    def reactive_powers(self) -> pulumi.Output[Sequence['outputs.LineReactivePower']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reactive_powers")

    @property
    @pulumi.getter(name="referenceResistance")
    def reference_resistance(self) -> pulumi.Output['outputs.LineReferenceResistance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "reference_resistance")

    @property
    @pulumi.getter
    def resistance(self) -> pulumi.Output['outputs.LineResistance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "resistance")

    @property
    @pulumi.getter(name="safetyMarginForPower")
    def safety_margin_for_power(self) -> pulumi.Output['outputs.LineSafetyMarginForPower']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "safety_margin_for_power")

    @property
    @pulumi.getter
    def susceptance(self) -> pulumi.Output['outputs.LineSusceptance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "susceptance")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.LineTag']]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="temperatureCoeffResistance")
    def temperature_coeff_resistance(self) -> pulumi.Output['outputs.LineTemperatureCoeffResistance']:
        """
        attribute of the resource
        """
        return pulumi.get(self, "temperature_coeff_resistance")

    @property
    @pulumi.getter(name="voltageRs")
    def voltage_rs(self) -> pulumi.Output[Sequence['outputs.LineVoltageR']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_rs")

    @property
    @pulumi.getter(name="voltageSts")
    def voltage_sts(self) -> pulumi.Output[Sequence['outputs.LineVoltageSt']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_sts")

    @property
    @pulumi.getter(name="voltageTrs")
    def voltage_trs(self) -> pulumi.Output[Sequence['outputs.LineVoltageTr']]:
        """
        attribute of the resource
        """
        return pulumi.get(self, "voltage_trs")

