# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[str],
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 machine_instance_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[str] version: [NAME-VERSION] the version of the hub server
        :param pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional description to add details of the resource
        :param pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]] env_vars: environment variables for the server
        :param pulumi.Input[str] log_level: log level of the server
        :param pulumi.Input[str] machine_instance_size: instance size
        :param pulumi.Input[str] name: the name of the server to be created
        :param pulumi.Input[str] node: id of the compute node where the server runs
        :param pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]] ports: ports of the server
        :param pulumi.Input[str] restart_policy: restart policy of the server
        :param pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]] tags: tags of the resource
        """
        pulumi.set(__self__, "version", version)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env_vars is not None:
            pulumi.set(__self__, "env_vars", env_vars)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if machine_instance_size is not None:
            pulumi.set(__self__, "machine_instance_size", machine_instance_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        [NAME-VERSION] the version of the hub server
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        optional description to add details of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="envVars")
    def env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]]:
        """
        environment variables for the server
        """
        return pulumi.get(self, "env_vars")

    @env_vars.setter
    def env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]]):
        pulumi.set(self, "env_vars", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        log level of the server
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="machineInstanceSize")
    def machine_instance_size(self) -> Optional[pulumi.Input[str]]:
        """
        instance size
        """
        return pulumi.get(self, "machine_instance_size")

    @machine_instance_size.setter
    def machine_instance_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_instance_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        the name of the server to be created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[str]]:
        """
        id of the compute node where the server runs
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]]:
        """
        ports of the server
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        restart policy of the server
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 machine_instance_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional description to add details of the resource
        :param pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]] env_vars: environment variables for the server
        :param pulumi.Input[str] log_level: log level of the server
        :param pulumi.Input[str] machine_instance_size: instance size
        :param pulumi.Input[str] name: the name of the server to be created
        :param pulumi.Input[str] node: id of the compute node where the server runs
        :param pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]] ports: ports of the server
        :param pulumi.Input[str] restart_policy: restart policy of the server
        :param pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]] tags: tags of the resource
        :param pulumi.Input[str] version: [NAME-VERSION] the version of the hub server
        """
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if env_vars is not None:
            pulumi.set(__self__, "env_vars", env_vars)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if machine_instance_size is not None:
            pulumi.set(__self__, "machine_instance_size", machine_instance_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        optional description to add details of the resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="envVars")
    def env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]]:
        """
        environment variables for the server
        """
        return pulumi.get(self, "env_vars")

    @env_vars.setter
    def env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerEnvVarArgs']]]]):
        pulumi.set(self, "env_vars", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        log level of the server
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="machineInstanceSize")
    def machine_instance_size(self) -> Optional[pulumi.Input[str]]:
        """
        instance size
        """
        return pulumi.get(self, "machine_instance_size")

    @machine_instance_size.setter
    def machine_instance_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_instance_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        the name of the server to be created
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[str]]:
        """
        id of the compute node where the server runs
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]]:
        """
        ports of the server
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        restart policy of the server
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        [NAME-VERSION] the version of the hub server
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerConfigArgs', 'ServerConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerEnvVarArgs', 'ServerEnvVarArgsDict']]]]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 machine_instance_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPortArgs', 'ServerPortArgsDict']]]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerTagArgs', 'ServerTagArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/server:Server [options] splight_server.<name> <server_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerConfigArgs', 'ServerConfigArgsDict']]]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional description to add details of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerEnvVarArgs', 'ServerEnvVarArgsDict']]]] env_vars: environment variables for the server
        :param pulumi.Input[str] log_level: log level of the server
        :param pulumi.Input[str] machine_instance_size: instance size
        :param pulumi.Input[str] name: the name of the server to be created
        :param pulumi.Input[str] node: id of the compute node where the server runs
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPortArgs', 'ServerPortArgsDict']]]] ports: ports of the server
        :param pulumi.Input[str] restart_policy: restart policy of the server
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerTagArgs', 'ServerTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[str] version: [NAME-VERSION] the version of the hub server
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import splight:index/server:Server [options] splight_server.<name> <server_id>
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerConfigArgs', 'ServerConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerEnvVarArgs', 'ServerEnvVarArgsDict']]]]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 machine_instance_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPortArgs', 'ServerPortArgsDict']]]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerTagArgs', 'ServerTagArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["configs"] = configs
            __props__.__dict__["description"] = description
            __props__.__dict__["env_vars"] = env_vars
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["machine_instance_size"] = machine_instance_size
            __props__.__dict__["name"] = name
            __props__.__dict__["node"] = node
            __props__.__dict__["ports"] = ports
            __props__.__dict__["restart_policy"] = restart_policy
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(Server, __self__).__init__(
            'splight:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerConfigArgs', 'ServerConfigArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerEnvVarArgs', 'ServerEnvVarArgsDict']]]]] = None,
            log_level: Optional[pulumi.Input[str]] = None,
            machine_instance_size: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerPortArgs', 'ServerPortArgsDict']]]]] = None,
            restart_policy: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerTagArgs', 'ServerTagArgsDict']]]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerConfigArgs', 'ServerConfigArgsDict']]]] configs: static config parameters of the routine
        :param pulumi.Input[str] description: optional description to add details of the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerEnvVarArgs', 'ServerEnvVarArgsDict']]]] env_vars: environment variables for the server
        :param pulumi.Input[str] log_level: log level of the server
        :param pulumi.Input[str] machine_instance_size: instance size
        :param pulumi.Input[str] name: the name of the server to be created
        :param pulumi.Input[str] node: id of the compute node where the server runs
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerPortArgs', 'ServerPortArgsDict']]]] ports: ports of the server
        :param pulumi.Input[str] restart_policy: restart policy of the server
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerTagArgs', 'ServerTagArgsDict']]]] tags: tags of the resource
        :param pulumi.Input[str] version: [NAME-VERSION] the version of the hub server
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["configs"] = configs
        __props__.__dict__["description"] = description
        __props__.__dict__["env_vars"] = env_vars
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["machine_instance_size"] = machine_instance_size
        __props__.__dict__["name"] = name
        __props__.__dict__["node"] = node
        __props__.__dict__["ports"] = ports
        __props__.__dict__["restart_policy"] = restart_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Optional[Sequence['outputs.ServerConfig']]]:
        """
        static config parameters of the routine
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        optional description to add details of the resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="envVars")
    def env_vars(self) -> pulumi.Output[Optional[Sequence['outputs.ServerEnvVar']]]:
        """
        environment variables for the server
        """
        return pulumi.get(self, "env_vars")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[Optional[str]]:
        """
        log level of the server
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="machineInstanceSize")
    def machine_instance_size(self) -> pulumi.Output[Optional[str]]:
        """
        instance size
        """
        return pulumi.get(self, "machine_instance_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        the name of the server to be created
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def node(self) -> pulumi.Output[Optional[str]]:
        """
        id of the compute node where the server runs
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Optional[Sequence['outputs.ServerPort']]]:
        """
        ports of the server
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> pulumi.Output[Optional[str]]:
        """
        restart policy of the server
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ServerTag']]]:
        """
        tags of the resource
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        [NAME-VERSION] the version of the hub server
        """
        return pulumi.get(self, "version")

