(v1.10.0)=
### 1.10.0 {small}`2024-03-26`

`scanpy` 1.10 brings a large amount of new features, performance improvements, and improved documentation.

Some highlights:

* Improved support for out-of-core workflows via `dask`. See new tutorial: {doc}`/tutorials/experimental/dask` demonstrating counts-to-clusters for 1.4 million cells in <10 min.
* A new {doc}`basic clustering tutorial </tutorials/basics/clustering>` demonstrating an updated workflow.
* Opt-in increased performance for neighbor search and clustering ({doc}`how to guide </how-to/knn-transformers>`).
* Ability to `mask` observations or variables from a number of methods (see {doc}`/tutorials/plotting/advanced` for an example with plotting embeddings)
* A new function {func}`~scanpy.get.aggregate` for computing aggregations of your data, very useful for pseudo bulking!

#### Features

* {func}`~scanpy.pp.scrublet` and {func}`~scanpy.pp.scrublet_simulate_doublets` were moved from {mod}`scanpy.external.pp` to {mod}`scanpy.pp`. The `scrublet` implementation is now maintained as part of scanpy {pr}`2703` {smaller}`P Angerer`
* {func}`scanpy.pp.pca`, {func}`scanpy.pp.scale`, {func}`scanpy.pl.embedding`, and {func}`scanpy.experimental.pp.normalize_pearson_residuals_pca` now support a `mask` parameter {pr}`2272` {smaller}`C Bright, T Marcella, & P Angerer`
* Enhanced dask support for some internal utilities, paving the way for more extensive dask support {pr}`2696` {smaller}`P Angerer`
* {func}`scanpy.pp.highly_variable_genes` supports dask for the default `seurat` and `cell_ranger` flavors {pr}`2809` {smaller}`P Angerer`
* New function {func}`scanpy.get.aggregate` which allows grouped aggregations over your data. Useful for pseudobulking! {pr}`2590` {smaller}`Isaac Virshup` {smaller}`Ilan Gold` {smaller}`Jon Bloom`
* {func}`scanpy.pp.neighbors` now has a `transformer` argument allowing the use of different ANN/ KNN libraries {pr}`2536` {smaller}`P Angerer`
* {func}`scanpy.experimental.pp.highly_variable_genes` using `flavor='pearson_residuals'` now uses numba for variance computation and is faster {pr}`2612` {smaller}`S Dicks & P Angerer`
* {func}`scanpy.tl.leiden` now offers `igraph`'s implementation of the leiden algorithm via  via `flavor` when set to `igraph`. `leidenalg`'s implementation is still default, but discouraged.  {pr}`2815` {smaller}`I Gold`
* {func}`scanpy.pp.highly_variable_genes` has new flavor `seurat_v3_paper` that is in its implementation consistent with the paper description in Stuart et al 2018. {pr}`2792` {smaller}`E Roellin`
* {func}`scanpy.datasets.blobs` now accepts a `random_state` argument {pr}`2683` {smaller}`E Roellin`
* {func}`scanpy.pp.pca` and {func}`scanpy.pp.regress_out` now accept a layer argument {pr}`2588` {smaller}`S Dicks`
* {func}`scanpy.pp.subsample` with `copy=True` can now be called in backed mode {pr}`2624` {smaller}`E Roellin`
* {func}`scanpy.external.pp.harmony_integrate` now runs with 64 bit floats improving reproducibility {pr}`2655` {smaller}`S Dicks`
* {func}`scanpy.tl.rank_genes_groups` no longer warns that it's default was changed from t-test_overestim_var to t-test {pr}`2798` {smaller}`L Heumos`
* `scanpy.pp.calculate_qc_metrics` now allows `qc_vars` to be passed as a string {pr}`2859` {smaller}`N Teyssier`
* {func}`scanpy.tl.leiden` and {func}`scanpy.tl.louvain` now store clustering parameters in the key provided by the `key_added` parameter instead of always writing to (or overwriting) a default key {pr}`2864` {smaller}`J Fan`
* {func}`scanpy.pp.scale` now clips `np.ndarray` also at `- max_value` for zero-centering {pr}`2913` {smaller}`S Dicks`
* Support sparse chunks in dask {func}`~scanpy.pp.scale`, {func}`~scanpy.pp.normalize_total` and {func}`~scanpy.pp.highly_variable_genes` (`seurat` and `cell-ranger` tested) {pr}`2856` {smaller}`ilan-gold`

#### Documentation

* Doc style overhaul {pr}`2220` {smaller}`A Gayoso`
* Re-add search-as-you-type, this time via `readthedocs-sphinx-search` {pr}`2805` {smaller}`P Angerer`
* Fixed a lot of broken usage examples {pr}`2605` {smaller}`P Angerer`
* Improved harmonization of return field of `sc.pp` and `sc.tl` functions {pr}`2742` {smaller}`E Roellin`
* Improved docs for `percent_top` argument of {func}`~scanpy.pp.calculate_qc_metrics` {pr}`2849` {smaller}`I Virshup`
* New basic clustering tutorial ({doc}`/tutorials/basics/clustering`), based on one from [scverse-tutorials](https://scverse-tutorials.readthedocs.io/en/latest/notebooks/basic-scrna-tutorial.html) {pr}`2901` {smaller}`I Virshup`
* Overhauled {doc}`/tutorials/index` page, and added new {doc}`/how-to/index` section to docs {pr}`2901` {smaller}`I Virshup`
* Added a new tutorial on working with dask ({doc}`/tutorials/experimental/dask`) {pr}`2901` {smaller}`I Gold` {smaller}`I Virshup`

#### Bug fixes

* Updated {func}`~scanpy.read_visium` such that it can read spaceranger 2.0 files {smaller}`L Lehner`
* Fix {func}`~scanpy.pp.normalize_total` for dask {pr}`2466` {smaller}`P Angerer`
* Fix setting :attr:`scanpy.settings.verbosity` in some cases {pr}`2605` {smaller}`P Angerer`
* Fix all remaining pandas warnings {pr}`2789` {smaller}`P Angerer`
* Fix some annoying plotting warnings around violin plots {pr}`2844` {smaller}`P Angerer`
* Scanpy now has a test job which tests against the minumum versions of the dependencies. In the process of implementing this, many bugs associated with using older versions of `pandas`, `anndata`, `numpy`, and `matplotlib` were fixed. {pr}`2816` {smaller}`I Virshup`
* Fix warnings caused by internal usage of `pandas.DataFrame.stack` with `pandas>=2.1` {pr}`2864`{smaller}`I Virshup`
* {func}`scanpy.get.aggregate` now always returns {class}`numpy.ndarray` {pr}`2893` {smaller}`S Dicks`
* Removes self from array of neighbors for `use_approx_neighbors = True` in {func}`~scanpy.pp.scrublet` {pr}`2896`{smaller}`S Dicks`
* Compatibility with scipy 1.13 {pr}`2943` {smaller}`I Virshup`
* Fix use of {func}`~scanpy.tl.dendrogram` on highly correlated low precision data {pr}`2928` {smaller}`P Angerer`
* Fix pytest deprecation warning {pr}`2879` {smaller}`P Angerer`


#### Development Process

* Scanpy is now tested against python 3.12 {pr}`2863` {smaller}`ivirshup`
* Fix testing package build {pr}`2468` {smaller}`P Angerer`

#### Deprecations

* Dropped support for Python 3.8. [More details here](https://numpy.org/neps/nep-0029-deprecation_policy.html). {pr}`2695` {smaller}`P Angerer`
* Deprecated specifying large numbers of function parameters by position as opposed to by name/keyword in all public APIs.
  e.g. prefer `sc.tl.umap(adata, min_dist=0.1, spread=0.8)` over `sc.tl.umap(adata, 0.1, 0.8)` {pr}`2702` {smaller}`P Angerer`
* Dropped support for `umap<0.5` for performance reasons. {pr}`2870` {smaller}`P Angerer`
