(v1.9.0)=
### 1.9.0 {small}`2022-04-01`

#### Tutorials

- New tutorial on the usage of Pearson Residuals: {doc}`/tutorials/experimental/pearson_residuals` {smaller}`J Lause, G Palla`
- [Materials](https://github.com/scverse/scanpy-tutorials/tree/master/scanpy_workshop) and [recordings](https://www.youtube.com/playlist?list=PL4rcQcNPLZxWQQH7LlRBMkAo5NWuHX1e3) for Scanpy workshops by Maren Büttner

#### Experimental module

- Added {mod}`scanpy.experimental` module! Currently contains functionality related to pearson residuals in {mod}`scanpy.experimental.pp` {pr}`1715` {smaller}`J Lause, G Palla, I Virshup`. This includes:

  - {func}`~scanpy.experimental.pp.normalize_pearson_residuals` for Pearson Residuals normalization
  - {func}`~scanpy.experimental.pp.highly_variable_genes` for HVG selection with Pearson Residuals
  - {func}`~scanpy.experimental.pp.normalize_pearson_residuals_pca` for Pearson Residuals normalization and dimensionality reduction with PCA
  - {func}`~scanpy.experimental.pp.recipe_pearson_residuals` for Pearson Residuals normalization, HVG selection and dimensionality reduction with PCA

#### Features

- {func}`~scanpy.tl.filter_rank_genes_groups` now allows to filter with absolute values of log fold change {pr}`1649` {smaller}`S Rybakov`
- `_choose_representation` now subsets the provided representation to n_pcs, regardless of the name of the provided representation (should affect mostly {func}`~scanpy.pp.neighbors`)  {pr}`2179`  {smaller}`I Virshup` {smaller}`PG Majev`
- {func}`scanpy.pp.scrublet` (and related functions) can now be used on `AnnData` objects containing multiple batches {pr}`1965` {smaller}`J Manning`
- Number of variables plotted with {func}`~scanpy.pl.pca_loadings` can now be controlled with `n_points` argument. Additionally, variables are no longer repeated if the anndata has less than 30 variables {pr}`2075` {smaller}`Yves33`
- Dask arrays now work with {func}`scanpy.pp.normalize_total` {pr}`1663` {smaller}`G Buckley, I Virshup`
- {func}`~scanpy.pl.embedding_density` now allows more than 10 groups {pr}`1936` {smaller}`A Wolf`
- Embedding plots can now pass `colorbar_loc` to specify the location of colorbar legend, or pass `None` to not show a colorbar {pr}`1821` {smaller}`A Schaar` {smaller}`I Virshup`
- Embedding plots now have a `dimensions` argument, which lets users select which dimensions of their embedding to plot and uses the same broadcasting rules as other arguments {pr}`1538` {smaller}`I Virshup`
- {func}`~scanpy.logging.print_versions` now uses `session_info` {pr}`2089` {smaller}`P Angerer` {smaller}`I Virshup`

#### Ecosystem

Multiple packages have been added to our ecosystem page, including:

- [decoupler](https://github.com/saezlab/decoupler-py) a for footprint analysis and pathway enrichement {pr}`2186` {smaller}`PB Mompel`
- [dandelion](https://github.com/zktuong/dandelion) for B-cell receptor analysis {pr}`1953` {smaller}`Z Tuong`
- [CIARA](https://github.com/ScialdoneLab/CIARA_python) a feature selection tools for identifying rare cell types {pr}`2175` {smaller}`M Stock`

#### Bug fixes

- Fixed finding variables with `use_raw=True` and `basis=None` in {func}`scanpy.pl.scatter` {pr}`2027` {smaller}`E Rice`
- Fixed {func}`scanpy.pp.scrublet` to address {issue}`1957` {smaller}`FlMai` and ensure raw counts are used for simulation
- Functions in {mod}`scanpy.datasets` no longer throw `OldFormatWarnings` when using `anndata` `0.8` {pr}`2096` {smaller}`I Virshup`
- Fixed use of {func}`scanpy.pp.neighbors` with `method='rapids'`: RAPIDS cuML no longer returns a squared Euclidean distance matrix, so we should not square-root the kNN distance matrix. {pr}`1828` {smaller}`M Zaslavsky`
- Removed `pytables` dependency by implementing `read_10x_h5` with `h5py` due to installation errors on Windows {pr}`2064`
- Fixed bug in {func}`scanpy.external.pp.hashsolo` where default value was set improperly {pr}`2190` {smaller}`B Reiz`
- Fixed bug in {func}`scanpy.pl.embedding` functions where an error could be raised when there were missing values and large numbers of categories {pr}`2187` {smaller}`I Virshup`
