"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.execSync = void 0;
const child = require("child_process");
function execSync(command, options = {}) {
    try {
        child.execSync(command, { cwd: options.cwd, env: options.env });
    }
    catch (err) {
        const message = [`Command failed: ${command}`];
        if (err.stderr) {
            message.push('STDERR:');
            message.push('\n');
            message.push('\n');
            message.push(err.stderr.toString().trim());
        }
        if (err.stdout) {
            message.push('STDOUT:');
            message.push('\n');
            message.push('\n');
            message.push(err.stdout.toString().trim());
        }
        throw new Error(message.join('\n\n'));
    }
}
exports.execSync = execSync;
//# sourceMappingURL=data:application/json;base64,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