# Code of conduct

The IMDClient *Code of Conduct* sets the rules for the behavior of
every member in the IMDClient community so that everyone can
experience a welcoming, supportive, and productive environment that is
free from harassment.

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-generate-toc again -->
**Table of Contents**

- [Code of conduct](#code-of-conduct)
  - [Code of Conduct and Community Guidelines](#code-of-conduct-and-community-guidelines)
  - [Scope](#scope)
  - [Enforcement](#enforcement)
  - [Acknowledgment](#acknowledgment)

<!-- markdown-toc end -->
## Code of Conduct and Community Guidelines

IMDClient is part of an engaged and respectful community made up of people from all
over the world. Your involvement helps us to further our mission and to create
an open platform that serves a broad range of communities, from research and
education to industry and beyond. This diversity is one of our biggest
strengths, but it can also lead to communication issues and conflicts.
Therefore, we have a few ground rules we ask that our community members adhere
to.

Fundamentally, we are committed to providing a productive,
harassment-free environment for everyone. Rather than considering this
code an exhaustive list of things that you can’t do, take it in the
spirit it is intended - a guide to make it easier to enrich all of us
and the communities in which we participate.

Importantly: as a member of our community, you are also a steward of these
values. Not all problems need to be resolved via formal processes, and often a
quick, friendly but clear word on an online forum or in person can help resolve
a misunderstanding and de-escalate things.

By embracing the following principles, guidelines and actions to follow or
avoid, you will help us make IMDClient a welcoming and productive community.

1. **Be friendly and patient**.

2. **Be welcoming**. We strive to be a community that welcomes and supports
   people of all backgrounds and identities. This includes, but is not limited
   to, members of any race, ethnicity, culture, national origin, color,
   immigration status, social and economic class, educational level, sex, sexual
   orientation, gender identity and expression, age, physical appearance, family
   status, political belief, technological or professional choices, academic
   discipline, religion, mental ability, and physical ability.

3. **Be considerate**. Your work will be used by other people, and you in turn
   will depend on the work of others. Any decision you take will affect users
   and colleagues, and you should take those consequences into account when
   making decisions. Remember that we're a world-wide community. You may be
   communicating with someone with a different primary language or cultural
   background.

4. **Be respectful**. Not all of us will agree all the time, but disagreement is
   no excuse for poor behavior or poor manners. We might all experience some
   frustration now and then, but we cannot allow that frustration to turn into a
   personal attack. It’s important to remember that a community where people
   feel uncomfortable or threatened is not a productive one.

5. **Be careful in the words that you choose**. Be kind to others. Do not insult
   or put down other community members. Harassment and other exclusionary
   behavior are not acceptable. This includes, but is not limited to:
   * threats or violent language directed against another person
   * discriminatory jokes and language
   * posting sexually explicit or violent material
   * posting (or threatening to post) other people's personally identifying
     information ("doxing")
   * personal insults, especially those using racist or sexist terms
   * unwelcome sexual attention
   * advocating for, or encouraging, any of the above behavior
   * repeated harassment of others. In general, if someone asks you to stop,
     then stop

6. **Moderate your expectations**. Many in our community volunteer their time.
   They are probably not purposefully ignoring issues, refusing to engage in
   discussion, avoiding features, etc. but often just unavailable.

7. **When we disagree, try to understand why**. Disagreements, both social and
   technical, happen all the time and IMDClient is no exception. It is important
   that we resolve disagreements and differing views constructively. Remember
   that we’re different. The strength of IMDClient comes from its varied community
   that includes people from a wide range of backgrounds. Different people have
   different perspectives on issues. Being unable to understand why someone
   holds a viewpoint doesn’t mean they’re wrong. Don’t forget that it is human
   to err and blaming each other doesn’t get us anywhere. Instead, focus on
   helping to resolve issues and learning from mistakes.

8. **A simple apology can go a long way**. It can often de-escalate a situation,
   and telling someone that you are sorry is act of empathy that doesn’t
   automatically imply an admission of guilt.


## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an
appointed representative at an online or offline event. Representation of a
project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at 'ljwoods2@asu.edu'. The project team will
review and investigate all complaints, and will respond in a way that it deems
appropriate to the circumstances. The project team is obligated to maintain
confidentiality with regard to the reporter of an incident. Further details of
specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.


## Acknowledgment

Original text was adapted from
the
[*Speak Up!*](http://web.archive.org/web/20141109123859/http://speakup.io/coc.html),
[*Django*](https://www.djangoproject.com/conduct),
[*Contributor Covenant*](http://contributor-covenant.org/),
[*Jupyter*](https://github.com/jupyter/governance/blob/master/conduct/code_of_conduct.md),
[*MolSSI*](https://github.com/MolSSI/cookiecutter-cms/blob/master/%7B%7Bcookiecutter.repo_name%7D%7D/CODE_OF_CONDUCT.md),
and [*MDAnalysis*](https://github.com/MDAnalysis/mdanalysis/blob/develop/CODE_OF_CONDUCT.md) projects,
modified by IMDClient.
We are grateful to those projects for contributing these
materials under open licensing terms for us to easily reuse.

All content on this page is licensed under a [*Creative Commons
Attribution*](http://creativecommons.org/licenses/by/3.0/) license. 
