# d361api
Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more. 

You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://document360.io/contact-us/](https://document360.io/contact-us/)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/twardoch/d361api.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/twardoch/d361api.git`)

Then import the package:
```python
import d361api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import d361api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import d361api
from d361api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://apihub.document360.io
# See configuration.py for a list of all supported configuration parameters.
configuration = d361api.Configuration(
    host = "https://apihub.document360.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: api_token
configuration.api_key['api_token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_token'] = 'Bearer'


# Enter a context with an instance of the API client
async with d361api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = d361api.APIReferencesApi(api_client)
    api_reference_id = 'api_reference_id_example' # str | The ID of the API reference
    page = 1 # int | Page number (optional) (default to 1)
    results_per_page = 5 # int | Total logs per page (optional) (default to 5)

    try:
        # Get all API reference logs
        api_response = await api_instance.v2_api_references_api_reference_id_logs_get(api_reference_id, page=page, results_per_page=results_per_page)
        print("The response of APIReferencesApi->v2_api_references_api_reference_id_logs_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIReferencesApi->v2_api_references_api_reference_id_logs_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://apihub.document360.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIReferencesApi* | [**v2_api_references_api_reference_id_logs_get**](docs/APIReferencesApi.md#v2_api_references_api_reference_id_logs_get) | **GET** /v2/APIReferences/{apiReferenceId}/Logs | Get all API reference logs
*APIReferencesApi* | [**v2_api_references_api_reference_id_logs_log_id_get**](docs/APIReferencesApi.md#v2_api_references_api_reference_id_logs_log_id_get) | **GET** /v2/APIReferences/{apiReferenceId}/Logs/{logId} | Get errors and alerts of a log
*APIReferencesApi* | [**v2_api_references_delete**](docs/APIReferencesApi.md#v2_api_references_delete) | **DELETE** /v2/APIReferences | Deletes an API reference
*APIReferencesApi* | [**v2_api_references_post**](docs/APIReferencesApi.md#v2_api_references_post) | **POST** /v2/APIReferences | Import the API reference spec file
*APIReferencesApi* | [**v2_api_references_publish_post**](docs/APIReferencesApi.md#v2_api_references_publish_post) | **POST** /v2/APIReferences/publish | Publishes an API reference
*APIReferencesApi* | [**v2_api_references_put**](docs/APIReferencesApi.md#v2_api_references_put) | **PUT** /v2/APIReferences | Resync the API reference spec file
*ArticlesApi* | [**v2_articles_article_id_delete**](docs/ArticlesApi.md#v2_articles_article_id_delete) | **DELETE** /v2/Articles/{articleId} | Deletes an article with an ID
*ArticlesApi* | [**v2_articles_article_id_fork_put**](docs/ArticlesApi.md#v2_articles_article_id_fork_put) | **PUT** /v2/Articles/{articleId}/fork | Forks an article with an id
*ArticlesApi* | [**v2_articles_article_id_lang_code_get**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_get) | **GET** /v2/Articles/{articleId}/{langCode} | Gets an article
*ArticlesApi* | [**v2_articles_article_id_lang_code_publish_delete**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_publish_delete) | **DELETE** /v2/Articles/{articleId}/{langCode}/publish | Unpublishes an article with an id
*ArticlesApi* | [**v2_articles_article_id_lang_code_publish_post**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_publish_post) | **POST** /v2/Articles/{articleId}/{langCode}/publish | Publishes an article with an id
*ArticlesApi* | [**v2_articles_article_id_lang_code_put**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_put) | **PUT** /v2/Articles/{articleId}/{langCode} | Updates an article with the ID
*ArticlesApi* | [**v2_articles_article_id_lang_code_settings_get**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_settings_get) | **GET** /v2/Articles/{articleId}/{langCode}/settings | Gets settings for the article
*ArticlesApi* | [**v2_articles_article_id_lang_code_settings_put**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_settings_put) | **PUT** /v2/Articles/{articleId}/{langCode}/settings | Updates settings for the article
*ArticlesApi* | [**v2_articles_article_id_lang_code_update_description_put**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_update_description_put) | **PUT** /v2/Articles/{articleId}/{langCode}/updateDescription | Update the Article Description
*ArticlesApi* | [**v2_articles_article_id_lang_code_version_version_number_delete**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_version_version_number_delete) | **DELETE** /v2/Articles/{articleId}/{langCode}/version/{versionNumber} | Deletes an article version
*ArticlesApi* | [**v2_articles_article_id_lang_code_versions_get**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_versions_get) | **GET** /v2/Articles/{articleId}/{langCode}/versions | Gets all article versions
*ArticlesApi* | [**v2_articles_article_id_lang_code_versions_version_number_get**](docs/ArticlesApi.md#v2_articles_article_id_lang_code_versions_version_number_get) | **GET** /v2/Articles/{articleId}/{langCode}/versions/{versionNumber} | Gets article by a version number
*ArticlesApi* | [**v2_articles_article_id_publish_post**](docs/ArticlesApi.md#v2_articles_article_id_publish_post) | **POST** /v2/Articles/{articleId}/publish | Publishes an article with an id
*ArticlesApi* | [**v2_articles_article_id_settings_get**](docs/ArticlesApi.md#v2_articles_article_id_settings_get) | **GET** /v2/Articles/{articleId}/settings | Gets settings for the article
*ArticlesApi* | [**v2_articles_article_id_settings_put**](docs/ArticlesApi.md#v2_articles_article_id_settings_put) | **PUT** /v2/Articles/{articleId}/settings | Updates settings for the article
*ArticlesApi* | [**v2_articles_article_id_update_description_put**](docs/ArticlesApi.md#v2_articles_article_id_update_description_put) | **PUT** /v2/Articles/{articleId}/updateDescription | Update the Article Description
*ArticlesApi* | [**v2_articles_article_id_version_version_number_delete**](docs/ArticlesApi.md#v2_articles_article_id_version_version_number_delete) | **DELETE** /v2/Articles/{articleId}/version/{versionNumber} | Deletes an article version
*ArticlesApi* | [**v2_articles_article_id_versions_get**](docs/ArticlesApi.md#v2_articles_article_id_versions_get) | **GET** /v2/Articles/{articleId}/versions | Gets all article versions
*ArticlesApi* | [**v2_articles_article_id_versions_version_number_get**](docs/ArticlesApi.md#v2_articles_article_id_versions_version_number_get) | **GET** /v2/Articles/{articleId}/versions/{versionNumber} | Gets article by a version number
*ArticlesApi* | [**v2_articles_bulkcreate_post**](docs/ArticlesApi.md#v2_articles_bulkcreate_post) | **POST** /v2/Articles/bulkcreate | Adds multiple articles
*ArticlesApi* | [**v2_articles_bulkdelete_article_versions_delete**](docs/ArticlesApi.md#v2_articles_bulkdelete_article_versions_delete) | **DELETE** /v2/Articles/bulkdelete-article-versions | Delete multiple article versions
*ArticlesApi* | [**v2_articles_bulkdelete_delete**](docs/ArticlesApi.md#v2_articles_bulkdelete_delete) | **DELETE** /v2/Articles/bulkdelete | Deletes multiple articles
*ArticlesApi* | [**v2_articles_bulkpublish_lang_code_delete**](docs/ArticlesApi.md#v2_articles_bulkpublish_lang_code_delete) | **DELETE** /v2/Articles/bulkpublish/{langCode} | Unpublishes multiple articles
*ArticlesApi* | [**v2_articles_bulkpublish_lang_code_post**](docs/ArticlesApi.md#v2_articles_bulkpublish_lang_code_post) | **POST** /v2/Articles/bulkpublish/{langCode} | Publishes multiple articles
*ArticlesApi* | [**v2_articles_bulkupdate_put**](docs/ArticlesApi.md#v2_articles_bulkupdate_put) | **PUT** /v2/Articles/bulkupdate | Updates multiple articles
*ArticlesApi* | [**v2_articles_post**](docs/ArticlesApi.md#v2_articles_post) | **POST** /v2/Articles | Adds an article to an existing category
*ArticlesApi* | [**v2_articles_update_workflow_post**](docs/ArticlesApi.md#v2_articles_update_workflow_post) | **POST** /v2/Articles/update-workflow | Update workflow status of the articles
*CategoriesApi* | [**v2_categories_bulkcreate_post**](docs/CategoriesApi.md#v2_categories_bulkcreate_post) | **POST** /v2/Categories/bulkcreate | Adds multiple Categories
*CategoriesApi* | [**v2_categories_bulkdelete_category_versions_delete**](docs/CategoriesApi.md#v2_categories_bulkdelete_category_versions_delete) | **DELETE** /v2/Categories/bulkdelete-category-versions | Delete multiple category versions
*CategoriesApi* | [**v2_categories_bulkpublish_lang_code_delete**](docs/CategoriesApi.md#v2_categories_bulkpublish_lang_code_delete) | **DELETE** /v2/Categories/bulkpublish/{langCode} | Unpublishes multiple categories
*CategoriesApi* | [**v2_categories_bulkpublish_lang_code_post**](docs/CategoriesApi.md#v2_categories_bulkpublish_lang_code_post) | **POST** /v2/Categories/bulkpublish/{langCode} | Publishes multiple categories
*CategoriesApi* | [**v2_categories_bulkupdate_content_put**](docs/CategoriesApi.md#v2_categories_bulkupdate_content_put) | **PUT** /v2/Categories/bulkupdateContent | Update multiple page categories
*CategoriesApi* | [**v2_categories_category_id_content_lang_code_get**](docs/CategoriesApi.md#v2_categories_category_id_content_lang_code_get) | **GET** /v2/Categories/{categoryId}/content/{langCode} | Get category page with an ID
*CategoriesApi* | [**v2_categories_category_id_content_lang_code_put**](docs/CategoriesApi.md#v2_categories_category_id_content_lang_code_put) | **PUT** /v2/Categories/{categoryId}/content/{langCode} | Update a category page content with the ID
*CategoriesApi* | [**v2_categories_category_id_delete**](docs/CategoriesApi.md#v2_categories_category_id_delete) | **DELETE** /v2/Categories/{categoryId} | Deletes an category with an ID
*CategoriesApi* | [**v2_categories_category_id_fork_put**](docs/CategoriesApi.md#v2_categories_category_id_fork_put) | **PUT** /v2/Categories/{categoryId}/fork | Fork category page with an id
*CategoriesApi* | [**v2_categories_category_id_get**](docs/CategoriesApi.md#v2_categories_category_id_get) | **GET** /v2/Categories/{categoryId} | Get category with an ID
*CategoriesApi* | [**v2_categories_category_id_lang_code_publish_delete**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_publish_delete) | **DELETE** /v2/Categories/{categoryId}/{langCode}/publish | Unpublishes a page category with an id
*CategoriesApi* | [**v2_categories_category_id_lang_code_publish_post**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_publish_post) | **POST** /v2/Categories/{categoryId}/{langCode}/publish | Publishes an category with an id
*CategoriesApi* | [**v2_categories_category_id_lang_code_settings_get**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_settings_get) | **GET** /v2/Categories/{categoryId}/{langCode}/settings | Get settings for the Category
*CategoriesApi* | [**v2_categories_category_id_lang_code_settings_put**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_settings_put) | **PUT** /v2/Categories/{categoryId}/{langCode}/settings | Update settings for the category
*CategoriesApi* | [**v2_categories_category_id_lang_code_update_description_put**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_update_description_put) | **PUT** /v2/Categories/{categoryId}/{langCode}/updateDescription | Update the category description
*CategoriesApi* | [**v2_categories_category_id_lang_code_version_version_number_delete**](docs/CategoriesApi.md#v2_categories_category_id_lang_code_version_version_number_delete) | **DELETE** /v2/Categories/{categoryId}/{langCode}/version/{versionNumber} | Delete category Version
*CategoriesApi* | [**v2_categories_category_id_lang_codeversions_get**](docs/CategoriesApi.md#v2_categories_category_id_lang_codeversions_get) | **GET** /v2/Categories/{categoryId}/{langCode}versions | Get category page versions
*CategoriesApi* | [**v2_categories_category_id_publish_post**](docs/CategoriesApi.md#v2_categories_category_id_publish_post) | **POST** /v2/Categories/{categoryId}/publish | Publishes an category with an id
*CategoriesApi* | [**v2_categories_category_id_put**](docs/CategoriesApi.md#v2_categories_category_id_put) | **PUT** /v2/Categories/{categoryId} | Update a category with the ID
*CategoriesApi* | [**v2_categories_category_id_settings_get**](docs/CategoriesApi.md#v2_categories_category_id_settings_get) | **GET** /v2/Categories/{categoryId}/settings | Get settings for the Category
*CategoriesApi* | [**v2_categories_category_id_settings_put**](docs/CategoriesApi.md#v2_categories_category_id_settings_put) | **PUT** /v2/Categories/{categoryId}/settings | Update settings for the category
*CategoriesApi* | [**v2_categories_category_id_update_category_type_put**](docs/CategoriesApi.md#v2_categories_category_id_update_category_type_put) | **PUT** /v2/Categories/{categoryId}/updateCategoryType | Update the Category Type
*CategoriesApi* | [**v2_categories_category_id_update_description_put**](docs/CategoriesApi.md#v2_categories_category_id_update_description_put) | **PUT** /v2/Categories/{categoryId}/updateDescription | Update the category description
*CategoriesApi* | [**v2_categories_category_id_version_version_number_delete**](docs/CategoriesApi.md#v2_categories_category_id_version_version_number_delete) | **DELETE** /v2/Categories/{categoryId}/version/{versionNumber} | Delete category Version
*CategoriesApi* | [**v2_categories_category_id_versions_get**](docs/CategoriesApi.md#v2_categories_category_id_versions_get) | **GET** /v2/Categories/{categoryId}/versions | Get category page versions
*CategoriesApi* | [**v2_categories_category_id_versions_lang_code_version_number_get**](docs/CategoriesApi.md#v2_categories_category_id_versions_lang_code_version_number_get) | **GET** /v2/Categories/{categoryId}/versions/{langCode}/{versionNumber} | Get category page content with an ID
*CategoriesApi* | [**v2_categories_category_id_versions_version_number_get**](docs/CategoriesApi.md#v2_categories_category_id_versions_version_number_get) | **GET** /v2/Categories/{categoryId}/versions/{versionNumber} | Get category page content with an ID
*CategoriesApi* | [**v2_categories_post**](docs/CategoriesApi.md#v2_categories_post) | **POST** /v2/Categories | Adds a new category
*CategoriesApi* | [**v2_categories_update_workflow_post**](docs/CategoriesApi.md#v2_categories_update_workflow_post) | **POST** /v2/Categories/update-workflow | Update workflow status of the page categories
*DriveApi* | [**v2_drive_folders_delete_file_status_task_id_get**](docs/DriveApi.md#v2_drive_folders_delete_file_status_task_id_get) | **GET** /v2/Drive/Folders/DeleteFile/Status/{taskId} | Get status of the delete file operation
*DriveApi* | [**v2_drive_folders_files_post**](docs/DriveApi.md#v2_drive_folders_files_post) | **POST** /v2/Drive/Folders/Files | Add file in to drive
*DriveApi* | [**v2_drive_folders_folder_id_delete**](docs/DriveApi.md#v2_drive_folders_folder_id_delete) | **DELETE** /v2/Drive/Folders/{folderId} | Delete a folder
*DriveApi* | [**v2_drive_folders_folder_id_file_id_copy_post**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_copy_post) | **POST** /v2/Drive/Folders/{folderId}/{fileId}/Copy | Copy file from one folder to another
*DriveApi* | [**v2_drive_folders_folder_id_file_id_delete**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_delete) | **DELETE** /v2/Drive/Folders/{folderId}/{fileId} | Delete file using file ID
*DriveApi* | [**v2_drive_folders_folder_id_file_id_get**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_get) | **GET** /v2/Drive/Folders/{folderId}/{fileId} | Gets file information
*DriveApi* | [**v2_drive_folders_folder_id_file_id_put**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_put) | **PUT** /v2/Drive/Folders/{folderId}/{fileId} | Move a file with file ID
*DriveApi* | [**v2_drive_folders_folder_id_file_id_tags_bulkdelete_post**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_tags_bulkdelete_post) | **POST** /v2/Drive/Folders/{folderId}/{fileId}/Tags/Bulkdelete | Delete tags from files
*DriveApi* | [**v2_drive_folders_folder_id_file_id_tags_post**](docs/DriveApi.md#v2_drive_folders_folder_id_file_id_tags_post) | **POST** /v2/Drive/Folders/{folderId}/{fileId}/Tags | Add tags in a file using file ID
*DriveApi* | [**v2_drive_folders_folder_id_get**](docs/DriveApi.md#v2_drive_folders_folder_id_get) | **GET** /v2/Drive/Folders/{folderId} | Gets folder information by folder ID
*DriveApi* | [**v2_drive_folders_get**](docs/DriveApi.md#v2_drive_folders_get) | **GET** /v2/Drive/Folders | Gets folders information
*DriveApi* | [**v2_drive_folders_post**](docs/DriveApi.md#v2_drive_folders_post) | **POST** /v2/Drive/Folders | Add new folder in drive
*DriveApi* | [**v2_drive_folders_put**](docs/DriveApi.md#v2_drive_folders_put) | **PUT** /v2/Drive/Folders | Update a folder with ID
*DriveApi* | [**v2_drive_media_files_project_version_id_article_id_lang_code_get**](docs/DriveApi.md#v2_drive_media_files_project_version_id_article_id_lang_code_get) | **GET** /v2/Drive/MediaFiles/{projectVersionId}/{articleId}/{langCode} | Get all media files inserted in the article
*DriveApi* | [**v2_drive_search_get**](docs/DriveApi.md#v2_drive_search_get) | **GET** /v2/Drive/Search | Drive search - files and folders
*LanguageApi* | [**v2_language_project_version_id_get**](docs/LanguageApi.md#v2_language_project_version_id_get) | **GET** /v2/Language/{projectVersionId} | Gets all version languages in the project
*ProjectApi* | [**v2_project_export_export_id_get**](docs/ProjectApi.md#v2_project_export_export_id_get) | **GET** /v2/Project/Export/{exportId} | Get the status of export
*ProjectApi* | [**v2_project_export_post**](docs/ProjectApi.md#v2_project_export_post) | **POST** /v2/Project/Export | Start a new export
*ProjectApi* | [**v2_project_import_import_id_get**](docs/ProjectApi.md#v2_project_import_import_id_get) | **GET** /v2/Project/Import/{importId} | Get the status of import
*ProjectApi* | [**v2_project_import_post**](docs/ProjectApi.md#v2_project_import_post) | **POST** /v2/Project/Import | Import documentation
*ProjectApi* | [**v2_project_schemes_get**](docs/ProjectApi.md#v2_project_schemes_get) | **GET** /v2/Project/Schemes | Get all the schemes for the project
*ProjectApi* | [**v2_project_workflow_statuses_get**](docs/ProjectApi.md#v2_project_workflow_statuses_get) | **GET** /v2/Project/workflow-statuses | Gets all workflow statuses for a project
*ProjectVersionsApi* | [**v2_project_versions_ask_ai_feedback_post**](docs/ProjectVersionsApi.md#v2_project_versions_ask_ai_feedback_post) | **POST** /v2/ProjectVersions/ask-ai-feedback | Provide feedback for AI assistive search
*ProjectVersionsApi* | [**v2_project_versions_ask_eddy_post**](docs/ProjectVersionsApi.md#v2_project_versions_ask_eddy_post) | **POST** /v2/ProjectVersions/ask-eddy | Perform AI assistive search within project version
*ProjectVersionsApi* | [**v2_project_versions_get**](docs/ProjectVersionsApi.md#v2_project_versions_get) | **GET** /v2/ProjectVersions | Gets list of project versions
*ProjectVersionsApi* | [**v2_project_versions_project_version_id_apireferences_get**](docs/ProjectVersionsApi.md#v2_project_versions_project_version_id_apireferences_get) | **GET** /v2/ProjectVersions/{projectVersionId}/apireferences | Gets list of api reference within project version
*ProjectVersionsApi* | [**v2_project_versions_project_version_id_articles_get**](docs/ProjectVersionsApi.md#v2_project_versions_project_version_id_articles_get) | **GET** /v2/ProjectVersions/{projectVersionId}/articles | Gets list of articles within project version
*ProjectVersionsApi* | [**v2_project_versions_project_version_id_categories_get**](docs/ProjectVersionsApi.md#v2_project_versions_project_version_id_categories_get) | **GET** /v2/ProjectVersions/{projectVersionId}/categories | Gets list of categories within project version
*ProjectVersionsApi* | [**v2_project_versions_project_version_id_lang_code_get**](docs/ProjectVersionsApi.md#v2_project_versions_project_version_id_lang_code_get) | **GET** /v2/ProjectVersions/{projectVersionId}/{langCode} | Searches for a phrase inside project version
*ReadersApi* | [**v2_readers_get**](docs/ReadersApi.md#v2_readers_get) | **GET** /v2/Readers | Get all available readers from the project
*ReadersApi* | [**v2_readers_groups_get**](docs/ReadersApi.md#v2_readers_groups_get) | **GET** /v2/Readers/groups | Get all reader groups
*ReadersApi* | [**v2_readers_groups_group_id_delete**](docs/ReadersApi.md#v2_readers_groups_group_id_delete) | **DELETE** /v2/Readers/groups/{groupId} | Deletes a reader group
*ReadersApi* | [**v2_readers_groups_group_id_get**](docs/ReadersApi.md#v2_readers_groups_group_id_get) | **GET** /v2/Readers/groups/{groupId} | Get a reader group via group id
*ReadersApi* | [**v2_readers_groups_group_id_put**](docs/ReadersApi.md#v2_readers_groups_group_id_put) | **PUT** /v2/Readers/groups/{groupId} | Updates a reader group
*ReadersApi* | [**v2_readers_groups_post**](docs/ReadersApi.md#v2_readers_groups_post) | **POST** /v2/Readers/groups | Add a new reader group
*ReadersApi* | [**v2_readers_jwt_delete**](docs/ReadersApi.md#v2_readers_jwt_delete) | **DELETE** /v2/Readers/JWT | Deletes JWT readers from the project
*ReadersApi* | [**v2_readers_post**](docs/ReadersApi.md#v2_readers_post) | **POST** /v2/Readers | Add a new reader
*ReadersApi* | [**v2_readers_reader_id_delete**](docs/ReadersApi.md#v2_readers_reader_id_delete) | **DELETE** /v2/Readers/{readerId} | Deletes a reader from the project
*ReadersApi* | [**v2_readers_reader_id_put**](docs/ReadersApi.md#v2_readers_reader_id_put) | **PUT** /v2/Readers/{readerId} | Updates a reader
*TeamsApi* | [**v2_teams_email_exists_get**](docs/TeamsApi.md#v2_teams_email_exists_get) | **GET** /v2/Teams/email-exists | Checks if email already exists in the project
*TeamsApi* | [**v2_teams_get**](docs/TeamsApi.md#v2_teams_get) | **GET** /v2/Teams | Get all team accounts
*TeamsApi* | [**v2_teams_groups_get**](docs/TeamsApi.md#v2_teams_groups_get) | **GET** /v2/Teams/groups | Get all user groups
*TeamsApi* | [**v2_teams_post**](docs/TeamsApi.md#v2_teams_post) | **POST** /v2/Teams | Adds a new Team Account
*TeamsApi* | [**v2_teams_roles_get**](docs/TeamsApi.md#v2_teams_roles_get) | **GET** /v2/Teams/roles | Get all available roles including default as well as custom roles
*TeamsApi* | [**v2_teams_user_id_content_put**](docs/TeamsApi.md#v2_teams_user_id_content_put) | **PUT** /v2/Teams/{userId}/content | Update the content roles of an individual user
*TeamsApi* | [**v2_teams_user_id_delete**](docs/TeamsApi.md#v2_teams_user_id_delete) | **DELETE** /v2/Teams/{userId} | Deletes a user with an ID
*TeamsApi* | [**v2_teams_user_id_get**](docs/TeamsApi.md#v2_teams_user_id_get) | **GET** /v2/Teams/{userId} | Get complete user details by id
*TeamsApi* | [**v2_teams_user_id_groups_put**](docs/TeamsApi.md#v2_teams_user_id_groups_put) | **PUT** /v2/Teams/{userId}/groups | Modify the groups associated with the user
*TeamsApi* | [**v2_teams_user_id_portal_put**](docs/TeamsApi.md#v2_teams_user_id_portal_put) | **PUT** /v2/Teams/{userId}/portal | Update the portal role of a individual user
*TranslationsApi* | [**v2_translations_project_version_id_lang_code_get**](docs/TranslationsApi.md#v2_translations_project_version_id_lang_code_get) | **GET** /v2/Translations/{projectVersionId}/{langCode} | Gets articles by translation status


## Documentation For Models

 - [AIAdditionalFeedbackInfo](docs/AIAdditionalFeedbackInfo.md)
 - [AIAssistiveSearch](docs/AIAssistiveSearch.md)
 - [AIAssistiveSearchRequest](docs/AIAssistiveSearchRequest.md)
 - [AccessScopeCustomerV2](docs/AccessScopeCustomerV2.md)
 - [AccessScopeLevel](docs/AccessScopeLevel.md)
 - [AddCategoryRequest](docs/AddCategoryRequest.md)
 - [AddCategoryResponse](docs/AddCategoryResponse.md)
 - [AddMediaFileResponseCustomer](docs/AddMediaFileResponseCustomer.md)
 - [AddMediaFolderRequestCustomer](docs/AddMediaFolderRequestCustomer.md)
 - [AddReaderGroupRequestV2](docs/AddReaderGroupRequestV2.md)
 - [AddReaderRequestV2](docs/AddReaderRequestV2.md)
 - [AddTeamAccountCustomer](docs/AddTeamAccountCustomer.md)
 - [AddUpdateAccessScopeCustomerV2](docs/AddUpdateAccessScopeCustomerV2.md)
 - [AddUserData](docs/AddUserData.md)
 - [AddUserDataCustomerApiResponse](docs/AddUserDataCustomerApiResponse.md)
 - [AllFilesWithCountCustomer](docs/AllFilesWithCountCustomer.md)
 - [AllFilesWithCountResponseCustomer](docs/AllFilesWithCountResponseCustomer.md)
 - [ApiDefinitionInforamtionCustomer](docs/ApiDefinitionInforamtionCustomer.md)
 - [ApiDocsImportDataCustomer](docs/ApiDocsImportDataCustomer.md)
 - [ApiDocsResyncDataCustomer](docs/ApiDocsResyncDataCustomer.md)
 - [ApiDocumentationImportResponseCustomer](docs/ApiDocumentationImportResponseCustomer.md)
 - [ApiDocumentationResyncResponseCustomer](docs/ApiDocumentationResyncResponseCustomer.md)
 - [ApiErrorAndWarningsData](docs/ApiErrorAndWarningsData.md)
 - [ApiLogs](docs/ApiLogs.md)
 - [ApiReferenceLogsDataCustomer](docs/ApiReferenceLogsDataCustomer.md)
 - [ApiReferenceLogsWrapResponseCustomer](docs/ApiReferenceLogsWrapResponseCustomer.md)
 - [ApiReferencePublishRequestCustomer](docs/ApiReferencePublishRequestCustomer.md)
 - [ArticleAccessInfo](docs/ArticleAccessInfo.md)
 - [ArticleContentType](docs/ArticleContentType.md)
 - [ArticleMatchedData](docs/ArticleMatchedData.md)
 - [ArticleSettingCustomer](docs/ArticleSettingCustomer.md)
 - [ArticleSettingCustomerResponse](docs/ArticleSettingCustomerResponse.md)
 - [ArticleSimpleDataCustomer](docs/ArticleSimpleDataCustomer.md)
 - [ArticleSimpleDataCustomerResponse](docs/ArticleSimpleDataCustomerResponse.md)
 - [ArticleSimpleVersionCustomer](docs/ArticleSimpleVersionCustomer.md)
 - [ArticleStaleStatus](docs/ArticleStaleStatus.md)
 - [ArticleStatusCustomer](docs/ArticleStatusCustomer.md)
 - [ArticleStatusIndicator](docs/ArticleStatusIndicator.md)
 - [ArticleType](docs/ArticleType.md)
 - [ArticleUpdateWorkflowRequest](docs/ArticleUpdateWorkflowRequest.md)
 - [ArticleVersionDataCustomerResponse](docs/ArticleVersionDataCustomerResponse.md)
 - [ArticleVersionInfoCustomerResponse](docs/ArticleVersionInfoCustomerResponse.md)
 - [ArticleWorkflowStatus](docs/ArticleWorkflowStatus.md)
 - [BackgroundTaskStatus](docs/BackgroundTaskStatus.md)
 - [BaseError](docs/BaseError.md)
 - [BaseInformation](docs/BaseInformation.md)
 - [BaseResponse](docs/BaseResponse.md)
 - [BaseResponseContext](docs/BaseResponseContext.md)
 - [BaseWarning](docs/BaseWarning.md)
 - [BooleanCustomerApiResponse](docs/BooleanCustomerApiResponse.md)
 - [BulkArticleResultCustomer](docs/BulkArticleResultCustomer.md)
 - [BulkCategoryResult](docs/BulkCategoryResult.md)
 - [BulkCreateArticleResponseCustomer](docs/BulkCreateArticleResponseCustomer.md)
 - [BulkCreateCategoryResponse](docs/BulkCreateCategoryResponse.md)
 - [BulkDeleteArticleResponse](docs/BulkDeleteArticleResponse.md)
 - [BulkDeleteArticleVersionResonse](docs/BulkDeleteArticleVersionResonse.md)
 - [BulkDeleteCategoryVersionResponse](docs/BulkDeleteCategoryVersionResponse.md)
 - [BulkPublishArticle](docs/BulkPublishArticle.md)
 - [BulkPublishCategory](docs/BulkPublishCategory.md)
 - [BulkPublishCategoryResponse](docs/BulkPublishCategoryResponse.md)
 - [BulkUnpublishArticle](docs/BulkUnpublishArticle.md)
 - [BulkUnpublishArticleRequest](docs/BulkUnpublishArticleRequest.md)
 - [BulkUnpublishArticleResponse](docs/BulkUnpublishArticleResponse.md)
 - [BulkUnpublishCategory](docs/BulkUnpublishCategory.md)
 - [BulkUnpublishCategoryRequest](docs/BulkUnpublishCategoryRequest.md)
 - [BulkUnpublishCategoryResponse](docs/BulkUnpublishCategoryResponse.md)
 - [BulkUpdateArticle](docs/BulkUpdateArticle.md)
 - [BulkUpdateArticleResponse](docs/BulkUpdateArticleResponse.md)
 - [BulkUpdateCategoryContentResponse](docs/BulkUpdateCategoryContentResponse.md)
 - [CategoryAccessInfo](docs/CategoryAccessInfo.md)
 - [CategoryDataCustomer](docs/CategoryDataCustomer.md)
 - [CategoryMeta](docs/CategoryMeta.md)
 - [CategoryScopeCustomer](docs/CategoryScopeCustomer.md)
 - [CategorySettingsCustomer](docs/CategorySettingsCustomer.md)
 - [CategorySimpleData](docs/CategorySimpleData.md)
 - [CategorySimpleVersionCustomer](docs/CategorySimpleVersionCustomer.md)
 - [CategorySummaryCustomerV2](docs/CategorySummaryCustomerV2.md)
 - [CategoryType](docs/CategoryType.md)
 - [CategoryVersionData](docs/CategoryVersionData.md)
 - [CategoryVersionDataCustomer](docs/CategoryVersionDataCustomer.md)
 - [CategoryWorkflowStatus](docs/CategoryWorkflowStatus.md)
 - [CompleteUserInfoCustomer](docs/CompleteUserInfoCustomer.md)
 - [CompleteUserInfoCustomerCustomerApiResponse](docs/CompleteUserInfoCustomerCustomerApiResponse.md)
 - [Content](docs/Content.md)
 - [ContentPermissionCustomer](docs/ContentPermissionCustomer.md)
 - [ContentRoleInfo](docs/ContentRoleInfo.md)
 - [ContentRoleSummaryCustomer](docs/ContentRoleSummaryCustomer.md)
 - [CreateArticleRequest](docs/CreateArticleRequest.md)
 - [CreateArticleResponse](docs/CreateArticleResponse.md)
 - [CustomerApiBaseResponse](docs/CustomerApiBaseResponse.md)
 - [DataSourceType](docs/DataSourceType.md)
 - [DateRange](docs/DateRange.md)
 - [DeleteApiDefinitionCustomer](docs/DeleteApiDefinitionCustomer.md)
 - [DeleteApiReferenceResponseCustomer](docs/DeleteApiReferenceResponseCustomer.md)
 - [DeleteMediaFileResponseCustomer](docs/DeleteMediaFileResponseCustomer.md)
 - [DeletedandStarredMetaDataCustomer](docs/DeletedandStarredMetaDataCustomer.md)
 - [DriveTaskStatus](docs/DriveTaskStatus.md)
 - [EditContentRoleCustomer](docs/EditContentRoleCustomer.md)
 - [EditPortalRoleCustomer](docs/EditPortalRoleCustomer.md)
 - [EditUserGroupsCustomer](docs/EditUserGroupsCustomer.md)
 - [EditableElementTypes](docs/EditableElementTypes.md)
 - [EmailExists](docs/EmailExists.md)
 - [EmailExistsResponse](docs/EmailExistsResponse.md)
 - [ExportDocumentationRequest](docs/ExportDocumentationRequest.md)
 - [ExportDocumentationResponse](docs/ExportDocumentationResponse.md)
 - [ExportDocumentationStatusResponse](docs/ExportDocumentationStatusResponse.md)
 - [ExportType](docs/ExportType.md)
 - [FeatureAnalytics](docs/FeatureAnalytics.md)
 - [FeatureExplorerStatus](docs/FeatureExplorerStatus.md)
 - [FeatureExplorerUserAnalyticsEntity](docs/FeatureExplorerUserAnalyticsEntity.md)
 - [FeatureExplorerUserRoleEnum](docs/FeatureExplorerUserRoleEnum.md)
 - [FeatureListEnum](docs/FeatureListEnum.md)
 - [FeedbackSubType](docs/FeedbackSubType.md)
 - [ForkArticleVersionRequest](docs/ForkArticleVersionRequest.md)
 - [ForkArticleVersionResponse](docs/ForkArticleVersionResponse.md)
 - [ForkCategoryVersionRequest](docs/ForkCategoryVersionRequest.md)
 - [ForkCategoryVersionResponse](docs/ForkCategoryVersionResponse.md)
 - [FormEditableProperties](docs/FormEditableProperties.md)
 - [GetApiReferenceDataResponseCustomer](docs/GetApiReferenceDataResponseCustomer.md)
 - [GetArticleNotTranslatedResponse](docs/GetArticleNotTranslatedResponse.md)
 - [GetArticleResponseCustomer](docs/GetArticleResponseCustomer.md)
 - [GetArticleSettingsResponse](docs/GetArticleSettingsResponse.md)
 - [GetArticleVersionResponse](docs/GetArticleVersionResponse.md)
 - [GetArticleVersionsResponse](docs/GetArticleVersionsResponse.md)
 - [GetArticlesResponseCustomer](docs/GetArticlesResponseCustomer.md)
 - [GetCategoriesResponse](docs/GetCategoriesResponse.md)
 - [GetCategoryContentResponse](docs/GetCategoryContentResponse.md)
 - [GetCategoryResponse](docs/GetCategoryResponse.md)
 - [GetCategorySettingsResponse](docs/GetCategorySettingsResponse.md)
 - [GetCategoryVersionsResponse](docs/GetCategoryVersionsResponse.md)
 - [GetCustomerTaskStatusResponse](docs/GetCustomerTaskStatusResponse.md)
 - [GetDriveFilesInArticleDataCustomer](docs/GetDriveFilesInArticleDataCustomer.md)
 - [GetLanguageFromProjectVersion](docs/GetLanguageFromProjectVersion.md)
 - [GetLogsDetailsResponseCustomer](docs/GetLogsDetailsResponseCustomer.md)
 - [GetMediaFolderResponseCustomer](docs/GetMediaFolderResponseCustomer.md)
 - [GetMediaFolderWithIdCustomer](docs/GetMediaFolderWithIdCustomer.md)
 - [GetProjectVersionsResponse](docs/GetProjectVersionsResponse.md)
 - [GetReaderResponseCustomer](docs/GetReaderResponseCustomer.md)
 - [GetWorkflowStatusResponse](docs/GetWorkflowStatusResponse.md)
 - [GroupInfo](docs/GroupInfo.md)
 - [GuideAccessInfo](docs/GuideAccessInfo.md)
 - [Highlightresult](docs/Highlightresult.md)
 - [Hit](docs/Hit.md)
 - [ImportAPILog](docs/ImportAPILog.md)
 - [ImportDocumemtationLogMessageType](docs/ImportDocumemtationLogMessageType.md)
 - [ImportDocumentationLogAction](docs/ImportDocumentationLogAction.md)
 - [ImportDocumentationRequest](docs/ImportDocumentationRequest.md)
 - [ImportDocumentationResponse](docs/ImportDocumentationResponse.md)
 - [ImportDocumentationStatusResponse](docs/ImportDocumentationStatusResponse.md)
 - [Language](docs/Language.md)
 - [LanguageAccessInfo](docs/LanguageAccessInfo.md)
 - [LanguageMeta](docs/LanguageMeta.md)
 - [LanguageScopeCustomer](docs/LanguageScopeCustomer.md)
 - [LanguageSummaryCustomer](docs/LanguageSummaryCustomer.md)
 - [LanguageTranslationOption](docs/LanguageTranslationOption.md)
 - [MediaFileAndTagsMetaDataCustomer](docs/MediaFileAndTagsMetaDataCustomer.md)
 - [MediaFileAndTagsMetaDataResponseCustomer](docs/MediaFileAndTagsMetaDataResponseCustomer.md)
 - [MediaFileDataResponseCustomer](docs/MediaFileDataResponseCustomer.md)
 - [MediaFileMetaDataCustomer](docs/MediaFileMetaDataCustomer.md)
 - [MediaFilesMetaDataCustomer](docs/MediaFilesMetaDataCustomer.md)
 - [MediaFolderMetaDataCustomer](docs/MediaFolderMetaDataCustomer.md)
 - [MediaFolderMetaDataResponseCustomer](docs/MediaFolderMetaDataResponseCustomer.md)
 - [MediaFolderViewMetaDataCustomer](docs/MediaFolderViewMetaDataCustomer.md)
 - [MediaFoldersDataCustomer](docs/MediaFoldersDataCustomer.md)
 - [NeedTranslationArticleData](docs/NeedTranslationArticleData.md)
 - [ProjectLanguage](docs/ProjectLanguage.md)
 - [ProjectProtection](docs/ProjectProtection.md)
 - [ProjectVersionCustomer](docs/ProjectVersionCustomer.md)
 - [ProjectVersionTypeCustomer](docs/ProjectVersionTypeCustomer.md)
 - [PublicAPIAIFeedbackRequest](docs/PublicAPIAIFeedbackRequest.md)
 - [PublishArticleRequest](docs/PublishArticleRequest.md)
 - [PublishCategoryRequest](docs/PublishCategoryRequest.md)
 - [ReaderGroupCustomerV2](docs/ReaderGroupCustomerV2.md)
 - [ReaderGroupCustomerV2CustomerApiResponse](docs/ReaderGroupCustomerV2CustomerApiResponse.md)
 - [ReaderGroupCustomerV2ListCustomerApiResponse](docs/ReaderGroupCustomerV2ListCustomerApiResponse.md)
 - [RelatedArticleData](docs/RelatedArticleData.md)
 - [RoleMetaData](docs/RoleMetaData.md)
 - [RoleMetaDataListCustomerApiResponse](docs/RoleMetaDataListCustomerApiResponse.md)
 - [RoleSummaryCustomer](docs/RoleSummaryCustomer.md)
 - [RoleType](docs/RoleType.md)
 - [SSOSchemeDetails](docs/SSOSchemeDetails.md)
 - [SSOSchemeReponse](docs/SSOSchemeReponse.md)
 - [SSOUserTypes](docs/SSOUserTypes.md)
 - [SearchProjectVersionResponseCustomerApi](docs/SearchProjectVersionResponseCustomerApi.md)
 - [SectionTypeEnum](docs/SectionTypeEnum.md)
 - [Snippetresult](docs/Snippetresult.md)
 - [StaleStatus](docs/StaleStatus.md)
 - [StringCustomerApiResponse](docs/StringCustomerApiResponse.md)
 - [TagsMetaDataCustomer](docs/TagsMetaDataCustomer.md)
 - [TeamAccountGroupSummaryCustomer](docs/TeamAccountGroupSummaryCustomer.md)
 - [TeamAccountGroupSummaryCustomerListCustomerApiResponse](docs/TeamAccountGroupSummaryCustomerListCustomerApiResponse.md)
 - [TeamAccountSummaryCustomer](docs/TeamAccountSummaryCustomer.md)
 - [TeamAccountSummaryCustomerListCustomerApiResponse](docs/TeamAccountSummaryCustomerListCustomerApiResponse.md)
 - [Title](docs/Title.md)
 - [TrophyStatus](docs/TrophyStatus.md)
 - [UIElement](docs/UIElement.md)
 - [UIElementType](docs/UIElementType.md)
 - [UnpublishArticleRequest](docs/UnpublishArticleRequest.md)
 - [UnpublishCategoryRequest](docs/UnpublishCategoryRequest.md)
 - [UpdateArticleRequest](docs/UpdateArticleRequest.md)
 - [UpdateArticleSettingsRequest](docs/UpdateArticleSettingsRequest.md)
 - [UpdateArticleSettingsResponseCustomer](docs/UpdateArticleSettingsResponseCustomer.md)
 - [UpdateCategoryContentCustomerRequest](docs/UpdateCategoryContentCustomerRequest.md)
 - [UpdateCategoryContentCustomerResponse](docs/UpdateCategoryContentCustomerResponse.md)
 - [UpdateCategoryContentRequest](docs/UpdateCategoryContentRequest.md)
 - [UpdateCategoryRequest](docs/UpdateCategoryRequest.md)
 - [UpdateCategoryResponse](docs/UpdateCategoryResponse.md)
 - [UpdateCategoryWorkflowStatusRequest](docs/UpdateCategoryWorkflowStatusRequest.md)
 - [UpdateMediaFolderRequestCustomer](docs/UpdateMediaFolderRequestCustomer.md)
 - [UpdateReaderGroupRequestV2](docs/UpdateReaderGroupRequestV2.md)
 - [UpdateReaderRequestV2](docs/UpdateReaderRequestV2.md)
 - [UserAccess](docs/UserAccess.md)
 - [UserDetailsCustomer](docs/UserDetailsCustomer.md)
 - [UserProfileCustomer](docs/UserProfileCustomer.md)
 - [VectorSearchReferenceArticles](docs/VectorSearchReferenceArticles.md)
 - [VersionAccessInfo](docs/VersionAccessInfo.md)
 - [ViewFormControl](docs/ViewFormControl.md)
 - [WorkflowStatusCustomer](docs/WorkflowStatusCustomer.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="api_token"></a>
### api_token

- **Type**: API key
- **API key parameter name**: api_token
- **Location**: HTTP header


## Author

support@document360.com


