# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from d361api.models.add_update_access_scope_customer_v2 import AddUpdateAccessScopeCustomerV2
from typing import Optional, Set
from typing_extensions import Self

class AddReaderGroupRequestV2(BaseModel):
    """
    AddReaderGroupRequestV2
    """ # noqa: E501
    title: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The name of the reader group")
    description: Optional[StrictStr] = Field(default=None, description="Access level of the reader group")
    associated_readers: Optional[List[StrictStr]] = Field(default=None, description="Description of the reader group")
    access_scope: AddUpdateAccessScopeCustomerV2 = Field(description="List of reader IDs to be associated with the reader group")
    associated_invited_sso_users: Optional[List[StrictStr]] = Field(default=None, description="List of invitation IDs to be associated with this reader group. Applicable only for SSO readers.")
    __properties: ClassVar[List[str]] = ["title", "description", "associated_readers", "access_scope", "associated_invited_sso_users"]

    @field_validator('title')
    def title_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[^~`!@#$%^&*)(+=|\]\[{};:?\/>\'.,]*$", value):
            raise ValueError(r"must validate the regular expression /^[^~`!@#$%^&*)(+=|\]\[{};:?\/>'.,]*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddReaderGroupRequestV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_scope
        if self.access_scope:
            _dict['access_scope'] = self.access_scope.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if associated_readers (nullable) is None
        # and model_fields_set contains the field
        if self.associated_readers is None and "associated_readers" in self.model_fields_set:
            _dict['associated_readers'] = None

        # set to None if associated_invited_sso_users (nullable) is None
        # and model_fields_set contains the field
        if self.associated_invited_sso_users is None and "associated_invited_sso_users" in self.model_fields_set:
            _dict['associated_invited_sso_users'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddReaderGroupRequestV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "associated_readers": obj.get("associated_readers"),
            "access_scope": AddUpdateAccessScopeCustomerV2.from_dict(obj["access_scope"]) if obj.get("access_scope") is not None else None,
            "associated_invited_sso_users": obj.get("associated_invited_sso_users")
        })
        return _obj


