# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from d361api.models.add_update_access_scope_customer_v2 import AddUpdateAccessScopeCustomerV2
from typing import Optional, Set
from typing_extensions import Self

class AddReaderRequestV2(BaseModel):
    """
    AddReaderRequestV2
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, description="The first name of the reader")
    last_name: Optional[StrictStr] = Field(default=None, description="The last name of the reader")
    email_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The Email address of the reader")
    associated_reader_groups: Optional[List[StrictStr]] = Field(default=None, description="List of reader group IDs")
    access_scope: Optional[AddUpdateAccessScopeCustomerV2] = Field(default=None, description="If access scope is not given, then 0-None access level will be assigned")
    is_sso_user: Optional[StrictBool] = Field(default=None, description="Specify if the reader is a Single Sign-On user or not")
    scheme_name: Optional[StrictStr] = Field(default=None, description="Specify to add the reader to the specific scheme name, if the reader is a Single Sign-On user. If the scheme name is not provided, then the reader will be added to the default scheme.")
    skip_sso_invitation_email: Optional[StrictBool] = Field(default=None, description="If the value is true, then the invitation email will not be sent to the reader. Applicable only for a Single Sign-On reader.")
    invited_by: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The ID of an existing team account. The name of this team account will be mentioned in the invitation email.")
    __properties: ClassVar[List[str]] = ["first_name", "last_name", "email_id", "associated_reader_groups", "access_scope", "is_sso_user", "scheme_name", "skip_sso_invitation_email", "invited_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddReaderRequestV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_scope
        if self.access_scope:
            _dict['access_scope'] = self.access_scope.to_dict()
        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if associated_reader_groups (nullable) is None
        # and model_fields_set contains the field
        if self.associated_reader_groups is None and "associated_reader_groups" in self.model_fields_set:
            _dict['associated_reader_groups'] = None

        # set to None if access_scope (nullable) is None
        # and model_fields_set contains the field
        if self.access_scope is None and "access_scope" in self.model_fields_set:
            _dict['access_scope'] = None

        # set to None if scheme_name (nullable) is None
        # and model_fields_set contains the field
        if self.scheme_name is None and "scheme_name" in self.model_fields_set:
            _dict['scheme_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddReaderRequestV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email_id": obj.get("email_id"),
            "associated_reader_groups": obj.get("associated_reader_groups"),
            "access_scope": AddUpdateAccessScopeCustomerV2.from_dict(obj["access_scope"]) if obj.get("access_scope") is not None else None,
            "is_sso_user": obj.get("is_sso_user"),
            "scheme_name": obj.get("scheme_name"),
            "skip_sso_invitation_email": obj.get("skip_sso_invitation_email"),
            "invited_by": obj.get("invited_by")
        })
        return _obj


