# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from d361api.models.content_permission_customer import ContentPermissionCustomer
from typing import Optional, Set
from typing_extensions import Self

class AddTeamAccountCustomer(BaseModel):
    """
    Request to add a new team account user
    """ # noqa: E501
    email_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The email address of the team account")
    first_name: Optional[StrictStr] = Field(default=None, description="First name of the team account")
    last_name: Optional[StrictStr] = Field(default=None, description="Last name of the team account")
    invited_by: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The ID of an existing team account. To get the id, please refer GET **/v2/Teams** endpoint")
    is_sso_user: Optional[StrictBool] = Field(default=None, description="Set this to true, if you are adding an SSO user")
    scheme_name: Optional[StrictStr] = Field(default=None, description="Specify to add the reader to the specific scheme name, if the reader is a Single Sign-On user. If the scheme name is not provided, then the reader will be added to the default scheme.")
    skip_sso_invitation_email: Optional[StrictBool] = Field(default=None, description="Set this to true, if you would like to avoid sending an invitation email to the newly added team account.  This property is applicable only when adding a SSO user.")
    associated_portal_role_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The associated portal role id. To get the list of portal roles refer /teams/roles endpoint.")
    content_permissions: List[ContentPermissionCustomer] = Field(description="The content level permissions for the newly added team account")
    associated_groups: Optional[List[StrictStr]] = Field(default=None, description="A list of group ids to which the team account has to be added. Please refer /teams/groups endpoint to get the available groups.")
    __properties: ClassVar[List[str]] = ["email_id", "first_name", "last_name", "invited_by", "is_sso_user", "scheme_name", "skip_sso_invitation_email", "associated_portal_role_id", "content_permissions", "associated_groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddTeamAccountCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in content_permissions (list)
        _items = []
        if self.content_permissions:
            for _item_content_permissions in self.content_permissions:
                if _item_content_permissions:
                    _items.append(_item_content_permissions.to_dict())
            _dict['content_permissions'] = _items
        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if scheme_name (nullable) is None
        # and model_fields_set contains the field
        if self.scheme_name is None and "scheme_name" in self.model_fields_set:
            _dict['scheme_name'] = None

        # set to None if associated_groups (nullable) is None
        # and model_fields_set contains the field
        if self.associated_groups is None and "associated_groups" in self.model_fields_set:
            _dict['associated_groups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddTeamAccountCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email_id": obj.get("email_id"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "invited_by": obj.get("invited_by"),
            "is_sso_user": obj.get("is_sso_user"),
            "scheme_name": obj.get("scheme_name"),
            "skip_sso_invitation_email": obj.get("skip_sso_invitation_email"),
            "associated_portal_role_id": obj.get("associated_portal_role_id"),
            "content_permissions": [ContentPermissionCustomer.from_dict(_item) for _item in obj["content_permissions"]] if obj.get("content_permissions") is not None else None,
            "associated_groups": obj.get("associated_groups")
        })
        return _obj


