# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.access_scope_level import AccessScopeLevel
from d361api.models.category_scope_customer import CategoryScopeCustomer
from d361api.models.language_scope_customer import LanguageScopeCustomer
from typing import Optional, Set
from typing_extensions import Self

class AddUpdateAccessScopeCustomerV2(BaseModel):
    """
    The access scope of the user
    """ # noqa: E501
    access_level: AccessScopeLevel = Field(description="This is an enum. Possible values are  0 - None  1 - Category  2 - Version  3 - Project  4 - Lanaguage")
    categories: Optional[List[CategoryScopeCustomer]] = Field(default=None, description="A list of category scope objects.  This is only required if the access level is set 1 - Category")
    project_versions: Optional[List[StrictStr]] = Field(default=None, description="A list of project versions  This is only required if the access level is set to 2 - Version")
    languages: Optional[List[LanguageScopeCustomer]] = Field(default=None, description="A list of language scope objects  This is only required if the access level is set to 4 - Language")
    __properties: ClassVar[List[str]] = ["access_level", "categories", "project_versions", "languages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddUpdateAccessScopeCustomerV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in languages (list)
        _items = []
        if self.languages:
            for _item_languages in self.languages:
                if _item_languages:
                    _items.append(_item_languages.to_dict())
            _dict['languages'] = _items
        # set to None if categories (nullable) is None
        # and model_fields_set contains the field
        if self.categories is None and "categories" in self.model_fields_set:
            _dict['categories'] = None

        # set to None if project_versions (nullable) is None
        # and model_fields_set contains the field
        if self.project_versions is None and "project_versions" in self.model_fields_set:
            _dict['project_versions'] = None

        # set to None if languages (nullable) is None
        # and model_fields_set contains the field
        if self.languages is None and "languages" in self.model_fields_set:
            _dict['languages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddUpdateAccessScopeCustomerV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_level": obj.get("access_level"),
            "categories": [CategoryScopeCustomer.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "project_versions": obj.get("project_versions"),
            "languages": [LanguageScopeCustomer.from_dict(_item) for _item in obj["languages"]] if obj.get("languages") is not None else None
        })
        return _obj


