# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class AIAdditionalFeedbackInfo(BaseModel):
    """
    AIAdditionalFeedbackInfo
    """ # noqa: E501
    need_more_information: Optional[StrictBool] = Field(default=None, description="User needs more information than what was provided in the AI response.")
    difficult_to_understand: Optional[StrictBool] = Field(default=None, description="The AI response was difficult for the user to understand.")
    irrelevant_content: Optional[StrictBool] = Field(default=None, description="The AI response was not relevant to the user's query.")
    incorrect_source_reference: Optional[StrictBool] = Field(default=None, description="The source references in the AI response were incorrect or misleading.")
    missing_information: Optional[StrictBool] = Field(default=None, description="Important information was missing from the AI response.")
    dont_like_style: Optional[StrictBool] = Field(default=None, description="The user did not like the style of the AI response.")
    others: Optional[StrictBool] = Field(default=None, description="The user's feedback does not fall under the predefined categories.")
    comments: Optional[StrictBool] = Field(default=None, description="Indicates whether the user has provided additional comments.")
    __properties: ClassVar[List[str]] = ["need_more_information", "difficult_to_understand", "irrelevant_content", "incorrect_source_reference", "missing_information", "dont_like_style", "others", "comments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AIAdditionalFeedbackInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AIAdditionalFeedbackInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "need_more_information": obj.get("need_more_information"),
            "difficult_to_understand": obj.get("difficult_to_understand"),
            "irrelevant_content": obj.get("irrelevant_content"),
            "incorrect_source_reference": obj.get("incorrect_source_reference"),
            "missing_information": obj.get("missing_information"),
            "dont_like_style": obj.get("dont_like_style"),
            "others": obj.get("others"),
            "comments": obj.get("comments")
        })
        return _obj


