# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.deletedand_starred_meta_data_customer import DeletedandStarredMetaDataCustomer
from typing import Optional, Set
from typing_extensions import Self

class AllFilesWithCountCustomer(BaseModel):
    """
    AllFilesWithCountCustomer
    """ # noqa: E501
    all_files: Optional[List[DeletedandStarredMetaDataCustomer]] = Field(default=None, description="Search file items from drive")
    count: Optional[StrictInt] = Field(default=None, description="Total file count")
    __properties: ClassVar[List[str]] = ["all_files", "count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AllFilesWithCountCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in all_files (list)
        _items = []
        if self.all_files:
            for _item_all_files in self.all_files:
                if _item_all_files:
                    _items.append(_item_all_files.to_dict())
            _dict['all_files'] = _items
        # set to None if all_files (nullable) is None
        # and model_fields_set contains the field
        if self.all_files is None and "all_files" in self.model_fields_set:
            _dict['all_files'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AllFilesWithCountCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "all_files": [DeletedandStarredMetaDataCustomer.from_dict(_item) for _item in obj["all_files"]] if obj.get("all_files") is not None else None,
            "count": obj.get("count")
        })
        return _obj


