# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.api_error_and_warnings_data import ApiErrorAndWarningsData
from typing import Optional, Set
from typing_extensions import Self

class ApiDocsImportDataCustomer(BaseModel):
    """
    ApiDocsImportDataCustomer
    """ # noqa: E501
    categories_created: Optional[StrictInt] = Field(default=None, description="Total category created")
    articles_created: Optional[StrictInt] = Field(default=None, description="Total article created")
    api_reference_id: Optional[StrictStr] = Field(default=None, description="Api reference ID")
    errors: Optional[List[ApiErrorAndWarningsData]] = Field(default=None, description="Error log response")
    alerts: Optional[List[ApiErrorAndWarningsData]] = Field(default=None, description="Alerts log response")
    __properties: ClassVar[List[str]] = ["categories_created", "articles_created", "api_reference_id", "errors", "alerts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiDocsImportDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in alerts (list)
        _items = []
        if self.alerts:
            for _item_alerts in self.alerts:
                if _item_alerts:
                    _items.append(_item_alerts.to_dict())
            _dict['alerts'] = _items
        # set to None if api_reference_id (nullable) is None
        # and model_fields_set contains the field
        if self.api_reference_id is None and "api_reference_id" in self.model_fields_set:
            _dict['api_reference_id'] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict['errors'] = None

        # set to None if alerts (nullable) is None
        # and model_fields_set contains the field
        if self.alerts is None and "alerts" in self.model_fields_set:
            _dict['alerts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiDocsImportDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categories_created": obj.get("categories_created"),
            "articles_created": obj.get("articles_created"),
            "api_reference_id": obj.get("api_reference_id"),
            "errors": [ApiErrorAndWarningsData.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "alerts": [ApiErrorAndWarningsData.from_dict(_item) for _item in obj["alerts"]] if obj.get("alerts") is not None else None
        })
        return _obj


