# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApiReferenceLogsDataCustomer(BaseModel):
    """
    ApiReferenceLogsDataCustomer
    """ # noqa: E501
    logs_id: Optional[StrictStr] = Field(default=None, description="The API reference Log ID")
    user_name: Optional[StrictStr] = Field(default=None, description="The name of the team account")
    user_id: Optional[StrictStr] = Field(default=None, description="The ID of the team account")
    title: Optional[StrictStr] = Field(default=None, description="Status of API reference")
    modified_at: Optional[datetime] = Field(default=None, description="Modified date/time")
    error_count: Optional[StrictInt] = Field(default=None, description="Total errors count")
    alerts_count: Optional[StrictInt] = Field(default=None, description="Total alerts count")
    __properties: ClassVar[List[str]] = ["logs_id", "user_name", "user_id", "title", "modified_at", "error_count", "alerts_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiReferenceLogsDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if logs_id (nullable) is None
        # and model_fields_set contains the field
        if self.logs_id is None and "logs_id" in self.model_fields_set:
            _dict['logs_id'] = None

        # set to None if user_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_name is None and "user_name" in self.model_fields_set:
            _dict['user_name'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiReferenceLogsDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "logs_id": obj.get("logs_id"),
            "user_name": obj.get("user_name"),
            "user_id": obj.get("user_id"),
            "title": obj.get("title"),
            "modified_at": obj.get("modified_at"),
            "error_count": obj.get("error_count"),
            "alerts_count": obj.get("alerts_count")
        })
        return _obj


