# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.hit import Hit
from typing import Optional, Set
from typing_extensions import Self

class ArticleMatchedData(BaseModel):
    """
    ArticleMatchedData
    """ # noqa: E501
    hits: Optional[List[Hit]] = Field(default=None, description="The list of articles that matched the search query.")
    nb_hits: Optional[StrictInt] = Field(default=None, description="The number of hits (articles) matched by the query.")
    page: Optional[StrictInt] = Field(default=None, description="The position of the current page (zero-based).")
    nb_pages: Optional[StrictInt] = Field(default=None, description="The number of returned pages. Calculation is based on the total number of hits (nbHits) divided by the number of hits per page (hitsPerPage), rounded up to the nearest integer.")
    hits_per_page: Optional[StrictInt] = Field(default=None, description="Maximum number of hits (articles) per page.")
    processing_time_ms: Optional[StrictInt] = Field(default=None, description="The time the server took to process the request, in milliseconds. This doesn’t include network time.")
    query: Optional[StrictStr] = Field(default=None, description="The query used to search the articles.")
    __properties: ClassVar[List[str]] = ["hits", "nb_hits", "page", "nb_pages", "hits_per_page", "processing_time_ms", "query"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArticleMatchedData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hits (list)
        _items = []
        if self.hits:
            for _item_hits in self.hits:
                if _item_hits:
                    _items.append(_item_hits.to_dict())
            _dict['hits'] = _items
        # set to None if hits (nullable) is None
        # and model_fields_set contains the field
        if self.hits is None and "hits" in self.model_fields_set:
            _dict['hits'] = None

        # set to None if nb_hits (nullable) is None
        # and model_fields_set contains the field
        if self.nb_hits is None and "nb_hits" in self.model_fields_set:
            _dict['nb_hits'] = None

        # set to None if page (nullable) is None
        # and model_fields_set contains the field
        if self.page is None and "page" in self.model_fields_set:
            _dict['page'] = None

        # set to None if nb_pages (nullable) is None
        # and model_fields_set contains the field
        if self.nb_pages is None and "nb_pages" in self.model_fields_set:
            _dict['nb_pages'] = None

        # set to None if hits_per_page (nullable) is None
        # and model_fields_set contains the field
        if self.hits_per_page is None and "hits_per_page" in self.model_fields_set:
            _dict['hits_per_page'] = None

        # set to None if processing_time_ms (nullable) is None
        # and model_fields_set contains the field
        if self.processing_time_ms is None and "processing_time_ms" in self.model_fields_set:
            _dict['processing_time_ms'] = None

        # set to None if query (nullable) is None
        # and model_fields_set contains the field
        if self.query is None and "query" in self.model_fields_set:
            _dict['query'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArticleMatchedData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hits": [Hit.from_dict(_item) for _item in obj["hits"]] if obj.get("hits") is not None else None,
            "nb_hits": obj.get("nb_hits"),
            "page": obj.get("page"),
            "nb_pages": obj.get("nb_pages"),
            "hits_per_page": obj.get("hits_per_page"),
            "processing_time_ms": obj.get("processing_time_ms"),
            "query": obj.get("query")
        })
        return _obj


