# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from d361api.models.article_workflow_status import ArticleWorkflowStatus
from typing import Optional, Set
from typing_extensions import Self

class ArticleUpdateWorkflowRequest(BaseModel):
    """
    ArticleUpdateWorkflowRequest
    """ # noqa: E501
    project_version_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Identifier of the specific workspace in the project in which the articles exist. This ID is used to ensure the workflow status update is applied to articles in a particular workspace.")
    lang_code: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Language code of the articles whose workflow status is being updated (e.g., \"en\", \"fr\"). This ensures the workflow status update is applied to the article in the specified language.")
    user_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="User ID of the team account changing the workflow status. This team account will be recorded in the audit log.")
    article_ids: List[StrictStr] = Field(description="List of article IDs to be updated. Each ID in this array should refer to an existing article in the specified project version and language.")
    workflow_status_info: ArticleWorkflowStatus = Field(description="Object for workflow status metadata. This object defines the new workflow status and any associated information like due date, comment, or assignee.")
    __properties: ClassVar[List[str]] = ["project_version_id", "lang_code", "user_id", "article_ids", "workflow_status_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArticleUpdateWorkflowRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workflow_status_info
        if self.workflow_status_info:
            _dict['workflow_status_info'] = self.workflow_status_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArticleUpdateWorkflowRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "project_version_id": obj.get("project_version_id"),
            "lang_code": obj.get("lang_code"),
            "user_id": obj.get("user_id"),
            "article_ids": obj.get("article_ids"),
            "workflow_status_info": ArticleWorkflowStatus.from_dict(obj["workflow_status_info"]) if obj.get("workflow_status_info") is not None else None
        })
        return _obj


