# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class BaseError(BaseModel):
    """
    BaseError
    """ # noqa: E501
    extension_data: Optional[Dict[str, Any]] = Field(default=None, description="This is the Extension data object")
    stack_trace: Optional[StrictStr] = Field(default=None, description="A technical trace showing where the error occurred within the system. Intended for backend debugging.")
    description: Optional[StrictStr] = Field(default=None, description="A clear message explaining what caused the error. This helps quickly understand what went wrong.")
    error_code: Optional[StrictStr] = Field(default=None, description="A short, predefined code that identifies the type of error. Useful for logging the error or raising a support request.")
    custom_data: Optional[Dict[str, Any]] = Field(default=None, description="Any structured metadata for the error object.")
    __properties: ClassVar[List[str]] = ["extension_data", "stack_trace", "description", "error_code", "custom_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if extension_data (nullable) is None
        # and model_fields_set contains the field
        if self.extension_data is None and "extension_data" in self.model_fields_set:
            _dict['extension_data'] = None

        # set to None if stack_trace (nullable) is None
        # and model_fields_set contains the field
        if self.stack_trace is None and "stack_trace" in self.model_fields_set:
            _dict['stack_trace'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if error_code (nullable) is None
        # and model_fields_set contains the field
        if self.error_code is None and "error_code" in self.model_fields_set:
            _dict['error_code'] = None

        # set to None if custom_data (nullable) is None
        # and model_fields_set contains the field
        if self.custom_data is None and "custom_data" in self.model_fields_set:
            _dict['custom_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "extension_data": obj.get("extension_data"),
            "stack_trace": obj.get("stack_trace"),
            "description": obj.get("description"),
            "error_code": obj.get("error_code"),
            "custom_data": obj.get("custom_data")
        })
        return _obj


