# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from d361api.models.bulk_unpublish_article import BulkUnpublishArticle
from typing import Optional, Set
from typing_extensions import Self

class BulkUnpublishArticleRequest(BaseModel):
    """
    BulkUnpublishArticleRequest
    """ # noqa: E501
    articles: List[BulkUnpublishArticle] = Field(description="Details of the articles need to be unpublished")
    user_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The ID of the team account that will be marked as the contributor of this unpublish")
    project_version_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The project version ID where the article exists.")
    unpublish_message: Optional[StrictStr] = Field(default=None, description="The unpublish message of the article")
    __properties: ClassVar[List[str]] = ["articles", "user_id", "project_version_id", "unpublish_message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkUnpublishArticleRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in articles (list)
        _items = []
        if self.articles:
            for _item_articles in self.articles:
                if _item_articles:
                    _items.append(_item_articles.to_dict())
            _dict['articles'] = _items
        # set to None if unpublish_message (nullable) is None
        # and model_fields_set contains the field
        if self.unpublish_message is None and "unpublish_message" in self.model_fields_set:
            _dict['unpublish_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkUnpublishArticleRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "articles": [BulkUnpublishArticle.from_dict(_item) for _item in obj["articles"]] if obj.get("articles") is not None else None,
            "user_id": obj.get("user_id"),
            "project_version_id": obj.get("project_version_id"),
            "unpublish_message": obj.get("unpublish_message")
        })
        return _obj


