# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.article_content_type import ArticleContentType
from d361api.models.article_simple_data_customer import ArticleSimpleDataCustomer
from d361api.models.article_status_customer import ArticleStatusCustomer
from d361api.models.category_type import CategoryType
from typing import Optional, Set
from typing_extensions import Self

class CategoryDataCustomer(BaseModel):
    """
    CategoryDataCustomer
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The ID of the category")
    name: Optional[StrictStr] = Field(default=None, description="Name of the category")
    description: Optional[StrictStr] = Field(default=None, description="Description of the category")
    project_version_id: Optional[StrictStr] = Field(default=None, description="The ID of the project version where this category is located")
    order: Optional[StrictInt] = Field(default=None, description="The position the category inside the parent category")
    parent_category_id: Optional[StrictStr] = Field(default=None, description="The ID of the parent category ( null if top-level )")
    hidden: Optional[StrictBool] = Field(default=None, description="Indicates if the category is visible on the site ( If \"false,\" all the child categories and articles will be hidden as well )")
    articles: Optional[List[ArticleSimpleDataCustomer]] = Field(default=None, description="The list of articles attached to this category")
    child_categories: Optional[List[CategoryDataCustomer]] = Field(default=None, description="The list of categories attached to this category")
    icon: Optional[StrictStr] = Field(default=None, description="Unicode representation of the icon or image URL")
    slug: Optional[StrictStr] = Field(default=None, description="The slug of the category")
    language_code: Optional[StrictStr] = Field(default=None, description="Language code of the category")
    category_type: Optional[CategoryType] = Field(default=None, description="0 - Folder, 1 - Page, 2 - Index")
    created_at: Optional[datetime] = Field(default=None, description="Category created date time")
    modified_at: Optional[datetime] = Field(default=None, description="Category modified date time")
    status: Optional[ArticleStatusCustomer] = Field(default=None, description="The status of the page type category: 0 - Draft, 3 - Published")
    content_type: Optional[ArticleContentType] = Field(default=None, description="The content type of the page type category: Markdown = 0, Wysiwyg = 1, Block = 2")
    current_workflow_status_id: Optional[StrictStr] = Field(default=None, description="Current Workflow status of the article")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "project_version_id", "order", "parent_category_id", "hidden", "articles", "child_categories", "icon", "slug", "language_code", "category_type", "created_at", "modified_at", "status", "content_type", "current_workflow_status_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CategoryDataCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in articles (list)
        _items = []
        if self.articles:
            for _item_articles in self.articles:
                if _item_articles:
                    _items.append(_item_articles.to_dict())
            _dict['articles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in child_categories (list)
        _items = []
        if self.child_categories:
            for _item_child_categories in self.child_categories:
                if _item_child_categories:
                    _items.append(_item_child_categories.to_dict())
            _dict['child_categories'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if project_version_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_version_id is None and "project_version_id" in self.model_fields_set:
            _dict['project_version_id'] = None

        # set to None if parent_category_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_category_id is None and "parent_category_id" in self.model_fields_set:
            _dict['parent_category_id'] = None

        # set to None if articles (nullable) is None
        # and model_fields_set contains the field
        if self.articles is None and "articles" in self.model_fields_set:
            _dict['articles'] = None

        # set to None if child_categories (nullable) is None
        # and model_fields_set contains the field
        if self.child_categories is None and "child_categories" in self.model_fields_set:
            _dict['child_categories'] = None

        # set to None if icon (nullable) is None
        # and model_fields_set contains the field
        if self.icon is None and "icon" in self.model_fields_set:
            _dict['icon'] = None

        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if language_code (nullable) is None
        # and model_fields_set contains the field
        if self.language_code is None and "language_code" in self.model_fields_set:
            _dict['language_code'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if modified_at (nullable) is None
        # and model_fields_set contains the field
        if self.modified_at is None and "modified_at" in self.model_fields_set:
            _dict['modified_at'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if current_workflow_status_id (nullable) is None
        # and model_fields_set contains the field
        if self.current_workflow_status_id is None and "current_workflow_status_id" in self.model_fields_set:
            _dict['current_workflow_status_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CategoryDataCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "project_version_id": obj.get("project_version_id"),
            "order": obj.get("order"),
            "parent_category_id": obj.get("parent_category_id"),
            "hidden": obj.get("hidden"),
            "articles": [ArticleSimpleDataCustomer.from_dict(_item) for _item in obj["articles"]] if obj.get("articles") is not None else None,
            "child_categories": [CategoryDataCustomer.from_dict(_item) for _item in obj["child_categories"]] if obj.get("child_categories") is not None else None,
            "icon": obj.get("icon"),
            "slug": obj.get("slug"),
            "language_code": obj.get("language_code"),
            "category_type": obj.get("category_type"),
            "created_at": obj.get("created_at"),
            "modified_at": obj.get("modified_at"),
            "status": obj.get("status"),
            "content_type": obj.get("content_type"),
            "current_workflow_status_id": obj.get("current_workflow_status_id")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
CategoryDataCustomer.model_rebuild(raise_errors=False)

