# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.article_status_customer import ArticleStatusCustomer
from typing import Optional, Set
from typing_extensions import Self

class CategorySimpleVersionCustomer(BaseModel):
    """
    CategorySimpleVersionCustomer
    """ # noqa: E501
    version_number: Optional[StrictInt] = Field(default=None, description="The currently fetched version number of this category page")
    created_by: Optional[StrictStr] = Field(default=None, description="The ID of the user that created the category page")
    created_at: Optional[datetime] = Field(default=None, description="The date the category page was created")
    modified_at: Optional[datetime] = Field(default=None, description="The date the category page was last modified")
    base_version: Optional[StrictInt] = Field(default=None, description="The base version of the currently fetched category page")
    status: Optional[ArticleStatusCustomer] = Field(default=None, description="The status of the article: 0 - Draft, 3 - Published")
    profile_url: Optional[StrictStr] = Field(default=None, description="The URL of team account's profile image")
    __properties: ClassVar[List[str]] = ["version_number", "created_by", "created_at", "modified_at", "base_version", "status", "profile_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CategorySimpleVersionCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        # set to None if profile_url (nullable) is None
        # and model_fields_set contains the field
        if self.profile_url is None and "profile_url" in self.model_fields_set:
            _dict['profile_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CategorySimpleVersionCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version_number": obj.get("version_number"),
            "created_by": obj.get("created_by"),
            "created_at": obj.get("created_at"),
            "modified_at": obj.get("modified_at"),
            "base_version": obj.get("base_version"),
            "status": obj.get("status"),
            "profile_url": obj.get("profile_url")
        })
        return _obj


