# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.article_status_customer import ArticleStatusCustomer
from d361api.models.stale_status import StaleStatus
from d361api.models.user_profile_customer import UserProfileCustomer
from typing import Optional, Set
from typing_extensions import Self

class CategoryVersionData(BaseModel):
    """
    CategoryVersionData
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The ID of the category")
    title: Optional[StrictStr] = Field(default=None, description="Category title")
    content: Optional[StrictStr] = Field(default=None, description="Category page Markdown content")
    html_content: Optional[StrictStr] = Field(default=None, description="Category page WYSIWYG(HTML) content")
    block_content: Optional[StrictStr] = Field(default=None, description="Category page Advanced WYSIWYG content")
    parent_category_id: Optional[StrictStr] = Field(default=None, description="Parent category ID")
    project_document_version_id: Optional[StrictStr] = Field(default=None, description="Project document version ID")
    version_number: Optional[StrictInt] = Field(default=None, description="The currently fetched version number of this category page")
    public_version: Optional[StrictInt] = Field(default=None, description="The version number that is currently published")
    latest_version: Optional[StrictInt] = Field(default=None, description="The latest version number(revision) of this  category page.")
    enable_rtl: Optional[StrictBool] = Field(default=None, description="Indicates if Right to Left alignment is enabled for the category page language")
    hidden: Optional[StrictBool] = Field(default=None, description="Indicates if the category page is visible on the site")
    status: Optional[ArticleStatusCustomer] = Field(default=None, description="The status of the article: 0 - Draft, 3 - Published")
    created_by: Optional[StrictStr] = Field(default=None, description="The ID of the user that created the category page")
    authors: Optional[List[UserProfileCustomer]] = Field(default=None, description="The list of authors that contributed to this category page")
    created_at: Optional[datetime] = Field(default=None, description="The date the category page was created")
    modified_at: Optional[datetime] = Field(default=None, description="The date the category page was last modified")
    slug: Optional[StrictStr] = Field(default=None, description="The slug of the category page")
    is_fall_back_content: Optional[StrictBool] = Field(default=None, description="Indicates whether the category page content is a fallback of the default language content or not")
    stale_status: Optional[StaleStatus] = Field(default=None, description="Fresh - Category page is up-to-date  Stale -  Category page requires review")
    content_type: Optional[StrictStr] = Field(default=None, description="0 - Markdown  1 - WYSIWYG(HTML)  2 - Advanced WYSIWYG")
    current_workflow_status_id: Optional[StrictStr] = Field(default=None, description="Current Workflow status of the article")
    is_block_editor: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "title", "content", "html_content", "block_content", "parent_category_id", "project_document_version_id", "version_number", "public_version", "latest_version", "enable_rtl", "hidden", "status", "created_by", "authors", "created_at", "modified_at", "slug", "is_fall_back_content", "stale_status", "content_type", "current_workflow_status_id", "is_block_editor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CategoryVersionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_block_editor",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in authors (list)
        _items = []
        if self.authors:
            for _item_authors in self.authors:
                if _item_authors:
                    _items.append(_item_authors.to_dict())
            _dict['authors'] = _items
        # override the default output from pydantic by calling `to_dict()` of stale_status
        if self.stale_status:
            _dict['stale_status'] = self.stale_status.to_dict()
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if html_content (nullable) is None
        # and model_fields_set contains the field
        if self.html_content is None and "html_content" in self.model_fields_set:
            _dict['html_content'] = None

        # set to None if block_content (nullable) is None
        # and model_fields_set contains the field
        if self.block_content is None and "block_content" in self.model_fields_set:
            _dict['block_content'] = None

        # set to None if parent_category_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_category_id is None and "parent_category_id" in self.model_fields_set:
            _dict['parent_category_id'] = None

        # set to None if project_document_version_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_document_version_id is None and "project_document_version_id" in self.model_fields_set:
            _dict['project_document_version_id'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        # set to None if authors (nullable) is None
        # and model_fields_set contains the field
        if self.authors is None and "authors" in self.model_fields_set:
            _dict['authors'] = None

        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if stale_status (nullable) is None
        # and model_fields_set contains the field
        if self.stale_status is None and "stale_status" in self.model_fields_set:
            _dict['stale_status'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if current_workflow_status_id (nullable) is None
        # and model_fields_set contains the field
        if self.current_workflow_status_id is None and "current_workflow_status_id" in self.model_fields_set:
            _dict['current_workflow_status_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CategoryVersionData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "content": obj.get("content"),
            "html_content": obj.get("html_content"),
            "block_content": obj.get("block_content"),
            "parent_category_id": obj.get("parent_category_id"),
            "project_document_version_id": obj.get("project_document_version_id"),
            "version_number": obj.get("version_number"),
            "public_version": obj.get("public_version"),
            "latest_version": obj.get("latest_version"),
            "enable_rtl": obj.get("enable_rtl"),
            "hidden": obj.get("hidden"),
            "status": obj.get("status"),
            "created_by": obj.get("created_by"),
            "authors": [UserProfileCustomer.from_dict(_item) for _item in obj["authors"]] if obj.get("authors") is not None else None,
            "created_at": obj.get("created_at"),
            "modified_at": obj.get("modified_at"),
            "slug": obj.get("slug"),
            "is_fall_back_content": obj.get("is_fall_back_content"),
            "stale_status": StaleStatus.from_dict(obj["stale_status"]) if obj.get("stale_status") is not None else None,
            "content_type": obj.get("content_type"),
            "current_workflow_status_id": obj.get("current_workflow_status_id"),
            "is_block_editor": obj.get("is_block_editor")
        })
        return _obj


