# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing import Optional, Set
from typing_extensions import Self

class CategoryWorkflowStatus(BaseModel):
    """
    CategoryWorkflowStatus
    """ # noqa: E501
    status_id: Optional[StrictStr] = Field(default=None, description="ID of the workflow status to apply to the listed articles. If omitted, no status change is applied. The value should match one of the predefined workflow statuses in the project.")
    due_date: Optional[datetime] = Field(default=None, description="Due date associated with the workflow status for completing the task or review. It should be in ISO 8601 format (yyyy-mm-ddThh:mm:ss)")
    comment: Optional[StrictStr] = Field(default=None, description="Optional text comment added along with the workflow status update. Useful for provided high-level instructions, context, or decisions.")
    assignee_id: Optional[StrictStr] = Field(default=None, description="ID of the user assigned to this workflow status. Assigning someone to a workflow status ensures they are notified via email.")
    __properties: ClassVar[List[str]] = ["status_id", "due_date", "comment", "assignee_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CategoryWorkflowStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if status_id (nullable) is None
        # and model_fields_set contains the field
        if self.status_id is None and "status_id" in self.model_fields_set:
            _dict['status_id'] = None

        # set to None if due_date (nullable) is None
        # and model_fields_set contains the field
        if self.due_date is None and "due_date" in self.model_fields_set:
            _dict['due_date'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if assignee_id (nullable) is None
        # and model_fields_set contains the field
        if self.assignee_id is None and "assignee_id" in self.model_fields_set:
            _dict['assignee_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CategoryWorkflowStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status_id": obj.get("status_id"),
            "due_date": obj.get("due_date"),
            "comment": obj.get("comment"),
            "assignee_id": obj.get("assignee_id")
        })
        return _obj


