# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.content_role_summary_customer import ContentRoleSummaryCustomer
from d361api.models.group_info import GroupInfo
from d361api.models.role_summary_customer import RoleSummaryCustomer
from typing import Optional, Set
from typing_extensions import Self

class CompleteUserInfoCustomer(BaseModel):
    """
    CompleteUserInfoCustomer
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, description="The ID of the user")
    first_name: Optional[StrictStr] = Field(default=None, description="First name of the user")
    last_name: Optional[StrictStr] = Field(default=None, description="Last name of the user")
    email_id: Optional[StrictStr] = Field(default=None, description="Email address of the user")
    profile_logo_url: Optional[StrictStr] = Field(default=None, description="Profile image URL of the user")
    last_login_at: Optional[datetime] = Field(default=None, description="Last login date of the user")
    portal_role: Optional[RoleSummaryCustomer] = Field(default=None, description="The name of the portal role")
    content_roles: Optional[List[ContentRoleSummaryCustomer]] = Field(default=None, description="The name of content role")
    associated_groups: Optional[List[GroupInfo]] = Field(default=None, description="THe group associated with the team account")
    __properties: ClassVar[List[str]] = ["user_id", "first_name", "last_name", "email_id", "profile_logo_url", "last_login_at", "portal_role", "content_roles", "associated_groups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompleteUserInfoCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of portal_role
        if self.portal_role:
            _dict['portal_role'] = self.portal_role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in content_roles (list)
        _items = []
        if self.content_roles:
            for _item_content_roles in self.content_roles:
                if _item_content_roles:
                    _items.append(_item_content_roles.to_dict())
            _dict['content_roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in associated_groups (list)
        _items = []
        if self.associated_groups:
            for _item_associated_groups in self.associated_groups:
                if _item_associated_groups:
                    _items.append(_item_associated_groups.to_dict())
            _dict['associated_groups'] = _items
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if email_id (nullable) is None
        # and model_fields_set contains the field
        if self.email_id is None and "email_id" in self.model_fields_set:
            _dict['email_id'] = None

        # set to None if profile_logo_url (nullable) is None
        # and model_fields_set contains the field
        if self.profile_logo_url is None and "profile_logo_url" in self.model_fields_set:
            _dict['profile_logo_url'] = None

        # set to None if last_login_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_login_at is None and "last_login_at" in self.model_fields_set:
            _dict['last_login_at'] = None

        # set to None if portal_role (nullable) is None
        # and model_fields_set contains the field
        if self.portal_role is None and "portal_role" in self.model_fields_set:
            _dict['portal_role'] = None

        # set to None if content_roles (nullable) is None
        # and model_fields_set contains the field
        if self.content_roles is None and "content_roles" in self.model_fields_set:
            _dict['content_roles'] = None

        # set to None if associated_groups (nullable) is None
        # and model_fields_set contains the field
        if self.associated_groups is None and "associated_groups" in self.model_fields_set:
            _dict['associated_groups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompleteUserInfoCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email_id": obj.get("email_id"),
            "profile_logo_url": obj.get("profile_logo_url"),
            "last_login_at": obj.get("last_login_at"),
            "portal_role": RoleSummaryCustomer.from_dict(obj["portal_role"]) if obj.get("portal_role") is not None else None,
            "content_roles": [ContentRoleSummaryCustomer.from_dict(_item) for _item in obj["content_roles"]] if obj.get("content_roles") is not None else None,
            "associated_groups": [GroupInfo.from_dict(_item) for _item in obj["associated_groups"]] if obj.get("associated_groups") is not None else None
        })
        return _obj


