# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.access_scope_level import AccessScopeLevel
from d361api.models.article_access_info import ArticleAccessInfo
from d361api.models.category_access_info import CategoryAccessInfo
from d361api.models.guide_access_info import GuideAccessInfo
from d361api.models.language_access_info import LanguageAccessInfo
from d361api.models.version_access_info import VersionAccessInfo
from typing import Optional, Set
from typing_extensions import Self

class ContentRoleInfo(BaseModel):
    """
    ContentRoleInfo
    """ # noqa: E501
    version_access_info: Optional[VersionAccessInfo] = None
    language_access_info: Optional[LanguageAccessInfo] = None
    category_access_info: Optional[CategoryAccessInfo] = None
    article_access_info: Optional[ArticleAccessInfo] = None
    access_scope_level: Optional[AccessScopeLevel] = Field(default=None, description="This is an enum. Possible values are 0 - None, 1 - Category, 2 - Version, 3 - Project, 4 - Lanaguage")
    guide_access_info: Optional[GuideAccessInfo] = None
    guide_category_access_info: Optional[CategoryAccessInfo] = None
    role_name: Optional[StrictStr] = None
    role_id: Optional[StrictStr] = None
    group_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["version_access_info", "language_access_info", "category_access_info", "article_access_info", "access_scope_level", "guide_access_info", "guide_category_access_info", "role_name", "role_id", "group_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentRoleInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version_access_info
        if self.version_access_info:
            _dict['version_access_info'] = self.version_access_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of language_access_info
        if self.language_access_info:
            _dict['language_access_info'] = self.language_access_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category_access_info
        if self.category_access_info:
            _dict['category_access_info'] = self.category_access_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of article_access_info
        if self.article_access_info:
            _dict['article_access_info'] = self.article_access_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of guide_access_info
        if self.guide_access_info:
            _dict['guide_access_info'] = self.guide_access_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of guide_category_access_info
        if self.guide_category_access_info:
            _dict['guide_category_access_info'] = self.guide_category_access_info.to_dict()
        # set to None if version_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.version_access_info is None and "version_access_info" in self.model_fields_set:
            _dict['version_access_info'] = None

        # set to None if language_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.language_access_info is None and "language_access_info" in self.model_fields_set:
            _dict['language_access_info'] = None

        # set to None if category_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.category_access_info is None and "category_access_info" in self.model_fields_set:
            _dict['category_access_info'] = None

        # set to None if article_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.article_access_info is None and "article_access_info" in self.model_fields_set:
            _dict['article_access_info'] = None

        # set to None if guide_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.guide_access_info is None and "guide_access_info" in self.model_fields_set:
            _dict['guide_access_info'] = None

        # set to None if guide_category_access_info (nullable) is None
        # and model_fields_set contains the field
        if self.guide_category_access_info is None and "guide_category_access_info" in self.model_fields_set:
            _dict['guide_category_access_info'] = None

        # set to None if role_name (nullable) is None
        # and model_fields_set contains the field
        if self.role_name is None and "role_name" in self.model_fields_set:
            _dict['role_name'] = None

        # set to None if role_id (nullable) is None
        # and model_fields_set contains the field
        if self.role_id is None and "role_id" in self.model_fields_set:
            _dict['role_id'] = None

        # set to None if group_name (nullable) is None
        # and model_fields_set contains the field
        if self.group_name is None and "group_name" in self.model_fields_set:
            _dict['group_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentRoleInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version_access_info": VersionAccessInfo.from_dict(obj["version_access_info"]) if obj.get("version_access_info") is not None else None,
            "language_access_info": LanguageAccessInfo.from_dict(obj["language_access_info"]) if obj.get("language_access_info") is not None else None,
            "category_access_info": CategoryAccessInfo.from_dict(obj["category_access_info"]) if obj.get("category_access_info") is not None else None,
            "article_access_info": ArticleAccessInfo.from_dict(obj["article_access_info"]) if obj.get("article_access_info") is not None else None,
            "access_scope_level": obj.get("access_scope_level"),
            "guide_access_info": GuideAccessInfo.from_dict(obj["guide_access_info"]) if obj.get("guide_access_info") is not None else None,
            "guide_category_access_info": CategoryAccessInfo.from_dict(obj["guide_category_access_info"]) if obj.get("guide_category_access_info") is not None else None,
            "role_name": obj.get("role_name"),
            "role_id": obj.get("role_id"),
            "group_name": obj.get("group_name")
        })
        return _obj


