# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from d361api.models.access_scope_level import AccessScopeLevel
from d361api.models.article_access_info import ArticleAccessInfo
from d361api.models.category_access_info import CategoryAccessInfo
from d361api.models.language_access_info import LanguageAccessInfo
from d361api.models.version_access_info import VersionAccessInfo
from typing import Optional, Set
from typing_extensions import Self

class ContentRoleSummaryCustomer(BaseModel):
    """
    ContentRoleSummaryCustomer
    """ # noqa: E501
    version_access: Optional[VersionAccessInfo] = None
    language_access: Optional[LanguageAccessInfo] = None
    category_access: Optional[CategoryAccessInfo] = None
    article_access: Optional[ArticleAccessInfo] = None
    access_scope_level: Optional[AccessScopeLevel] = Field(default=None, description="This is an enum. Possible values are 0 - None, 1 - Category, 2 - Version, 3 - Project, 4 - Lanaguage")
    role_id: Optional[StrictStr] = None
    role_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["version_access", "language_access", "category_access", "article_access", "access_scope_level", "role_id", "role_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentRoleSummaryCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of version_access
        if self.version_access:
            _dict['version_access'] = self.version_access.to_dict()
        # override the default output from pydantic by calling `to_dict()` of language_access
        if self.language_access:
            _dict['language_access'] = self.language_access.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category_access
        if self.category_access:
            _dict['category_access'] = self.category_access.to_dict()
        # override the default output from pydantic by calling `to_dict()` of article_access
        if self.article_access:
            _dict['article_access'] = self.article_access.to_dict()
        # set to None if version_access (nullable) is None
        # and model_fields_set contains the field
        if self.version_access is None and "version_access" in self.model_fields_set:
            _dict['version_access'] = None

        # set to None if language_access (nullable) is None
        # and model_fields_set contains the field
        if self.language_access is None and "language_access" in self.model_fields_set:
            _dict['language_access'] = None

        # set to None if category_access (nullable) is None
        # and model_fields_set contains the field
        if self.category_access is None and "category_access" in self.model_fields_set:
            _dict['category_access'] = None

        # set to None if article_access (nullable) is None
        # and model_fields_set contains the field
        if self.article_access is None and "article_access" in self.model_fields_set:
            _dict['article_access'] = None

        # set to None if role_id (nullable) is None
        # and model_fields_set contains the field
        if self.role_id is None and "role_id" in self.model_fields_set:
            _dict['role_id'] = None

        # set to None if role_name (nullable) is None
        # and model_fields_set contains the field
        if self.role_name is None and "role_name" in self.model_fields_set:
            _dict['role_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentRoleSummaryCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version_access": VersionAccessInfo.from_dict(obj["version_access"]) if obj.get("version_access") is not None else None,
            "language_access": LanguageAccessInfo.from_dict(obj["language_access"]) if obj.get("language_access") is not None else None,
            "category_access": CategoryAccessInfo.from_dict(obj["category_access"]) if obj.get("category_access") is not None else None,
            "article_access": ArticleAccessInfo.from_dict(obj["article_access"]) if obj.get("article_access") is not None else None,
            "access_scope_level": obj.get("access_scope_level"),
            "role_id": obj.get("role_id"),
            "role_name": obj.get("role_name")
        })
        return _obj


