# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.content_permission_customer import ContentPermissionCustomer
from typing import Optional, Set
from typing_extensions import Self

class EditContentRoleCustomer(BaseModel):
    """
    EditContentRoleCustomer
    """ # noqa: E501
    content_permissions: List[ContentPermissionCustomer] = Field(description="Content permissions of the team account. Note that a team account can have multiple content permissions.")
    is_invitation_id: Optional[StrictBool] = Field(default=None, description="Applicable only for SSO team accounts. If temporary invitation ID is passed as team account ID, then set this to true.")
    __properties: ClassVar[List[str]] = ["content_permissions", "is_invitation_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditContentRoleCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in content_permissions (list)
        _items = []
        if self.content_permissions:
            for _item_content_permissions in self.content_permissions:
                if _item_content_permissions:
                    _items.append(_item_content_permissions.to_dict())
            _dict['content_permissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditContentRoleCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_permissions": [ContentPermissionCustomer.from_dict(_item) for _item in obj["content_permissions"]] if obj.get("content_permissions") is not None else None,
            "is_invitation_id": obj.get("is_invitation_id")
        })
        return _obj


