# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.editable_element_types import EditableElementTypes
from d361api.models.view_form_control import ViewFormControl
from typing import Optional, Set
from typing_extensions import Self

class FormEditableProperties(BaseModel):
    """
    FormEditableProperties
    """ # noqa: E501
    element_name: Optional[StrictStr] = None
    element_type: Optional[EditableElementTypes] = None
    label: Optional[StrictStr] = None
    value: Optional[StrictStr] = None
    view_form_control: Optional[ViewFormControl] = None
    editable_properties: Optional[FormEditableProperties] = None
    element_guid: Optional[StrictStr] = None
    children: Optional[List[FormEditableProperties]] = None
    edit_component_style_properties: Optional[Dict[str, Any]] = None
    edit_component_properties: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["element_name", "element_type", "label", "value", "view_form_control", "editable_properties", "element_guid", "children", "edit_component_style_properties", "edit_component_properties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FormEditableProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of view_form_control
        if self.view_form_control:
            _dict['view_form_control'] = self.view_form_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of editable_properties
        if self.editable_properties:
            _dict['editable_properties'] = self.editable_properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in children (list)
        _items = []
        if self.children:
            for _item_children in self.children:
                if _item_children:
                    _items.append(_item_children.to_dict())
            _dict['children'] = _items
        # set to None if element_name (nullable) is None
        # and model_fields_set contains the field
        if self.element_name is None and "element_name" in self.model_fields_set:
            _dict['element_name'] = None

        # set to None if element_type (nullable) is None
        # and model_fields_set contains the field
        if self.element_type is None and "element_type" in self.model_fields_set:
            _dict['element_type'] = None

        # set to None if label (nullable) is None
        # and model_fields_set contains the field
        if self.label is None and "label" in self.model_fields_set:
            _dict['label'] = None

        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        # set to None if view_form_control (nullable) is None
        # and model_fields_set contains the field
        if self.view_form_control is None and "view_form_control" in self.model_fields_set:
            _dict['view_form_control'] = None

        # set to None if editable_properties (nullable) is None
        # and model_fields_set contains the field
        if self.editable_properties is None and "editable_properties" in self.model_fields_set:
            _dict['editable_properties'] = None

        # set to None if element_guid (nullable) is None
        # and model_fields_set contains the field
        if self.element_guid is None and "element_guid" in self.model_fields_set:
            _dict['element_guid'] = None

        # set to None if children (nullable) is None
        # and model_fields_set contains the field
        if self.children is None and "children" in self.model_fields_set:
            _dict['children'] = None

        # set to None if edit_component_style_properties (nullable) is None
        # and model_fields_set contains the field
        if self.edit_component_style_properties is None and "edit_component_style_properties" in self.model_fields_set:
            _dict['edit_component_style_properties'] = None

        # set to None if edit_component_properties (nullable) is None
        # and model_fields_set contains the field
        if self.edit_component_properties is None and "edit_component_properties" in self.model_fields_set:
            _dict['edit_component_properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FormEditableProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "element_name": obj.get("element_name"),
            "element_type": obj.get("element_type"),
            "label": obj.get("label"),
            "value": obj.get("value"),
            "view_form_control": ViewFormControl.from_dict(obj["view_form_control"]) if obj.get("view_form_control") is not None else None,
            "editable_properties": FormEditableProperties.from_dict(obj["editable_properties"]) if obj.get("editable_properties") is not None else None,
            "element_guid": obj.get("element_guid"),
            "children": [FormEditableProperties.from_dict(_item) for _item in obj["children"]] if obj.get("children") is not None else None,
            "edit_component_style_properties": obj.get("edit_component_style_properties"),
            "edit_component_properties": obj.get("edit_component_properties")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
FormEditableProperties.model_rebuild(raise_errors=False)

