# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.api_logs import ApiLogs
from d361api.models.base_error import BaseError
from d361api.models.base_information import BaseInformation
from d361api.models.base_warning import BaseWarning
from typing import Optional, Set
from typing_extensions import Self

class GetLogsDetailsResponseCustomer(BaseModel):
    """
    GetLogsDetailsResponseCustomer
    """ # noqa: E501
    api_reference_errors: Optional[List[ApiLogs]] = Field(default=None, description="Error log response")
    api_reference_alerts: Optional[List[ApiLogs]] = Field(default=None, description="Alerts log response")
    extension_data: Optional[Dict[str, Any]] = Field(default=None, description="Extension data for customer API response")
    success: Optional[StrictBool] = Field(default=None, description="Indicates the status of the API response. A value of true signifies that the request was successfully processed, while false indicates a failure or error occurred.")
    errors: Optional[List[BaseError]] = Field(default=None, description="A list of errors encountered during the API request. Each error object provides details about the problem, including an error code and a message explaining the issue. This field is populated when the request fails or encounters issues.")
    warnings: Optional[List[BaseWarning]] = Field(default=None, description="A list of warnings generated during the API request. These are non-critical issues or recommendations that might affect the request but won't stop it from processing. Each warning object provides a message to inform the user of potential problems.")
    information: Optional[List[BaseInformation]] = Field(default=None, description="Contains additional non-critical information relevant to the request or response. This field provides extra details that might assist in understanding the context of the API response but is not essential for processing.")
    __properties: ClassVar[List[str]] = ["api_reference_errors", "api_reference_alerts", "extension_data", "success", "errors", "warnings", "information"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLogsDetailsResponseCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in api_reference_errors (list)
        _items = []
        if self.api_reference_errors:
            for _item_api_reference_errors in self.api_reference_errors:
                if _item_api_reference_errors:
                    _items.append(_item_api_reference_errors.to_dict())
            _dict['api_reference_errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in api_reference_alerts (list)
        _items = []
        if self.api_reference_alerts:
            for _item_api_reference_alerts in self.api_reference_alerts:
                if _item_api_reference_alerts:
                    _items.append(_item_api_reference_alerts.to_dict())
            _dict['api_reference_alerts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item_warnings in self.warnings:
                if _item_warnings:
                    _items.append(_item_warnings.to_dict())
            _dict['warnings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in information (list)
        _items = []
        if self.information:
            for _item_information in self.information:
                if _item_information:
                    _items.append(_item_information.to_dict())
            _dict['information'] = _items
        # set to None if api_reference_errors (nullable) is None
        # and model_fields_set contains the field
        if self.api_reference_errors is None and "api_reference_errors" in self.model_fields_set:
            _dict['api_reference_errors'] = None

        # set to None if api_reference_alerts (nullable) is None
        # and model_fields_set contains the field
        if self.api_reference_alerts is None and "api_reference_alerts" in self.model_fields_set:
            _dict['api_reference_alerts'] = None

        # set to None if extension_data (nullable) is None
        # and model_fields_set contains the field
        if self.extension_data is None and "extension_data" in self.model_fields_set:
            _dict['extension_data'] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict['errors'] = None

        # set to None if warnings (nullable) is None
        # and model_fields_set contains the field
        if self.warnings is None and "warnings" in self.model_fields_set:
            _dict['warnings'] = None

        # set to None if information (nullable) is None
        # and model_fields_set contains the field
        if self.information is None and "information" in self.model_fields_set:
            _dict['information'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLogsDetailsResponseCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "api_reference_errors": [ApiLogs.from_dict(_item) for _item in obj["api_reference_errors"]] if obj.get("api_reference_errors") is not None else None,
            "api_reference_alerts": [ApiLogs.from_dict(_item) for _item in obj["api_reference_alerts"]] if obj.get("api_reference_alerts") is not None else None,
            "extension_data": obj.get("extension_data"),
            "success": obj.get("success"),
            "errors": [BaseError.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "warnings": [BaseWarning.from_dict(_item) for _item in obj["warnings"]] if obj.get("warnings") is not None else None,
            "information": [BaseInformation.from_dict(_item) for _item in obj["information"]] if obj.get("information") is not None else None
        })
        return _obj


