# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from d361api.models.access_scope_customer_v2 import AccessScopeCustomerV2
from typing import Optional, Set
from typing_extensions import Self

class GetReaderResponseCustomer(BaseModel):
    """
    GetReaderResponseCustomer
    """ # noqa: E501
    reader_id: Optional[StrictStr] = Field(default=None, description="The ID of the reader.")
    first_name: Optional[StrictStr] = Field(default=None, description="The first name of the reader.")
    last_name: Optional[StrictStr] = Field(default=None, description="The last name of the reader.")
    email: Optional[StrictStr] = Field(default=None, description="Email address of the reader.")
    access_scope: Optional[AccessScopeCustomerV2] = Field(default=None, description="The access scope of the reader.")
    associated_reader_groups: Optional[List[StrictStr]] = Field(default=None, description="An array of the group IDs the reader is associated with.")
    is_invite_sso_user: Optional[StrictBool] = Field(default=None, description="Applicable only for SSO readers. If true, it indicates that an invitation has been sent to the reader, but the reader hasn't accepted the invitation yet.")
    last_login_at: Optional[datetime] = Field(default=None, description="The last login date and time by the reader.")
    __properties: ClassVar[List[str]] = ["reader_id", "first_name", "last_name", "email", "access_scope", "associated_reader_groups", "is_invite_sso_user", "last_login_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetReaderResponseCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of access_scope
        if self.access_scope:
            _dict['access_scope'] = self.access_scope.to_dict()
        # set to None if reader_id (nullable) is None
        # and model_fields_set contains the field
        if self.reader_id is None and "reader_id" in self.model_fields_set:
            _dict['reader_id'] = None

        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if access_scope (nullable) is None
        # and model_fields_set contains the field
        if self.access_scope is None and "access_scope" in self.model_fields_set:
            _dict['access_scope'] = None

        # set to None if associated_reader_groups (nullable) is None
        # and model_fields_set contains the field
        if self.associated_reader_groups is None and "associated_reader_groups" in self.model_fields_set:
            _dict['associated_reader_groups'] = None

        # set to None if last_login_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_login_at is None and "last_login_at" in self.model_fields_set:
            _dict['last_login_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetReaderResponseCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "reader_id": obj.get("reader_id"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "access_scope": AccessScopeCustomerV2.from_dict(obj["access_scope"]) if obj.get("access_scope") is not None else None,
            "associated_reader_groups": obj.get("associated_reader_groups"),
            "is_invite_sso_user": obj.get("is_invite_sso_user"),
            "last_login_at": obj.get("last_login_at")
        })
        return _obj


