# coding: utf-8

"""
    Document360 Customer API

    Document360 RESTful APIs will allow you to integrate your documentation with your software, allowing you to easily onboard new users, manage your articles and more.   You can find detailed API documentation here : [API Documentation](https://apidocs.document360.io/docs)

    The version of the OpenAPI document: 2.0
    Contact: support@document360.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from d361api.models.highlightresult import Highlightresult
from d361api.models.snippetresult import Snippetresult
from typing import Optional, Set
from typing_extensions import Self

class Hit(BaseModel):
    """
    Hit
    """ # noqa: E501
    title: Optional[StrictStr] = Field(default=None, description="Article title")
    content: Optional[StrictStr] = Field(default=None, description="Article HTML content")
    is_hidden: Optional[StrictBool] = Field(default=None, description="Indicates if the article is visible on the site")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Custom article tags")
    slug: Optional[StrictStr] = Field(default=None, description="The slug of the article")
    version: Optional[StrictInt] = Field(default=None, description="The version number that is currently published")
    article_id: Optional[StrictStr] = Field(default=None, description="The ID of the article")
    category_id: Optional[StrictStr] = Field(default=None, description="The ID of the category")
    is_category_hidden: Optional[StrictBool] = Field(default=None, description="Indicates if category is visible on the site")
    order: Optional[StrictInt] = Field(default=None, description="The position inside the parent category")
    is_draft: Optional[StrictBool] = Field(default=None, description="Indicates if the article is marked as a draft")
    exclude: Optional[StrictBool] = Field(default=None, description="Indicates if the article is excluded from search results on user website")
    breadcrumb: Optional[StrictStr] = Field(default=None, description="The breadcrumb of the article")
    is_category: Optional[StrictBool] = Field(default=None, description="If the value is True, then the object has to considered as a category, otherwise it is an article")
    attachment_ids: Optional[List[Any]] = Field(default=None, description="The IDs of the files attached to the article")
    is_deleted: Optional[StrictBool] = Field(default=None, description="If the value is True, then it indicates that the article has been deleted")
    is_folder_type_category: Optional[StrictBool] = Field(default=None, description="If the value is True, then it indicates that the category is a folder type category")
    updated_on_timestamp: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The last updated timestamp of the article")
    is_private: Optional[StrictBool] = Field(default=None, description="If the value is True, then the article can only be accessed by logged in users in the knowledge base site")
    language_id: Optional[StrictStr] = Field(default=None, description="The ID of the language")
    project_id: Optional[StrictStr] = Field(default=None, description="The ID of the project")
    is_latest_version: Optional[StrictBool] = Field(default=None, description="If the value is True, then the article is the latest version")
    contributors: Optional[List[StrictStr]] = Field(default=None, description="The IDs of users who have contributed to the article")
    is_shared_article: Optional[StrictInt] = Field(default=None, description="If the value is True, then it indicates that it is a shared article")
    lang_code: Optional[StrictStr] = Field(default=None, description="The language code of the article or category")
    category_unique_id: Optional[StrictStr] = Field(default=None, description="A unique identifier for the category which is a combination of category ID and the language code")
    unique_id: Optional[StrictStr] = Field(default=None, description="A unique identifier for the article which is a combination of article ID and the language code")
    deleted_by: Optional[StrictStr] = Field(default=None, description="The ID of the user who deleted the article")
    deleted_at: Optional[StrictStr] = Field(default=None, description="The timestamp when the article was deleted")
    is_git_hub_entity: Optional[StrictBool] = Field(default=None, description="If the value is True, then it indicates that the article is synced from GitHub")
    original_article_id: Optional[StrictStr] = Field(default=None, description="The original article ID. Applicable only for shared articles.")
    object_id: Optional[StrictStr] = Field(default=None, description="algolia search object ID")
    snippet_result: Optional[Snippetresult] = Field(default=None, description="Markup text with occurrences highlighted.", alias="_snippet_result")
    highlight_result: Optional[Highlightresult] = Field(default=None, description="Highlighted attributes", alias="_highlight_result")
    __properties: ClassVar[List[str]] = ["title", "content", "is_hidden", "tags", "slug", "version", "article_id", "category_id", "is_category_hidden", "order", "is_draft", "exclude", "breadcrumb", "is_category", "attachment_ids", "is_deleted", "is_folder_type_category", "updated_on_timestamp", "is_private", "language_id", "project_id", "is_latest_version", "contributors", "is_shared_article", "lang_code", "category_unique_id", "unique_id", "deleted_by", "deleted_at", "is_git_hub_entity", "original_article_id", "object_id", "_snippet_result", "_highlight_result"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Hit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of snippet_result
        if self.snippet_result:
            _dict['_snippet_result'] = self.snippet_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of highlight_result
        if self.highlight_result:
            _dict['_highlight_result'] = self.highlight_result.to_dict()
        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if is_hidden (nullable) is None
        # and model_fields_set contains the field
        if self.is_hidden is None and "is_hidden" in self.model_fields_set:
            _dict['is_hidden'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if article_id (nullable) is None
        # and model_fields_set contains the field
        if self.article_id is None and "article_id" in self.model_fields_set:
            _dict['article_id'] = None

        # set to None if category_id (nullable) is None
        # and model_fields_set contains the field
        if self.category_id is None and "category_id" in self.model_fields_set:
            _dict['category_id'] = None

        # set to None if is_category_hidden (nullable) is None
        # and model_fields_set contains the field
        if self.is_category_hidden is None and "is_category_hidden" in self.model_fields_set:
            _dict['is_category_hidden'] = None

        # set to None if is_draft (nullable) is None
        # and model_fields_set contains the field
        if self.is_draft is None and "is_draft" in self.model_fields_set:
            _dict['is_draft'] = None

        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict['exclude'] = None

        # set to None if breadcrumb (nullable) is None
        # and model_fields_set contains the field
        if self.breadcrumb is None and "breadcrumb" in self.model_fields_set:
            _dict['breadcrumb'] = None

        # set to None if is_category (nullable) is None
        # and model_fields_set contains the field
        if self.is_category is None and "is_category" in self.model_fields_set:
            _dict['is_category'] = None

        # set to None if attachment_ids (nullable) is None
        # and model_fields_set contains the field
        if self.attachment_ids is None and "attachment_ids" in self.model_fields_set:
            _dict['attachment_ids'] = None

        # set to None if is_deleted (nullable) is None
        # and model_fields_set contains the field
        if self.is_deleted is None and "is_deleted" in self.model_fields_set:
            _dict['is_deleted'] = None

        # set to None if is_folder_type_category (nullable) is None
        # and model_fields_set contains the field
        if self.is_folder_type_category is None and "is_folder_type_category" in self.model_fields_set:
            _dict['is_folder_type_category'] = None

        # set to None if updated_on_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.updated_on_timestamp is None and "updated_on_timestamp" in self.model_fields_set:
            _dict['updated_on_timestamp'] = None

        # set to None if is_private (nullable) is None
        # and model_fields_set contains the field
        if self.is_private is None and "is_private" in self.model_fields_set:
            _dict['is_private'] = None

        # set to None if language_id (nullable) is None
        # and model_fields_set contains the field
        if self.language_id is None and "language_id" in self.model_fields_set:
            _dict['language_id'] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict['project_id'] = None

        # set to None if is_latest_version (nullable) is None
        # and model_fields_set contains the field
        if self.is_latest_version is None and "is_latest_version" in self.model_fields_set:
            _dict['is_latest_version'] = None

        # set to None if contributors (nullable) is None
        # and model_fields_set contains the field
        if self.contributors is None and "contributors" in self.model_fields_set:
            _dict['contributors'] = None

        # set to None if is_shared_article (nullable) is None
        # and model_fields_set contains the field
        if self.is_shared_article is None and "is_shared_article" in self.model_fields_set:
            _dict['is_shared_article'] = None

        # set to None if lang_code (nullable) is None
        # and model_fields_set contains the field
        if self.lang_code is None and "lang_code" in self.model_fields_set:
            _dict['lang_code'] = None

        # set to None if category_unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.category_unique_id is None and "category_unique_id" in self.model_fields_set:
            _dict['category_unique_id'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['unique_id'] = None

        # set to None if deleted_by (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_by is None and "deleted_by" in self.model_fields_set:
            _dict['deleted_by'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deleted_at'] = None

        # set to None if is_git_hub_entity (nullable) is None
        # and model_fields_set contains the field
        if self.is_git_hub_entity is None and "is_git_hub_entity" in self.model_fields_set:
            _dict['is_git_hub_entity'] = None

        # set to None if original_article_id (nullable) is None
        # and model_fields_set contains the field
        if self.original_article_id is None and "original_article_id" in self.model_fields_set:
            _dict['original_article_id'] = None

        # set to None if object_id (nullable) is None
        # and model_fields_set contains the field
        if self.object_id is None and "object_id" in self.model_fields_set:
            _dict['object_id'] = None

        # set to None if snippet_result (nullable) is None
        # and model_fields_set contains the field
        if self.snippet_result is None and "snippet_result" in self.model_fields_set:
            _dict['_snippet_result'] = None

        # set to None if highlight_result (nullable) is None
        # and model_fields_set contains the field
        if self.highlight_result is None and "highlight_result" in self.model_fields_set:
            _dict['_highlight_result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Hit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "content": obj.get("content"),
            "is_hidden": obj.get("is_hidden"),
            "tags": obj.get("tags"),
            "slug": obj.get("slug"),
            "version": obj.get("version"),
            "article_id": obj.get("article_id"),
            "category_id": obj.get("category_id"),
            "is_category_hidden": obj.get("is_category_hidden"),
            "order": obj.get("order"),
            "is_draft": obj.get("is_draft"),
            "exclude": obj.get("exclude"),
            "breadcrumb": obj.get("breadcrumb"),
            "is_category": obj.get("is_category"),
            "attachment_ids": obj.get("attachment_ids"),
            "is_deleted": obj.get("is_deleted"),
            "is_folder_type_category": obj.get("is_folder_type_category"),
            "updated_on_timestamp": obj.get("updated_on_timestamp"),
            "is_private": obj.get("is_private"),
            "language_id": obj.get("language_id"),
            "project_id": obj.get("project_id"),
            "is_latest_version": obj.get("is_latest_version"),
            "contributors": obj.get("contributors"),
            "is_shared_article": obj.get("is_shared_article"),
            "lang_code": obj.get("lang_code"),
            "category_unique_id": obj.get("category_unique_id"),
            "unique_id": obj.get("unique_id"),
            "deleted_by": obj.get("deleted_by"),
            "deleted_at": obj.get("deleted_at"),
            "is_git_hub_entity": obj.get("is_git_hub_entity"),
            "original_article_id": obj.get("original_article_id"),
            "object_id": obj.get("object_id"),
            "_snippet_result": Snippetresult.from_dict(obj["_snippet_result"]) if obj.get("_snippet_result") is not None else None,
            "_highlight_result": Highlightresult.from_dict(obj["_highlight_result"]) if obj.get("_highlight_result") is not None else None
        })
        return _obj


